/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves;

import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import net.mcreator.fromthecaves.FromTheCavesMod;

public class AudioCapture {
    private static double lastDbLevel = -60.0;
    private static TargetDataLine currentLine = null;
    private static String currentMixerName = "";
    private static final Object LOCK = new Object();
    private static Thread captureThread = null;
    private static volatile boolean isRunning = false;
    private static final AtomicReference<Double> latestDbLevel = new AtomicReference<Double>(-60.0);
    private static final int SAMPLE_RATE = 1000;
    private static final int BUFFER_SIZE = 128;
    private static final int UPDATE_INTERVAL_MS = 5000000;
    private static int warnTickCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCapture(String mixerName) {
        Object object = LOCK;
        synchronized (object) {
            if (isRunning && currentMixerName.equals(mixerName)) {
                return;
            }
            AudioCapture.stopCapture();
            try {
                Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                Mixer selectedMixer = null;
                for (Mixer.Info mixerInfo : mixers) {
                    if (!mixerInfo.getName().toLowerCase().contains(mixerName.toLowerCase())) continue;
                    selectedMixer = AudioSystem.getMixer(mixerInfo);
                    break;
                }
                if (selectedMixer == null) {
                    if (warnTickCounter++ % 160000 == 0) {
                        FromTheCavesMod.LOGGER.warn("Mixer not found: " + mixerName);
                    }
                    return;
                }
                AudioFormat format = new AudioFormat(1000.0f, 16, 1, true, false);
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
                if (!selectedMixer.isLineSupported(info)) {
                    if (warnTickCounter++ % 160000 == 0) {
                        FromTheCavesMod.LOGGER.warn("Line not supported for mixer: " + mixerName);
                    }
                    return;
                }
                currentLine = (TargetDataLine)selectedMixer.getLine(info);
                currentLine.open(format, 128);
                currentLine.start();
                currentMixerName = mixerName;
                isRunning = true;
                captureThread = new Thread(() -> AudioCapture.captureLoop(), "AudioCaptureThread");
                captureThread.setDaemon(true);
                captureThread.setPriority(1);
                captureThread.start();
                FromTheCavesMod.LOGGER.info("Audio capture started for: " + mixerName);
            }
            catch (Exception e) {
                FromTheCavesMod.LOGGER.error("Error starting audio capture: ", (Throwable)e);
                AudioCapture.stopCapture();
            }
        }
    }

    private static void captureLoop() {
        byte[] buffer = new byte[128];
        while (isRunning && currentLine != null) {
            try {
                int bytesRead = currentLine.read(buffer, 0, buffer.length);
                if (bytesRead > 0) {
                    double sum = 0.0;
                    for (int i = 0; i < bytesRead - 1; i += 2) {
                        int sample = buffer[i + 1] << 8 | buffer[i] & 0xFF;
                        sum += (double)(sample * sample);
                    }
                    double rms = Math.sqrt(sum / ((double)bytesRead / 2.0));
                    double db = 20.0 * Math.log10(rms / 32768.0);
                    db = Math.max(-60.0, Math.min(0.0, db));
                    latestDbLevel.set(db);
                }
                Thread.sleep(5000000L);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                FromTheCavesMod.LOGGER.error("Error in capture loop: ", (Throwable)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopCapture() {
        Object object = LOCK;
        synchronized (object) {
            isRunning = false;
            if (captureThread != null && captureThread.isAlive()) {
                captureThread.interrupt();
                try {
                    captureThread.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                captureThread = null;
            }
            if (currentLine != null) {
                try {
                    currentLine.stop();
                    currentLine.close();
                }
                catch (Exception e) {
                    FromTheCavesMod.LOGGER.error("Error closing audio line: ", (Throwable)e);
                }
                currentLine = null;
            }
            currentMixerName = "";
        }
    }

    public static double getDbLevel() {
        return latestDbLevel.get();
    }

    @Deprecated
    public static double getDbLevel(String mixerName) {
        if (!currentMixerName.equals(mixerName)) {
            AudioCapture.startCapture(mixerName);
        }
        return AudioCapture.getDbLevel();
    }

    public static boolean isCapturing() {
        return isRunning;
    }

    public static String getCurrentMixer() {
        return currentMixerName;
    }

    public static String[] getAudioDevices() {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        String[] deviceNames = new String[mixers.length];
        for (int i = 0; i < mixers.length; ++i) {
            deviceNames[i] = mixers[i].getName();
        }
        return deviceNames;
    }
}

