/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.fromthecaves.init.FromTheCavesModBlockEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.util.CemeteryMarkerManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CemeteryMarkerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final Set<Long> forcedChunks = new HashSet<Long>();
    private static final int CHUNK_FORCE_RADIUS = 2;
    private static final int MAX_FORCE_CHUNKS = 16;
    private static final int NEAREST_PLAYER_SEARCH_RADIUS = 2048;

    public CemeteryMarkerBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)FromTheCavesModBlockEntities.CEMETERY_MARKER.get(), position, state);
    }

    private static long encodeChunkCoords(int cx, int cz) {
        return (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
    }

    public void onLoad() {
        Level level;
        super.onLoad();
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CemeteryMarkerManager.addMarker(this.f_58858_);
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 0) {
            return;
        }
        int markerChunkX = this.f_58858_.m_123341_() >> 4;
        int markerChunkZ = this.f_58858_.m_123343_() >> 4;
        serverLevel.m_8602_(markerChunkX, markerChunkZ, true);
        this.forcedChunks.add(CemeteryMarkerBlockEntity.encodeChunkCoords(markerChunkX, markerChunkZ));
        ServerPlayer nearestPlayer = null;
        double nearestDistSq = Double.MAX_VALUE;
        for (ServerPlayer p : serverLevel.m_6907_()) {
            double dz;
            double dy;
            double dx = p.m_20185_() - ((double)this.f_58858_.m_123341_() + 0.5);
            double dsq = dx * dx + (dy = p.m_20186_() - ((double)this.f_58858_.m_123342_() + 0.5)) * dy + (dz = p.m_20189_() - ((double)this.f_58858_.m_123343_() + 0.5)) * dz;
            if (!(dsq <= 4194304.0) || !(dsq < nearestDistSq)) continue;
            nearestDistSq = dsq;
            nearestPlayer = p;
        }
        if (nearestPlayer == null) {
            return;
        }
        int playerChunkX = nearestPlayer.m_20183_().m_123341_() >> 4;
        int playerChunkZ = nearestPlayer.m_20183_().m_123343_() >> 4;
        Comparator<int[]> byPlayerDist = Comparator.comparingDouble(a -> {
            double dx = a[0] - playerChunkX;
            double dz = a[1] - playerChunkZ;
            return dx * dx + dz * dz;
        });
        int totalForced = this.forcedChunks.size();
        int radiusLimit = Math.max(2, 8);
        block1: for (int r = 1; r <= radiusLimit && totalForced < 16; ++r) {
            long key;
            ArrayList<int[]> ring = new ArrayList<int[]>();
            int minX = markerChunkX - r;
            int maxX = markerChunkX + r;
            int minZ = markerChunkZ - r;
            int maxZ = markerChunkZ + r;
            int cx = minX;
            while (cx <= maxX) {
                ring.add(new int[]{cx, minZ});
                ring.add(new int[]{cx++, maxZ});
            }
            int cz = minZ + 1;
            while (cz <= maxZ - 1) {
                ring.add(new int[]{minX, cz});
                ring.add(new int[]{maxX, cz++});
            }
            ArrayList<int[]> loaded = new ArrayList<int[]>();
            ArrayList<int[]> unloaded = new ArrayList<int[]>();
            for (int[] c : ring) {
                key = CemeteryMarkerBlockEntity.encodeChunkCoords(c[0], c[1]);
                if (this.forcedChunks.contains(key)) continue;
                if (serverLevel.m_7232_(c[0], c[1])) {
                    loaded.add(c);
                    continue;
                }
                unloaded.add(c);
            }
            Collections.sort(loaded, byPlayerDist);
            Collections.sort(unloaded, byPlayerDist);
            for (int[] c : loaded) {
                if (totalForced >= 16) break block1;
                key = CemeteryMarkerBlockEntity.encodeChunkCoords(c[0], c[1]);
                serverLevel.m_8602_(c[0], c[1], true);
                this.forcedChunks.add(key);
                ++totalForced;
            }
            for (int[] c : unloaded) {
                if (totalForced >= 16) break block1;
                key = CemeteryMarkerBlockEntity.encodeChunkCoords(c[0], c[1]);
                serverLevel.m_8602_(c[0], c[1], true);
                this.forcedChunks.add(key);
                ++totalForced;
            }
        }
    }

    public void m_7651_() {
        Object object = this.f_58857_;
        if (object instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            if (!this.f_58857_.m_5776_()) {
                object = this.forcedChunks.iterator();
                while (object.hasNext()) {
                    long key = (Long)object.next();
                    int cx = (int)(key >> 32);
                    int cz = (int)key;
                    serverLevel.m_8602_(cx, cz, false);
                }
                this.forcedChunks.clear();
                CemeteryMarkerManager.removeMarker(this.f_58858_);
            }
        }
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> h : this.handlers) {
            h.invalidate();
        }
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public Component m_6820_() {
        return Component.m_237113_((String)"cemetery_marker");
    }

    public AbstractContainerMenu m_6555_(int id, Inventory inv) {
        return ChestMenu.m_39255_((int)id, (Inventory)inv);
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction dir) {
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction dir) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
            return this.handlers[side.ordinal()].cast();
        }
        return super.getCapability(cap, side);
    }
}

