/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigScreenConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue SPAWN_IN_VILLAGE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<String> LOCATE_VILLAGE_TAG;
    public static final ForgeConfigSpec.BooleanValue KEEP_DEFAULT_VILLAGE_TAG_BACKUP;
    public static final ForgeConfigSpec.BooleanValue START_IN_PHASE_1;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_SINGLEPLAYER_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue DEFAULT_MULTIPLAYER_SCALE;
    public static final ForgeConfigSpec.ConfigValue<String> PROTECTED_MOD_IDS;
    public static final ForgeConfigSpec.BooleanValue PHOTOSENSITIVE_MODE_ENABLED;
    public static final ForgeConfigSpec.BooleanValue UPSIDE_DOWN_CROSS_SPAWN_ENABLED;
    public static final ForgeConfigSpec.BooleanValue ALLOW_GRIEF;
    public static final ForgeConfigSpec.ConfigValue<String> EXORCIZABLE_ENTITIES;
    public static final ForgeConfigSpec.ConfigValue<String> EXORCIZABLE_POSSESSED_MOBS;
    public static final ForgeConfigSpec.ConfigValue<String> CUSTOM_POSSESSION_PAIRS;

    static {
        BUILDER.push("spawn_settings");
        SPAWN_IN_VILLAGE_ENABLED = BUILDER.comment("Enable spawning players in villages on first join").define("spawn_in_village_enabled", false);
        LOCATE_VILLAGE_TAG = BUILDER.comment("Structure tag to locate for spawn (e.g., #minecraft:village)").define("locateVillageTag", (Object)"#minecraft:village");
        KEEP_DEFAULT_VILLAGE_TAG_BACKUP = BUILDER.comment("Use default village tag as backup if custom tag fails").define("keepDefaultVillageTagBackup", true);
        START_IN_PHASE_1 = BUILDER.comment("Start the game in phase 1").define("start_in_phase_1", false);
        DEFAULT_SINGLEPLAYER_MULTIPLIER = BUILDER.comment("Singleplayer difficulty multiplier (Min: 0.0, Max: 10.0, Default: 0.80)").defineInRange("default_singleplayer_multiplier", 0.8, 0.0, 10.0);
        DEFAULT_MULTIPLAYER_SCALE = BUILDER.comment("Multiplayer difficulty scale factor (Min: 0.0, Max: 1.0, Default: 0.25)").defineInRange("default_multiplayer_scale", 0.25, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("protection_settings");
        PROTECTED_MOD_IDS = BUILDER.comment("Comma-separated list of mod IDs whose blocks should be protected (e.g., 'create,botania,thermal')").define("protected_mod_ids", (Object)"create");
        BUILDER.pop();
        BUILDER.push("gameplay_settings");
        PHOTOSENSITIVE_MODE_ENABLED = BUILDER.comment("Enable photosensitive safety mode by default").define("photosensitive_mode_enabled", false);
        UPSIDE_DOWN_CROSS_SPAWN_ENABLED = BUILDER.comment("Enable upside down cross spawning").define("upside_down_cross_spawn_enabled", true);
        ALLOW_GRIEF = BUILDER.comment("Allow block destruction/grief (if false, blocks won't be destroyed)").define("allow_grief", true);
        BUILDER.pop();
        BUILDER.push("exorcism_settings");
        EXORCIZABLE_ENTITIES = BUILDER.comment(new String[]{"Comma-separated list of entity IDs that can be exorcized using MassPossessedBanish", "These are regular entities (not possessed variants)", "Format: modid:entity_name,modid:entity_name", "Example: 'from_the_caves:watcher,from_the_caves:lurker'"}).define("exorcizable_entities", (Object)"");
        EXORCIZABLE_POSSESSED_MOBS = BUILDER.comment(new String[]{"List of possessed mob exorcism mappings for PossessedMobExorcism", "Format: possessed_mob->original_mob,possessed_mob->original_mob", "Example: 'from_the_caves:possessed_villager->minecraft:villager,from_the_caves:possessed_pig->minecraft:pig'", "The possessed mob will be converted back to its original form when exorcized"}).define("exorcizable_possessed_mobs", (Object)"");
        CUSTOM_POSSESSION_PAIRS = BUILDER.comment(new String[]{"Custom possession pairs for Phase2Possession", "Format: original_mob->possessed_mob,original_mob->possessed_mob", "Example: 'minecraft:villager->from_the_caves:possessed_villager,minecraft:pig->from_the_caves:possessed_pig'", "Original mobs will be converted to their possessed variants"}).define("custom_possession_pairs", (Object)"");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

