/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.fromthecaves.SessionVariables;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MicrophoneLevelMessage {
    public UUID playerId;
    public double dbLevel;

    public MicrophoneLevelMessage() {
    }

    public MicrophoneLevelMessage(UUID p, double d) {
        this.playerId = p;
        this.dbLevel = d;
    }

    public static void encode(MicrophoneLevelMessage m, FriendlyByteBuf buf) {
        buf.m_130077_(m.playerId);
        buf.writeDouble(m.dbLevel);
    }

    public static MicrophoneLevelMessage decode(FriendlyByteBuf buf) {
        MicrophoneLevelMessage m = new MicrophoneLevelMessage();
        m.playerId = buf.m_130259_();
        m.dbLevel = buf.readDouble();
        return m;
    }

    public static void handle(MicrophoneLevelMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!sender.m_20148_().equals(msg.playerId)) {
                return;
            }
            SessionVariables.currentDbLevels.put(msg.playerId, msg.dbLevel);
        });
        ctx.get().setPacketHandled(true);
    }
}

