/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class AngerSystemProcedure {
    private static final double CROSS_USE_ANGER = 0.1;
    private static final double WOLF_KILL_ANGER = 0.8;
    private static final double VILLAGER_KILL_ANGER = 0.9;
    private static final double EXORCISM_ANGER = 10.0;
    private static final double UPSIDE_DOWN_CROSS_BREAK_ANGER = 4.0;
    private static final double ENCLOSED_ANGER_PER_INTERVAL = 2.0;
    private static final double DEEP_CAVE_ANGER_PER_INTERVAL = 8.0;
    private static final double INSIDE_HOUSE_ANGER_PER_INTERVAL = 0.8;
    private static final int DEEP_CAVE_Y_THRESHOLD = 45;
    private static final int ENCLOSED_CHECK_TICKS = 2400;
    private static final int DEEP_CAVE_CHECK_TICKS = 12000;
    private static final int INSIDE_HOUSE_CHECK_TICKS = 1200;
    private static final int DEBUG_UPDATE_TICKS = 40;
    private static final int CHUNK_TIME_THRESHOLD = 1200;
    private static final double ANGER_THRESHOLD_PHASE2 = 50.0;
    private static final Map<String, Map<ChunkPos, ChunkData>> playerChunkTimes = new HashMap<String, Map<ChunkPos, ChunkData>>();

    private static AngerSavedData getAngerData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (AngerSavedData)storage.m_164861_(AngerSavedData::load, AngerSavedData::new, "fromthecaves_anger_data");
    }

    private static HouseChunksSavedData getHouseChunksData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (HouseChunksSavedData)storage.m_164861_(HouseChunksSavedData::load, HouseChunksSavedData::new, "fromthecaves_house_chunks");
    }

    public static double getAngerLevel(ServerLevel level) {
        return AngerSystemProcedure.getAngerData(level).getAngerLevel();
    }

    public static void addAnger(ServerLevel level, double amount) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) < 1) {
            return;
        }
        AngerSavedData data = AngerSystemProcedure.getAngerData(level);
        double previousAnger = data.getAngerLevel();
        data.addAnger(amount);
        double currentAnger = Math.min(data.getAngerLevel(), 50.0);
        data.setAngerLevel(currentAnger);
        if (previousAnger < 50.0 && currentAnger >= 50.0) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)level, 2);
        }
    }

    public static void setAngerLevel(ServerLevel level, double amount) {
        AngerSystemProcedure.getAngerData(level).setAngerLevel(amount);
    }

    public static void resetAnger(ServerLevel level) {
        AngerSystemProcedure.getAngerData(level).resetAnger();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"angerDebug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
                return 0;
            }
            boolean current = player.getPersistentData().m_128471_("debugAnger");
            boolean newState = !current;
            player.getPersistentData().m_128379_("debugAnger", newState);
            source.m_288197_(() -> Component.m_237113_((String)("Anger Debug mode " + (newState ? "enabled" : "disabled"))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                AngerSystemProcedure.resetAnger(server);
                source.m_288197_(() -> Component.m_237113_((String)"Anger level has been reset to 0"), true);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                double anger = AngerSystemProcedure.getAngerLevel(server);
                source.m_288197_(() -> Component.m_237113_((String)("Current Anger Level: " + String.format("%.2f", anger))), false);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"listHouseChunks").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                HouseChunksSavedData data = AngerSystemProcedure.getHouseChunksData(server);
                Set<String> chunks = data.getHouseChunks();
                if (chunks.isEmpty()) {
                    source.m_288197_(() -> Component.m_237113_((String)"No house chunks registered"), false);
                } else {
                    source.m_288197_(() -> Component.m_237113_((String)("House chunks (" + chunks.size() + "):")), false);
                    for (String chunk : chunks) {
                        source.m_288197_(() -> Component.m_237113_((String)("  - " + chunk)), false);
                    }
                }
                return 1;
            }
            return 0;
        })));
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        LivingEntity deadEntity = event.getEntity();
        Level level = deadEntity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        EntityType type = deadEntity.m_6095_();
        if (type == EntityType.f_20499_) {
            AngerSystemProcedure.addAnger(server, 0.8);
            AngerSystemProcedure.sendAngerNotification(server, "Wolf killed", 0.8);
        } else if (type == EntityType.f_20492_) {
            AngerSystemProcedure.addAnger(server, 0.9);
            AngerSystemProcedure.sendAngerNotification(server, "Villager killed", 0.9);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Level level = event.getPlayer().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.m_60734_();
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId == null) {
            return;
        }
        if ("from_the_caves".equals(blockId.m_135827_()) && "upside_down_cross".equals(blockId.m_135815_())) {
            AngerSystemProcedure.addAnger(server, 4.0);
            AngerSystemProcedure.sendAngerNotification(server, "Upside Down Cross broken", 4.0);
        }
    }

    public static void onCrossUsed(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 0.1);
        AngerSystemProcedure.sendAngerNotification(server, "Cross used", 0.1);
    }

    public static void onExorcism(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 10.0);
        AngerSystemProcedure.sendAngerNotification(server, "Exorcism performed", 10.0);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        CompoundTag nbt = player.getPersistentData();
        BlockPos playerPos = player.m_20183_();
        ChunkPos currentChunk = new ChunkPos(playerPos);
        AngerSystemProcedure.updateChunkTracking(player, currentChunk);
        boolean isEnclosed = AngerSystemProcedure.isPlayerEnclosed(server, playerPos, player);
        boolean isInDeepCave = AngerSystemProcedure.isPlayerInDeepCave(server, playerPos, player);
        boolean isInsideHouse = AngerSystemProcedure.isPlayerInsideHouse(server, playerPos, player, currentChunk);
        int enclosedTicks = nbt.m_128451_("ftc_enclosedTicks");
        if (isEnclosed) {
            nbt.m_128405_("ftc_enclosedTicks", ++enclosedTicks);
            if (enclosedTicks >= 2400) {
                AngerSystemProcedure.addAnger(server, 2.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player enclosed", 2.0);
                nbt.m_128405_("ftc_enclosedTicks", 0);
            }
        } else if (enclosedTicks > 0) {
            nbt.m_128405_("ftc_enclosedTicks", 0);
        }
        int deepCaveTicks = nbt.m_128451_("ftc_deepCaveTicks");
        if (isInDeepCave) {
            nbt.m_128405_("ftc_deepCaveTicks", ++deepCaveTicks);
            if (deepCaveTicks >= 12000) {
                AngerSystemProcedure.addAnger(server, 8.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player in deep caves", 8.0);
                nbt.m_128405_("ftc_deepCaveTicks", 0);
            }
        } else if (deepCaveTicks > 0) {
            nbt.m_128405_("ftc_deepCaveTicks", 0);
        }
        int insideHouseTicks = nbt.m_128451_("ftc_insideHouseTicks");
        if (isInsideHouse) {
            nbt.m_128405_("ftc_insideHouseTicks", ++insideHouseTicks);
            if (insideHouseTicks >= 1200) {
                AngerSystemProcedure.addAnger(server, 0.8);
                AngerSystemProcedure.sendAngerNotification(server, "Player inside house", 0.8);
                nbt.m_128405_("ftc_insideHouseTicks", 0);
            }
        } else if (insideHouseTicks > 0) {
            nbt.m_128405_("ftc_insideHouseTicks", 0);
        }
        if (player.f_19797_ % 40 == 0 && nbt.m_128471_("debugAnger")) {
            AngerSystemProcedure.sendDebugInfo(server, player, isEnclosed, isInDeepCave, isInsideHouse, enclosedTicks, deepCaveTicks, insideHouseTicks);
        }
    }

    private static void updateChunkTracking(Player player, ChunkPos currentChunk) {
        String playerUUID = player.m_20149_();
        Map chunkMap = playerChunkTimes.computeIfAbsent(playerUUID, k -> new HashMap());
        ChunkData data = chunkMap.computeIfAbsent(currentChunk, k -> new ChunkData());
        ++data.ticksInChunk;
    }

    private static boolean isPlayerEnclosed(ServerLevel level, BlockPos playerPos, Player player) {
        int[][] horizontalOffsets;
        if (playerPos.m_123342_() >= 45) {
            return false;
        }
        if (player.m_5833_() || !player.m_20096_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int solidBlocksAround = 0;
        int totalChecks = 0;
        int airOrTransparentBlocks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 3; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (dx == 0 && dz == 0 && dy >= 0 && dy <= 2) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    ++totalChecks;
                    if (state.m_60795_() || !state.m_280296_() || !state.m_60815_()) {
                        ++airOrTransparentBlocks;
                        continue;
                    }
                    if (!state.m_280296_()) continue;
                    ++solidBlocksAround;
                }
            }
        }
        if ((double)airOrTransparentBlocks > (double)totalChecks * 0.4) {
            return false;
        }
        int skyVisibilityChecks = 0;
        for (int y = playerPos.m_123342_() + 3; y <= Math.min(playerPos.m_123342_() + 15, level.m_151558_()); ++y) {
            mutable.m_122178_(playerPos.m_123341_(), y, playerPos.m_123343_());
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (state.m_60795_()) {
                ++skyVisibilityChecks;
                continue;
            }
            if (state.m_280296_()) break;
        }
        if (skyVisibilityChecks > 8) {
            return false;
        }
        int horizontalSolidCount = 0;
        for (int[] offset : horizontalOffsets = new int[][]{{-3, 0}, {3, 0}, {0, -3}, {0, 3}, {-2, -2}, {2, -2}, {-2, 2}, {2, 2}}) {
            mutable.m_122178_(playerPos.m_123341_() + offset[0], playerPos.m_123342_() + 1, playerPos.m_123343_() + offset[1]);
            if (!level.m_8055_((BlockPos)mutable).m_280296_()) continue;
            ++horizontalSolidCount;
        }
        return horizontalSolidCount >= 6 && (double)solidBlocksAround > (double)totalChecks * 0.55;
    }

    private static boolean isPlayerInDeepCave(ServerLevel level, BlockPos playerPos, Player player) {
        if (player.m_5833_()) {
            return false;
        }
        int playerY = playerPos.m_123342_();
        return playerY < 45;
    }

    private static boolean isPlayerInsideHouse(ServerLevel level, BlockPos playerPos, Player player, ChunkPos currentChunk) {
        if (player.m_5833_()) {
            return false;
        }
        HouseChunksSavedData houseData = AngerSystemProcedure.getHouseChunksData(level);
        if (houseData.isHouseChunk(currentChunk)) {
            return true;
        }
        String playerUUID = player.m_20149_();
        Map<ChunkPos, ChunkData> chunkMap = playerChunkTimes.get(playerUUID);
        if (chunkMap == null) {
            return false;
        }
        ChunkData chunkData = chunkMap.get(currentChunk);
        if (chunkData == null) {
            return false;
        }
        if (chunkData.isMarkedAsHouse) {
            return true;
        }
        if (chunkData.ticksInChunk < 1200) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        HashSet<BlockState> homeBlocks = new HashSet<BlockState>();
        int searchRadius = 16;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dy = -5; dy <= 5; ++dy) {
                for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                    BlockState state;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    if (!level.m_46749_((BlockPos)mutable) || !AngerSystemProcedure.isHomeBlock(state = level.m_8055_((BlockPos)mutable))) continue;
                    homeBlocks.add(state);
                }
            }
        }
        if (homeBlocks.size() >= 5) {
            chunkData.isMarkedAsHouse = true;
            houseData.markAsHouse(currentChunk);
            return true;
        }
        return false;
    }

    private static boolean isHomeBlock(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        return state.m_60713_(Blocks.f_50066_) || state.m_60713_(Blocks.f_50067_) || state.m_60713_(Blocks.f_50068_) || state.m_60713_(Blocks.f_50017_) || state.m_60713_(Blocks.f_50018_) || state.m_60713_(Blocks.f_50019_) || state.m_60713_(Blocks.f_50020_) || state.m_60713_(Blocks.f_50021_) || state.m_60713_(Blocks.f_50022_) || state.m_60713_(Blocks.f_50023_) || state.m_60713_(Blocks.f_50024_) || state.m_60713_(Blocks.f_50025_) || state.m_60713_(Blocks.f_50026_) || state.m_60713_(Blocks.f_50027_) || state.m_60713_(Blocks.f_50028_) || state.m_60713_(Blocks.f_50029_) || state.m_60713_(Blocks.f_50091_) || state.m_60713_(Blocks.f_50094_) || state.m_60713_(Blocks.f_50620_) || state.m_60713_(Blocks.f_50619_) || state.m_60713_(Blocks.f_50322_) || state.m_60713_(Blocks.f_50323_) || state.m_60713_(Blocks.f_50324_) || state.m_60713_(Blocks.f_50087_) || state.m_60713_(Blocks.f_50325_) || state.m_60713_(Blocks.f_50618_) || state.m_60713_(Blocks.f_50081_) || state.m_60713_(Blocks.f_50082_) || state.m_60713_(Blocks.f_50139_) || state.m_60713_(Blocks.f_50140_) || state.m_60713_(Blocks.f_50681_) || state.m_60713_(Blocks.f_50682_) || state.m_60713_(Blocks.f_50092_) || state.m_60713_(Blocks.f_50249_) || state.m_60713_(Blocks.f_50250_) || state.m_60713_(Blocks.f_50444_) || state.m_60713_(Blocks.f_50683_) || state.m_60713_(Blocks.f_50684_) || state.m_60713_(Blocks.f_50624_) || state.m_60713_(Blocks.f_50078_) || state.m_60713_(Blocks.f_50201_) || state.m_60713_(Blocks.f_50255_) || state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_50617_) || state.m_60713_(Blocks.f_50715_) || state.m_60713_(Blocks.f_50621_) || state.m_60713_(Blocks.f_50622_) || state.m_60713_(Blocks.f_50625_) || state.m_60713_(Blocks.f_50623_) || state.m_60713_(Blocks.f_50679_);
    }

    private static void sendAngerNotification(ServerLevel server, String cause, double amount) {
        for (ServerPlayer player : server.m_6907_()) {
            if (!player.getPersistentData().m_128471_("debugAnger")) continue;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[ANGER] " + cause + ": +" + String.format("%.2f", amount))));
        }
    }

    private static void sendDebugInfo(ServerLevel server, Player player, boolean enclosed, boolean inDeepCave, boolean insideHouse, int enclosedTicks, int deepCaveTicks, int houseTicks) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        double angerLevel = AngerSystemProcedure.getAngerLevel(server);
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        double enclosedProgress = (double)enclosedTicks / 2400.0 * 100.0;
        double deepCaveProgress = (double)deepCaveTicks / 12000.0 * 100.0;
        double houseProgress = (double)houseTicks / 1200.0 * 100.0;
        String actionBar = "\u00a7cAnger: " + String.format("%.1f", angerLevel) + "/" + String.format("%.0f", 50.0) + " \u00a77| Phase:" + phase + " | Enclosed:" + (enclosed ? "\u00a7a\u2713" : "\u00a77\u2717") + String.format("%.0f%%", enclosedProgress) + " Cave:" + (inDeepCave ? "\u00a7a\u2713" : "\u00a77\u2717") + String.format("%.0f%%", deepCaveProgress) + " House:" + (insideHouse ? "\u00a7a\u2713" : "\u00a77\u2717") + String.format("%.0f%%", houseProgress);
        sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)actionBar)));
    }

    public static boolean isChunkHouse(ServerLevel level, ChunkPos chunkPos) {
        HouseChunksSavedData houseData = AngerSystemProcedure.getHouseChunksData(level);
        return houseData.isHouseChunk(chunkPos);
    }

    public static boolean isPlayerInHouse(ServerLevel level, Player player) {
        ChunkPos currentChunk = new ChunkPos(player.m_20183_());
        return AngerSystemProcedure.isChunkHouse(level, currentChunk);
    }

    public static class AngerSavedData
    extends SavedData {
        public static final String NAME = "fromthecaves_anger_data";
        private double angerLevel = 0.0;

        public static AngerSavedData load(CompoundTag tag) {
            AngerSavedData data = new AngerSavedData();
            data.angerLevel = tag.m_128459_("angerLevel");
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128347_("angerLevel", this.angerLevel);
            return tag;
        }

        public double getAngerLevel() {
            return this.angerLevel;
        }

        public void addAnger(double amount) {
            this.angerLevel += amount;
            this.m_77762_();
        }

        public void setAngerLevel(double level) {
            this.angerLevel = level;
            this.m_77762_();
        }

        public void resetAnger() {
            this.angerLevel = 0.0;
            this.m_77762_();
        }
    }

    public static class HouseChunksSavedData
    extends SavedData {
        public static final String NAME = "fromthecaves_house_chunks";
        private final Set<String> houseChunks = new HashSet<String>();

        public static HouseChunksSavedData load(CompoundTag tag) {
            HouseChunksSavedData data = new HouseChunksSavedData();
            ListTag list = tag.m_128437_("houseChunks", 8);
            for (Tag t : list) {
                data.houseChunks.add(t.m_7916_());
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            ListTag list = new ListTag();
            for (String chunkKey : this.houseChunks) {
                list.add((Object)StringTag.m_129297_((String)chunkKey));
            }
            tag.m_128365_("houseChunks", (Tag)list);
            return tag;
        }

        public boolean isHouseChunk(ChunkPos pos) {
            return this.houseChunks.contains(HouseChunksSavedData.chunkPosToKey(pos));
        }

        public void markAsHouse(ChunkPos pos) {
            this.houseChunks.add(HouseChunksSavedData.chunkPosToKey(pos));
            this.m_77762_();
        }

        public void removeHouse(ChunkPos pos) {
            this.houseChunks.remove(HouseChunksSavedData.chunkPosToKey(pos));
            this.m_77762_();
        }

        public Set<String> getHouseChunks() {
            return new HashSet<String>(this.houseChunks);
        }

        private static String chunkPosToKey(ChunkPos pos) {
            return pos.f_45578_ + "_" + pos.f_45579_;
        }
    }

    private static class ChunkData {
        int ticksInChunk = 0;
        boolean isMarkedAsHouse = false;

        private ChunkData() {
        }
    }
}

