/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnimalFearManagerProcedure {
    private static final double DETECT_RADIUS = 20.0;
    private static final double AVOID_DISTANCE = 10.0;
    private static final double FLEE_SPEED = 0.2;
    private static final double FLEE_SPEED_OTHERS = 0.5;
    private static final double CROSS_ACTION_CHANCE = 0.5;
    private static final int CHUNK_LOAD_GRACE_TICKS = 100;
    private static final int SCAN_INTERVAL = 4;
    private static final ResourceLocation[] PARROT_IT_SOUNDS = new ResourceLocation[]{new ResourceLocation("from_the_caves", "it_13"), new ResourceLocation("from_the_caves", "it_14"), new ResourceLocation("from_the_caves", "it_15"), new ResourceLocation("from_the_caves", "it_16"), new ResourceLocation("from_the_caves", "it_18"), new ResourceLocation("from_the_caves", "it_19"), new ResourceLocation("from_the_caves", "it_20"), new ResourceLocation("from_the_caves", "it_21"), new ResourceLocation("from_the_caves", "it_22"), new ResourceLocation("from_the_caves", "it_23"), new ResourceLocation("from_the_caves", "it_24"), new ResourceLocation("from_the_caves", "it_25"), new ResourceLocation("from_the_caves", "it_26"), new ResourceLocation("from_the_caves", "it_27"), new ResourceLocation("from_the_caves", "it_28")};
    private static final int MIN_DELAY_TICKS = 200;
    private static final int MAX_DELAY_TICKS = 600;
    private static final int MIN_EXISTENCE_TICKS = 60;
    private static final Map<UUID, Long> lastSoundTick = new HashMap<UUID, Long>();
    private static final Set<UUID> villagersWithCross = new HashSet<UUID>();
    private static final Set<UUID> illagersWithCross = new HashSet<UUID>();
    private static final Map<Long, Long> recentlyLoadedChunks = new HashMap<Long, Long>();
    private static final Set<UUID> processedThisTick = new HashSet<UUID>();
    private static long lastScanTick = 0L;

    private static boolean isTamedMob(Mob mob) {
        if (mob instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)mob;
            return tamable.m_21824_();
        }
        if (mob.getPersistentData().m_128441_("Owner")) {
            return true;
        }
        if (mob.getPersistentData().m_128441_("OwnerUUID")) {
            return true;
        }
        if (mob.getPersistentData().m_128441_("Tamed")) {
            return true;
        }
        return mob.getPersistentData().m_128471_("IsTamed");
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        long chunkKey = ChunkPos.m_45589_((int)event.getChunk().m_7697_().f_45578_, (int)event.getChunk().m_7697_().f_45579_);
        recentlyLoadedChunks.put(chunkKey, level.m_46467_());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : ev.getServer().m_129785_()) {
            long currentTick = level.m_46467_();
            recentlyLoadedChunks.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 100L);
            if (currentTick - lastScanTick < 4L) continue;
            processedThisTick.clear();
            for (Player player : level.m_6907_()) {
                if (player == null) continue;
                AABB detectBox = player.m_20191_().m_82400_(20.0);
                ArrayList<Entity> dangers = new ArrayList<Entity>();
                for (Entity en : level.m_6443_(Entity.class, detectBox, e -> true)) {
                    ResourceLocation typeRL;
                    if (en == null || en.m_213877_() || (typeRL = ForgeRegistries.ENTITY_TYPES.getKey((Object)en.m_6095_())) == null || !"from_the_caves".equals(typeRL.m_135827_()) || en instanceof Player) continue;
                    dangers.add(en);
                }
                if (dangers.isEmpty()) continue;
                long now = level.m_46467_();
                for (Entity en : level.m_6443_(Entity.class, detectBox, e -> true)) {
                    double dist;
                    SoundEvent sound;
                    float yaw;
                    SoundEvent sound2;
                    boolean playSound;
                    boolean isVanillaTameable;
                    if (en == null || en.m_213877_() || !(en instanceof Mob)) continue;
                    Mob mob = (Mob)en;
                    UUID mobId = en.m_20148_();
                    if (processedThisTick.contains(mobId)) continue;
                    processedThisTick.add(mobId);
                    boolean isTamed = AnimalFearManagerProcedure.isTamedMob(mob);
                    boolean bl = isVanillaTameable = en instanceof Wolf || en instanceof Cat || en instanceof Parrot || en instanceof Horse;
                    if (isTamed && !isVanillaTameable || mob.f_19797_ < 60 || !mob.isAddedToWorld() || mob.m_21224_() || !level.m_46749_(mob.m_20183_()) || mob.m_20159_() || mob.m_20160_()) continue;
                    ChunkPos mobChunk = mob.m_146902_();
                    long chunkKey = ChunkPos.m_45589_((int)mobChunk.f_45578_, (int)mobChunk.f_45579_);
                    if (recentlyLoadedChunks.containsKey(chunkKey)) continue;
                    Entity nearestDanger = null;
                    double nearestDist = Double.MAX_VALUE;
                    for (Entity danger : dangers) {
                        double d = en.m_20280_(danger);
                        if (!(d < nearestDist)) continue;
                        nearestDist = d;
                        nearestDanger = danger;
                    }
                    if (nearestDanger == null || nearestDist > 400.0) continue;
                    UUID id = en.m_20148_();
                    long allowedAt = lastSoundTick.getOrDefault(id, 0L);
                    boolean bl2 = playSound = now >= allowedAt;
                    if (en.m_6095_() == EntityType.f_20499_ && en instanceof Wolf) {
                        Wolf w = (Wolf)en;
                        if (isTamed) {
                            if (!playSound) continue;
                            ResourceLocation rl = new ResourceLocation("minecraft", "entity.wolf.growl");
                            sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                            if (sound2 != null) {
                                level.m_5594_(null, w.m_20183_(), sound2, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            int delay = 200 + level.m_213780_().m_188503_(401);
                            lastSoundTick.put(id, now + (long)delay);
                            continue;
                        }
                        double dx = nearestDanger.m_20185_() - w.m_20185_();
                        double dz = nearestDanger.m_20189_() - w.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        w.m_146922_(yaw);
                        w.f_20885_ = w.m_146908_();
                        w.m_20256_(new Vec3(0.0, w.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.wolf.growl");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, w.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20553_ && en instanceof Cat) {
                        Cat c = (Cat)en;
                        if (isTamed) {
                            if (!playSound) continue;
                            ResourceLocation rl = new ResourceLocation("minecraft", "entity.cat.hiss");
                            sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                            if (sound2 != null) {
                                level.m_5594_(null, c.m_20183_(), sound2, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            int delay = 200 + level.m_213780_().m_188503_(401);
                            lastSoundTick.put(id, now + (long)delay);
                            continue;
                        }
                        double dx = nearestDanger.m_20185_() - c.m_20185_();
                        double dz = nearestDanger.m_20189_() - c.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        c.m_146922_(yaw);
                        c.f_20885_ = c.m_146908_();
                        c.m_20256_(new Vec3(0.0, c.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.cat.hiss");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, c.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20508_ && en instanceof Parrot) {
                        Parrot p = (Parrot)en;
                        if (isTamed) {
                            if (!playSound) continue;
                            ResourceLocation rl = PARROT_IT_SOUNDS[level.m_213780_().m_188503_(PARROT_IT_SOUNDS.length)];
                            sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                            if (sound2 != null) {
                                level.m_5594_(null, p.m_20183_(), sound2, SoundSource.NEUTRAL, 0.3f, 1.6f);
                            }
                            int delay = 200 + level.m_213780_().m_188503_(401);
                            lastSoundTick.put(id, now + (long)delay);
                            continue;
                        }
                        float yaw2 = (float)(Math.atan2(nearestDanger.m_20189_() - p.m_20189_(), nearestDanger.m_20185_() - p.m_20185_()) * 180.0 / Math.PI) - 90.0f;
                        p.m_146922_(yaw2);
                        p.f_20885_ = p.m_146908_();
                        p.m_20256_(new Vec3(0.0, p.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = PARROT_IT_SOUNDS[level.m_213780_().m_188503_(PARROT_IT_SOUNDS.length)];
                        SoundEvent sound3 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound3 != null) {
                            level.m_5594_(null, p.m_20183_(), sound3, SoundSource.NEUTRAL, 0.3f, 1.6f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20457_ && en instanceof Horse) {
                        Horse h = (Horse)en;
                        if (isTamed) {
                            if (!playSound) continue;
                            ResourceLocation rl = new ResourceLocation("minecraft", "entity.horse.angry");
                            sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                            if (sound2 != null) {
                                level.m_5594_(null, h.m_20183_(), sound2, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            int delay = 200 + level.m_213780_().m_188503_(401);
                            lastSoundTick.put(id, now + (long)delay);
                            continue;
                        }
                        double dx = nearestDanger.m_20185_() - h.m_20185_();
                        double dz = nearestDanger.m_20189_() - h.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        h.m_146922_(yaw);
                        h.f_20885_ = h.m_146908_();
                        h.m_20256_(new Vec3(0.0, h.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.horse.angry");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, h.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20452_ && en instanceof Fox) {
                        Fox f = (Fox)en;
                        double dx = nearestDanger.m_20185_() - f.m_20185_();
                        double dz = nearestDanger.m_20189_() - f.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        f.m_146922_(yaw);
                        f.f_20885_ = f.m_146908_();
                        f.m_20256_(new Vec3(0.0, f.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.fox.screech");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, f.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20517_ && en instanceof Rabbit) {
                        Rabbit r = (Rabbit)en;
                        double dx = nearestDanger.m_20185_() - r.m_20185_();
                        double dz = nearestDanger.m_20189_() - r.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        r.m_146922_(yaw);
                        r.f_20885_ = r.m_146908_();
                        r.m_20256_(new Vec3(0.0, r.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.rabbit.hurt");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, r.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20555_ && en instanceof Chicken) {
                        Chicken ch = (Chicken)en;
                        double dx = nearestDanger.m_20185_() - ch.m_20185_();
                        double dz = nearestDanger.m_20189_() - ch.m_20189_();
                        yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        ch.m_146922_(yaw);
                        ch.f_20885_ = ch.m_146908_();
                        ch.m_20256_(new Vec3(0.0, ch.m_20184_().f_82480_, 0.0));
                        if (!playSound) continue;
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.chicken.hurt");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, ch.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20492_ && en instanceof Villager) {
                        Villager v = (Villager)en;
                        AnimalFearManagerProcedure.handleVillagerFear(level, v, nearestDanger, nearestDist, id, now, playSound);
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20494_ && en instanceof WanderingTrader) {
                        WanderingTrader wt = (WanderingTrader)en;
                        AnimalFearManagerProcedure.handleVillagerTypeFear(level, (Entity)wt, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.wandering_trader.no"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20513_ && en instanceof Pillager) {
                        Pillager pillager = (Pillager)en;
                        AnimalFearManagerProcedure.handleIllagerFear(level, (Entity)pillager, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.pillager.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20493_ && en instanceof Vindicator) {
                        Vindicator vindicator = (Vindicator)en;
                        AnimalFearManagerProcedure.handleIllagerFear(level, (Entity)vindicator, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.vindicator.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20568_ && en instanceof Evoker) {
                        Evoker evoker = (Evoker)en;
                        AnimalFearManagerProcedure.handleIllagerFear(level, (Entity)evoker, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.evoker.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20459_ && en instanceof Illusioner) {
                        Illusioner illusioner = (Illusioner)en;
                        AnimalFearManagerProcedure.handleIllagerFear(level, (Entity)illusioner, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.illusioner.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20518_ && en instanceof Ravager) {
                        Ravager ravager = (Ravager)en;
                        AnimalFearManagerProcedure.handleIllagerFear(level, (Entity)ravager, nearestDanger, nearestDist, id, now, playSound, new ResourceLocation("minecraft", "entity.ravager.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20510_ && en instanceof Pig) {
                        Pig pig = (Pig)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)pig, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.pig.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20557_ && en instanceof Cow) {
                        Cow cow = (Cow)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)cow, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.cow.hurt"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20520_ && en instanceof Sheep) {
                        Sheep sheep = (Sheep)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)sheep, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.sheep.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20550_ && en instanceof Bee) {
                        Bee bee = (Bee)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)bee, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.bee.hurt"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20507_ && en instanceof Panda) {
                        Panda panda = (Panda)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)panda, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.panda.worried_ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20505_ && en instanceof Ocelot) {
                        Ocelot ocelot = (Ocelot)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)ocelot, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.cat.hiss"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_20514_ && en instanceof PolarBear) {
                        PolarBear bear = (PolarBear)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)bear, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.polar_bear.warning"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_147035_ && en instanceof Goat) {
                        Goat goat = (Goat)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)goat, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.goat.screaming.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_147039_ && en instanceof Axolotl) {
                        Axolotl axolotl = (Axolotl)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)axolotl, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.axolotl.hurt"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_217012_ && en instanceof Frog) {
                        Frog frog = (Frog)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)frog, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.frog.ambient"));
                        continue;
                    }
                    if (en.m_6095_() == EntityType.f_217014_ && en instanceof Allay) {
                        Allay allay = (Allay)en;
                        AnimalFearManagerProcedure.handleStaringAnimal(level, (Entity)allay, nearestDanger, id, now, playSound, new ResourceLocation("minecraft", "entity.allay.hurt"));
                        continue;
                    }
                    if (en.m_6095_() != EntityType.f_20460_ || !(en instanceof IronGolem)) continue;
                    IronGolem g = (IronGolem)en;
                    double dx = nearestDanger.m_20185_() - g.m_20185_();
                    double dz = nearestDanger.m_20189_() - g.m_20189_();
                    yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                    g.m_146922_(yaw);
                    g.f_20885_ = g.m_146908_();
                    if (playSound) {
                        ResourceLocation rl = new ResourceLocation("minecraft", "entity.iron_golem.hurt");
                        sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                        if (sound != null) {
                            level.m_5594_(null, g.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        }
                        int delay = 200 + level.m_213780_().m_188503_(401);
                        lastSoundTick.put(id, now + (long)delay);
                    }
                    if ((dist = Math.sqrt(nearestDist)) < 10.0) {
                        Vec3 away = g.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
                        Vec3 move = away.m_82490_(0.5).m_82520_(0.0, g.m_20184_().f_82480_, 0.0);
                        g.m_20256_(move);
                        continue;
                    }
                    g.m_20256_(new Vec3(0.0, g.m_20184_().f_82480_, 0.0));
                }
            }
            lastScanTick = currentTick;
        }
    }

    private static void handleVillagerFear(ServerLevel level, Villager v, Entity nearestDanger, double nearestDist, UUID id, long now, boolean playSound) {
        double dist;
        double dx = nearestDanger.m_20185_() - v.m_20185_();
        double dz = nearestDanger.m_20189_() - v.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        v.m_146922_(yaw);
        v.f_20885_ = v.m_146908_();
        if (playSound) {
            ResourceLocation rl = new ResourceLocation("minecraft", "entity.villager.no");
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
            if (sound != null) {
                level.m_5594_(null, v.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            int delay = 200 + level.m_213780_().m_188503_(401);
            lastSoundTick.put(id, now + (long)delay);
        }
        if (!villagersWithCross.contains(id)) {
            if (level.m_213780_().m_188500_() < 0.5) {
                AnimalFearManagerProcedure.handleVillagerCrossAction(level, (Entity)v);
            }
            villagersWithCross.add(id);
        }
        if (level.m_46467_() % 10L == 0L) {
            AnimalFearManagerProcedure.spawnCryingParticles(level, v);
        }
        if ((dist = Math.sqrt(nearestDist)) < 10.0) {
            Vec3 away = v.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
            Vec3 move = away.m_82490_(0.2).m_82520_(0.0, v.m_20184_().f_82480_, 0.0);
            v.m_20256_(move);
        } else {
            v.m_20256_(new Vec3(0.0, v.m_20184_().f_82480_, 0.0));
        }
    }

    private static void handleVillagerTypeFear(ServerLevel level, Entity villagerType, Entity nearestDanger, double nearestDist, UUID id, long now, boolean playSound, ResourceLocation soundLocation) {
        double dist;
        WanderingTrader wt;
        double dx = nearestDanger.m_20185_() - villagerType.m_20185_();
        double dz = nearestDanger.m_20189_() - villagerType.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        villagerType.m_146922_(yaw);
        if (villagerType instanceof Mob) {
            Mob mob = (Mob)villagerType;
            mob.f_20885_ = mob.m_146908_();
        }
        if (playSound) {
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
            if (sound != null) {
                level.m_5594_(null, villagerType.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            int delay = 200 + level.m_213780_().m_188503_(401);
            lastSoundTick.put(id, now + (long)delay);
        }
        if (!villagersWithCross.contains(id) && villagerType instanceof WanderingTrader) {
            wt = (WanderingTrader)villagerType;
            if (level.m_213780_().m_188500_() < 0.5) {
                AnimalFearManagerProcedure.handleVillagerCrossAction(level, (Entity)wt);
            }
            villagersWithCross.add(id);
        }
        if (level.m_46467_() % 10L == 0L && villagerType instanceof WanderingTrader) {
            wt = (WanderingTrader)villagerType;
            AnimalFearManagerProcedure.spawnCryingParticlesTrader(level, wt);
        }
        if ((dist = Math.sqrt(nearestDist)) < 10.0) {
            Vec3 away = villagerType.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
            Vec3 move = away.m_82490_(0.2).m_82520_(0.0, villagerType.m_20184_().f_82480_, 0.0);
            villagerType.m_20256_(move);
        } else {
            villagerType.m_20256_(new Vec3(0.0, villagerType.m_20184_().f_82480_, 0.0));
        }
    }

    private static void handleVillagerCrossAction(ServerLevel level, Entity villager) {
        boolean placeBlock = level.m_213780_().m_188499_();
        if (placeBlock) {
            Block crossBlock;
            BlockPos feetPos = villager.m_20183_();
            Block currentBlock = level.m_8055_(feetPos).m_60734_();
            if ((currentBlock == Blocks.f_50016_ || currentBlock.m_49966_().m_60795_()) && (crossBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "cross_floor"))) != null && crossBlock != Blocks.f_50016_) {
                level.m_46597_(feetPos, crossBlock.m_49966_());
                ResourceLocation woodSound = new ResourceLocation("minecraft", "block.wood.place");
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(woodSound);
                if (sound != null) {
                    level.m_5594_(null, feetPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        } else {
            ItemStack crossItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("from_the_caves", "wooden_cross")));
            if (!crossItem.m_41619_()) {
                ItemEntity itemEntity = new ItemEntity((Level)level, villager.m_20185_(), villager.m_20186_() + 1.0, villager.m_20189_(), crossItem);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
    }

    private static void spawnCryingParticles(ServerLevel level, Villager v) {
        Vec3 eyePos = v.m_146892_();
        double offsetX = v.m_20154_().f_82479_ * 0.3;
        double offsetZ = v.m_20154_().f_82481_ * 0.3;
        double randomOffsetX = (level.m_213780_().m_188500_() - 0.5) * 0.1;
        double randomOffsetZ = (level.m_213780_().m_188500_() - 0.5) * 0.1;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123803_, eyePos.f_82479_ + offsetX + randomOffsetX, eyePos.f_82480_ - 0.1, eyePos.f_82481_ + offsetZ + randomOffsetZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void spawnCryingParticlesTrader(ServerLevel level, WanderingTrader wt) {
        Vec3 eyePos = wt.m_146892_();
        double offsetX = wt.m_20154_().f_82479_ * 0.3;
        double offsetZ = wt.m_20154_().f_82481_ * 0.3;
        double randomOffsetX = (level.m_213780_().m_188500_() - 0.5) * 0.1;
        double randomOffsetZ = (level.m_213780_().m_188500_() - 0.5) * 0.1;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123803_, eyePos.f_82479_ + offsetX + randomOffsetX, eyePos.f_82480_ - 0.1, eyePos.f_82481_ + offsetZ + randomOffsetZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void handleIllagerFear(ServerLevel level, Entity illager, Entity nearestDanger, double nearestDist, UUID id, long now, boolean playSound, ResourceLocation soundLocation) {
        double dist;
        double dx = nearestDanger.m_20185_() - illager.m_20185_();
        double dz = nearestDanger.m_20189_() - illager.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        illager.m_146922_(yaw);
        if (illager instanceof Mob) {
            Mob mob = (Mob)illager;
            mob.f_20885_ = mob.m_146908_();
        }
        if (playSound) {
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
            if (sound != null) {
                level.m_5594_(null, illager.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            int delay = 200 + level.m_213780_().m_188503_(401);
            lastSoundTick.put(id, now + (long)delay);
        }
        if (!illagersWithCross.contains(id)) {
            if (level.m_213780_().m_188500_() < 0.5) {
                AnimalFearManagerProcedure.handleIllagerCrossAction(level, illager);
            }
            illagersWithCross.add(id);
        }
        if ((dist = Math.sqrt(nearestDist)) < 10.0) {
            Vec3 away = illager.m_20182_().m_82546_(nearestDanger.m_20182_()).m_82541_();
            Vec3 move = away.m_82490_(0.2).m_82520_(0.0, illager.m_20184_().f_82480_, 0.0);
            illager.m_20256_(move);
        } else {
            illager.m_20256_(new Vec3(0.0, illager.m_20184_().f_82480_, 0.0));
        }
    }

    private static void handleIllagerCrossAction(ServerLevel level, Entity illager) {
        BlockPos feetPos = illager.m_20183_();
        Block crossBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "upside_down_cross"));
        if (crossBlock == null || crossBlock == Blocks.f_50016_) {
            return;
        }
        BlockPos placePos = feetPos;
        Block currentBlock = level.m_8055_(placePos).m_60734_();
        if (currentBlock != Blocks.f_50016_ && !currentBlock.m_49966_().m_60795_()) {
            BlockPos above = placePos.m_7494_();
            Block aboveBlock = level.m_8055_(above).m_60734_();
            if (aboveBlock == Blocks.f_50016_ || aboveBlock.m_49966_().m_60795_()) {
                placePos = above;
            } else {
                boolean found = false;
                for (int dx = -1; dx <= 1 && !found; ++dx) {
                    for (int dz = -1; dz <= 1 && !found; ++dz) {
                        BlockPos nearby = feetPos.m_7918_(dx, 0, dz);
                        Block nb = level.m_8055_(nearby).m_60734_();
                        if (nb != Blocks.f_50016_ && !nb.m_49966_().m_60795_()) continue;
                        placePos = nearby;
                        found = true;
                    }
                }
                if (!found) {
                    return;
                }
            }
        }
        level.m_46597_(placePos, crossBlock.m_49966_());
        ResourceLocation woodSound = new ResourceLocation("minecraft", "block.wood.place");
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(woodSound);
        if (sound != null) {
            level.m_5594_(null, placePos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void handleStaringAnimal(ServerLevel level, Entity animal, Entity nearestDanger, UUID id, long now, boolean playSound, ResourceLocation soundLocation) {
        double dx = nearestDanger.m_20185_() - animal.m_20185_();
        double dz = nearestDanger.m_20189_() - animal.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        animal.m_146922_(yaw);
        if (animal instanceof Mob) {
            Mob mob = (Mob)animal;
            mob.f_20885_ = mob.m_146908_();
        }
        animal.m_20256_(new Vec3(0.0, animal.m_20184_().f_82480_, 0.0));
        if (playSound) {
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation);
            if (sound != null) {
                level.m_5594_(null, animal.m_20183_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            int delay = 200 + level.m_213780_().m_188503_(401);
            lastSoundTick.put(id, now + (long)delay);
        }
    }
}

