/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorStandEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final int CHUNKS_PER_TICK = 3;
    private static final int MAX_SEARCH_RADIUS_CHUNKS = 2;
    private static final int SEARCH_INTERVAL_TICKS = 100;
    private static final Map<Integer, ArmorStandEventState> activeEvents = new HashMap<Integer, ArmorStandEventState>();
    private static final Map<UUID, SearchProgress> searchProgress = new ConcurrentHashMap<UUID, SearchProgress>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        SearchProgress progress;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int currentTick = player.f_19797_;
        if (currentTick % 100 == 0) {
            progress = searchProgress.computeIfAbsent(playerUUID, k -> new SearchProgress());
            progress.reset();
        }
        if ((progress = searchProgress.get(playerUUID)) != null && !progress.searchComplete) {
            ArmorStandEventsProcedure.incrementalSearchChunks(player, server, progress);
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        if (progress == null || progress.foundStands.isEmpty()) {
            return;
        }
        ArrayList<ArmorStand> validStands = new ArrayList<ArmorStand>(progress.foundStands);
        if (validStands.isEmpty()) {
            return;
        }
        ArmorStand chosen = (ArmorStand)validStands.get(server.m_213780_().m_188503_(validStands.size()));
        ArmorStandEvent event = ArmorStandEvent.values()[server.m_213780_().m_188503_(ArmorStandEvent.values().length)];
        activeEvents.put(eventIdCounter++, new ArmorStandEventState(event, player, chosen));
    }

    private static void incrementalSearchChunks(Player player, ServerLevel level, SearchProgress progress) {
        BlockPos playerPos = player.m_20183_();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int chunksChecked = 0;
        while (chunksChecked < 3 && progress.currentRadius <= 2) {
            if (progress.currentRadius == 0) {
                ArmorStandEventsProcedure.searchChunkForArmorStands(level, playerChunkX, playerChunkZ, progress.foundStands);
                progress.currentRadius = 1;
                progress.currentAngle = 0;
                ++chunksChecked;
                continue;
            }
            int perimeterChunks = progress.currentRadius * 8;
            if (progress.currentAngle >= perimeterChunks) {
                ++progress.currentRadius;
                progress.currentAngle = 0;
                continue;
            }
            int side = progress.currentAngle / (progress.currentRadius * 2);
            int offset = progress.currentAngle % (progress.currentRadius * 2);
            int chunkX = playerChunkX;
            int chunkZ = playerChunkZ;
            switch (side) {
                case 0: {
                    chunkX = playerChunkX - progress.currentRadius + offset;
                    chunkZ = playerChunkZ - progress.currentRadius;
                    break;
                }
                case 1: {
                    chunkX = playerChunkX + progress.currentRadius;
                    chunkZ = playerChunkZ - progress.currentRadius + offset;
                    break;
                }
                case 2: {
                    chunkX = playerChunkX + progress.currentRadius - offset;
                    chunkZ = playerChunkZ + progress.currentRadius;
                    break;
                }
                case 3: {
                    chunkX = playerChunkX - progress.currentRadius;
                    chunkZ = playerChunkZ + progress.currentRadius - offset;
                }
            }
            ArmorStandEventsProcedure.searchChunkForArmorStands(level, chunkX, chunkZ, progress.foundStands);
            ++progress.currentAngle;
            ++chunksChecked;
        }
        if (progress.currentRadius > 2) {
            progress.searchComplete = true;
        }
    }

    private static void searchChunkForArmorStands(ServerLevel level, int chunkX, int chunkZ, List<ArmorStand> foundStands) {
        if (!level.m_7232_(chunkX, chunkZ)) {
            return;
        }
        for (Entity entity : level.m_8583_()) {
            if (!(entity instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)entity;
            BlockPos pos = stand.m_20183_();
            int entityChunkX = pos.m_123341_() >> 4;
            int entityChunkZ = pos.m_123343_() >> 4;
            if (entityChunkX != chunkX || entityChunkZ != chunkZ) continue;
            foundStands.add(stand);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ArmorStandEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ArmorStandEventState> entry = iterator.next();
            ArmorStandEventState state = entry.getValue();
            if (!state.armorStand.m_6084_() || state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                if (state.armorStand.m_6084_()) {
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                }
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            ArmorStandEventsProcedure.handleHeadTracking(server, state);
            switch (state.event) {
                case HEAD_TRACKING: {
                    if (state.tickCount < 200) break;
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                    iterator.remove();
                    break;
                }
                case ARMOR_SHIMMER: {
                    ArmorStandEventsProcedure.handleArmorShimmer(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                    break;
                }
                case SUDDEN_ROTATION: {
                    ArmorStandEventsProcedure.handleSuddenRotation(server, state);
                    if (state.tickCount < 60) break;
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                    iterator.remove();
                    break;
                }
                case HEAD_TWITCH: {
                    ArmorStandEventsProcedure.handleHeadTwitch(server, state);
                    if (state.tickCount < 40) break;
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                    iterator.remove();
                    break;
                }
                case RATTLE: {
                    ArmorStandEventsProcedure.handleRattle(server, state);
                    if (state.tickCount < 80) break;
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                    iterator.remove();
                    break;
                }
                case GHOST_SOUND: {
                    ArmorStandEventsProcedure.handleGhostSound(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                }
            }
        }
    }

    private static void handleHeadTracking(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 2 != 0) {
            return;
        }
        double dx = state.player.m_20185_() - state.armorStand.m_20185_();
        double dy = state.player.m_20186_() + (double)state.player.m_20192_() - state.armorStand.m_20186_() - 1.5;
        double dz = state.player.m_20189_() - state.armorStand.m_20189_();
        float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float pitch = (float)(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232);
        float standYaw = state.armorStand.m_146908_();
        float relativeYaw = Mth.m_14177_((float)(yaw - standYaw));
        state.armorStand.m_31597_(new Rotations(Mth.m_14036_((float)pitch, (float)-45.0f, (float)45.0f), Mth.m_14036_((float)relativeYaw, (float)-75.0f, (float)75.0f), 0.0f));
    }

    private static void handleArmorShimmer(ServerLevel server, ArmorStandEventState state) {
        if (state.player.m_20280_((Entity)state.armorStand) > 36.0) {
            return;
        }
        if (state.tickCount % 5 == 0) {
            double x = state.armorStand.m_20185_();
            double y = state.armorStand.m_20186_() + 1.0;
            double z = state.armorStand.m_20189_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 2, 0.3, 0.5, 0.3, 0.1);
        }
    }

    private static void handleSuddenRotation(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 20 != 0) {
            return;
        }
        float randomYaw = state.originalYRot + (server.m_213780_().m_188501_() * 360.0f - 180.0f);
        state.armorStand.m_146922_(randomYaw);
        state.armorStand.f_19859_ = randomYaw;
        server.m_5594_(null, new BlockPos((Vec3i)state.armorStand.m_20183_()), SoundEvents.f_144243_, SoundSource.BLOCKS, 0.7f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, state.armorStand.m_20185_(), state.armorStand.m_20186_() + 1.0, state.armorStand.m_20189_(), 6, 0.2, 0.5, 0.2, 0.02);
    }

    private static void handleHeadTwitch(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 3 != 0) {
            return;
        }
        float jitterYaw = (server.m_213780_().m_188501_() - 0.5f) * 20.0f;
        float jitterPitch = (server.m_213780_().m_188501_() - 0.5f) * 10.0f;
        Rotations r = new Rotations(Mth.m_14036_((float)(state.originalHeadPose.m_123156_() + jitterPitch), (float)-45.0f, (float)45.0f), Mth.m_14036_((float)(state.originalHeadPose.m_123157_() + jitterYaw), (float)-75.0f, (float)75.0f), state.originalHeadPose.m_123158_());
        state.armorStand.m_31597_(r);
        if (state.tickCount % 10 == 0) {
            server.m_5594_(null, new BlockPos((Vec3i)state.armorStand.m_20183_()), SoundEvents.f_11672_, SoundSource.BLOCKS, 0.4f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
        }
    }

    private static void handleRattle(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 5 != 0) {
            return;
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, state.armorStand.m_20185_(), state.armorStand.m_20186_() + 1.0, state.armorStand.m_20189_(), 1, 0.1, 0.2, 0.1, 0.01);
        if (state.tickCount % 15 == 0) {
            server.m_5594_(null, new BlockPos((Vec3i)state.armorStand.m_20183_()), SoundEvents.f_11675_, SoundSource.BLOCKS, 0.6f, 0.9f + server.m_213780_().m_188501_() * 0.2f);
        }
    }

    private static void handleGhostSound(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 25 != 0) {
            return;
        }
        server.m_5594_(null, new BlockPos((Vec3i)state.armorStand.m_20183_()), SoundEvents.f_215762_, SoundSource.HOSTILE, 0.3f, 0.6f + server.m_213780_().m_188501_() * 0.4f);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, state.armorStand.m_20185_(), state.armorStand.m_20186_() + 1.0, state.armorStand.m_20189_(), 4, 0.2, 0.3, 0.2, 0.01);
    }

    private static void restoreOriginalPoses(ArmorStandEventState state) {
        if (state.armorStand.m_6084_()) {
            state.armorStand.m_31597_(state.originalHeadPose);
            state.armorStand.m_146922_(state.originalYRot);
        }
    }

    private static class SearchProgress {
        int currentRadius = 0;
        int currentAngle = 0;
        boolean searchComplete = false;
        List<ArmorStand> foundStands = new ArrayList<ArmorStand>();

        private SearchProgress() {
        }

        void reset() {
            this.currentRadius = 0;
            this.currentAngle = 0;
            this.searchComplete = false;
            this.foundStands.clear();
        }
    }

    private static enum ArmorStandEvent {
        HEAD_TRACKING,
        ARMOR_SHIMMER,
        SUDDEN_ROTATION,
        HEAD_TWITCH,
        RATTLE,
        GHOST_SOUND;

    }

    private static class ArmorStandEventState {
        ArmorStandEvent event;
        Player player;
        ArmorStand armorStand;
        int tickCount;
        Rotations originalHeadPose;
        float originalYRot;
        boolean faded;

        ArmorStandEventState(ArmorStandEvent event, Player player, ArmorStand armorStand) {
            this.event = event;
            this.player = player;
            this.armorStand = armorStand;
            this.tickCount = 0;
            this.originalHeadPose = armorStand.m_31680_();
            this.originalYRot = armorStand.m_146908_();
            this.faded = false;
        }
    }
}

