/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BeaconEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final Map<Integer, BeaconEventState> activeEvents = new HashMap<Integer, BeaconEventState>();
    private static final Map<BlockPos, Long> beaconCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validBeacons = BeaconEventsProcedure.findValidBeacons(server, player);
        if (validBeacons.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validBeacons.removeIf(pos -> beaconCooldowns.containsKey(pos) && currentTime < beaconCooldowns.get(pos));
        if (validBeacons.isEmpty()) {
            return;
        }
        BlockPos chosen = validBeacons.get(server.m_213780_().m_188503_(validBeacons.size()));
        BeaconEvent event = BeaconEvent.values()[server.m_213780_().m_188503_(BeaconEvent.values().length)];
        beaconCooldowns.put(chosen, currentTime + 300L);
        activeEvents.put(eventIdCounter++, new BeaconEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, BeaconEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BeaconEventState> entry = iterator.next();
            BeaconEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case BEACON_FLICKER: {
                    BeaconEventsProcedure.handleBeaconFlicker(server, state);
                    break;
                }
                case BEACON_DEEP_SOUND: {
                    BeaconEventsProcedure.handleBeaconSound(server, state);
                }
            }
            if (state.tickCount < 200) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidBeacons(ServerLevel server, Player player) {
        ArrayList<BlockPos> beacons = new ArrayList<BlockPos>();
        int radius = 48;
        BlockPos playerPos = player.m_20183_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -10; y <= 10; ++y) {
                    BlockPos pos = playerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof BeaconBlock)) continue;
                    beacons.add(pos.m_7949_());
                }
            }
        }
        return beacons;
    }

    private static void handleBeaconFlicker(ServerLevel server, BeaconEventState state) {
        if (state.tickCount % 10 == 0) {
            state.beamVisible = !state.beamVisible;
            server.m_5594_(null, state.beaconPos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.1f, state.beamVisible ? 1.0f : 0.5f);
        }
    }

    private static void handleBeaconSound(ServerLevel server, BeaconEventState state) {
        if (state.tickCount % 40 == 0) {
            server.m_5594_(null, state.beaconPos, SoundEvents.f_11737_, SoundSource.BLOCKS, 0.3f, 0.3f);
        }
    }

    private static enum BeaconEvent {
        BEACON_FLICKER,
        BEACON_DEEP_SOUND;

    }

    private static class BeaconEventState {
        BeaconEvent event;
        Player player;
        BlockPos beaconPos;
        int tickCount;
        boolean beamVisible;

        BeaconEventState(BeaconEvent event, Player player, BlockPos beaconPos) {
            this.event = event;
            this.player = player;
            this.beaconPos = beaconPos;
            this.tickCount = 0;
            this.beamVisible = true;
        }
    }
}

