/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BedWatchingProcedure {
    private static final double BASE_PROB = 0.02;
    private static final double MAX_PROB = 0.08;
    private static final int MESSAGE_DELAY = 10;
    private static final int WAKE_DELAY = 40;
    private static final int DESPAWN_TIME = 60;
    private static final String KEY_ENABLED = "bedScareEnabled";
    private static final String KEY_MESSAGE_TICK = "bedScareMessageTick";
    private static final String KEY_SPAWN_TICK = "bedScareSpawnTick";
    private static final String KEY_CHECKED = "bedScareChecked";
    private static final String KEY_MESSAGE_SHOWN = "bedScareMessageShown";
    private static final String KEY_SPAWNED = "bedScareSpawned";
    private static final String KEY_ENTITY_UUID = "bedScareEntityUUID";
    private static final String KEY_BLOCK1_X = "bedScareBlock1X";
    private static final String KEY_BLOCK1_Y = "bedScareBlock1Y";
    private static final String KEY_BLOCK1_Z = "bedScareBlock1Z";
    private static final String KEY_BLOCK2_X = "bedScareBlock2X";
    private static final String KEY_BLOCK2_Y = "bedScareBlock2Y";
    private static final String KEY_BLOCK2_Z = "bedScareBlock2Z";
    private static final String KEY_STATE1 = "bedScareState1";
    private static final String KEY_STATE2 = "bedScareState2";
    private static final String KEY_WAITING_LOOK = "bedScareWaitingLook";
    private static final String KEY_LOOK_TIMER = "bedScareLookTimer";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer serverPlayer;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        CompoundTag data = player.getPersistentData();
        if (player.m_5803_() && !data.m_128471_(KEY_CHECKED)) {
            long dayTime;
            data.m_128379_(KEY_CHECKED, true);
            int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
            if (phase == 2 && ((dayTime = server.m_46468_() % 24000L) < 12541L || dayTime > 23458L)) {
                return;
            }
            double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 0.02, 0.08);
            if (server.m_213780_().m_188500_() >= dynamicProb) {
                return;
            }
            BlockPos bedPos = player.m_21257_().orElse(null);
            if (bedPos == null) {
                return;
            }
            BlockState bedState = server.m_8055_(bedPos);
            if (!(bedState.m_60734_() instanceof BedBlock)) {
                return;
            }
            BedPart bedPart = (BedPart)bedState.m_61143_((Property)BedBlock.f_49440_);
            Direction facing = (Direction)bedState.m_61143_((Property)BedBlock.f_54117_);
            BlockPos headPos = bedPart == BedPart.HEAD ? bedPos : bedPos.m_121945_(facing);
            BlockPos footPos = bedPart == BedPart.FOOT ? bedPos : bedPos.m_121945_(facing.m_122424_());
            BlockPos underHead1 = headPos.m_7495_();
            BlockPos underFoot1 = footPos.m_7495_();
            BlockPos underHead2 = headPos.m_6625_(2);
            BlockPos underFoot2 = footPos.m_6625_(2);
            BlockState state1 = server.m_8055_(underHead1);
            BlockState state2 = server.m_8055_(underFoot1);
            BlockState state3 = server.m_8055_(underHead2);
            BlockState state4 = server.m_8055_(underFoot2);
            if (state1.m_60795_() || state2.m_60795_() || state3.m_60795_() || state4.m_60795_()) {
                return;
            }
            if (ProtectedBlocksProcedure.isProtected(state1) || ProtectedBlocksProcedure.isProtected(state2) || ProtectedBlocksProcedure.isProtected(state3) || ProtectedBlocksProcedure.isProtected(state4)) {
                return;
            }
            long currentTick = server.m_46467_();
            data.m_128379_(KEY_ENABLED, true);
            data.m_128356_(KEY_MESSAGE_TICK, currentTick + 10L);
            data.m_128356_(KEY_SPAWN_TICK, currentTick + 40L);
            data.m_128379_(KEY_MESSAGE_SHOWN, false);
            data.m_128379_(KEY_SPAWNED, false);
            data.m_128405_(KEY_BLOCK1_X, underHead1.m_123341_());
            data.m_128405_(KEY_BLOCK1_Y, underHead1.m_123342_());
            data.m_128405_(KEY_BLOCK1_Z, underHead1.m_123343_());
            data.m_128359_(KEY_STATE1, ForgeRegistries.BLOCKS.getKey((Object)state1.m_60734_()).toString());
            data.m_128405_(KEY_BLOCK2_X, underFoot1.m_123341_());
            data.m_128405_(KEY_BLOCK2_Y, underFoot1.m_123342_());
            data.m_128405_(KEY_BLOCK2_Z, underFoot1.m_123343_());
            data.m_128359_(KEY_STATE2, ForgeRegistries.BLOCKS.getKey((Object)state2.m_60734_()).toString());
            data.m_128405_("bedScareBlock3X", underHead2.m_123341_());
            data.m_128405_("bedScareBlock3Y", underHead2.m_123342_());
            data.m_128405_("bedScareBlock3Z", underHead2.m_123343_());
            data.m_128359_("bedScareState3", ForgeRegistries.BLOCKS.getKey((Object)state3.m_60734_()).toString());
            data.m_128405_("bedScareBlock4X", underFoot2.m_123341_());
            data.m_128405_("bedScareBlock4Y", underFoot2.m_123342_());
            data.m_128405_("bedScareBlock4Z", underFoot2.m_123343_());
            data.m_128359_("bedScareState4", ForgeRegistries.BLOCKS.getKey((Object)state4.m_60734_()).toString());
        }
        if (!player.m_5803_() && data.m_128471_(KEY_CHECKED)) {
            data.m_128379_(KEY_CHECKED, false);
            if (!data.m_128471_(KEY_SPAWNED)) {
                data.m_128379_(KEY_ENABLED, false);
            }
        }
        if (!data.m_128471_(KEY_ENABLED)) {
            return;
        }
        long currentTick = server.m_46467_();
        if (!data.m_128471_(KEY_MESSAGE_SHOWN) && currentTick >= data.m_128454_(KEY_MESSAGE_TICK)) {
            data.m_128379_(KEY_MESSAGE_SHOWN, true);
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237113_((String)"\u00a77I feel something under the bed..."), false);
            }
        }
        if (!data.m_128471_(KEY_SPAWNED) && currentTick >= data.m_128454_(KEY_SPAWN_TICK)) {
            data.m_128379_(KEY_SPAWNED, true);
            if (player.m_5803_() && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.m_6145_(true, true);
            }
            BlockPos block1Pos = new BlockPos(data.m_128451_(KEY_BLOCK1_X), data.m_128451_(KEY_BLOCK1_Y), data.m_128451_(KEY_BLOCK1_Z));
            BlockPos block2Pos = new BlockPos(data.m_128451_(KEY_BLOCK2_X), data.m_128451_(KEY_BLOCK2_Y), data.m_128451_(KEY_BLOCK2_Z));
            BlockPos block3Pos = new BlockPos(data.m_128451_("bedScareBlock3X"), data.m_128451_("bedScareBlock3Y"), data.m_128451_("bedScareBlock3Z"));
            BlockPos block4Pos = new BlockPos(data.m_128451_("bedScareBlock4X"), data.m_128451_("bedScareBlock4Y"), data.m_128451_("bedScareBlock4Z"));
            ProtectedBlocksProcedure.markModCausedBreak(block1Pos);
            ProtectedBlocksProcedure.markModCausedBreak(block2Pos);
            ProtectedBlocksProcedure.markModCausedBreak(block3Pos);
            ProtectedBlocksProcedure.markModCausedBreak(block4Pos);
            server.m_46961_(block1Pos, false);
            server.m_46961_(block2Pos, false);
            server.m_46961_(block3Pos, false);
            server.m_46961_(block4Pos, false);
            Entity entity = ((EntityType)FromTheCavesModEntities.FROMTHECAVESBED.get()).m_20615_((Level)server);
            if (entity != null) {
                double centerX = (double)(block1Pos.m_123341_() + block2Pos.m_123341_()) / 2.0 + 0.5;
                double centerZ = (double)(block1Pos.m_123343_() + block2Pos.m_123343_()) / 2.0 + 0.5;
                double spawnY = block1Pos.m_123342_();
                Vec3 playerPos = player.m_20182_();
                double dx = playerPos.f_82479_ - centerX;
                double dz = playerPos.f_82481_ - centerZ;
                float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
                entity.m_7678_(centerX, spawnY, centerZ, yaw, 0.0f);
                entity.m_146922_(yaw);
                entity.m_5616_(yaw);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21557_(true);
                }
                entity.getPersistentData().m_128379_("bed_scare", true);
                entity.getPersistentData().m_128362_("player_id", player.m_20148_());
                entity.getPersistentData().m_128356_("spawn_tick", currentTick);
                CompoundTag blocksTag = new CompoundTag();
                blocksTag.m_128405_("x1", block1Pos.m_123341_());
                blocksTag.m_128405_("y1", block1Pos.m_123342_());
                blocksTag.m_128405_("z1", block1Pos.m_123343_());
                blocksTag.m_128359_("block1", data.m_128461_(KEY_STATE1));
                blocksTag.m_128405_("x2", block2Pos.m_123341_());
                blocksTag.m_128405_("y2", block2Pos.m_123342_());
                blocksTag.m_128405_("z2", block2Pos.m_123343_());
                blocksTag.m_128359_("block2", data.m_128461_(KEY_STATE2));
                blocksTag.m_128405_("x3", block3Pos.m_123341_());
                blocksTag.m_128405_("y3", block3Pos.m_123342_());
                blocksTag.m_128405_("z3", block3Pos.m_123343_());
                blocksTag.m_128359_("block3", data.m_128461_("bedScareState3"));
                blocksTag.m_128405_("x4", block4Pos.m_123341_());
                blocksTag.m_128405_("y4", block4Pos.m_123342_());
                blocksTag.m_128405_("z4", block4Pos.m_123343_());
                blocksTag.m_128359_("block4", data.m_128461_("bedScareState4"));
                entity.getPersistentData().m_128365_("bed_blocks", (Tag)blocksTag);
                server.m_7967_(entity);
                data.m_128362_(KEY_ENTITY_UUID, entity.m_20148_());
                data.m_128379_(KEY_WAITING_LOOK, true);
                data.m_128405_(KEY_LOOK_TIMER, 0);
            }
        }
        if (data.m_128471_(KEY_SPAWNED) && data.m_128441_(KEY_ENTITY_UUID)) {
            long elapsed;
            ServerPlayer serverPlayer2;
            UUID entityUUID = data.m_128342_(KEY_ENTITY_UUID);
            Entity entity = server.m_8791_(entityUUID);
            if (entity == null || !entity.m_6084_()) {
                BedWatchingProcedure.restoreBlocksFromData(server, data);
                data.m_128379_(KEY_ENABLED, false);
                return;
            }
            if (data.m_128471_(KEY_WAITING_LOOK) && player instanceof ServerPlayer && BedWatchingProcedure.isLookingAt(serverPlayer2 = (ServerPlayer)player, entity)) {
                data.m_128379_(KEY_WAITING_LOOK, false);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21557_(false);
                }
            }
            if (currentTick % 2L == 0L) {
                Vec3 playerPos = player.m_20182_();
                double dx = playerPos.f_82479_ - entity.m_20185_();
                double dz = playerPos.f_82481_ - entity.m_20189_();
                float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
                entity.m_146922_(yaw);
                entity.m_5616_(yaw);
            }
            if (!data.m_128471_(KEY_WAITING_LOOK)) {
                int timer = data.m_128451_(KEY_LOOK_TIMER);
                data.m_128405_(KEY_LOOK_TIMER, ++timer);
                if (timer >= 60) {
                    entity.m_146870_();
                    BedWatchingProcedure.restoreBlocksFromData(server, data);
                    data.m_128379_(KEY_ENABLED, false);
                    return;
                }
            }
            if ((elapsed = currentTick - entity.getPersistentData().m_128454_("spawn_tick")) > 200L) {
                entity.m_146870_();
                BedWatchingProcedure.restoreBlocksFromData(server, data);
                data.m_128379_(KEY_ENABLED, false);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level level;
        LivingEntity entity;
        CompoundTag data;
        if (event.getEntity().getPersistentData().m_128471_("bed_scare") && (data = (entity = event.getEntity()).getPersistentData()).m_128441_("bed_blocks") && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            CompoundTag blocksTag = data.m_128469_("bed_blocks");
            BedWatchingProcedure.restoreBlocksFromTag(level2, blocksTag);
        }
    }

    private static boolean isLookingAt(ServerPlayer player, Entity entity) {
        Vec3 playerLook = player.m_20154_();
        Vec3 toEntity = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(player.m_20299_(1.0f));
        double distance = toEntity.m_82553_();
        if (distance > 10.0) {
            return false;
        }
        double dot = playerLook.m_82526_(toEntity = toEntity.m_82541_());
        return dot > 0.5;
    }

    private static void restoreBlocksFromData(ServerLevel level, CompoundTag data) {
        try {
            BlockPos pos4;
            BlockPos pos3;
            BlockPos pos2;
            BlockPos pos1 = new BlockPos(data.m_128451_(KEY_BLOCK1_X), data.m_128451_(KEY_BLOCK1_Y), data.m_128451_(KEY_BLOCK1_Z));
            if (level.m_8055_(pos1).m_60795_()) {
                String blockId = data.m_128461_(KEY_STATE1);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos1, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos1, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos2 = new BlockPos(data.m_128451_(KEY_BLOCK2_X), data.m_128451_(KEY_BLOCK2_Y), data.m_128451_(KEY_BLOCK2_Z))).m_60795_()) {
                String blockId = data.m_128461_(KEY_STATE2);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos2, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos2, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos3 = new BlockPos(data.m_128451_("bedScareBlock3X"), data.m_128451_("bedScareBlock3Y"), data.m_128451_("bedScareBlock3Z"))).m_60795_()) {
                String blockId = data.m_128461_("bedScareState3");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos3, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos3, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos4 = new BlockPos(data.m_128451_("bedScareBlock4X"), data.m_128451_("bedScareBlock4Y"), data.m_128451_("bedScareBlock4Z"))).m_60795_()) {
                String blockId = data.m_128461_("bedScareState4");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos4, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos4, Blocks.f_50069_.m_49966_(), 3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void restoreBlocksFromTag(ServerLevel level, CompoundTag blocksTag) {
        try {
            BlockPos pos4;
            BlockPos pos3;
            BlockPos pos2;
            BlockPos pos1 = new BlockPos(blocksTag.m_128451_("x1"), blocksTag.m_128451_("y1"), blocksTag.m_128451_("z1"));
            if (level.m_8055_(pos1).m_60795_()) {
                String blockId = blocksTag.m_128461_("block1");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos1, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos1, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos2 = new BlockPos(blocksTag.m_128451_("x2"), blocksTag.m_128451_("y2"), blocksTag.m_128451_("z2"))).m_60795_()) {
                String blockId = blocksTag.m_128461_("block2");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos2, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos2, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos3 = new BlockPos(blocksTag.m_128451_("x3"), blocksTag.m_128451_("y3"), blocksTag.m_128451_("z3"))).m_60795_()) {
                String blockId = blocksTag.m_128461_("block3");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos3, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos3, Blocks.f_50069_.m_49966_(), 3);
                }
            }
            if (level.m_8055_(pos4 = new BlockPos(blocksTag.m_128451_("x4"), blocksTag.m_128451_("y4"), blocksTag.m_128451_("z4"))).m_60795_()) {
                String blockId = blocksTag.m_128461_("block4");
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockId));
                if (block != null) {
                    level.m_7731_(pos4, block.m_49966_(), 3);
                } else {
                    level.m_7731_(pos4, Blocks.f_50069_.m_49966_(), 3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

