/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BellEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final int CHUNKS_PER_TICK = 3;
    private static final int MAX_SEARCH_RADIUS_CHUNKS = 2;
    private static final int SEARCH_INTERVAL_TICKS = 100;
    private static final Map<Integer, BellRingState> activeRings = new HashMap<Integer, BellRingState>();
    private static final Map<BlockPos, Long> bellCooldowns = new HashMap<BlockPos, Long>();
    private static final Map<UUID, SearchProgress> searchProgress = new ConcurrentHashMap<UUID, SearchProgress>();
    private static int ringIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        SearchProgress progress;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int currentTick = player.f_19797_;
        if (currentTick % 100 == 0) {
            progress = searchProgress.computeIfAbsent(playerUUID, k -> new SearchProgress());
            progress.reset();
        }
        if ((progress = searchProgress.get(playerUUID)) != null && !progress.searchComplete) {
            BellEventsProcedure.incrementalSearchChunks(player, server, progress);
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        if (progress == null || progress.foundBells.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        ArrayList<BlockPos> validBells = new ArrayList<BlockPos>(progress.foundBells);
        validBells.removeIf(pos -> bellCooldowns.containsKey(pos) && currentTime < bellCooldowns.get(pos));
        if (validBells.isEmpty()) {
            return;
        }
        BlockPos chosen = (BlockPos)validBells.get(server.m_213780_().m_188503_(validBells.size()));
        BellEvent event = BellEvent.values()[server.m_213780_().m_188503_(BellEvent.values().length)];
        bellCooldowns.put(chosen, currentTime + 600L);
        List<Object> group = event == BellEvent.SYNCHRONIZED_BELLS ? (validBells.size() > 1 ? validBells.subList(0, Math.min(4, validBells.size())) : Collections.singletonList(chosen)) : Collections.singletonList(chosen);
        BellRingState state = new BellRingState(event, player, chosen, group);
        switch (event) {
            case SINGLE_RING: {
                state.ringsRemaining = 1;
                break;
            }
            case MULTIPLE_RINGS: {
                state.ringsRemaining = 3 + server.m_213780_().m_188503_(3);
                break;
            }
            case FAST_RINGS: {
                state.ringsRemaining = 8 + server.m_213780_().m_188503_(5);
                break;
            }
            case SLOW_OMINOUS_RINGS: {
                state.ringsRemaining = 4;
                state.basePitch = 0.7f;
                break;
            }
            case DEATH_TOLL: {
                state.ringsRemaining = 13;
                state.basePitch = 0.5f;
                break;
            }
            case CHAOTIC_RINGS: {
                state.ringsRemaining = 10 + server.m_213780_().m_188503_(10);
                break;
            }
            case ASCENDING_PITCH: {
                state.ringsRemaining = 8;
                state.basePitch = 0.6f;
                break;
            }
            case DESCENDING_PITCH: {
                state.ringsRemaining = 8;
                state.basePitch = 1.8f;
            }
        }
        activeRings.put(ringIdCounter++, state);
    }

    private static void incrementalSearchChunks(Player player, ServerLevel level, SearchProgress progress) {
        BlockPos playerPos = player.m_20183_();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int playerY = playerPos.m_123342_();
        int chunksChecked = 0;
        while (chunksChecked < 3 && progress.currentRadius <= 2) {
            if (progress.currentRadius == 0) {
                BellEventsProcedure.searchChunkForBells(level, playerChunkX, playerChunkZ, playerY, progress.foundBells);
                progress.currentRadius = 1;
                progress.currentAngle = 0;
                ++chunksChecked;
                continue;
            }
            int perimeterChunks = progress.currentRadius * 8;
            if (progress.currentAngle >= perimeterChunks) {
                ++progress.currentRadius;
                progress.currentAngle = 0;
                continue;
            }
            int side = progress.currentAngle / (progress.currentRadius * 2);
            int offset = progress.currentAngle % (progress.currentRadius * 2);
            int chunkX = playerChunkX;
            int chunkZ = playerChunkZ;
            switch (side) {
                case 0: {
                    chunkX = playerChunkX - progress.currentRadius + offset;
                    chunkZ = playerChunkZ - progress.currentRadius;
                    break;
                }
                case 1: {
                    chunkX = playerChunkX + progress.currentRadius;
                    chunkZ = playerChunkZ - progress.currentRadius + offset;
                    break;
                }
                case 2: {
                    chunkX = playerChunkX + progress.currentRadius - offset;
                    chunkZ = playerChunkZ + progress.currentRadius;
                    break;
                }
                case 3: {
                    chunkX = playerChunkX - progress.currentRadius;
                    chunkZ = playerChunkZ + progress.currentRadius - offset;
                }
            }
            BellEventsProcedure.searchChunkForBells(level, chunkX, chunkZ, playerY, progress.foundBells);
            ++progress.currentAngle;
            ++chunksChecked;
        }
        if (progress.currentRadius > 2) {
            progress.searchComplete = true;
        }
    }

    private static void searchChunkForBells(ServerLevel level, int chunkX, int chunkZ, int playerY, List<BlockPos> foundBells) {
        if (!level.m_7232_(chunkX, chunkZ)) {
            return;
        }
        LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
        int baseX = chunk.m_7697_().m_45604_();
        int baseZ = chunk.m_7697_().m_45605_();
        int minY = Math.max(level.m_141937_(), playerY - 8);
        int maxY = Math.min(level.m_151558_() - 1, playerY + 8);
        for (int lx = 0; lx < 16; ++lx) {
            for (int lz = 0; lz < 16; ++lz) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                    BlockState state = level.m_8055_(pos);
                    if (!(state.m_60734_() instanceof BellBlock)) continue;
                    foundBells.add(pos.m_7949_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, BellRingState>> iterator = activeRings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BellRingState> entry = iterator.next();
            BellRingState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCounter;
            if (state.ringsRemaining <= 0) {
                iterator.remove();
                continue;
            }
            --state.nextRingTick;
            if (state.nextRingTick > 0) continue;
            switch (state.event) {
                case SINGLE_RING: {
                    BellEventsProcedure.ringBell(server, state, 1.0f);
                    state.ringsRemaining = 0;
                    break;
                }
                case MULTIPLE_RINGS: {
                    BellEventsProcedure.ringBell(server, state, 1.0f);
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 15 + server.m_213780_().m_188503_(10);
                    break;
                }
                case FAST_RINGS: {
                    BellEventsProcedure.ringBell(server, state, 1.1f + server.m_213780_().m_188501_() * 0.3f);
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 3 + server.m_213780_().m_188503_(3);
                    break;
                }
                case SLOW_OMINOUS_RINGS: {
                    BellEventsProcedure.ringBellWithParticles(server, state, state.basePitch, (ParticleOptions)ParticleTypes.f_123746_);
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 40 + server.m_213780_().m_188503_(20);
                    break;
                }
                case DISTANT_ECHO: {
                    if (state.tickCounter % 30 == 0) {
                        float echoVolume = 0.3f + server.m_213780_().m_188501_() * 0.2f;
                        server.m_5594_(null, state.bellPos, SoundEvents.f_11699_, SoundSource.BLOCKS, echoVolume, 0.8f);
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)state.bellPos.m_123341_() + 0.5, (double)state.bellPos.m_123342_() + 0.5, (double)state.bellPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (state.tickCounter < 180) break;
                    state.ringsRemaining = 0;
                    break;
                }
                case DEATH_TOLL: {
                    BellEventsProcedure.ringBellWithParticles(server, state, state.basePitch, (ParticleOptions)ParticleTypes.f_235898_);
                    server.m_5594_(null, state.bellPos, SoundEvents.f_215762_, SoundSource.HOSTILE, 0.3f, 0.5f);
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 60;
                    break;
                }
                case CHAOTIC_RINGS: {
                    float randomPitch = 0.5f + server.m_213780_().m_188501_() * 1.5f;
                    BellEventsProcedure.ringBell(server, state, randomPitch);
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 2 + server.m_213780_().m_188503_(8);
                    break;
                }
                case SYNCHRONIZED_BELLS: {
                    for (BlockPos pos : state.bellGroup) {
                        server.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 0.9f, 1.0f);
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
                    }
                    --state.ringsRemaining;
                    if (state.ringsRemaining > 0) {
                        state.nextRingTick = 20 + server.m_213780_().m_188503_(15);
                    } else {
                        state.ringsRemaining = 0;
                    }
                    if (state.tickCounter != 1) break;
                    state.ringsRemaining = 5;
                    break;
                }
                case ASCENDING_PITCH: {
                    BellEventsProcedure.ringBell(server, state, state.basePitch);
                    state.basePitch += 0.15f;
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 12;
                    break;
                }
                case DESCENDING_PITCH: {
                    BellEventsProcedure.ringBell(server, state, state.basePitch);
                    state.basePitch -= 0.15f;
                    --state.ringsRemaining;
                    if (state.ringsRemaining <= 0) break;
                    state.nextRingTick = 12;
                }
            }
        }
    }

    private static void ringBell(ServerLevel server, BellRingState state, float pitch) {
        float pitchVariation = (server.m_213780_().m_188501_() - 0.5f) * 0.1f;
        float finalPitch = Mth.m_14036_((float)(pitch + pitchVariation), (float)0.5f, (float)2.0f);
        server.m_5594_(null, state.bellPos, SoundEvents.f_11699_, SoundSource.BLOCKS, 1.0f, finalPitch);
        if (server.m_213780_().m_188501_() < 0.7f) {
            double x = (double)state.bellPos.m_123341_() + 0.5;
            double y = (double)state.bellPos.m_123342_() + 0.5;
            double z = (double)state.bellPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void ringBellWithParticles(ServerLevel server, BellRingState state, float pitch, ParticleOptions particle) {
        server.m_5594_(null, state.bellPos, SoundEvents.f_11699_, SoundSource.BLOCKS, 1.0f, pitch);
        double x = (double)state.bellPos.m_123341_() + 0.5;
        double y = (double)state.bellPos.m_123342_() + 0.5;
        double z = (double)state.bellPos.m_123343_() + 0.5;
        server.m_8767_(particle, x, y, z, 5, 0.3, 0.2, 0.3, 0.02);
    }

    private static class SearchProgress {
        int currentRadius = 0;
        int currentAngle = 0;
        boolean searchComplete = false;
        List<BlockPos> foundBells = new ArrayList<BlockPos>();

        private SearchProgress() {
        }

        void reset() {
            this.currentRadius = 0;
            this.currentAngle = 0;
            this.searchComplete = false;
            this.foundBells.clear();
        }
    }

    private static enum BellEvent {
        SINGLE_RING,
        MULTIPLE_RINGS,
        FAST_RINGS,
        SLOW_OMINOUS_RINGS,
        DISTANT_ECHO,
        DEATH_TOLL,
        CHAOTIC_RINGS,
        SYNCHRONIZED_BELLS,
        ASCENDING_PITCH,
        DESCENDING_PITCH;

    }

    private static class BellRingState {
        BellEvent event;
        Player player;
        BlockPos bellPos;
        List<BlockPos> bellGroup;
        int ringsRemaining;
        int nextRingTick;
        float basePitch;
        int tickCounter;

        BellRingState(BellEvent event, Player player, BlockPos bellPos, List<BlockPos> bellGroup) {
            this.event = event;
            this.player = player;
            this.bellPos = bellPos;
            this.bellGroup = bellGroup;
            this.ringsRemaining = 2 + new Random().nextInt(4);
            this.nextRingTick = 0;
            this.basePitch = 1.0f;
            this.tickCounter = 0;
        }
    }
}

