/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BookshelfEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final Map<Integer, BookshelfEventState> activeEvents = new HashMap<Integer, BookshelfEventState>();
    private static final Map<BlockPos, Long> bookshelfCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validBookshelves = BookshelfEventsProcedure.findValidBookshelves(server, player);
        if (validBookshelves.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validBookshelves.removeIf(pos -> bookshelfCooldowns.containsKey(pos) && currentTime < bookshelfCooldowns.get(pos));
        if (validBookshelves.isEmpty()) {
            return;
        }
        BlockPos chosen = validBookshelves.get(server.m_213780_().m_188503_(validBookshelves.size()));
        BookshelfEvent event = BookshelfEvent.values()[server.m_213780_().m_188503_(BookshelfEvent.values().length)];
        bookshelfCooldowns.put(chosen, currentTime + 300L);
        activeEvents.put(eventIdCounter++, new BookshelfEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, BookshelfEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BookshelfEventState> entry = iterator.next();
            BookshelfEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                for (ItemEntity item : state.spawnedItems) {
                    if (!item.m_6084_()) continue;
                    item.m_146870_();
                }
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case BOOKS_FALLING: {
                    BookshelfEventsProcedure.handleBooksFalling(server, state);
                    break;
                }
                case BOOK_PAGE_SOUNDS: {
                    BookshelfEventsProcedure.handlePageSounds(server, state);
                    break;
                }
                case BOOKS_FLOATING: {
                    BookshelfEventsProcedure.handleBooksFloating(server, state);
                    break;
                }
                case ENCHANT_PARTICLES: {
                    BookshelfEventsProcedure.handleEnchantParticles(server, state);
                }
            }
            if (state.tickCount < 160) continue;
            for (ItemEntity item : state.spawnedItems) {
                if (!item.m_6084_()) continue;
                item.m_146870_();
            }
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidBookshelves(ServerLevel server, Player player) {
        ArrayList<BlockPos> bookshelves = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -3; y <= 3; ++y) {
                    BlockPos pos = playerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (state.m_60734_() != Blocks.f_50078_) continue;
                    bookshelves.add(pos.m_7949_());
                }
            }
        }
        return bookshelves;
    }

    private static void handleBooksFalling(ServerLevel server, BookshelfEventState state) {
        if (state.tickCount % 10 == 0 && state.tickCount <= 50) {
            double x = (double)state.bookshelfPos.m_123341_() + 0.5;
            double y = (double)state.bookshelfPos.m_123342_() + 1.0;
            double z = (double)state.bookshelfPos.m_123343_() + 0.5;
            ItemEntity bookEntity = new ItemEntity((Level)server, x, y, z, new ItemStack((ItemLike)Items.f_42517_));
            bookEntity.m_20334_((server.m_213780_().m_188500_() - 0.5) * 0.1, 0.1, (server.m_213780_().m_188500_() - 0.5) * 0.1);
            server.m_7967_((Entity)bookEntity);
            state.spawnedItems.add(bookEntity);
        }
    }

    private static void handlePageSounds(ServerLevel server, BookshelfEventState state) {
        if (state.tickCount % 5 == 0) {
            server.m_5594_(null, state.bookshelfPos, SoundEvents.f_11713_, SoundSource.BLOCKS, 0.3f, 1.5f);
        }
    }

    private static void handleBooksFloating(ServerLevel server, BookshelfEventState state) {
        block3: {
            block2: {
                if (state.tickCount != 1) break block2;
                for (int i = 0; i < 3; ++i) {
                    double x = (double)state.bookshelfPos.m_123341_() + 0.3 + (double)i * 0.2;
                    double y = (double)state.bookshelfPos.m_123342_() + 1.5;
                    double z = (double)state.bookshelfPos.m_123343_() + 0.5;
                    ItemEntity bookEntity = new ItemEntity((Level)server, x, y, z, new ItemStack((ItemLike)Items.f_42517_));
                    bookEntity.m_20242_(true);
                    bookEntity.m_20334_(0.0, 0.0, 0.0);
                    server.m_7967_((Entity)bookEntity);
                    state.spawnedItems.add(bookEntity);
                }
                break block3;
            }
            if (state.tickCount != 60) break block3;
            for (ItemEntity item : state.spawnedItems) {
                if (!item.m_6084_()) continue;
                item.m_20242_(false);
                item.m_20334_((server.m_213780_().m_188500_() - 0.5) * 0.2, 0.1, (server.m_213780_().m_188500_() - 0.5) * 0.2);
            }
        }
    }

    private static void handleEnchantParticles(ServerLevel server, BookshelfEventState state) {
        double x = (double)state.bookshelfPos.m_123341_() + 0.5;
        double y = (double)state.bookshelfPos.m_123342_() + 1.0;
        double z = (double)state.bookshelfPos.m_123343_() + 0.5;
        if (state.tickCount % 3 == 0) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 3, 0.3, 0.5, 0.3, 0.1);
        }
    }

    private static enum BookshelfEvent {
        BOOKS_FALLING,
        BOOK_PAGE_SOUNDS,
        BOOKS_FLOATING,
        ENCHANT_PARTICLES;

    }

    private static class BookshelfEventState {
        BookshelfEvent event;
        Player player;
        BlockPos bookshelfPos;
        int tickCount;
        List<ItemEntity> spawnedItems;

        BookshelfEventState(BookshelfEvent event, Player player, BlockPos bookshelfPos) {
            this.event = event;
            this.player = player;
            this.bookshelfPos = bookshelfPos;
            this.tickCount = 0;
            this.spawnedItems = new ArrayList<ItemEntity>();
        }
    }
}

