/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mcreator.fromthecaves.entity.FROMTHECAVESCAVESPIDEREntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CaveSpiderSpawnProcedure {
    private static final double BASE_PROB = 3.0E-5;
    private static final double MAX_PROB = 5.0E-5;
    private static final int MIN_SPAWN_DIST = 10;
    private static final int MAX_SPAWN_DIST = 32;
    private static final int MAX_SPAWN_ATTEMPTS = 15;
    private static final int MAX_PLAYER_HEIGHT = 50;
    private static final int VERTICAL_OFFSET_RANGE = 3;
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!CaveSpiderSpawnProcedure.shouldAttemptSpawn(server, player)) {
            return;
        }
        BlockPos spawnPos = CaveSpiderSpawnProcedure.findOptimalSpawnPosition(level, player);
        if (spawnPos == null) {
            return;
        }
        CaveSpiderSpawnProcedure.createAndSpawnEntity(server, spawnPos);
    }

    private static boolean shouldAttemptSpawn(ServerLevel server, Player player) {
        if (player.m_20186_() >= 50.0) {
            return false;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return false;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 3.0E-5, 5.0E-5);
        return RNG.nextDouble() < dynamicProb;
    }

    private static BlockPos findOptimalSpawnPosition(Level level, Player player) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        BlockPos playerPos = player.m_20183_();
        for (int attempt = 0; attempt < 15; ++attempt) {
            BlockPos candidate = CaveSpiderSpawnProcedure.generateSpawnPosition(player, playerPos);
            if (!CaveSpiderSpawnProcedure.isChunkLoaded(level, candidate) || !CaveSpiderSpawnProcedure.hasValidAirSpace(level, candidate) || !CaveSpiderSpawnProcedure.hasSolidGround(level, candidate) || !CaveSpiderSpawnProcedure.hasAdjacentStoneWall(level, candidate)) continue;
            validPositions.add(candidate);
            if (validPositions.size() >= 3) break;
        }
        return validPositions.isEmpty() ? null : CaveSpiderSpawnProcedure.selectBestPosition(validPositions, player);
    }

    private static BlockPos generateSpawnPosition(Player player, BlockPos playerPos) {
        double angle = RNG.nextDouble() * Math.PI * 2.0;
        double distance = 10.0 + RNG.nextDouble() * 22.0;
        double dx = Math.cos(angle) * distance;
        double dz = Math.sin(angle) * distance;
        int cx = Mth.m_14107_((double)(player.m_20185_() + dx));
        int cz = Mth.m_14107_((double)(player.m_20189_() + dz));
        int cy = Mth.m_14107_((double)player.m_20186_()) + RNG.nextInt(7) - 3;
        return new BlockPos(cx, cy, cz);
    }

    private static boolean isChunkLoaded(Level level, BlockPos pos) {
        return level.m_46749_(pos);
    }

    private static boolean hasValidAirSpace(Level level, BlockPos pos) {
        if (!level.m_46859_(pos)) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        return level.m_46859_(above);
    }

    private static boolean hasSolidGround(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (!level.m_46749_(below)) {
            return false;
        }
        BlockState state = level.m_8055_(below);
        if (state.m_60795_()) {
            return false;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)level, below);
        return !shape.m_83281_();
    }

    private static boolean hasAdjacentStoneWall(Level level, BlockPos center) {
        BlockState state;
        BlockPos adjacentPos;
        int stoneWallCount = 0;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            adjacentPos = center.m_121945_(dir);
            if (!level.m_46749_(adjacentPos) || !CaveSpiderSpawnProcedure.isNaturalStone(state = level.m_8055_(adjacentPos))) continue;
            ++stoneWallCount;
        }
        for (Direction dir : Direction.Plane.VERTICAL) {
            adjacentPos = center.m_121945_(dir);
            if (!level.m_46749_(adjacentPos) || !CaveSpiderSpawnProcedure.isNaturalStone(state = level.m_8055_(adjacentPos))) continue;
            ++stoneWallCount;
        }
        return stoneWallCount >= 1;
    }

    private static boolean isNaturalStone(BlockState state) {
        return state.m_60734_() == Blocks.f_50069_ || state.m_60734_() == Blocks.f_152550_ || state.m_60734_() == Blocks.f_50334_ || state.m_60734_() == Blocks.f_50228_ || state.m_60734_() == Blocks.f_50122_ || state.m_60734_() == Blocks.f_50652_ || state.m_60734_() == Blocks.f_152551_;
    }

    private static BlockPos selectBestPosition(List<BlockPos> positions, Player player) {
        if (positions.size() == 1) {
            return positions.get(0);
        }
        BlockPos playerPos = player.m_20183_();
        BlockPos best = positions.get(0);
        double bestScore = CaveSpiderSpawnProcedure.evaluatePosition(best, playerPos, player);
        for (int i = 1; i < positions.size(); ++i) {
            BlockPos candidate = positions.get(i);
            double score = CaveSpiderSpawnProcedure.evaluatePosition(candidate, playerPos, player);
            if (!(score > bestScore)) continue;
            best = candidate;
            bestScore = score;
        }
        return best;
    }

    private static double evaluatePosition(BlockPos pos, BlockPos playerPos, Player player) {
        double distance = Math.sqrt(pos.m_123331_((Vec3i)playerPos));
        double targetDist = 21.0;
        double distanceScore = 1.0 - Math.abs(distance - targetDist) / 32.0;
        double heightDiff = Math.abs(pos.m_123342_() - playerPos.m_123342_());
        double heightScore = 1.0 - heightDiff / 20.0;
        Vec3 playerLook = player.m_20154_();
        Vec3 toSpawn = new Vec3((double)(pos.m_123341_() - playerPos.m_123341_()), (double)(pos.m_123342_() - playerPos.m_123342_()), (double)(pos.m_123343_() - playerPos.m_123343_())).m_82541_();
        double behindScore = 1.0 - Math.max(0.0, playerLook.m_82526_(toSpawn));
        return distanceScore * 0.4 + heightScore * 0.3 + behindScore * 0.3;
    }

    private static void createAndSpawnEntity(ServerLevel server, BlockPos pos) {
        FROMTHECAVESCAVESPIDEREntity spider = (FROMTHECAVESCAVESPIDEREntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESCAVESPIDER.get()).m_20615_((Level)server);
        if (spider == null) {
            return;
        }
        spider.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, RNG.nextFloat() * 360.0f, 0.0f);
        spider.getPersistentData().m_128379_("caveMode", true);
        spider.m_21557_(false);
        spider.m_21530_();
        server.m_7967_((Entity)spider);
    }
}

