/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.item.CrossCompassItem;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.util.CemeteryMarkerManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CrossCompassBehaviorProcedure {
    private static final int SEARCH_INTERVAL_TICKS = 200;
    private static final int ANIMATION_UPDATE_INTERVAL_TICKS = 15;
    private static final int PARTICLE_INTERVAL_TICKS = 30;
    private static final int INITIAL_PARTICLE_INTERVAL_TICKS = 60;
    private static final int INITIAL_PHASE_DURATION_TICKS = 600;
    private static final int MARKER_HIGHLIGHT_INTERVAL_TICKS = 10;
    private static final int PROXIMITY_MESSAGE_INTERVAL = 300;
    private static final int CHUNKS_PER_TICK = 16;
    private static final int MAX_SEARCH_RADIUS_CHUNKS = 1024;
    private static final int VERTICAL_SEARCH_RANGE = 48;
    private static final double PROXIMITY_THRESHOLD = 96.0;
    private static final double MAX_SEARCH_RADIUS_BLOCKS = 65536.0;
    private static final double DIST_HIGH = 1028.0;
    private static final double DIST_MED = 512.0;
    private static final double DIST_CLOSE = 256.0;
    private static final double DIST_VERY_CLOSE = 64.0;
    private static final double HIGHLIGHT_DISTANCE = 30.0;
    private static final double DIST_STRUCTURE_VERY_FAR = 2048.0;
    private static final double DIST_STRUCTURE_FAR = 1024.0;
    private static final String ANIM_1 = "animation.WoodenCross.1";
    private static final String ANIM_2 = "animation.WoodenCross.2";
    private static final String ANIM_3 = "animation.WoodenCross.3";
    private static final String ANIM_4 = "animation.WoodenCross.4";
    private static final Map<UUID, CompassCacheEntry> playerCache = new ConcurrentHashMap<UUID, CompassCacheEntry>();
    private static final Map<UUID, SearchProgress> searchProgress = new ConcurrentHashMap<UUID, SearchProgress>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long lastAnimUpdateTick;
        BlockPos structurePos;
        BlockPos foundMarker;
        SearchProgress progress;
        boolean isStructureTarget;
        boolean offIsCompass;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player == null) {
            return;
        }
        if (event.player.m_9236_() == null || event.player.m_9236_().m_5776_()) {
            return;
        }
        Level level = event.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 0) {
            playerCache.remove(player2.m_20148_());
            searchProgress.remove(player2.m_20148_());
            return;
        }
        ItemStack mainHand = player2.m_21205_();
        ItemStack offHand = player2.m_21206_();
        boolean mainIsCompass = !mainHand.m_41619_() && mainHand.m_41720_() instanceof CrossCompassItem;
        boolean bl = offIsCompass = !offHand.m_41619_() && offHand.m_41720_() instanceof CrossCompassItem;
        if (!mainIsCompass && !offIsCompass) {
            playerCache.remove(player2.m_20148_());
            searchProgress.remove(player2.m_20148_());
            return;
        }
        int currentTick = player2.f_19797_;
        UUID playerUUID = player2.m_20148_();
        ItemStack activeCompass = mainIsCompass ? mainHand : offHand;
        CompoundTag tag = activeCompass.m_41784_();
        CompassCacheEntry cache = playerCache.get(playerUUID);
        BlockPos targetPos = cache != null ? cache.markerPos : null;
        boolean bl2 = isStructureTarget = cache != null ? cache.isStructure : false;
        if (currentTick % 200 == 0) {
            progress = searchProgress.computeIfAbsent(playerUUID, k -> new SearchProgress());
            progress.reset();
        }
        if (targetPos == null || isStructureTarget) {
            try {
                BlockPos foundViaManager = CemeteryMarkerManager.findNearestMarker(player2.m_20183_(), 65536.0);
                if (foundViaManager != null && serverLevel.m_46749_(foundViaManager) && serverLevel.m_8055_(foundViaManager).m_60713_((Block)FromTheCavesModBlocks.CEMETERY_MARKER.get())) {
                    playerCache.put(playerUUID, new CompassCacheEntry(foundViaManager, currentTick, false));
                    targetPos = foundViaManager;
                    isStructureTarget = false;
                }
            }
            catch (Throwable foundViaManager) {
                // empty catch block
            }
        }
        progress = searchProgress.get(playerUUID);
        if (targetPos == null && progress != null && !progress.searchComplete && CemeteryMarkerManager.getMarkerCount() > 0 && (foundMarker = CrossCompassBehaviorProcedure.incrementalSearchChunks(player2, serverLevel, progress)) != null) {
            playerCache.put(playerUUID, new CompassCacheEntry(foundMarker, currentTick, false));
            targetPos = foundMarker;
            isStructureTarget = false;
            progress.searchComplete = true;
        }
        if (targetPos == null && (structurePos = CrossCompassBehaviorProcedure.findNearestStructure(serverLevel, player2.m_20183_())) != null) {
            playerCache.put(playerUUID, new CompassCacheEntry(structurePos, currentTick, true));
            targetPos = structurePos;
            isStructureTarget = true;
        }
        if ((long)currentTick - (lastAnimUpdateTick = tag.m_128454_("cross_compass_last_anim_tick")) >= 15L) {
            String newAnimation = CrossCompassBehaviorProcedure.computeAnimationFromPos(player2, targetPos);
            boolean changed = CrossCompassBehaviorProcedure.updateStackAnimation(activeCompass, tag, newAnimation, currentTick);
            if (changed && player2.f_36096_ != null) {
                player2.f_36096_.m_38946_();
            }
            if (mainIsCompass && offIsCompass) {
                CompoundTag offTag = offHand.m_41784_();
                CrossCompassBehaviorProcedure.updateStackAnimation(offHand, offTag, newAnimation, currentTick);
            }
        }
        if (targetPos != null) {
            double distanceSq;
            int foundAt;
            int sinceFound;
            int effectiveParticleInterval = 30;
            if (cache != null && (sinceFound = currentTick - (foundAt = cache.foundAtTick)) >= 0 && sinceFound < 600) {
                effectiveParticleInterval = 60;
            }
            if (currentTick % effectiveParticleInterval == 0) {
                CrossCompassBehaviorProcedure.spawnParticlesTowardMarker(serverLevel, player2, targetPos);
            }
            if (!isStructureTarget && currentTick % 10 == 0 && (distanceSq = player2.m_20275_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5)) <= 900.0) {
                CrossCompassBehaviorProcedure.highlightMarkerBlock(serverLevel, targetPos, distanceSq);
            }
            if (currentTick % 300 == 0) {
                if (isStructureTarget) {
                    CrossCompassBehaviorProcedure.sendStructureProximityFeedback(player2, targetPos);
                } else {
                    CrossCompassBehaviorProcedure.sendProximityFeedback(player2, targetPos);
                }
            }
        }
    }

    private static BlockPos findNearestStructure(ServerLevel level, BlockPos center) {
        try {
            Pair result;
            ResourceLocation structureId = new ResourceLocation("from_the_caves", "miners_mine");
            ResourceKey structureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)structureId);
            Optional structureHolder = level.m_9598_().m_175515_(Registries.f_256944_).m_203636_(structureKey);
            if (structureHolder.isPresent() && (result = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureHolder.get()}), center, 64, false)) != null) {
                return (BlockPos)result.getFirst();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isWithinProximity(ServerPlayer player, BlockPos markerPos) {
        double dz;
        double dy;
        double dx = player.m_20185_() - ((double)markerPos.m_123341_() + 0.5);
        double distanceSq = dx * dx + (dy = player.m_20186_() - ((double)markerPos.m_123342_() + 0.5)) * dy + (dz = player.m_20189_() - ((double)markerPos.m_123343_() + 0.5)) * dz;
        return distanceSq <= 9216.0;
    }

    private static boolean updateStackAnimation(ItemStack stack, CompoundTag tag, String newAnim, int currentTick) {
        String currentAnim = tag.m_128461_("cross_compass_anim");
        if (currentAnim == null || currentAnim.isEmpty()) {
            currentAnim = ANIM_1;
        }
        boolean changed = false;
        if (!newAnim.equals(currentAnim)) {
            tag.m_128359_("cross_compass_anim", newAnim);
            changed = true;
        }
        tag.m_128356_("cross_compass_last_anim_tick", (long)currentTick);
        return changed;
    }

    private static String computeAnimationFromPos(ServerPlayer player, BlockPos markerPos) {
        double dz;
        if (markerPos == null) {
            return ANIM_1;
        }
        double dx = player.m_20185_() - ((double)markerPos.m_123341_() + 0.5);
        double horizDistSq = dx * dx + (dz = player.m_20189_() - ((double)markerPos.m_123343_() + 0.5)) * dz;
        if (horizDistSq <= 4096.0) {
            return ANIM_4;
        }
        if (horizDistSq <= 65536.0) {
            return ANIM_3;
        }
        if (horizDistSq <= 262144.0) {
            return ANIM_2;
        }
        return ANIM_1;
    }

    private static BlockPos incrementalSearchChunks(ServerPlayer player, ServerLevel level, SearchProgress progress) {
        BlockPos playerPos = player.m_20183_();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int chunksChecked = 0;
        int maxChunkRadiusFromBlocks = (int)Math.max(1.0, Math.floor(4096.0));
        int effectiveMaxChunkRadius = Math.min(1024, maxChunkRadiusFromBlocks);
        while (chunksChecked < 16 && progress.currentRadius <= effectiveMaxChunkRadius) {
            if (progress.currentRadius == 0) {
                BlockPos found = CrossCompassBehaviorProcedure.searchChunkForMarker(level, playerChunkX, playerChunkZ, playerPos.m_123342_());
                if (found != null) {
                    return found;
                }
                progress.currentRadius = 1;
                progress.currentAngle = 0;
                ++chunksChecked;
                continue;
            }
            int perimeterChunks = progress.currentRadius * 8;
            if (progress.currentAngle >= perimeterChunks) {
                ++progress.currentRadius;
                progress.currentAngle = 0;
                continue;
            }
            int side = progress.currentAngle / (progress.currentRadius * 2);
            int offset = progress.currentAngle % (progress.currentRadius * 2);
            int chunkX = playerChunkX;
            int chunkZ = playerChunkZ;
            switch (side) {
                case 0: {
                    chunkX = playerChunkX - progress.currentRadius + offset;
                    chunkZ = playerChunkZ - progress.currentRadius;
                    break;
                }
                case 1: {
                    chunkX = playerChunkX + progress.currentRadius;
                    chunkZ = playerChunkZ - progress.currentRadius + offset;
                    break;
                }
                case 2: {
                    chunkX = playerChunkX + progress.currentRadius - offset;
                    chunkZ = playerChunkZ + progress.currentRadius;
                    break;
                }
                case 3: {
                    chunkX = playerChunkX - progress.currentRadius;
                    chunkZ = playerChunkZ + progress.currentRadius - offset;
                }
            }
            BlockPos found = CrossCompassBehaviorProcedure.searchChunkForMarker(level, chunkX, chunkZ, playerPos.m_123342_());
            if (found != null) {
                return found;
            }
            ++progress.currentAngle;
            ++chunksChecked;
        }
        if (progress.currentRadius > effectiveMaxChunkRadius) {
            progress.searchComplete = true;
        }
        return null;
    }

    private static BlockPos searchChunkForMarker(ServerLevel level, int chunkX, int chunkZ, int playerY) {
        if (!level.m_7232_(chunkX, chunkZ)) {
            return null;
        }
        LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = (chunkX << 4) + x;
                int worldZ = (chunkZ << 4) + z;
                for (int dy = 0; dy <= 48; ++dy) {
                    BlockPos pos;
                    int checkY = playerY + dy;
                    if (checkY >= level.m_141937_() && checkY < level.m_151558_() && chunk.m_8055_(pos = new BlockPos(worldX, checkY, worldZ)).m_60713_((Block)FromTheCavesModBlocks.CEMETERY_MARKER.get())) {
                        return pos;
                    }
                    if (dy == 0 || (checkY = playerY - dy) < level.m_141937_() || checkY >= level.m_151558_() || !chunk.m_8055_(pos = new BlockPos(worldX, checkY, worldZ)).m_60713_((Block)FromTheCavesModBlocks.CEMETERY_MARKER.get())) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private static void spawnParticlesTowardMarker(ServerLevel level, ServerPlayer player, BlockPos markerPos) {
        int i;
        double maxVisualDistance;
        double mz;
        double dz;
        double my;
        double dy;
        double px = player.m_20185_();
        double py = player.m_20186_() + (double)player.m_20192_() * 0.75;
        double pz = player.m_20189_();
        double mx = (double)markerPos.m_123341_() + 0.5;
        double dx = mx - px;
        double dist = Math.sqrt(dx * dx + (dy = (my = (double)markerPos.m_123342_() + 0.5) - py) * dy + (dz = (mz = (double)markerPos.m_123343_() + 0.5) - pz) * dz);
        if (dist < 1.0) {
            return;
        }
        double proximityFactor = dist <= 64.0 ? 1.0 : (dist <= 256.0 ? 0.6 + 0.4 * (256.0 - dist) / 192.0 : (dist <= 512.0 ? 0.3 + 0.3 * (512.0 - dist) / 256.0 : 0.3));
        int baseParticleCount = (int)(15.0 + proximityFactor * 35.0);
        double effectiveDist = maxVisualDistance = Math.min(dist, 50.0 + proximityFactor * 150.0);
        SoundEvent whisperSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.vex.ambient"));
        float soundChance = (float)((double)0.2f + proximityFactor * 0.5);
        if (whisperSound != null && level.f_46441_.m_188501_() < soundChance) {
            float volume = (float)((double)0.3f + proximityFactor * (double)0.4f);
            level.m_6263_(null, px, py, pz, whisperSound, SoundSource.PLAYERS, volume, 0.5f + level.f_46441_.m_188501_() * 0.5f);
        }
        for (i = 0; i < baseParticleCount; ++i) {
            double frac = (double)i / (double)Math.max(1, baseParticleCount - 1);
            double cx = px + frac * dx * (effectiveDist / dist);
            double cy = py + frac * dy * (effectiveDist / dist);
            double cz = pz + frac * dz * (effectiveDist / dist);
            int particlesPerPoint = (int)(1.0 + proximityFactor * 2.0);
            for (int j = 0; j < particlesPerPoint; ++j) {
                double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.3 * (1.0 - proximityFactor * 0.7);
                double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.3 * (1.0 - proximityFactor * 0.7);
                double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.3 * (1.0 - proximityFactor * 0.7);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, cx + spreadX, cy + spreadY, cz + spreadZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (proximityFactor > 0.7) {
            for (i = 0; i < 5; ++i) {
                double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 1.5;
                double particleX = px + Math.cos(angle) * radius;
                double particleZ = pz + Math.sin(angle) * radius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, particleX, py, particleZ, 1, 0.0, 0.05, 0.0, 0.01);
            }
        }
    }

    private static void sendProximityFeedback(ServerPlayer player, BlockPos markerPos) {
        double dx = player.m_20185_() - ((double)markerPos.m_123341_() + 0.5);
        double dz = player.m_20189_() - ((double)markerPos.m_123343_() + 0.5);
        double distance = Math.sqrt(dx * dx + dz * dz);
        ServerLevel level = (ServerLevel)player.m_9236_();
        SoundEvent bellSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "churchbell"));
        if (bellSound != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), bellSound, SoundSource.PLAYERS, 0.4f, 0.5f + level.f_46441_.m_188501_() * 0.1f);
        }
        if (distance <= 64.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\u271f \u00a74Very Close... \u00a7c\u00a7l\u271f"), true);
            SoundEvent closeSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient"));
            if (closeSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), closeSound, SoundSource.PLAYERS, 0.15f, 0.6f);
            }
            for (int i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 * (double)i / 8.0;
                double radius = 2.0;
                double particleX = player.m_20185_() + Math.cos(angle) * radius;
                double particleZ = player.m_20189_() + Math.sin(angle) * radius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, particleX, player.m_20186_(), particleZ, 1, 0.0, 0.1, 0.0, 0.01);
            }
        } else if (distance <= 256.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\u271f Getting closer... \u271f"), true);
            SoundEvent medSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.soul_sand.step"));
            if (medSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), medSound, SoundSource.PLAYERS, 0.1f, 1.2f);
            }
        } else if (distance <= 512.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a77\u271f I sense something... \u271f"), true);
        } else if (distance <= 1028.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a78\u271f A faint feeling in the distance... \u271f"), true);
        }
    }

    private static void sendStructureProximityFeedback(ServerPlayer player, BlockPos structurePos) {
        double dx = player.m_20185_() - ((double)structurePos.m_123341_() + 0.5);
        double dz = player.m_20189_() - ((double)structurePos.m_123343_() + 0.5);
        double distance = Math.sqrt(dx * dx + dz * dz);
        ServerLevel level = (ServerLevel)player.m_9236_();
        SoundEvent bellSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "churchbell"));
        if (bellSound != null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), bellSound, SoundSource.PLAYERS, 0.5f, 0.5f + level.f_46441_.m_188501_() * 0.1f);
        }
        if (distance <= 64.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\u271f \u00a74Very Close to the mineshaft... \u00a7c\u00a7l\u271f"), true);
            SoundEvent closeSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.portal.ambient"));
            if (closeSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), closeSound, SoundSource.PLAYERS, 0.15f, 1.8f);
            }
            for (int i = 0; i < 8; ++i) {
                double angle = Math.PI * 2 * (double)i / 8.0;
                double radius = 2.0;
                double particleX = player.m_20185_() + Math.cos(angle) * radius;
                double particleZ = player.m_20189_() + Math.sin(angle) * radius;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, particleX, player.m_20186_(), particleZ, 1, 0.0, 0.1, 0.0, 0.01);
            }
        } else if (distance <= 256.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a76\u271f The mineshaft is nearby... \u271f"), true);
            SoundEvent medSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.soul_sand.step"));
            if (medSound != null) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), medSound, SoundSource.PLAYERS, 0.1f, 1.2f);
            }
        } else if (distance <= 512.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a77\u271f I sense the mineshaft... \u271f"), true);
        } else if (distance <= 1024.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a78\u271f The mineshaft in the distance... \u271f"), true);
        } else if (distance <= 2048.0) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a78\u271f The faraway mineshaft calls... \u271f"), true);
        } else {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a78\u271f Something calls from very far away... \u271f"), true);
        }
    }

    private static void highlightMarkerBlock(ServerLevel level, BlockPos markerPos, double distanceSq) {
        int i;
        double distance = Math.sqrt(distanceSq);
        double intensityFactor = 1.0 - distance / 30.0;
        intensityFactor = Math.max(0.2, Math.min(1.0, intensityFactor));
        int particleCount = (int)(8.0 + intensityFactor * 12.0);
        double centerX = (double)markerPos.m_123341_() + 0.5;
        double centerY = (double)markerPos.m_123342_() + 0.5;
        double centerZ = (double)markerPos.m_123343_() + 0.5;
        SoundEvent bellSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.bell.resonate"));
        if (bellSound != null && level.f_46441_.m_188501_() < 0.05f) {
            level.m_6263_(null, centerX, centerY, centerZ, bellSound, SoundSource.BLOCKS, 0.05f, 0.5f);
        }
        for (i = 0; i < particleCount; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.2;
            double offsetY = level.f_46441_.m_188500_() * 1.5;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.2;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 1, 0.0, 0.02, 0.0, 0.01);
        }
        if (intensityFactor > 0.7) {
            for (i = 0; i < 3; ++i) {
                double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 0.8;
                double spiralX = centerX + Math.cos(angle) * radius;
                double spiralZ = centerZ + Math.sin(angle) * radius;
                double spiralY = centerY + level.f_46441_.m_188500_() * 2.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, spiralX, spiralY, spiralZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private record CompassCacheEntry(BlockPos markerPos, int foundAtTick, boolean isStructure) {
    }

    private static class SearchProgress {
        int currentRadius = 0;
        int currentAngle = 0;
        boolean searchComplete = false;

        private SearchProgress() {
        }

        void reset() {
            this.currentRadius = 0;
            this.currentAngle = 0;
            this.searchComplete = false;
        }
    }
}

