/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVESCROSSDEMONEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CrossDemonSpawnProcedure {
    private static final double BASE_PROB = 2.0E-5;
    private static final double MAX_PROB = 3.0E-5;
    private static final double MIN_HEIGHT = 28.0;
    private static final double MAX_HEIGHT = 32.0;
    private static final long DESPAWN_TICKS = 3600L;
    private static final double TRIGGER_DIST = 15.0;
    private static final double STARE_DIST = 25.0;
    private static final long STARE_DURATION = 80L;
    private static final long CHARGE_DURATION = 60L;
    private static final double CHARGE_SPEED = 0.8;
    private static final double CHARGE_SPEED_LOOKED = 1.4;
    private static final double SLOW_APPROACH_SPEED = 0.15;
    private static final double SLOW_APPROACH_SPEED_LOOKED = 0.3;
    private static final int PARTICLE_INTERVAL = 10;
    private static final double PLAYER_FOV = 130.0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level world = player.m_9236_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 2.0E-5, 3.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 2 && phase != 3) {
            return;
        }
        double yOff = 28.0 + server.f_46441_.m_188500_() * 4.0;
        long now = server.m_46467_();
        Vec3 playerLook = player.m_20154_().m_82541_();
        Vec3 rightVector = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
        double sideOffset = (double)(server.f_46441_.m_188499_() ? 1 : -1) * (8.0 + server.f_46441_.m_188500_() * 4.0);
        double forwardOffset = 10.0 + server.f_46441_.m_188500_() * 5.0;
        Vec3 spawnPos = player.m_20182_().m_82549_(playerLook.m_82490_(forwardOffset)).m_82549_(rightVector.m_82490_(sideOffset)).m_82520_(0.0, yOff, 0.0);
        FROMTHECAVESCROSSDEMONEntity demon = new FROMTHECAVESCROSSDEMONEntity((EntityType<FROMTHECAVESCROSSDEMONEntity>)((EntityType)FromTheCavesModEntities.FROMTHECAVESCROSSDEMON.get()), (Level)server);
        demon.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        demon.m_21530_();
        demon.m_20242_(true);
        demon.m_20225_(false);
        server.m_7967_((Entity)demon);
        CompoundTag nbt = demon.getPersistentData();
        nbt.m_128356_("spawnTick", now);
        nbt.m_128356_("despawnAfter", now + 3600L);
        nbt.m_128359_("behaviorState", "waiting");
        nbt.m_128356_("stateStartTick", now);
        nbt.m_128379_("hasBeenLookedAt", false);
    }

    @SubscribeEvent
    public static void onDemonTick(LivingEvent.LivingTickEvent event) {
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof FROMTHECAVESCROSSDEMONEntity)) {
            return;
        }
        FROMTHECAVESCROSSDEMONEntity demon = (FROMTHECAVESCROSSDEMONEntity)ent;
        Level level = demon.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        demon.m_20242_(true);
        CompoundTag nbt = demon.getPersistentData();
        long now = server.m_46467_();
        long despawnTime = nbt.m_128454_("despawnAfter");
        if (now >= despawnTime) {
            CrossDemonSpawnProcedure.spawnDespawnEffect(server, demon);
            demon.m_146870_();
            return;
        }
        Player nearestPlayer = server.m_45930_((Entity)demon, 25.0);
        if (nearestPlayer == null) {
            demon.m_146870_();
            return;
        }
        double distToPlayer = demon.m_20270_((Entity)nearestPlayer);
        CrossDemonSpawnProcedure.makeEntityLookAt((LivingEntity)demon, nearestPlayer);
        boolean playerLookingAtDemon = CrossDemonSpawnProcedure.isPlayerLookingAtEntity(nearestPlayer, (LivingEntity)demon, 130.0);
        boolean hasBeenLookedAt = nbt.m_128471_("hasBeenLookedAt");
        if (playerLookingAtDemon && !hasBeenLookedAt) {
            nbt.m_128379_("hasBeenLookedAt", true);
            hasBeenLookedAt = true;
        }
        if (now % 10L == 0L) {
            CrossDemonSpawnProcedure.spawnAmbientParticles(server, demon);
        }
        String state = nbt.m_128461_("behaviorState");
        long stateStart = nbt.m_128454_("stateStartTick");
        long elapsed = now - stateStart;
        switch (state) {
            case "waiting": {
                demon.m_20334_(0.0, 0.0, 0.0);
                if (!hasBeenLookedAt) break;
                nbt.m_128359_("behaviorState", "staring");
                nbt.m_128356_("stateStartTick", now);
                break;
            }
            case "staring": {
                demon.m_20334_(0.0, 0.0, 0.0);
                if (elapsed <= 80L && !(distToPlayer < 15.0)) break;
                nbt.m_128359_("behaviorState", "charging");
                nbt.m_128356_("stateStartTick", now);
                server.m_5594_(null, demon.m_20183_(), SoundEvents.f_12554_, SoundSource.HOSTILE, 1.5f, 0.5f);
                break;
            }
            case "charging": {
                Vec3 toPlayer = nearestPlayer.m_20182_().m_82546_(demon.m_20182_()).m_82541_();
                double chargeSpeed = playerLookingAtDemon ? 1.4 : 0.8;
                Vec3 velocity = toPlayer.m_82490_(chargeSpeed);
                demon.m_20334_(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                demon.m_6478_(MoverType.SELF, demon.m_20184_());
                if (now % 5L == 0L) {
                    CrossDemonSpawnProcedure.spawnChargeParticles(server, demon);
                }
                if (elapsed > 60L) {
                    nbt.m_128359_("behaviorState", "approach");
                    nbt.m_128356_("stateStartTick", now);
                }
                if (!(distToPlayer < 2.0)) break;
                nearestPlayer.m_6469_(nearestPlayer.m_269291_().m_269425_(), 1.0f);
                CrossDemonSpawnProcedure.spawnDespawnEffect(server, demon);
                demon.m_146870_();
                break;
            }
            case "approach": {
                Vec3 toPlayerSlow = nearestPlayer.m_20182_().m_82546_(demon.m_20182_()).m_82541_();
                double approachSpeed = playerLookingAtDemon ? 0.3 : 0.15;
                Vec3 velocitySlow = toPlayerSlow.m_82490_(approachSpeed);
                demon.m_20334_(velocitySlow.f_82479_, velocitySlow.f_82480_, velocitySlow.f_82481_);
                demon.m_6478_(MoverType.SELF, demon.m_20184_());
                if (!(distToPlayer < 3.0)) break;
                nearestPlayer.m_6469_(nearestPlayer.m_269291_().m_269425_(), 1.0f);
                CrossDemonSpawnProcedure.spawnDespawnEffect(server, demon);
                demon.m_146870_();
            }
        }
    }

    private static boolean isPlayerLookingAtEntity(Player player, LivingEntity entity, double fov) {
        Vec3 toEntity;
        Vec3 playerLook = player.m_20154_().m_82541_();
        double dotProduct = playerLook.m_82526_(toEntity = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_());
        double angle = Math.toDegrees(Math.acos(dotProduct));
        return angle <= fov / 2.0;
    }

    private static void makeEntityLookAt(LivingEntity entity, Player target) {
        double dx = target.m_20185_() - entity.m_20185_();
        double dz = target.m_20189_() - entity.m_20189_();
        double dy = target.m_20186_() + (double)target.m_20192_() - (entity.m_20186_() + (double)entity.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        entity.m_146922_(yaw);
        entity.f_20883_ = yaw;
        entity.f_20885_ = yaw;
        entity.m_146926_(pitch);
    }

    private static void spawnAmbientParticles(ServerLevel level, FROMTHECAVESCROSSDEMONEntity demon) {
        double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.5;
        double offsetY = level.f_46441_.m_188500_() * (double)demon.m_20206_();
        double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.5;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, demon.m_20185_() + offsetX, demon.m_20186_() + offsetY, demon.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void spawnChargeParticles(ServerLevel level, FROMTHECAVESCROSSDEMONEntity demon) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, demon.m_20185_(), demon.m_20186_() + (double)(demon.m_20206_() / 2.0f), demon.m_20189_(), 3, 0.2, 0.2, 0.2, 0.02);
    }

    private static void spawnDespawnEffect(ServerLevel level, FROMTHECAVESCROSSDEMONEntity demon) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, demon.m_20185_(), demon.m_20186_() + (double)(demon.m_20206_() / 2.0f), demon.m_20189_(), 15, 0.3, 0.3, 0.3, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, demon.m_20185_(), demon.m_20186_() + (double)(demon.m_20206_() / 2.0f), demon.m_20189_(), 10, 0.2, 0.2, 0.2, 0.03);
        level.m_5594_(null, demon.m_20183_(), SoundEvents.f_11894_, SoundSource.HOSTILE, 0.8f, 1.5f);
    }
}

