/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.SessionVariables;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EyelessAIBehaviorProcedure {
    private static final double MAX_DETECTION_RANGE = 32.0;
    private static final double ATTACK_RANGE = 1.5;
    private static final double MOVEMENT_POSITION_THRESHOLD = 0.13;
    private static final double SOUND_THRESHOLD = 1.0;
    private static final int DETECTION_DURATION_TICKS = 200;
    private static final double RAGE_DECAY_RATE = 0.05;
    private static final double MAX_RAGE = 10.0;
    private static final double RAGE_SPEED_MULTIPLIER = 0.15;
    private static final int ATTACK_COOLDOWN = 20;
    private static final int HEARTBEAT_INTERVAL = 60;
    private static final double HEARTBEAT_RANGE = 16.0;
    private static final double MICROPHONE_DB_THRESHOLD = -41.0;
    private static final double MICROPHONE_LOUD_THRESHOLD = -20.0;
    private static final double MICROPHONE_CHECK_RADIUS = 40.0;
    private static final int MICROPHONE_CHECK_INTERVAL = 5;
    private static final Map<UUID, Double> lastMicrophoneLevels = new ConcurrentHashMap<UUID, Double>();
    private static final Map<UUID, DetectionData> detectedPlayers = new ConcurrentHashMap<UUID, DetectionData>();
    private static final Map<UUID, Vec3> lastPlayerPositions = new ConcurrentHashMap<UUID, Vec3>();
    private static final Map<UUID, Vec3> lastKnownPlayerPositions = new ConcurrentHashMap<UUID, Vec3>();
    private static boolean TACZ_LOADED = false;

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.m_9236_().m_5776_()) {
            return;
        }
        if (EyelessAIBehaviorProcedure.isEyelessEntity(entity) && entity instanceof PathfinderMob) {
            EyelessAIBehaviorProcedure.setupEyelessAI((PathfinderMob)entity);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_9236_().m_5776_()) {
            return;
        }
        if (!EyelessAIBehaviorProcedure.isEyelessEntity((Entity)entity) || !(entity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)entity;
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CompoundTag pd = mob.getPersistentData();
        long now = level.m_46467_();
        double rage = pd.m_128459_("eyeless_rage");
        if (rage > 0.0) {
            rage = Math.max(0.0, rage - 0.05);
            pd.m_128347_("eyeless_rage", rage);
        }
        if (now % 5L == 0L) {
            EyelessAIBehaviorProcedure.checkMicrophoneNoise(mob, serverLevel);
        }
        if (level.m_46467_() % 5L != 0L) {
            return;
        }
        EyelessAIBehaviorProcedure.updateTargetingAndNavigation(mob, serverLevel);
        if (mob.m_5448_() != null) {
            EyelessAIBehaviorProcedure.playListeningEffects(serverLevel, mob);
            if (rage > 5.0) {
                EyelessAIBehaviorProcedure.playRageEffects(serverLevel, mob);
            }
        }
        EyelessAIBehaviorProcedure.applyBlindnessToNearbyPlayers(mob, serverLevel);
        if (now % 60L == 0L) {
            EyelessAIBehaviorProcedure.playHeartbeatSound(mob, serverLevel);
        }
    }

    private static void checkMicrophoneNoise(PathfinderMob mob, ServerLevel level) {
        AABB searchBox = mob.m_20191_().m_82400_(40.0);
        List nearbyPlayers = level.m_45976_(Player.class, searchBox);
        for (Player player : nearbyPlayers) {
            double distanceToMob;
            double currentDbLevel = SessionVariables.currentDbLevels.getOrDefault(player.m_20148_(), -60.0);
            System.out.println("[DEBUG] currentDbLevel: " + currentDbLevel + ", threshold: -41.0");
            UUID pid = player.m_20148_();
            Double lastDbLevel = lastMicrophoneLevels.get(pid);
            lastMicrophoneLevels.put(pid, currentDbLevel);
            if (currentDbLevel <= -41.0) {
                System.out.println("[DEBUG] Ignorado por estar bajo el umbral");
                continue;
            }
            System.out.println("[DEBUG] Paso 1: Sobre el umbral!");
            double dbAboveThreshold = currentDbLevel - -41.0;
            double normalizedDb = Math.min(dbAboveThreshold / 20.0, 1.0);
            double soundLevel = normalizedDb * 3.5;
            System.out.println("[DEBUG] dbAboveThreshold: " + dbAboveThreshold + ", soundLevel inicial: " + soundLevel);
            boolean isVeryLoud = currentDbLevel > -20.0;
            double detectionRadius = 40.0;
            if (isVeryLoud) {
                detectionRadius = 60.0;
                soundLevel = Math.max(soundLevel, 3.0);
            }
            if ((distanceToMob = (double)mob.m_20270_((Entity)player)) > detectionRadius) {
                System.out.println("[DEBUG] Demasiado lejos: " + distanceToMob + " > " + detectionRadius);
                continue;
            }
            System.out.println("[DEBUG] Paso 2: En rango!");
            double distanceFactor = 1.0 - distanceToMob / detectionRadius;
            System.out.println("[DEBUG] soundLevel despu\u00e9s atenuaci\u00f3n: " + (soundLevel *= distanceFactor) + ", SOUND_THRESHOLD: 1.0");
            if (soundLevel <= 1.0) {
                System.out.println("[DEBUG] soundLevel muy bajo despu\u00e9s de atenuaci\u00f3n");
                continue;
            }
            System.out.println("[DEBUG] \u00a1\u00a1\u00a1DETECCI\u00d3N CONFIRMADA!!!");
            Vec3 playerPos = player.m_20182_();
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, playerPos, soundLevel, detectionRadius);
            if (!(level.f_46441_.m_188501_() < 0.3f)) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 1, 0.1, 0.1, 0.1, 0.0);
        }
    }

    private static void playRageEffects(ServerLevel level, PathfinderMob mob) {
        if (level.f_46441_.m_188501_() < 0.5f) {
            Vec3 pos = mob.m_20182_();
            for (int i = 0; i < 3; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = level.f_46441_.m_188500_() * (double)mob.m_20206_();
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, 1, 0.0, 0.1, 0.0, 0.0);
            }
        }
    }

    private static void playHeartbeatSound(PathfinderMob mob, ServerLevel level) {
        AABB box = mob.m_20191_().m_82400_(16.0);
        List nearbyPlayers = level.m_45976_(Player.class, box);
        if (!nearbyPlayers.isEmpty()) {
            level.m_5594_(null, mob.m_20183_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("from_the_caves", "one_heart")), SoundSource.HOSTILE, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.2f);
        }
    }

    private static void applyBlindnessToNearbyPlayers(PathfinderMob mob, ServerLevel level) {
        AABB searchBox = mob.m_20191_().m_82400_(8.0);
        List nearbyPlayers = level.m_45976_(Player.class, searchBox);
        for (Player player : nearbyPlayers) {
            CompoundTag pd;
            double rage;
            double distance = mob.m_20270_((Entity)player);
            if (!(distance <= 8.0)) continue;
            int amplifier = 0;
            int duration = 60;
            if (distance < 4.0) {
                amplifier = 1;
                duration = 80;
            }
            if ((rage = (pd = mob.getPersistentData()).m_128459_("eyeless_rage")) > 5.0) {
                amplifier = Math.min(2, amplifier + 1);
                duration += 40;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, duration, amplifier, false, false));
        }
    }

    @SubscribeEvent
    public static void onAnyLivingTick(LivingEvent.LivingTickEvent event) {
        double producedSound;
        double dist;
        LivingEntity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        Player player = (Player)ent;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        UUID pid = player.m_20148_();
        Vec3 nowPos = player.m_20182_();
        Vec3 lastPos = lastPlayerPositions.get(pid);
        double movementSound = 0.0;
        if (lastPos != null && (dist = lastPos.m_82554_(nowPos)) > 0.13) {
            movementSound = player.m_20142_() ? 2.0 : (player.m_6047_() ? 0.4 : 1.1);
            lastKnownPlayerPositions.put(pid, nowPos);
        }
        double fallSound = 0.0;
        if (!player.m_20096_() && player.m_20184_().f_82480_ < -0.12) {
            fallSound = 1.5;
        }
        if ((producedSound = Math.max(movementSound, fallSound)) > 1.0) {
            double radius = Math.min(32.0, 32.0 * (producedSound / 2.0 + 0.5));
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, nowPos, producedSound, radius);
        }
        lastPlayerPositions.put(pid, nowPos);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 pos = Vec3.m_82512_((Vec3i)event.getPos());
        double soundLevel = 3.0;
        double radius = 32.0;
        if (soundLevel > 1.0) {
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 pos = Vec3.m_82512_((Vec3i)event.getPos());
        double soundLevel = 1.2;
        double radius = 22.4;
        if (soundLevel > 1.0) {
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 pos = player.m_20182_();
        double soundLevel = 2.5;
        double radius = 28.8;
        if (soundLevel > 1.0) {
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 pos = player.m_20182_();
        double soundLevel = 3.0;
        double radius = 32.0;
        if (soundLevel > 1.0) {
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
        }
    }

    @SubscribeEvent
    public static void onSoundPlayed(PlayLevelSoundEvent.AtEntity event) {
        if (event.getEntity() == null) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 pos = player.m_20182_();
        String soundName = "";
        try {
            soundName = ((SoundEvent)event.getSound().m_203334_()).m_11660_().toString();
        }
        catch (Throwable t) {
            soundName = "unknown";
        }
        double soundLevel = 0.0;
        double radius = 32.0;
        if (TACZ_LOADED && (soundName.contains("gun") || soundName.contains("shoot") || soundName.contains("fire") || soundName.contains("tacz") || soundName.contains("shot"))) {
            soundLevel = 4.0;
            radius = 48.0;
        }
        if (soundLevel > 1.0) {
            EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
        }
    }

    @SubscribeEvent
    public static void onGenericModEvent(Event event) {
        String className = event.getClass().getName();
        if (TACZ_LOADED && className.contains("tacz") && (className.contains("Shoot") || className.contains("Fire") || className.contains("Gun"))) {
            try {
                Object shooter = null;
                try {
                    shooter = event.getClass().getMethod("getShooter", new Class[0]).invoke((Object)event, new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        shooter = event.getClass().getMethod("getPlayer", new Class[0]).invoke((Object)event, new Object[0]);
                    }
                    catch (NoSuchMethodException e2) {
                        try {
                            shooter = event.getClass().getMethod("getEntity", new Class[0]).invoke((Object)event, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    if (player.m_9236_().m_5776_()) {
                        return;
                    }
                    ServerLevel level = (ServerLevel)player.m_9236_();
                    Vec3 pos = player.m_20182_();
                    double soundLevel = 4.0;
                    double radius = 48.0;
                    EyelessAIBehaviorProcedure.makeNoiseAt(level, player, pos, soundLevel, radius);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void makeNoiseAt(ServerLevel level, Player player, Vec3 pos, double soundLevel, double radius) {
        if (soundLevel <= 1.0) {
            return;
        }
        long now = level.m_46467_();
        detectedPlayers.put(player.m_20148_(), new DetectionData(player, now, soundLevel, pos));
        AABB box = new AABB(pos.f_82479_ - radius, pos.f_82480_ - radius, pos.f_82481_ - radius, pos.f_82479_ + radius, pos.f_82480_ + radius, pos.f_82481_ + radius);
        List mobs = level.m_45976_(PathfinderMob.class, box);
        for (PathfinderMob mob : mobs) {
            if (!EyelessAIBehaviorProcedure.isEyelessEntity((Entity)mob)) continue;
            CompoundTag pd = mob.getPersistentData();
            double rage = pd.m_128459_("eyeless_rage");
            rage = Math.min(10.0, rage + soundLevel * 0.3);
            pd.m_128347_("eyeless_rage", rage);
            if (mob.m_21573_() != null) {
                double speed = 1.05 + rage * 0.15 * 0.1;
                mob.m_21573_().m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, speed);
            }
            level.m_5594_(null, mob.m_20183_(), SoundEvents.f_215764_, SoundSource.HOSTILE, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.3f);
        }
    }

    private static void setupEyelessAI(PathfinderMob mob) {
        try {
            mob.f_21345_.m_148105_().clear();
            mob.f_21346_.m_148105_().clear();
            mob.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)mob));
            mob.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(mob, 1.2, true));
            mob.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal(mob, 0.3, 0.8f));
            mob.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal(mob, 0.3, 120));
            mob.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)mob));
            if (mob.m_21051_(Attributes.f_22277_) != null) {
                mob.m_21051_(Attributes.f_22277_).m_22100_(32.0);
            }
            mob.m_21530_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void updateTargetingAndNavigation(PathfinderMob mob, ServerLevel level) {
        long now = level.m_46467_();
        CompoundTag pd = mob.getPersistentData();
        double rage = pd.m_128459_("eyeless_rage");
        if (mob.m_5448_() != null && mob.m_5448_().m_6084_()) {
            UUID tid = mob.m_5448_().m_20148_();
            DetectionData d = detectedPlayers.get(tid);
            if (d == null || now - d.lastDetectionTime > 200L) {
                mob.m_6710_(null);
                if (mob.m_21573_() != null) {
                    mob.m_21573_().m_26573_();
                }
            } else if (mob.m_21573_() != null) {
                double speed = 1.2 + rage * 0.15;
                mob.m_21573_().m_5624_((Entity)mob.m_5448_(), speed);
            }
            return;
        }
        DetectionData chosen = null;
        double bestScore = -1.0;
        for (DetectionData detectionData : detectedPlayers.values()) {
            double distance;
            double score;
            if (detectionData.player == null || !detectionData.player.m_6084_() || now - detectionData.lastDetectionTime > 200L || !((score = detectionData.soundLevel / (0.5 + (distance = (double)mob.m_20270_((Entity)detectionData.player)) / 10.0)) > bestScore)) continue;
            bestScore = score;
            chosen = detectionData;
        }
        if (chosen == null) {
            if (rage > 3.0 && mob.m_21573_() != null) {
                for (Map.Entry entry : lastKnownPlayerPositions.entrySet()) {
                    Vec3 lastPos = (Vec3)entry.getValue();
                    if (!(mob.m_20238_(lastPos) < 1024.0)) continue;
                    mob.m_21573_().m_26519_(lastPos.f_82479_, lastPos.f_82480_, lastPos.f_82481_, 1.0);
                    return;
                }
            }
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_26573_();
            }
            return;
        }
        double distToPlayer = mob.m_20270_((Entity)chosen.player);
        if (distToPlayer <= 1.5) {
            long lastAttack = pd.m_128454_("eyeless_last_attack");
            if (now - lastAttack >= 20L) {
                mob.m_6710_((LivingEntity)chosen.player);
                pd.m_128356_("eyeless_last_attack", now);
            }
            if (mob.m_21573_() != null) {
                mob.m_21573_().m_26573_();
            }
            return;
        }
        if (mob.m_21573_() != null) {
            Vec3 targetPos = chosen.location != null ? chosen.location : chosen.player.m_20182_();
            double navSpeed = 1.05 + rage * 0.15 * 0.1;
            mob.m_21573_().m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, navSpeed);
        }
    }

    private static void playListeningEffects(ServerLevel level, PathfinderMob mob) {
        if (level.f_46441_.m_188501_() < 0.25f) {
            Vec3 pos = mob.m_20182_();
            level.m_8767_((ParticleOptions)ParticleTypes.f_235898_, pos.f_82479_, pos.f_82480_ + (double)mob.m_20206_() * 0.8, pos.f_82481_, 1, 0.2, 0.2, 0.2, 0.01);
        }
    }

    private static boolean isEyelessEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        try {
            EntityType eyelessType = (EntityType)FromTheCavesModEntities.FROMTHECAVESEYELESS.get();
            return entity.m_6095_().equals(eyelessType);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void onEyelessHurt(PathfinderMob mob, DamageSource source) {
        if (source == null) {
            return;
        }
        if (!(mob.m_9236_() instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        if (source.m_7639_() instanceof Player) {
            Player attacker = (Player)source.m_7639_();
            double soundLevel = 3.0;
            detectedPlayers.put(attacker.m_20148_(), new DetectionData(attacker, level.m_46467_(), soundLevel, mob.m_20182_()));
            EyelessAIBehaviorProcedure.makeNoiseAt(level, attacker, mob.m_20182_(), soundLevel, 32.0);
            level.m_5594_(null, mob.m_20183_(), SoundEvents.f_215775_, SoundSource.HOSTILE, 2.0f, 0.8f);
            CompoundTag pd = mob.getPersistentData();
            double rage = pd.m_128459_("eyeless_rage");
            rage = Math.min(10.0, rage + 2.0);
            pd.m_128347_("eyeless_rage", rage);
        }
    }

    static {
        TACZ_LOADED = ModList.get().isLoaded("tacz");
        if (TACZ_LOADED) {
            System.out.println("[EYELESS DEBUG] TACZ mod detected.");
        }
    }

    private static class DetectionData {
        Player player;
        long lastDetectionTime;
        double soundLevel;
        Vec3 location;

        DetectionData(Player p, long t, double s, Vec3 loc) {
            this.player = p;
            this.lastDetectionTime = t;
            this.soundLevel = s;
            this.location = loc;
        }
    }
}

