/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Random;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EyelessSpawnProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final int MIN_SPAWN_DISTANCE = 8;
    private static final int MAX_SPAWN_DISTANCE = 32;
    private static final int Y_THRESHOLD = 45;
    private static final int BLOCK_CHECK_RADIUS = 16;
    private static final int SPAWN_COOLDOWN = 20;
    private static long lastSpawnTime = 0L;
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        double dynProb;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = serverPlayer.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 3) {
            return;
        }
        long currentTime = serverLevel.m_46467_();
        if (currentTime - lastSpawnTime < 20L) {
            return;
        }
        try {
            dynProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, (Player)serverPlayer, 4.0E-5, 5.5E-5);
        }
        catch (Throwable t) {
            dynProb = 4.0E-5;
        }
        if (random.nextDouble() >= dynProb) {
            return;
        }
        if (!EyelessSpawnProcedure.checkSpawnConditions(serverPlayer, serverLevel)) {
            return;
        }
        if (EyelessSpawnProcedure.trySpawnEyeless(serverPlayer, serverLevel)) {
            lastSpawnTime = currentTime;
        }
    }

    private static boolean checkSpawnConditions(ServerPlayer player, ServerLevel level) {
        BlockPos playerPos = player.m_20183_();
        if (playerPos.m_123342_() <= 45) {
            return true;
        }
        if (EyelessSpawnProcedure.isNightTime(level)) {
            return EyelessSpawnProcedure.isNearSpecificBlocks(level, playerPos);
        }
        return false;
    }

    private static boolean isNightTime(ServerLevel level) {
        long dayTime = level.m_46468_() % 24000L;
        return dayTime >= 13000L && dayTime <= 23000L;
    }

    private static boolean isNearSpecificBlocks(ServerLevel level, BlockPos center) {
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos checkPos = center.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (state.m_60713_(Blocks.f_50705_) || state.m_60713_(Blocks.f_50741_) || state.m_60713_(Blocks.f_50742_) || state.m_60713_(Blocks.f_50743_) || state.m_60713_(Blocks.f_50744_) || state.m_60713_(Blocks.f_50745_) || state.m_60713_(Blocks.f_220865_) || state.m_60713_(Blocks.f_271304_) || state.m_60713_(Blocks.f_244477_) || state.m_60713_(Blocks.f_50655_) || state.m_60713_(Blocks.f_50656_)) {
                        return true;
                    }
                    if (state.m_60713_(Blocks.f_50652_) || state.m_60713_(Blocks.f_50079_) || state.m_60713_(Blocks.f_50157_) || state.m_60713_(Blocks.f_50409_) || state.m_60713_(Blocks.f_50274_)) {
                        return true;
                    }
                    if (!state.m_60713_(Blocks.f_50058_) && !state.m_60713_(Blocks.f_152498_) && !state.m_60713_(Blocks.f_50147_) && !state.m_60713_(Blocks.f_50148_) && !state.m_60713_(Blocks.f_50202_) && !state.m_60713_(Blocks.f_50203_) && !state.m_60713_(Blocks.f_50204_) && !state.m_60713_(Blocks.f_50205_) && !state.m_60713_(Blocks.f_50206_) && !state.m_60713_(Blocks.f_50207_) && !state.m_60713_(Blocks.f_50208_) && !state.m_60713_(Blocks.f_50209_) && !state.m_60713_(Blocks.f_50210_) && !state.m_60713_(Blocks.f_50211_) && !state.m_60713_(Blocks.f_50212_) && !state.m_60713_(Blocks.f_50213_) && !state.m_60713_(Blocks.f_50214_) && !state.m_60713_(Blocks.f_50215_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean trySpawnEyeless(ServerPlayer player, ServerLevel level) {
        Vec3 playerPos = player.m_20182_();
        for (int attempt = 0; attempt < 20; ++attempt) {
            BlockPos below;
            double distance = 8.0 + random.nextDouble() * 24.0;
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double spawnX = playerPos.f_82479_ + Math.cos(angle) * distance;
            double spawnZ = playerPos.f_82481_ + Math.sin(angle) * distance;
            BlockPos searchPos = new BlockPos((int)Math.floor(spawnX), (int)Math.floor(playerPos.f_82480_), (int)Math.floor(spawnZ));
            BlockPos spawnPos = EyelessSpawnProcedure.findValidSpawnPosition(level, searchPos);
            if (spawnPos == null || !level.m_46749_(below = spawnPos.m_7495_()) || level.m_8055_(below).m_60795_()) continue;
            EyelessSpawnProcedure.spawnEyelessWithAnimation(level, spawnPos, (Player)player);
            return true;
        }
        return false;
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, BlockPos start) {
        for (int y = start.m_123342_(); y > level.m_141937_(); --y) {
            BlockPos checkPos = new BlockPos(start.m_123341_(), y, start.m_123343_());
            BlockPos abovePos = checkPos.m_7494_();
            BlockPos above2Pos = checkPos.m_6630_(2);
            if (!level.m_46749_(checkPos)) continue;
            BlockState groundState = level.m_8055_(checkPos);
            BlockState above1State = level.m_8055_(abovePos);
            BlockState above2State = level.m_8055_(above2Pos);
            if (groundState.m_60795_() || !groundState.m_60804_((BlockGetter)level, checkPos) || !above1State.m_60795_() || !above2State.m_60795_()) continue;
            return abovePos;
        }
        return null;
    }

    private static void spawnEyelessWithAnimation(ServerLevel level, BlockPos spawnPos, Player player) {
        try {
            EntityType entityType = (EntityType)FromTheCavesModEntities.FROMTHECAVESEYELESS.get();
            if (entityType == null) {
                return;
            }
            Entity entity = entityType.m_20615_((Level)level);
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            Vec3 spawnVec = new Vec3((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
            mob.m_7678_(spawnVec.f_82479_, spawnVec.f_82480_, spawnVec.f_82481_, random.nextFloat() * 360.0f, 0.0f);
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(spawnPos), MobSpawnType.TRIGGERED, null, null);
            mob.m_21530_();
            EyelessSpawnProcedure.playWardenLikeEffects(level, spawnPos);
            level.m_7967_((Entity)mob);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void playWardenLikeEffects(ServerLevel level, BlockPos pos) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        level.m_5594_(null, pos, SoundEvents.f_215781_, SoundSource.HOSTILE, 1.5f, 0.8f);
        for (i = 0; i < 30; ++i) {
            offsetX = (random.nextDouble() - 0.5) * 2.0;
            offsetY = random.nextDouble() * 2.0;
            offsetZ = (random.nextDouble() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.1, 0.0, 0.02);
        }
        for (i = 0; i < 20; ++i) {
            offsetX = (random.nextDouble() - 0.5) * 1.5;
            offsetY = random.nextDouble() * 1.5;
            offsetZ = (random.nextDouble() - 0.5) * 1.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
        }
    }

    public static boolean forceSpawn(ServerLevel level, ServerPlayer player) {
        if (level == null || player == null) {
            return false;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 3) {
            return false;
        }
        return EyelessSpawnProcedure.trySpawnEyeless(player, level);
    }
}

