/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.entity.FROMTHECAVESFALLINGEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FallingMobProcedure {
    private static final double BASE_PROB = 0.0015;
    private static final double MAX_PROB = 0.003;
    private static final int MIN_PHASE = 1;
    private static final int MAX_PHASE = 2;
    private static final int BREAK_HEIGHT = 8;
    private static final double LOOK_Y_THRESHOLD = 0.6;
    private static final double DESPAWN_DISTANCE = 1.5;
    private static final long DESPAWN_TICKS = 80L;

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent evt) {
        Player player = evt.getPlayer();
        LevelAccessor levelAcc = evt.getLevel();
        if (player == null) {
            return;
        }
        if (levelAcc.m_5776_()) {
            return;
        }
        if (!(levelAcc instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAcc;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase < 1 || phase > 2) {
            return;
        }
        Vec3 look = player.m_20154_();
        if (look == null || look.f_82480_ <= 0.6) {
            return;
        }
        double prob = ChunkTensionProcedure.getDynamicProbability(serverLevel, player, 0.0015, 0.003);
        if (Math.random() >= prob) {
            return;
        }
        BlockPos base = player.m_20183_().m_7494_();
        for (int i = 0; i < 8; ++i) {
            BlockPos pos = base.m_6630_(i);
            BlockState state = serverLevel.m_8055_(pos);
            if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_ || state.m_60734_() == Blocks.f_50375_) continue;
            serverLevel.m_46597_(pos, Blocks.f_50016_.m_49966_());
            serverLevel.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        BlockPos spawnPos = base.m_6630_(7);
        FROMTHECAVESFALLINGEntity mob = (FROMTHECAVESFALLINGEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESFALLING.get()).m_20615_((Level)serverLevel);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_20334_(0.0, -0.5, 0.0);
        mob.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        serverLevel.m_7967_((Entity)mob);
        CompoundTag tag = mob.getPersistentData();
        tag.m_128356_("spawnTick", serverLevel.m_46467_());
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVESFALLINGEntity)) {
            return;
        }
        FROMTHECAVESFALLINGEntity mob = (FROMTHECAVESFALLINGEntity)e;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)lvl;
        CompoundTag tag = mob.getPersistentData();
        long spawnTick = tag.m_128454_("spawnTick");
        if (serverLevel.m_46467_() - spawnTick >= 80L) {
            serverLevel.m_5594_(null, mob.m_20183_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.AMBIENT, 1.0f, 0.5f);
            mob.m_146870_();
            return;
        }
        ServerPlayer closest = null;
        double minDistSq = Double.MAX_VALUE;
        for (ServerPlayer p : serverLevel.m_6907_()) {
            double d2 = mob.m_20280_((Entity)p);
            if (!(d2 < minDistSq)) continue;
            minDistSq = d2;
            closest = p;
        }
        if (closest == null) {
            return;
        }
        if (Math.sqrt(minDistSq) <= 1.5) {
            closest.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 1.0f);
            serverLevel.m_5594_(null, mob.m_20183_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.AMBIENT, 1.0f, 0.5f);
            mob.m_146870_();
        }
    }
}

