/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlamingoHauntedProcedure {
    private static final double BASE_PROB = 0.003;
    private static final double MAX_PROB = 0.0055;
    private static final int SEARCH_RADIUS = 16;
    private static final int MAX_CHECKS_PER_TICK = 20;
    private static final Random random = new Random();
    private static final Map<UUID, Long> lastCheckTime = new HashMap<UUID, Long>();
    private static final Map<UUID, BlockPos> cachedFlamingoPos = new HashMap<UUID, BlockPos>();
    private static final ResourceLocation[] SOUND_NAMES = new ResourceLocation[]{new ResourceLocation("from_the_caves", "flamingo1"), new ResourceLocation("from_the_caves", "flamingo2"), new ResourceLocation("from_the_caves", "flamingo3"), new ResourceLocation("from_the_caves", "flamingo4"), new ResourceLocation("from_the_caves", "flamingo5")};

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        BlockPos flamingoPos;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 0 || phase > 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 0.003, 0.0055);
        if (Math.random() >= dynamicProb) {
            return;
        }
        UUID playerId = player.m_20148_();
        BlockPos playerPos = player.m_20183_();
        BlockPos cached = cachedFlamingoPos.get(playerId);
        if (cached != null) {
            double distSq = cached.m_123331_((Vec3i)playerPos);
            if (distSq <= 256.0 && FlamingoHauntedProcedure.isFlamingoBlock(level, cached)) {
                FlamingoHauntedProcedure.playFlamingoSound(level, cached);
                return;
            }
            cachedFlamingoPos.remove(playerId);
        }
        if ((flamingoPos = FlamingoHauntedProcedure.findFlamingoNearby(level, playerPos)) != null) {
            cachedFlamingoPos.put(playerId, flamingoPos);
            FlamingoHauntedProcedure.playFlamingoSound(level, flamingoPos);
        }
    }

    private static BlockPos findFlamingoNearby(Level level, BlockPos center) {
        ArrayList samplesToCheck = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            int dz;
            int dy;
            int dx = random.nextInt(33) - 16;
            BlockPos checkPos = center.m_7918_(dx, dy = random.nextInt(33) - 16, dz = random.nextInt(33) - 16);
            if (!FlamingoHauntedProcedure.isFlamingoBlock(level, checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private static boolean isFlamingoBlock(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        return blockId != null && "from_the_caves".equals(blockId.m_135827_()) && "flamingo".equals(blockId.m_135815_());
    }

    private static void playFlamingoSound(Level level, BlockPos pos) {
        ResourceLocation soundRL = SOUND_NAMES[random.nextInt(SOUND_NAMES.length)];
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundRL);
        if (soundEvent != null) {
            level.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

