/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HideSpawnProcedure {
    private static final double BASE_PROB = 3.5E-5;
    private static final double MAX_PROB = 4.0E-5;
    private static final double BACK_DISTANCE = 2.0;
    private static final double LEFT_OFFSET = -1.0;
    private static final int PILLAR_MIN_HEIGHT = 2;
    private static final int LOOK_DESPAWN_TICKS = 14;
    private static final double DETECTION_RANGE = 50.0;
    private static final double DETECTION_RANGE_SQ = 2500.0;
    private static final double TOTAL_FOV_DEGREES = 130.0;
    private static final double HALF_FOV_DEGREES = 65.0;
    private static final double HALF_FOV_DOT = Math.cos(Math.toRadians(65.0));
    private static final int TICK_CHECK_INTERVAL = 2;
    private static final Map<UUID, Long> sneakSchedule = new ConcurrentHashMap<UUID, Long>();
    private static final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private static final String NBT_PILLAR_X = "FTC_pillarX";
    private static final String NBT_PILLAR_Y = "FTC_pillarY";
    private static final String NBT_PILLAR_Z = "FTC_pillarZ";
    private static final String NBT_HIDE_flag = "FTC_hide";
    private static final String NBT_PILLAR_BLOCKS = "FTC_pillarBlocks";
    private static final ThreadLocal<List<BlockPos>> tempPillarBlocks = new ThreadLocal();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        double dynamicProb;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = ev.player;
        if (p == null || p.m_9236_().m_5776_()) {
            return;
        }
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)p;
        Level level = serverPlayer.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (p.m_20186_() >= 50.0) {
            return;
        }
        try {
            dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)serverPlayer, 3.5E-5, 4.0E-5);
        }
        catch (Throwable t) {
            dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)serverPlayer);
        }
        if (Math.random() >= dynamicProb) {
            return;
        }
        Vec3 spawnPos = HideSpawnProcedure.calculateSpawnPosition(serverPlayer);
        if (spawnPos == null) {
            return;
        }
        HideSpawnProcedure.spawnHideEntity(server, serverPlayer, spawnPos);
    }

    public static boolean trySpawnImmediate(ServerLevel server, ServerPlayer player) {
        if (server == null || player == null) {
            return false;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return false;
        }
        Vec3 pos = HideSpawnProcedure.calculateSpawnPosition(player);
        if (pos == null) {
            return false;
        }
        HideSpawnProcedure.spawnHideEntity(server, player, pos);
        return true;
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level lvl = mob.m_9236_();
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)lvl;
        if (!HideSpawnProcedure.isHideEntity((Entity)mob)) {
            return;
        }
        long now = server.m_46467_();
        UUID id = mob.m_20148_();
        Long scheduled = sneakSchedule.get(id);
        if (scheduled != null) {
            if (now >= scheduled) {
                HideSpawnProcedure.performDespawn(mob, server, id);
            }
            return;
        }
        if (now % 2L != 0L) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        for (ServerPlayer player : server.m_6907_()) {
            double d2;
            if (player.m_5833_() || (d2 = mob.m_20280_((Entity)player)) > 2500.0 || !HideSpawnProcedure.isPlayerCloseOrLookingAt((Player)player, mob, d2)) continue;
            Vec3 playerEye = player.m_20299_(1.0f);
            Vec3 look = player.m_20154_();
            Vec3 forward = new Vec3(look.f_82479_, 0.0, look.f_82481_);
            double flen = Math.sqrt(forward.f_82479_ * forward.f_82479_ + forward.f_82481_ * forward.f_82481_);
            if (flen < 1.0E-6) {
                flen = 1.0;
            }
            forward = forward.m_82490_(1.0 / flen);
            Vec3 left = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_);
            Vec3 targetLookPoint = playerEye.m_82549_(left.m_82490_(-0.5));
            try {
                mob.m_21563_().m_24950_(targetLookPoint.f_82479_, targetLookPoint.f_82480_, targetLookPoint.f_82481_, 30.0f, 30.0f);
            }
            catch (Throwable ignored) {
                double dx = targetLookPoint.f_82479_ - mob.m_20185_();
                double dz = targetLookPoint.f_82481_ - mob.m_20189_();
                float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
                mob.m_146922_(yaw);
                mob.f_20883_ = yaw;
                mob.f_20885_ = yaw;
            }
            HideSpawnProcedure.triggerHideBehavior(mob, id, now, server);
            break;
        }
    }

    private static Vec3 calculateSpawnPosition(ServerPlayer player) {
        Vec3 look = player.m_20154_();
        Vec3 forward = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        double flen = Math.sqrt(forward.f_82479_ * forward.f_82479_ + forward.f_82481_ * forward.f_82481_);
        if (flen < 1.0E-6) {
            return null;
        }
        forward = forward.m_82490_(1.0 / flen);
        Vec3 left = new Vec3(-forward.f_82481_, 0.0, forward.f_82479_);
        Vec3 behind = forward.m_82490_(-1.0);
        double sx = player.m_20185_() + behind.f_82479_ * 2.0 + left.f_82479_ * -1.0;
        double sy = player.m_20186_();
        double sz = player.m_20189_() + behind.f_82481_ * 2.0 + left.f_82481_ * -1.0;
        ServerLevel server = (ServerLevel)player.m_9236_();
        BlockPos spawnXZ = BlockPos.m_274561_((double)sx, (double)sy, (double)sz);
        int chosenY = HideSpawnProcedure.findSuitableYForPillar(server, spawnXZ);
        BlockPos pillarBase = new BlockPos(spawnXZ.m_123341_(), chosenY, spawnXZ.m_123343_());
        List<BlockPos> placedBlocks = HideSpawnProcedure.ensurePillar(server, pillarBase, 2);
        Vec3 safe = HideSpawnProcedure.findSafeSpawnPosition(server, pillarBase, behind);
        if (safe == null) {
            safe = new Vec3((double)pillarBase.m_123341_() + 0.5, (double)(pillarBase.m_123342_() + 2) + 0.1, (double)pillarBase.m_123343_() + 0.5);
        }
        tempPillarBlocks.set(placedBlocks);
        return safe;
    }

    private static void spawnHideEntity(ServerLevel server, ServerPlayer player, Vec3 position) {
        EntityType et;
        try {
            et = (EntityType)FromTheCavesModEntities.FROMTHECAVESHIDE.get();
        }
        catch (Throwable t) {
            return;
        }
        if (et == null) {
            return;
        }
        Entity ent = et.m_20615_((Level)server);
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        Vec3 playerEye = player.m_20299_(1.0f);
        double dx = playerEye.f_82479_ - position.f_82479_;
        double dz = playerEye.f_82481_ - position.f_82481_;
        float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 105.0f;
        double dy = playerEye.f_82480_ - (position.f_82480_ + (double)mob.m_20192_());
        double flat = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, flat)));
        mob.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, yaw, pitch);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        mob.m_21557_(false);
        mob.m_21530_();
        int pillarX = (int)Math.floor(position.f_82479_);
        int pillarZ = (int)Math.floor(position.f_82481_);
        int pillarY = HideSpawnProcedure.findSuitableYForPillar(server, new BlockPos(pillarX, (int)position.f_82480_, pillarZ));
        CompoundTag pd = mob.getPersistentData();
        pd.m_128405_(NBT_PILLAR_X, pillarX);
        pd.m_128405_(NBT_PILLAR_Y, pillarY);
        pd.m_128405_(NBT_PILLAR_Z, pillarZ);
        List<BlockPos> placedBlocks = tempPillarBlocks.get();
        if (placedBlocks != null && !placedBlocks.isEmpty()) {
            ArrayList<Integer> coords = new ArrayList<Integer>();
            for (BlockPos pos : placedBlocks) {
                coords.add(pos.m_123341_());
                coords.add(pos.m_123342_());
                coords.add(pos.m_123343_());
            }
            int[] arr = coords.stream().mapToInt(Integer::intValue).toArray();
            pd.m_128385_(NBT_PILLAR_BLOCKS, arr);
            tempPillarBlocks.remove();
        }
        server.m_7967_((Entity)mob);
    }

    private static boolean isHideEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        try {
            EntityType reg;
            try {
                reg = (EntityType)FromTheCavesModEntities.FROMTHECAVESHIDE.get();
            }
            catch (Throwable t) {
                return false;
            }
            return entity.m_6095_().equals(reg);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isPlayerCloseOrLookingAt(Player player, Mob mob, double distSq) {
        if (distSq <= 4.0) {
            return true;
        }
        Vec3 playerEye = player.m_20299_(1.0f);
        Vec3 mobEye = new Vec3(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
        Vec3 toMob = mobEye.m_82546_(playerEye);
        double len = toMob.m_82553_();
        if (len < 0.001) {
            return true;
        }
        Vec3 dirToMob = toMob.m_82490_(1.0 / len);
        Vec3 playerLook = player.m_20154_();
        double dot = playerLook.f_82479_ * dirToMob.f_82479_ + playerLook.f_82480_ * dirToMob.f_82480_ + playerLook.f_82481_ * dirToMob.f_82481_;
        return dot >= HALF_FOV_DOT;
    }

    private static void triggerHideBehavior(Mob mob, UUID id, long now, ServerLevel server) {
        try {
            mob.getPersistentData().m_128379_(NBT_HIDE_flag, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HideSpawnProcedure.applySneak(mob, true);
        HideSpawnProcedure.playHideSound(server, mob);
        HideSpawnProcedure.addHideParticles(server, mob, 3);
        sneakSchedule.put(id, now + 14L);
    }

    private static void performDespawn(Mob mob, ServerLevel server, UUID id) {
        try {
            mob.getPersistentData().m_128379_(NBT_HIDE_flag, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SoundEvent cave = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
        if (cave != null) {
            server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.8f);
        }
        HideSpawnProcedure.addDespawnParticles(server, mob);
        CompoundTag pd = mob.getPersistentData();
        int[] arr = pd.m_128465_(NBT_PILLAR_BLOCKS);
        if (arr != null && arr.length % 3 == 0) {
            for (int i = 0; i < arr.length; i += 3) {
                BlockPos p = new BlockPos(arr[i], arr[i + 1], arr[i + 2]);
                try {
                    BlockState currentState;
                    if (!server.m_46749_(p) || !(currentState = server.m_8055_(p)).m_60713_(Blocks.f_50069_)) continue;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 3, 0.25, 0.25, 0.25, 0.01);
                    try {
                        server.m_46961_(p, false);
                    }
                    catch (Throwable t1) {
                        try {
                            server.m_46597_(p, Blocks.f_50016_.m_49966_());
                        }
                        catch (Throwable throwable) {}
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            pd.m_128473_(NBT_PILLAR_BLOCKS);
        }
        mob.m_146870_();
        sneakSchedule.remove(id);
    }

    private static void applySneak(Mob mob, boolean value) {
        try {
            mob.m_20260_(value);
            return;
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            String[] methodNames = new String[]{"setShiftKeyDown", "setSneaking", "setSneak", "setShift"};
            Class<?> clazz = mob.getClass();
            for (String name : methodNames) {
                String key = clazz.getName() + "." + name;
                Method method = methodCache.get(key);
                if (method == null) {
                    try {
                        method = clazz.getMethod(name, Boolean.TYPE);
                        method.setAccessible(true);
                        methodCache.put(key, method);
                    }
                    catch (NoSuchMethodException ex) {
                        method = null;
                    }
                }
                if (method == null) continue;
                try {
                    method.invoke((Object)mob, value);
                    return;
                }
                catch (Throwable t) {
                    methodCache.remove(key);
                }
            }
            try {
                mob.m_20124_(value ? Pose.CROUCHING : Pose.STANDING);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    private static void playHideSound(ServerLevel server, Mob mob) {
        SoundEvent stepSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "block.stone.step"));
        if (stepSound != null) {
            server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), stepSound, SoundSource.HOSTILE, 1.0f, 0.7f);
        }
    }

    private static void addHideParticles(ServerLevel server, Mob mob, int count) {
        for (int i = 0; i < count; ++i) {
            double px = mob.m_20185_() + (server.f_46441_.m_188500_() - 0.5) * 0.3;
            double py = mob.m_20186_() + 0.1;
            double pz = mob.m_20189_() + (server.f_46441_.m_188500_() - 0.5) * 0.3;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static void addDespawnParticles(ServerLevel server, Mob mob) {
        for (int i = 0; i < 8; ++i) {
            double px = mob.m_20185_() + (server.f_46441_.m_188500_() - 0.5);
            double py = mob.m_20186_() + server.f_46441_.m_188500_() * (double)mob.m_20206_();
            double pz = mob.m_20189_() + (server.f_46441_.m_188500_() - 0.5);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, px, py, pz, 1, 0.0, 0.05, 0.0, 0.02);
        }
    }

    private static int findSuitableYForPillar(ServerLevel server, BlockPos spawnXZ) {
        BlockPos p;
        int d;
        int baseY = spawnXZ.m_123342_();
        for (d = 0; d <= 6; ++d) {
            p = spawnXZ.m_6625_(d);
            if (!server.m_46749_(p) || server.m_8055_(p).m_60795_()) continue;
            int candidate = p.m_123342_() + 1;
            return Math.max(1, Math.min(candidate, server.m_151558_() - 2));
        }
        for (d = 0; d <= 6; ++d) {
            p = spawnXZ.m_6630_(d);
            if (!server.m_46749_(p) || server.m_8055_(p).m_60795_()) continue;
            int candidate = p.m_123342_();
            return Math.max(1, Math.min(candidate, server.m_151558_() - 2));
        }
        return Math.max(1, Math.min(baseY, server.m_151558_() - 2));
    }

    private static List<BlockPos> ensurePillar(ServerLevel server, BlockPos base, int minHeight) {
        BlockPos p;
        int h;
        ArrayList<BlockPos> placedBlocks = new ArrayList<BlockPos>();
        int solid = 0;
        for (h = 0; h < minHeight; ++h) {
            p = base.m_6630_(h);
            if (!server.m_46749_(p) || server.m_8055_(p).m_60795_()) continue;
            ++solid;
        }
        if (solid >= minHeight) {
            return placedBlocks;
        }
        for (h = 0; h < minHeight; ++h) {
            p = base.m_6630_(h);
            if (!server.m_46749_(p) || !server.m_8055_(p).m_60795_()) continue;
            server.m_46597_(p, Blocks.f_50069_.m_49966_());
            placedBlocks.add(p);
        }
        return placedBlocks;
    }

    private static Vec3 findSafeSpawnPosition(ServerLevel server, BlockPos pillarBase, Vec3 prefDir) {
        double px = prefDir.f_82479_;
        double pz = prefDir.f_82481_;
        double plen = Math.sqrt(px * px + pz * pz);
        if (plen < 1.0E-6) {
            px = 0.0;
            pz = -1.0;
            plen = 1.0;
        }
        Vec3 pref = new Vec3(px /= plen, 0.0, pz /= plen);
        Vec3 left = new Vec3(-pz, 0.0, px);
        double[] dists = new double[]{1.25, 1.5};
        Vec3[] dirCandidates = new Vec3[]{pref, pref.m_82549_(left), pref.m_82546_(left), left, left.m_82490_(-1.0), new Vec3(0.0, 1.0, 0.0)};
        for (double d : dists) {
            for (Vec3 dir : dirCandidates) {
                if (dir.f_82480_ != 0.0) {
                    int topY = pillarBase.m_123342_() + 2;
                    BlockPos pos = new BlockPos(pillarBase.m_123341_(), topY, pillarBase.m_123343_());
                    if (!server.m_46749_(pos)) continue;
                    Vec3 sp = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
                    BlockPos feet = BlockPos.m_274561_((double)sp.f_82479_, (double)sp.f_82480_, (double)sp.f_82481_);
                    BlockPos below = feet.m_7495_();
                    if (!server.m_46749_(feet) || !server.m_46749_(below) || !server.m_8055_(feet).m_60795_() || server.m_8055_(below).m_60795_()) continue;
                    return sp;
                }
                double ox = (double)pillarBase.m_123341_() + 0.5 + dir.f_82479_ * d;
                double oz = (double)pillarBase.m_123343_() + 0.5 + dir.f_82481_ * d;
                for (int hy = 0; hy <= 3; ++hy) {
                    int y = pillarBase.m_123342_() + hy;
                    BlockPos feet = new BlockPos((int)Math.floor(ox), y, (int)Math.floor(oz));
                    if (!server.m_46749_(feet)) continue;
                    BlockState bsFeet = server.m_8055_(feet);
                    BlockPos below = feet.m_7495_();
                    if (!server.m_46749_(below)) continue;
                    BlockState bsBelow = server.m_8055_(below);
                    if (!bsFeet.m_60795_() || bsBelow.m_60795_() || feet.m_123341_() == pillarBase.m_123341_() && feet.m_123343_() == pillarBase.m_123343_() && feet.m_123342_() >= pillarBase.m_123342_() && feet.m_123342_() < pillarBase.m_123342_() + 2) continue;
                    return new Vec3((double)feet.m_123341_() + 0.5, (double)feet.m_123342_(), (double)feet.m_123343_() + 0.5);
                }
            }
        }
        return null;
    }
}

