/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.AngerSystemProcedure;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HouseCornerStalkerProcedure {
    private static final double BASE_PROB = 5.0E-5;
    private static final double MAX_PROB = 9.0E-5;
    private static final double MIN_DIST = 5.0;
    private static final double MAX_DIST = 30.0;
    private static final double WATCH_DISTANCE = 60.0;
    private static final double CHASE_TRIGGER_DIST = 4.0;
    private static final int LOOK_TRIGGER_TICKS = 20;
    private static final double RUN_SPEED = 0.75;
    private static final int RUN_DURATION_TICKS = 240;
    private static final double GRAVITY = 0.42;
    private static final int MAX_LIGHT_LEVEL = 5;
    private static final int CORNER_SEARCH_RADIUS = 20;
    private static final int MAX_CORNER_ATTEMPTS = 30;
    private static final double NOCLIP_SPEED = 0.6;
    private static final double DESPAWN_BEHIND_COVER_DIST = 25.0;
    private static final int DESPAWN_HIDDEN_TICKS = 60;
    private static final int DESPAWN_DELAY_TICKS = 20;
    private static final int HIDE_AFTER_LOOK_TICKS = 20;
    private static final String KEY_HOUSE_CORNER = "hcs_houseCorner";
    private static final String KEY_SPAWN_TIME = "hcs_spawnTime";
    private static final String KEY_LOOK_START = "hcs_lookStart";
    private static final String KEY_RUNNING = "hcs_running";
    private static final String KEY_RUN_START = "hcs_runStart";
    private static final String KEY_FROZEN = "hcs_frozen";
    private static final String KEY_FADE_START = "hcs_fadeStart";
    private static final String KEY_HIDDEN_START = "hcs_hiddenStart";
    private static final String KEY_DESPAWN_STARTED = "hcs_despawnStarted";
    private static final String KEY_DESPAWN_DELAY = "hcs_despawnDelay";
    private static final String KEY_HIDE_START = "hcs_hideStart";
    private static final String KEY_HIDING = "hcs_hiding";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (!AngerSystemProcedure.isPlayerInHouse(level, player)) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 5.0E-5, 9.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        EntityType<?> chosenEntity = HouseCornerStalkerProcedure.chooseRandomEntity();
        BlockPos cornerPos = HouseCornerStalkerProcedure.findDarkCornerInHouse(level, player);
        if (cornerPos == null) {
            return;
        }
        Mob mob = (Mob)chosenEntity.m_262496_(level, cornerPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        mob.f_19794_ = false;
        HouseCornerStalkerProcedure.makeEntityLookAtPlayer(mob, player);
        CompoundTag data = mob.getPersistentData();
        data.m_128379_(KEY_HOUSE_CORNER, true);
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128379_(KEY_FROZEN, false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
        data.m_128379_(KEY_HIDING, false);
    }

    private static EntityType<?> chooseRandomEntity() {
        double roll = Math.random();
        if (roll < 0.4) {
            return (EntityType)FromTheCavesModEntities.WATCHEYES.get();
        }
        if (roll < 0.7) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get();
    }

    private static BlockPos findDarkCornerInHouse(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int attempt = 0; attempt < 30; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 5.0 + Math.random() * 25.0;
            int dx = (int)Math.round(Math.cos(angle) * dist);
            int dz = (int)Math.round(Math.sin(angle) * dist);
            for (int dy = -3; dy <= 3; ++dy) {
                double distance;
                BlockPos above;
                BlockState stateAt;
                ChunkPos testChunk;
                BlockPos testPos = playerPos.m_7918_(dx, dy, dz);
                if (!level.m_46749_(testPos) || !HouseCornerStalkerProcedure.isInDarkCorner(level, testPos) || !AngerSystemProcedure.isChunkHouse(level, testChunk = new ChunkPos(testPos)) || !(stateAt = level.m_8055_(testPos)).m_60795_() || !level.m_8055_(above = testPos.m_7494_()).m_60795_() || !((distance = Math.sqrt(testPos.m_203193_((Position)player.m_20182_()))) >= 5.0) || !(distance <= 30.0)) continue;
                return testPos;
            }
        }
        return null;
    }

    private static boolean isInDarkCorner(ServerLevel level, BlockPos pos) {
        int[][] directions;
        int lightLevel = level.m_46803_(pos);
        if (lightLevel > 5) {
            return false;
        }
        int wallsNearby = 0;
        for (int[] dir : directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            BlockState state;
            BlockPos wallCheck = pos.m_7918_(dir[0], 0, dir[1]);
            if (!level.m_46749_(wallCheck) || !(state = level.m_8055_(wallCheck)).m_280296_() || !state.m_60796_((BlockGetter)level, wallCheck)) continue;
            ++wallsNearby;
        }
        return wallsNearby >= 2;
    }

    private static void makeEntityLookAtPlayer(Mob mob, Player player) {
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        double dy = player.m_20188_() - mob.m_20188_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(Math.atan2(dy, horizontalDist) * 180.0 / Math.PI);
        mob.m_146926_(pitch);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.WATCHEYES.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get()))) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128471_(KEY_HOUSE_CORNER)) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 60.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        boolean running = data.m_128471_(KEY_RUNNING);
        boolean frozen = data.m_128471_(KEY_FROZEN);
        boolean hiding = data.m_128471_(KEY_HIDING);
        if (hiding) {
            HouseCornerStalkerProcedure.handleHidingBehavior(mob, data, level, player, now);
            return;
        }
        if (frozen) {
            HouseCornerStalkerProcedure.handleFrozenBehavior(mob, data, level, player, now);
            return;
        }
        if (!running) {
            HouseCornerStalkerProcedure.handleWatchingBehavior(mob, data, level, player, now, dist);
            return;
        }
        HouseCornerStalkerProcedure.handleFleeingBehavior(mob, data, level, player, now);
    }

    private static void handleWatchingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, double dist) {
        double vanishRoll;
        boolean inSightCone;
        HouseCornerStalkerProcedure.makeEntityLookAtPlayer(mob, player);
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        if (dist <= 4.0) {
            HouseCornerStalkerProcedure.startRunning(mob, data, now);
            return;
        }
        boolean playerLookingAtMob = HouseCornerStalkerProcedure.isPlayerLookingAtMob(player, mob, 100.0);
        if (playerLookingAtMob) {
            if (!data.m_128441_(KEY_HIDE_START)) {
                data.m_128356_(KEY_HIDE_START, now);
            } else {
                long hideStart = data.m_128454_(KEY_HIDE_START);
                if (now - hideStart >= 20L) {
                    HouseCornerStalkerProcedure.startHiding(mob, data, now);
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_HIDE_START);
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
        if (toMob.m_82553_() == 0.0) {
            data.m_128473_(KEY_LOOK_START);
            return;
        }
        Vec3 toMobNorm = toMob.m_82541_();
        double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
        boolean bl = inSightCone = dot > 0.92 && hasLOS;
        if (inSightCone) {
            if (!data.m_128441_(KEY_LOOK_START)) {
                data.m_128356_(KEY_LOOK_START, now);
            } else {
                long started = data.m_128454_(KEY_LOOK_START);
                if (now - started >= 20L) {
                    double freezeRoll = Math.random();
                    if (freezeRoll < 0.2) {
                        data.m_128379_(KEY_FROZEN, true);
                        data.m_128356_(KEY_FADE_START, now);
                    } else {
                        HouseCornerStalkerProcedure.startRunning(mob, data, now);
                    }
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_LOOK_START);
        }
        long spawnTime = data.m_128454_(KEY_SPAWN_TIME);
        if (now - spawnTime > 800L && (vanishRoll = Math.random()) < 0.03 && !hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static boolean isPlayerLookingAtMob(Player player, Mob mob, double fov) {
        double fovRadians;
        double requiredDot;
        Vec3 toMob;
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        double dot = playerLook.m_82526_(toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20188_(), mob.m_20189_() - player.m_20189_()).m_82541_());
        return dot >= (requiredDot = Math.cos(fovRadians = Math.toRadians(fov / 2.0))) && player.m_142582_((Entity)mob);
    }

    private static void startHiding(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_HIDING, true);
        data.m_128356_(KEY_HIDE_START, now);
        mob.m_21557_(true);
        ServerLevel level = (ServerLevel)mob.m_9236_();
        level.m_5594_(null, mob.m_20183_(), SoundEvents.f_11937_, SoundSource.HOSTILE, 0.7f, 0.8f);
        for (int i = 0; i < 8; ++i) {
            double offsetX = (Math.random() - 0.5) * 0.8;
            double offsetY = Math.random() * 1.5;
            double offsetZ = (Math.random() - 0.5) * 0.8;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY, mob.m_20189_() + offsetZ, 3, 0.1, 0.1, 0.1, 0.02);
        }
    }

    private static void handleHidingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.m_20334_(0.0, 0.0, 0.0);
        mob.m_21557_(true);
        long hideStart = data.m_128454_(KEY_HIDE_START);
        long hideDuration = 40L;
        if ((now - hideStart) % 5L == 0L) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), 2, 0.2, 0.3, 0.2, 0.01);
        }
        if (now - hideStart >= hideDuration) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFrozenBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        mob.m_21557_(true);
        long fadeStart = data.m_128454_(KEY_FADE_START);
        long fadeDuration = 80L;
        if (now - fadeStart >= fadeDuration) {
            mob.m_146870_();
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        if (!hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFleeingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        boolean despawnStarted = data.m_128471_(KEY_DESPAWN_STARTED);
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 25.0) {
            if (!data.m_128441_(KEY_HIDDEN_START)) {
                data.m_128356_(KEY_HIDDEN_START, now);
            } else {
                long hiddenTime = now - data.m_128454_(KEY_HIDDEN_START);
                if (hiddenTime >= 60L) {
                    if (!despawnStarted) {
                        data.m_128379_(KEY_DESPAWN_STARTED, true);
                        data.m_128356_(KEY_DESPAWN_DELAY, now);
                    } else {
                        long despawnTime = now - data.m_128454_(KEY_DESPAWN_DELAY);
                        if (despawnTime >= 20L) {
                            mob.m_146870_();
                            return;
                        }
                    }
                }
            }
        } else {
            data.m_128473_(KEY_HIDDEN_START);
            data.m_128379_(KEY_DESPAWN_STARTED, false);
        }
        Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
        if (fleeDir.m_82556_() < 1.0E-6) {
            Vec3 look = player.m_20252_(1.0f).m_82541_();
            fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
        }
        Vec3 targetDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        mob.m_21557_(true);
        mob.m_20242_(false);
        mob.f_19794_ = true;
        double speedFactor = 0.6;
        BlockPos belowPos = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(belowPos)) {
            BlockState belowState = level.m_8055_(belowPos);
            onGround = !belowState.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.21;
        Vec3 motion = new Vec3(targetDir.f_82479_ * speedFactor, newY, targetDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY_pos = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY_pos, newZ);
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 240L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        mob.m_21557_(true);
        mob.m_20242_(false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
    }
}

