/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.FromTheCavesMod;
import net.mcreator.fromthecaves.init.FromTheCavesModParticleTypes;
import net.mcreator.fromthecaves.network.InkStatusSyncPacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InkSacProjectileHitProcedure {
    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        Level player;
        EntityHitResult entityHit;
        Entity entity;
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        Snowball snowball = (Snowball)projectile;
        CompoundTag projectileData = snowball.getPersistentData();
        if (!projectileData.m_128471_("is_ink_sac")) {
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof Player) {
            Level level;
            player = (Player)entity;
            CompoundTag playerData = player.getPersistentData();
            long now = player.m_9236_().m_46467_();
            long until = now + 200L;
            playerData.m_128356_("inked_until", until);
            playerData.m_128379_("is_inked", true);
            playerData.m_128356_("ink_last_damage", now);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                try {
                    FromTheCavesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new InkStatusSyncPacket(until));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((level = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123765_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 60, 0.9, 1.3, 0.9, 0.25);
                server.m_8767_((ParticleOptions)((SimpleParticleType)FromTheCavesModParticleTypes.INK.get()), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 30, 0.8, 1.2, 0.8, 0.15);
                server.m_5594_(null, player.m_20183_(), SoundEvents.f_12441_, SoundSource.NEUTRAL, 1.2f, 0.9f);
            }
        }
        if ((player = snowball.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)player;
            Vec3 pos = snowball.m_20182_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123765_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 25, 0.5, 0.5, 0.5, 0.15);
            server.m_8767_((ParticleOptions)((SimpleParticleType)FromTheCavesModParticleTypes.INK.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 15, 0.6, 0.6, 0.6, 0.1);
        }
        snowball.m_146870_();
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag pd = player.getPersistentData();
        long now = player.m_9236_().m_46467_();
        if (!pd.m_128471_("is_inked")) {
            return;
        }
        long inkedUntil = pd.m_128454_("inked_until");
        if (now >= inkedUntil) {
            pd.m_128379_("is_inked", false);
            pd.m_128473_("inked_until");
            pd.m_128473_("ink_last_damage");
            return;
        }
        long lastDamage = pd.m_128454_("ink_last_damage");
        if (now - lastDamage >= 20L) {
            player.m_6469_(player.m_269291_().m_269425_(), 1.0f);
            pd.m_128356_("ink_last_damage", now);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123765_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), 6, 0.3, 0.5, 0.3, 0.06);
                server.m_8767_((ParticleOptions)((SimpleParticleType)FromTheCavesModParticleTypes.INK.get()), player.m_20185_(), player.m_20186_() + 0.6, player.m_20189_(), 3, 0.3, 0.4, 0.3, 0.04);
            }
        }
    }
}

