/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemFrameEventsProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final int CHUNKS_PER_TICK = 3;
    private static final int MAX_SEARCH_RADIUS_CHUNKS = 2;
    private static final int SEARCH_INTERVAL_TICKS = 100;
    private static final Map<Integer, ItemFrameEventState> activeEvents = new HashMap<Integer, ItemFrameEventState>();
    private static final Map<UUID, SearchProgress> searchProgress = new ConcurrentHashMap<UUID, SearchProgress>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        SearchProgress progress;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 5.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int currentTick = player.f_19797_;
        if (currentTick % 100 == 0) {
            progress = searchProgress.computeIfAbsent(playerUUID, k -> new SearchProgress());
            progress.reset();
        }
        if ((progress = searchProgress.get(playerUUID)) != null && !progress.searchComplete) {
            ItemFrameEventsProcedure.incrementalSearchChunks(player, server, progress);
        }
        if (progress != null && !progress.foundFrames.isEmpty()) {
            ItemFrame chosen = progress.foundFrames.get(server.m_213780_().m_188503_(progress.foundFrames.size()));
            ItemFrameEvent event = ItemFrameEvent.values()[server.m_213780_().m_188503_(ItemFrameEvent.values().length)];
            activeEvents.put(eventIdCounter++, new ItemFrameEventState(event, player, chosen));
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ItemFrameEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ItemFrameEventState> entry = iterator.next();
            ItemFrameEventState state = entry.getValue();
            if (!state.itemFrame.m_6084_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case ROTATION_CYCLE: {
                    ItemFrameEventsProcedure.handleRotationCycle(server, state);
                    if (state.tickCount < 120) break;
                    iterator.remove();
                    break;
                }
                case ITEM_SHAKE: {
                    ItemFrameEventsProcedure.handleItemShake(server, state);
                    if (state.tickCount < 60) break;
                    iterator.remove();
                    break;
                }
                case ITEM_VANISH_RETURN: {
                    ItemFrameEventsProcedure.handleItemVanishReturn(server, state);
                    if (state.tickCount < 80) break;
                    iterator.remove();
                }
            }
        }
    }

    private static void incrementalSearchChunks(Player player, ServerLevel level, SearchProgress progress) {
        BlockPos playerPos = player.m_20183_();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int chunksChecked = 0;
        while (chunksChecked < 3 && progress.currentRadius <= 2) {
            if (progress.currentRadius == 0) {
                ItemFrameEventsProcedure.searchChunkForFrames(level, playerChunkX, playerChunkZ, progress.foundFrames);
                progress.currentRadius = 1;
                progress.currentAngle = 0;
                ++chunksChecked;
                continue;
            }
            int perimeterChunks = progress.currentRadius * 8;
            if (progress.currentAngle >= perimeterChunks) {
                ++progress.currentRadius;
                progress.currentAngle = 0;
                continue;
            }
            int side = progress.currentAngle / (progress.currentRadius * 2);
            int offset = progress.currentAngle % (progress.currentRadius * 2);
            int chunkX = playerChunkX;
            int chunkZ = playerChunkZ;
            switch (side) {
                case 0: {
                    chunkX = playerChunkX - progress.currentRadius + offset;
                    chunkZ = playerChunkZ - progress.currentRadius;
                    break;
                }
                case 1: {
                    chunkX = playerChunkX + progress.currentRadius;
                    chunkZ = playerChunkZ - progress.currentRadius + offset;
                    break;
                }
                case 2: {
                    chunkX = playerChunkX + progress.currentRadius - offset;
                    chunkZ = playerChunkZ + progress.currentRadius;
                    break;
                }
                case 3: {
                    chunkX = playerChunkX - progress.currentRadius;
                    chunkZ = playerChunkZ + progress.currentRadius - offset;
                }
            }
            ItemFrameEventsProcedure.searchChunkForFrames(level, chunkX, chunkZ, progress.foundFrames);
            ++progress.currentAngle;
            ++chunksChecked;
        }
        if (progress.currentRadius > 2) {
            progress.searchComplete = true;
        }
    }

    private static void searchChunkForFrames(ServerLevel level, int chunkX, int chunkZ, List<ItemFrame> foundFrames) {
        if (!level.m_7232_(chunkX, chunkZ)) {
            return;
        }
        int baseX = chunkX << 4;
        int baseZ = chunkZ << 4;
        int radius = 16;
        for (Entity entity : level.m_8583_()) {
            ItemFrame frame;
            if (!(entity instanceof ItemFrame) || (frame = (ItemFrame)entity).m_31822_().m_41619_()) continue;
            BlockPos pos = frame.m_20183_();
            int entityChunkX = pos.m_123341_() >> 4;
            int entityChunkZ = pos.m_123343_() >> 4;
            if (entityChunkX != chunkX || entityChunkZ != chunkZ) continue;
            foundFrames.add(frame);
        }
    }

    private static void handleRotationCycle(ServerLevel server, ItemFrameEventState state) {
        SoundEvent sound;
        if (state.tickCount == 1) {
            sound = SoundEvents.f_12017_;
            server.m_5594_(null, state.itemFrame.m_20183_(), sound, SoundSource.BLOCKS, 0.4f, 0.9f);
        }
        if (state.tickCount % 15 == 0 && state.tickCount < 90) {
            int newRotation = (state.originalRotation + state.tickCount / 15) % 8;
            state.itemFrame.m_31770_(newRotation);
            SoundEvent sound2 = SoundEvents.f_12017_;
            server.m_5594_(null, state.itemFrame.m_20183_(), sound2, SoundSource.BLOCKS, 0.3f, 1.0f + (float)state.tickCount * 0.01f);
        }
        if (state.tickCount == 120) {
            state.itemFrame.m_31770_(state.originalRotation);
            sound = SoundEvents.f_12017_;
            server.m_5594_(null, state.itemFrame.m_20183_(), sound, SoundSource.BLOCKS, 0.4f, 0.8f);
        }
    }

    private static void handleItemShake(ServerLevel server, ItemFrameEventState state) {
        SoundEvent sound;
        if (state.tickCount == 1) {
            sound = SoundEvents.f_12014_;
            server.m_5594_(null, state.itemFrame.m_20183_(), sound, SoundSource.BLOCKS, 0.3f, 1.5f);
        }
        if (state.tickCount < 50 && state.tickCount % 3 == 0) {
            int shake = server.m_213780_().m_188503_(3) - 1;
            int newRotation = Math.max(0, Math.min(7, state.originalRotation + shake));
            state.itemFrame.m_31770_(newRotation);
            BlockPos pos = state.itemFrame.m_20183_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.1, 0.1, 0.1, 0.01);
        }
        if (state.tickCount == 60) {
            state.itemFrame.m_31770_(state.originalRotation);
            sound = SoundEvents.f_12015_;
            server.m_5594_(null, state.itemFrame.m_20183_(), sound, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private static void handleItemVanishReturn(ServerLevel server, ItemFrameEventState state) {
        SoundEvent sound;
        BlockPos pos;
        if (state.tickCount == 1) {
            pos = state.itemFrame.m_20183_();
            state.itemFrame.m_31805_(ItemStack.f_41583_);
            sound = SoundEvents.f_11937_;
            server.m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.5f, 0.3f);
        }
        if (state.tickCount == 80) {
            pos = state.itemFrame.m_20183_();
            state.itemFrame.m_31805_(state.originalItem);
            sound = (SoundEvent)SoundEvents.f_11689_.m_203334_();
            server.m_5594_(null, pos, sound, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }

    private static class SearchProgress {
        int currentRadius = 0;
        int currentAngle = 0;
        boolean searchComplete = false;
        List<ItemFrame> foundFrames = new ArrayList<ItemFrame>();

        private SearchProgress() {
        }

        void reset() {
            this.currentRadius = 0;
            this.currentAngle = 0;
            this.searchComplete = false;
            this.foundFrames.clear();
        }
    }

    private static enum ItemFrameEvent {
        ROTATION_CYCLE,
        ITEM_SHAKE,
        ITEM_VANISH_RETURN;

    }

    private static class ItemFrameEventState {
        ItemFrameEvent event;
        Player player;
        ItemFrame itemFrame;
        int tickCount;
        int originalRotation;
        ItemStack originalItem;

        ItemFrameEventState(ItemFrameEvent event, Player player, ItemFrame itemFrame) {
            this.event = event;
            this.player = player;
            this.itemFrame = itemFrame;
            this.tickCount = 0;
            this.originalRotation = itemFrame.m_31823_();
            this.originalItem = itemFrame.m_31822_().m_41777_();
        }
    }
}

