/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mcreator.fromthecaves.configuration.ConfigScreenConfiguration;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.AngerSystemProcedure;
import net.mcreator.fromthecaves.procedures.CrossUseCounterProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MassPossessedBanishProcedure {
    private static final int MAX_DUST = 300;
    private static final int BLIND_SECONDS = 5;
    private static final int CROSS_DURABILITY_LOSS = 10;
    private static final double BASE_BANISH_RANGE = 2.5;
    private static final double IRON_CROSS_BONUS_RANGE = 2.0;
    private static Set<ResourceLocation> cachedExorcizableEntities = null;

    private static Set<ResourceLocation> getExorcizableEntities() {
        if (cachedExorcizableEntities == null) {
            cachedExorcizableEntities = new HashSet<ResourceLocation>();
            String config = (String)ConfigScreenConfiguration.EXORCIZABLE_ENTITIES.get();
            if (config != null && !config.trim().isEmpty()) {
                String[] entries;
                for (String entry : entries = config.split(",")) {
                    if ((entry = entry.trim()).isEmpty()) continue;
                    try {
                        cachedExorcizableEntities.add(new ResourceLocation(entry));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return cachedExorcizableEntities;
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem ev) {
        boolean isIronCross;
        if (ev.getLevel().m_5776_()) {
            return;
        }
        ItemStack stack = ev.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        boolean isWoodenCross = stack.m_41720_() == FromTheCavesModItems.WOODEN_CROSS.get();
        boolean bl = isIronCross = stack.m_41720_() == FromTheCavesModItems.IRON_CROSS.get();
        if (!isWoodenCross && !isIronCross) {
            return;
        }
        Player player = ev.getEntity();
        Level level = ev.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        double banishRange = isIronCross ? 4.5 : 2.5;
        AABB searchBox = player.m_20191_().m_82400_(banishRange);
        List nearbyMobs = level.m_45976_(Mob.class, searchBox);
        for (Mob mob : nearbyMobs) {
            double distance = player.m_20270_((Entity)mob);
            if (!(distance <= banishRange) || !MassPossessedBanishProcedure.attemptBanish(player, mob, stack, ev.getHand(), level, isIronCross)) continue;
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract ev) {
        double banishRange;
        boolean isIronCross;
        if (ev.getLevel().m_5776_()) {
            return;
        }
        ItemStack stack = ev.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        boolean isWoodenCross = stack.m_41720_() == FromTheCavesModItems.WOODEN_CROSS.get();
        boolean bl = isIronCross = stack.m_41720_() == FromTheCavesModItems.IRON_CROSS.get();
        if (!isWoodenCross && !isIronCross) {
            return;
        }
        Entity target = ev.getTarget();
        if (!(target instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)target;
        Player player = ev.getEntity();
        double d = banishRange = isIronCross ? 4.5 : 2.5;
        if ((double)player.m_20270_((Entity)mob) > banishRange) {
            return;
        }
        MassPossessedBanishProcedure.attemptBanish(player, mob, stack, ev.getHand(), ev.getLevel(), isIronCross);
    }

    private static boolean attemptBanish(Player player, Mob mob, ItemStack stack, InteractionHand hand, Level level, boolean isIronCross) {
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null) {
            return false;
        }
        Set<ResourceLocation> customExorcizable = MassPossessedBanishProcedure.getExorcizableEntities();
        if (customExorcizable.contains(key)) {
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel server = (ServerLevel)level;
            BlockPos pos = mob.m_20183_();
            MassPossessedBanishProcedure.spawnBanishEffects(server, pos, isIronCross);
            mob.m_146870_();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
            stack.m_41622_(10, (LivingEntity)player, p -> p.m_21190_(hand));
            CrossUseCounterProcedure.incrementExorcismCounter((LivingEntity)player, level);
            AngerSystemProcedure.onExorcism(server);
            return true;
        }
        if (!"from_the_caves".equals(key.m_135827_())) {
            return false;
        }
        String path = key.m_135815_();
        if (path.startsWith("possessed_") || path.startsWith("Watcher")) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = mob.m_20183_();
        MassPossessedBanishProcedure.spawnBanishEffects(server, pos, isIronCross);
        mob.m_146870_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
        stack.m_41622_(10, (LivingEntity)player, p -> p.m_21190_(hand));
        CrossUseCounterProcedure.incrementExorcismCounter((LivingEntity)player, level);
        AngerSystemProcedure.onExorcism(server);
        return true;
    }

    private static void spawnBanishEffects(ServerLevel level, BlockPos pos, boolean isIronCross) {
        SoundEvent it28;
        Vector3f dustColor = isIronCross ? new Vector3f(0.7f, 0.7f, 0.8f) : new Vector3f(1.0f, 1.0f, 1.0f);
        int particleAmount = isIronCross ? 390 : 300;
        DustParticleOptions dust = new DustParticleOptions(dustColor, isIronCross ? 1.2f : 1.0f);
        level.m_8767_((ParticleOptions)dust, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, particleAmount, isIronCross ? 0.7 : 0.5, isIronCross ? 0.7 : 0.5, isIronCross ? 0.7 : 0.5, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, isIronCross ? 35 : 25, isIronCross ? 0.4 : 0.3, isIronCross ? 0.4 : 0.3, isIronCross ? 0.4 : 0.3, 0.08);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, isIronCross ? 20 : 15, isIronCross ? 0.4 : 0.3, isIronCross ? 0.6 : 0.5, isIronCross ? 0.4 : 0.3, 0.1);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, isIronCross ? 4 : 3, 0.0, 0.0, 0.0, 0.0);
        float volumeMultiplier = isIronCross ? 1.2f : 1.0f;
        float pitchModifier = isIronCross ? 0.9f : 1.0f;
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f * volumeMultiplier, 1.0f * pitchModifier);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.8f * volumeMultiplier, 1.2f * pitchModifier);
        SoundEvent it6 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_6"));
        if (it6 != null) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), it6, SoundSource.HOSTILE, 1.0f * volumeMultiplier, 1.0f * pitchModifier);
        }
        if ((it28 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_28"))) != null) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), it28, SoundSource.HOSTILE, 0.9f * volumeMultiplier, 1.1f * pitchModifier);
        }
        if (isIronCross) {
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11668_, SoundSource.HOSTILE, 0.5f, 1.5f);
        }
    }

    public static void clearCache() {
        cachedExorcizableEntities = null;
    }
}

