/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NoteBlockEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final int CHUNKS_PER_TICK = 3;
    private static final int MAX_SEARCH_RADIUS_CHUNKS = 2;
    private static final int SEARCH_INTERVAL_TICKS = 100;
    private static final int COOLDOWN_TICKS = 200;
    private static final int INTERVAL_TICKS = 6;
    private static final Map<Integer, NoteBlockEventState> activeEvents = new HashMap<Integer, NoteBlockEventState>();
    private static final Map<BlockPos, Long> noteBlockCooldowns = new HashMap<BlockPos, Long>();
    private static final Map<UUID, SearchProgress> searchProgress = new ConcurrentHashMap<UUID, SearchProgress>();
    private static int eventIdCounter = 0;
    private static final int[] CREEPY_MELODY = new int[]{0, 3, 0, 3, 5, 3, 1, 0};
    private static final int[] RHYTHMIC_PATTERN = new int[]{0, 0, 5, 0, 7, 0, 5, 0};

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        SearchProgress progress;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        int currentTick = player.f_19797_;
        if (currentTick % 100 == 0) {
            progress = searchProgress.computeIfAbsent(playerUUID, k -> new SearchProgress());
            progress.reset();
        }
        if ((progress = searchProgress.get(playerUUID)) != null && !progress.searchComplete) {
            NoteBlockEventsProcedure.incrementalSearchChunks(player, server, progress);
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        if (progress == null || progress.foundNoteBlocks.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        ArrayList<BlockPos> noteBlocks = new ArrayList<BlockPos>(progress.foundNoteBlocks);
        noteBlocks.removeIf(pos -> noteBlockCooldowns.containsKey(pos) && currentTime < noteBlockCooldowns.get(pos));
        if (noteBlocks.isEmpty()) {
            return;
        }
        BlockPos chosen = (BlockPos)noteBlocks.get(server.m_213780_().m_188503_(noteBlocks.size()));
        NoteBlockEvent event = NoteBlockEvent.values()[server.m_213780_().m_188503_(NoteBlockEvent.values().length)];
        noteBlockCooldowns.put(chosen, currentTime + 200L);
        NoteBlockEventState st = new NoteBlockEventState(event, player, switch (event) {
            case NoteBlockEvent.CREEPY_MELODY, NoteBlockEvent.RHYTHMIC_PATTERN, NoteBlockEvent.ECHO_EFFECT -> NoteBlockEventsProcedure.pickMelodySequence(server, chosen, noteBlocks);
            case NoteBlockEvent.DISCORDANT_NOTES, NoteBlockEvent.RANDOM_BURST, NoteBlockEvent.GLISSANDO -> Collections.singletonList(chosen);
            case NoteBlockEvent.SYNCHRONIZED_NOTES, NoteBlockEvent.ASCENDING_SCALE, NoteBlockEvent.DESCENDING_SCALE, NoteBlockEvent.HARMONICS -> noteBlocks;
            default -> Collections.singletonList(chosen);
        });
        st.basePitch = event == NoteBlockEvent.DISCORDANT_NOTES ? 0.5 + server.m_213780_().m_188500_() * 1.0 : (event == NoteBlockEvent.GLISSANDO ? 0.5 : 1.0);
        activeEvents.put(eventIdCounter++, st);
    }

    private static void incrementalSearchChunks(Player player, ServerLevel level, SearchProgress progress) {
        BlockPos playerPos = player.m_20183_();
        int playerChunkX = playerPos.m_123341_() >> 4;
        int playerChunkZ = playerPos.m_123343_() >> 4;
        int playerY = playerPos.m_123342_();
        int chunksChecked = 0;
        while (chunksChecked < 3 && progress.currentRadius <= 2) {
            if (progress.currentRadius == 0) {
                NoteBlockEventsProcedure.searchChunkForNoteBlocks(level, playerChunkX, playerChunkZ, playerY, progress.foundNoteBlocks);
                progress.currentRadius = 1;
                progress.currentAngle = 0;
                ++chunksChecked;
                continue;
            }
            int perimeterChunks = progress.currentRadius * 8;
            if (progress.currentAngle >= perimeterChunks) {
                ++progress.currentRadius;
                progress.currentAngle = 0;
                continue;
            }
            int side = progress.currentAngle / (progress.currentRadius * 2);
            int offset = progress.currentAngle % (progress.currentRadius * 2);
            int chunkX = playerChunkX;
            int chunkZ = playerChunkZ;
            switch (side) {
                case 0: {
                    chunkX = playerChunkX - progress.currentRadius + offset;
                    chunkZ = playerChunkZ - progress.currentRadius;
                    break;
                }
                case 1: {
                    chunkX = playerChunkX + progress.currentRadius;
                    chunkZ = playerChunkZ - progress.currentRadius + offset;
                    break;
                }
                case 2: {
                    chunkX = playerChunkX + progress.currentRadius - offset;
                    chunkZ = playerChunkZ + progress.currentRadius;
                    break;
                }
                case 3: {
                    chunkX = playerChunkX - progress.currentRadius;
                    chunkZ = playerChunkZ + progress.currentRadius - offset;
                }
            }
            NoteBlockEventsProcedure.searchChunkForNoteBlocks(level, chunkX, chunkZ, playerY, progress.foundNoteBlocks);
            ++progress.currentAngle;
            ++chunksChecked;
        }
        if (progress.currentRadius > 2) {
            progress.searchComplete = true;
        }
    }

    private static void searchChunkForNoteBlocks(ServerLevel level, int chunkX, int chunkZ, int playerY, List<BlockPos> foundNoteBlocks) {
        if (!level.m_7232_(chunkX, chunkZ)) {
            return;
        }
        LevelChunk chunk = level.m_6325_(chunkX, chunkZ);
        int baseX = chunk.m_7697_().m_45604_();
        int baseZ = chunk.m_7697_().m_45605_();
        int minY = Math.max(level.m_141937_(), playerY - 6);
        int maxY = Math.min(level.m_151558_() - 1, playerY + 6);
        for (int lx = 0; lx < 16; ++lx) {
            for (int lz = 0; lz < 16; ++lz) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                    BlockState state = level.m_8055_(pos);
                    if (!(state.m_60734_() instanceof NoteBlock)) continue;
                    foundNoteBlocks.add(pos.m_7949_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, NoteBlockEventState>> iterator = activeEvents.entrySet().iterator();
        SoundEvent noteSound = NoteBlockEventsProcedure.getSoundEvent(new ResourceLocation("minecraft", "block.note_block.pling"));
        block12: while (iterator.hasNext()) {
            Map.Entry<Integer, NoteBlockEventState> entry = iterator.next();
            NoteBlockEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case CREEPY_MELODY: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block12;
                    if (state.melodyCursor >= CREEPY_MELODY.length) {
                        iterator.remove();
                        break;
                    }
                    int note = CREEPY_MELODY[state.melodyCursor];
                    double pitch = Math.pow(2.0, (double)note / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.9f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.melodyCursor;
                    break;
                }
                case DISCORDANT_NOTES: {
                    if (state.tickCount % 6 != 0) continue block12;
                    for (BlockPos pos : state.noteBlockPositions) {
                        BlockState s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        double pitch = 0.5 + server.m_213780_().m_188500_() * 1.0;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.9f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    if (state.tickCount < 72) continue block12;
                    iterator.remove();
                    break;
                }
                case SYNCHRONIZED_NOTES: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block12;
                    int note = server.m_213780_().m_188503_(25);
                    double pitch = Math.pow(2.0, (double)note / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.85f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    if (state.tickCount < 60) continue block12;
                    iterator.remove();
                    break;
                }
                case ASCENDING_SCALE: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block12;
                    if (state.melodyCursor >= 13) {
                        iterator.remove();
                        break;
                    }
                    double pitch = Math.pow(2.0, (double)state.melodyCursor / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.8f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.melodyCursor;
                    break;
                }
                case DESCENDING_SCALE: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block12;
                    if (state.melodyCursor >= 13) {
                        iterator.remove();
                        break;
                    }
                    double pitch = Math.pow(2.0, (double)(12 - state.melodyCursor) / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.8f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.melodyCursor;
                    break;
                }
                case RANDOM_BURST: {
                    if (state.tickCount % 2 != 0) continue block12;
                    for (BlockPos pos : state.noteBlockPositions) {
                        BlockState s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        int note = server.m_213780_().m_188503_(25);
                        double pitch = Math.pow(2.0, (double)note / 12.0);
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.7f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 2, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.burstCount;
                    if (state.burstCount < 20) continue block12;
                    iterator.remove();
                    break;
                }
                case ECHO_EFFECT: {
                    if (state.tickCount % 6 == 0 && state.melodyCursor < state.noteBlockPositions.size()) {
                        BlockPos pos = state.noteBlockPositions.get(state.melodyCursor);
                        BlockState s = server.m_8055_(pos);
                        if (s.m_60734_() instanceof NoteBlock) {
                            int note = 5 + server.m_213780_().m_188503_(8);
                            double pitch = Math.pow(2.0, (double)note / 12.0);
                            if (noteSound != null) {
                                server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.9f, (float)pitch);
                            }
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                            state.echoQueue.add(pitch);
                            state.echoPositions.add(pos);
                        }
                        ++state.melodyCursor;
                    }
                    if (state.tickCount % 12 == 6 && !state.echoQueue.isEmpty()) {
                        double echoPitch = state.echoQueue.remove(0);
                        BlockPos echoPos = state.echoPositions.remove(0);
                        BlockState s = server.m_8055_(echoPos);
                        if (s.m_60734_() instanceof NoteBlock) {
                            if (noteSound != null) {
                                server.m_5594_(null, echoPos, noteSound, SoundSource.BLOCKS, 0.5f, (float)echoPitch);
                            }
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)echoPos.m_123341_() + 0.5, (double)echoPos.m_123342_() + 1.2, (double)echoPos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                        }
                    }
                    if (state.tickCount < 180) continue block12;
                    iterator.remove();
                    break;
                }
                case RHYTHMIC_PATTERN: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block12;
                    if (state.melodyCursor >= RHYTHMIC_PATTERN.length) {
                        iterator.remove();
                        break;
                    }
                    int note = RHYTHMIC_PATTERN[state.melodyCursor];
                    double pitch = Math.pow(2.0, (double)note / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.95f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.melodyCursor;
                    break;
                }
                case HARMONICS: {
                    BlockState s;
                    if (state.tickCount % 12 != 0) continue block12;
                    int baseNote = 7;
                    int[] harmonics = new int[]{baseNote, baseNote + 7, baseNote + 12};
                    for (int i = 0; i < Math.min(state.noteBlockPositions.size(), harmonics.length); ++i) {
                        BlockPos pos = state.noteBlockPositions.get(i);
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        double pitch = Math.pow(2.0, (double)harmonics[i] / 12.0);
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.75f, (float)pitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    ++state.melodyCursor;
                    if (state.melodyCursor < 8) continue block12;
                    iterator.remove();
                    break;
                }
                case GLISSANDO: {
                    if (state.tickCount % 3 != 0) continue block12;
                    for (BlockPos pos : state.noteBlockPositions) {
                        BlockState s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        if (noteSound != null) {
                            server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.8f, (float)state.basePitch);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 1, 0.5, 0.0, 0.5, 0.0);
                    }
                    state.basePitch += 0.05;
                    if (!(state.basePitch >= 2.0)) continue block12;
                    iterator.remove();
                    break;
                }
                default: {
                    iterator.remove();
                }
            }
        }
    }

    private static SoundEvent getSoundEvent(ResourceLocation location) {
        Object obj = ForgeRegistries.SOUND_EVENTS.getValue(location);
        if (obj instanceof SoundEvent) {
            return (SoundEvent)obj;
        }
        if (obj instanceof Holder) {
            return (SoundEvent)((Holder)obj).m_203334_();
        }
        return null;
    }

    private static List<BlockPos> pickMelodySequence(ServerLevel server, BlockPos origin, List<BlockPos> allBlocks) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        res.add(origin.m_7949_());
        for (BlockPos candidate : allBlocks) {
            if (res.contains(candidate) || res.size() >= 5) continue;
            res.add(candidate.m_7949_());
        }
        return res;
    }

    private static class SearchProgress {
        int currentRadius = 0;
        int currentAngle = 0;
        boolean searchComplete = false;
        List<BlockPos> foundNoteBlocks = new ArrayList<BlockPos>();

        private SearchProgress() {
        }

        void reset() {
            this.currentRadius = 0;
            this.currentAngle = 0;
            this.searchComplete = false;
            this.foundNoteBlocks.clear();
        }
    }

    private static enum NoteBlockEvent {
        CREEPY_MELODY,
        DISCORDANT_NOTES,
        SYNCHRONIZED_NOTES,
        ASCENDING_SCALE,
        DESCENDING_SCALE,
        RANDOM_BURST,
        ECHO_EFFECT,
        RHYTHMIC_PATTERN,
        HARMONICS,
        GLISSANDO;

    }

    private static class NoteBlockEventState {
        NoteBlockEvent event;
        Player player;
        List<BlockPos> noteBlockPositions;
        int tickCount;
        int melodyCursor;
        double basePitch;
        int burstCount;
        List<Double> echoQueue;
        List<BlockPos> echoPositions;

        NoteBlockEventState(NoteBlockEvent event, Player player, List<BlockPos> noteBlockPositions) {
            this.event = event;
            this.player = player;
            this.noteBlockPositions = noteBlockPositions;
            this.tickCount = 0;
            this.melodyCursor = 0;
            this.basePitch = 1.0;
            this.burstCount = 0;
            this.echoQueue = new ArrayList<Double>();
            this.echoPositions = new ArrayList<BlockPos>();
        }
    }
}

