/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OutsideWatcherProcedure {
    private static final double BASE_PROB = 5.0E-5;
    private static final double MAX_PROB = 9.0E-5;
    private static final double MIN_SPAWN_DIST = 18.0;
    private static final double MAX_SPAWN_DIST = 64.0;
    private static final double FLEE_DISTANCE = 12.0;
    private static final double PLAYER_FOV = 30.0;
    private static final double APPROACH_DISTANCE = 32.0;
    private static final double ESCAPE_DELTA_SPEED = 0.8;
    private static final double APPROACH_DELTA_SPEED = 0.5;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player.m_20186_() <= 55.0) {
            return;
        }
        if (!OutsideWatcherProcedure.isOutside(server, player.m_20183_())) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 5.0E-5, 9.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos spawnPos = OutsideWatcherProcedure.findValidSpawnPosition(server, player);
        if (spawnPos == null) {
            return;
        }
        Mob watcher = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)server);
        if (watcher == null) {
            return;
        }
        watcher.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        watcher.m_21530_();
        watcher.m_21557_(false);
        watcher.m_20225_(true);
        watcher.m_20242_(false);
        watcher.f_19794_ = false;
        CompoundTag nbt = watcher.getPersistentData();
        nbt.m_128379_("isOutsideWatcher", true);
        nbt.m_128379_("isEscaping", false);
        nbt.m_128356_("spawnTick", server.m_46467_());
        nbt.m_128356_("lastActionTick", server.m_46467_());
        server.m_7967_((Entity)watcher);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isOutsideWatcher")) {
            return;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        OutsideWatcherProcedure.handleWatcherBehavior(mob, server);
    }

    private static void handleWatcherBehavior(Mob watcher, ServerLevel server) {
        CompoundTag nbt;
        Player nearestPlayer = server.m_45930_((Entity)watcher, 100.0);
        if (nearestPlayer == null) {
            watcher.m_146870_();
            return;
        }
        long now = server.m_46467_();
        if (now - (nbt = watcher.getPersistentData()).m_128454_("spawnTick") > 12000L) {
            watcher.m_146870_();
            return;
        }
        double distToPlayer = watcher.m_20270_((Entity)nearestPlayer);
        if (distToPlayer > 80.0) {
            watcher.m_146870_();
            return;
        }
        OutsideWatcherProcedure.lookAtPlayer(watcher, nearestPlayer);
        boolean isPlayerLooking = OutsideWatcherProcedure.isPlayerLookingAt(nearestPlayer, watcher);
        boolean isPlayerTooClose = distToPlayer < 12.0;
        boolean isPlayerTooFar = distToPlayer > 32.0;
        long lastAction = nbt.m_128454_("lastActionTick");
        boolean canPlayerSee = OutsideWatcherProcedure.canPlayerSeeMob(nearestPlayer, watcher, server);
        if (isPlayerLooking || isPlayerTooClose) {
            watcher.m_20242_(true);
            watcher.f_19794_ = true;
            OutsideWatcherProcedure.escapeWithDelta(watcher, nearestPlayer);
            nbt.m_128379_("isEscaping", true);
            nbt.m_128356_("lastActionTick", now);
        } else if (isPlayerTooFar) {
            if (canPlayerSee) {
                watcher.m_20242_(true);
                watcher.f_19794_ = true;
                OutsideWatcherProcedure.approachPlayerWithDelta(watcher, nearestPlayer);
                nbt.m_128379_("isEscaping", false);
                nbt.m_128356_("lastActionTick", now);
            } else {
                if (nbt.m_128471_("isEscaping")) {
                    watcher.m_146870_();
                    return;
                }
                watcher.m_20242_(false);
                watcher.f_19794_ = false;
            }
        } else {
            if (nbt.m_128471_("isEscaping") && !canPlayerSee) {
                watcher.m_146870_();
                return;
            }
            if (!nbt.m_128471_("isEscaping")) {
                watcher.m_20242_(false);
                watcher.f_19794_ = false;
                watcher.m_20334_(0.0, 0.0, 0.0);
            }
        }
        if (now - lastAction > 40L) {
            nbt.m_128356_("lastActionTick", now);
        }
    }

    private static void escapeWithDelta(Mob watcher, Player player) {
        Vec3 awayFromPlayer = watcher.m_20182_().m_82546_(player.m_20182_()).m_82541_();
        awayFromPlayer = awayFromPlayer.m_82520_(0.0, (Math.random() - 0.5) * 0.3, 0.0).m_82541_();
        Vec3 deltaMovement = awayFromPlayer.m_82490_(0.8);
        watcher.m_20256_(deltaMovement);
        watcher.m_6034_(watcher.m_20185_() + watcher.m_20184_().f_82479_, watcher.m_20186_() + watcher.m_20184_().f_82480_, watcher.m_20189_() + watcher.m_20184_().f_82481_);
    }

    private static void approachPlayerWithDelta(Mob watcher, Player player) {
        Vec3 toPlayer = player.m_20182_().m_82546_(watcher.m_20182_()).m_82541_();
        double desiredDistance = 32.0;
        double currentDistance = watcher.m_20270_((Entity)player);
        if (Math.abs(currentDistance - desiredDistance) < 2.0) {
            watcher.m_20334_(0.0, 0.0, 0.0);
            return;
        }
        Vec3 playerPos = player.m_20182_();
        Vec3 watcherPos = watcher.m_20182_();
        Vec3 directionFromPlayer = watcherPos.m_82546_(playerPos).m_82541_();
        Vec3 targetPos = playerPos.m_82549_(directionFromPlayer.m_82490_(desiredDistance));
        Vec3 toTarget = targetPos.m_82546_(watcherPos).m_82541_();
        toTarget = toTarget.m_82520_(0.0, (Math.random() - 0.5) * 0.2, 0.0).m_82541_();
        Vec3 deltaMovement = toTarget.m_82490_(0.5);
        double distanceToTarget = watcherPos.m_82554_(targetPos);
        if (distanceToTarget < 5.0) {
            deltaMovement = deltaMovement.m_82490_(distanceToTarget / 5.0);
        }
        watcher.m_20256_(deltaMovement);
        watcher.m_6034_(watcher.m_20185_() + watcher.m_20184_().f_82479_, watcher.m_20186_() + watcher.m_20184_().f_82480_, watcher.m_20189_() + watcher.m_20184_().f_82481_);
    }

    private static boolean isPlayerLookingAt(Player player, Mob mob) {
        Vec3 toMob;
        Vec3 playerLook = player.m_20154_().m_82541_();
        double dotProduct = playerLook.m_82526_(toMob = mob.m_20182_().m_82546_(player.m_146892_()).m_82541_());
        double angleInDegrees = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct))));
        return angleInDegrees <= 30.0;
    }

    private static boolean canPlayerSeeMob(Player player, Mob mob, ServerLevel level) {
        AABB mobBox = mob.m_20191_();
        Vec3 playerEye = player.m_146892_();
        Vec3 playerLook = player.m_20154_().m_82541_();
        Vec3[] checkPoints = new Vec3[]{new Vec3(mobBox.f_82288_, mobBox.f_82289_, mobBox.f_82290_), new Vec3(mobBox.f_82291_, mobBox.f_82289_, mobBox.f_82290_), new Vec3(mobBox.f_82288_, mobBox.f_82292_, mobBox.f_82290_), new Vec3(mobBox.f_82291_, mobBox.f_82292_, mobBox.f_82290_), new Vec3(mobBox.f_82288_, mobBox.f_82289_, mobBox.f_82293_), new Vec3(mobBox.f_82291_, mobBox.f_82289_, mobBox.f_82293_), new Vec3(mobBox.f_82288_, mobBox.f_82292_, mobBox.f_82293_), new Vec3(mobBox.f_82291_, mobBox.f_82292_, mobBox.f_82293_), mob.m_20182_().m_82520_(0.0, (double)(mob.m_20206_() / 2.0f), 0.0)};
        boolean anyPointVisible = false;
        for (Vec3 point : checkPoints) {
            Vec3 toPoint = point.m_82546_(playerEye).m_82541_();
            double dotProduct = playerLook.m_82526_(toPoint);
            double angleInDegrees = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct))));
            if (!(angleInDegrees <= 90.0) || OutsideWatcherProcedure.isBlockedByTerrain(playerEye, point, level)) continue;
            anyPointVisible = true;
            break;
        }
        return anyPointVisible;
    }

    private static boolean isBlockedByTerrain(Vec3 start, Vec3 end, ServerLevel level) {
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        Vec3 normalized = direction.m_82541_();
        int steps = (int)(distance / 0.5);
        for (int i = 1; i < steps; ++i) {
            Vec3 checkPoint = start.m_82549_(normalized.m_82490_((double)i * 0.5));
            BlockPos pos = new BlockPos((int)checkPoint.f_82479_, (int)checkPoint.f_82480_, (int)checkPoint.f_82481_);
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_() || !state.m_60815_()) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, Player player) {
        Vec3 playerPos = player.m_20182_();
        for (int attempt = 0; attempt < 30; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double distance = 18.0 + Math.random() * 46.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            int spawnX = (int)Math.floor(playerPos.f_82479_ + offsetX);
            int spawnZ = (int)Math.floor(playerPos.f_82481_ + offsetZ);
            int playerY = (int)playerPos.f_82480_;
            for (int yOffset = -10; yOffset <= 10; ++yOffset) {
                BlockPos pos;
                int checkY = playerY + yOffset;
                if (checkY < level.m_141937_() || checkY > level.m_151558_() - 2 || !OutsideWatcherProcedure.isValidSpawnLocation(level, pos = new BlockPos(spawnX, checkY, spawnZ)) || !OutsideWatcherProcedure.isOutside(level, pos)) continue;
                return pos;
            }
        }
        return null;
    }

    private static boolean isValidSpawnLocation(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return OutsideWatcherProcedure.isSolidGround(below) && OutsideWatcherProcedure.isPassable(at) && OutsideWatcherProcedure.isPassable(above);
    }

    private static boolean isPassable(BlockState state) {
        return state.m_60795_() || !state.m_60815_();
    }

    private static boolean isSolidGround(BlockState state) {
        return !state.m_60795_() && state.m_60815_();
    }

    private static boolean isOutside(ServerLevel level, BlockPos pos) {
        for (int yOffset = 1; yOffset <= 10; ++yOffset) {
            BlockPos checkPos = pos.m_6630_(yOffset);
            BlockState state = level.m_8055_(checkPos);
            if (state.m_60795_() || !state.m_60815_()) continue;
            return false;
        }
        int skyLight = level.m_45517_(LightLayer.SKY, pos);
        return skyLight > 10;
    }

    private static void lookAtPlayer(Mob mob, Player target) {
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        if (toPlayer.m_82556_() > 1.0E-6) {
            Vec3 toPlayerNorm = toPlayer.m_82541_();
            float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
    }
}

