/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PaintingEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final int SCAN_RADIUS = 24;
    private static final Map<Integer, PaintingEventState> activeEvents = new HashMap<Integer, PaintingEventState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (Math.random() >= dynamicProb) {
            return;
        }
        List<Painting> validPaintings = PaintingEventsProcedure.findValidPaintings(server, player);
        if (validPaintings.isEmpty()) {
            return;
        }
        Painting chosen = validPaintings.get(server.m_213780_().m_188503_(validPaintings.size()));
        PaintingEvent event = PaintingEvent.values()[server.m_213780_().m_188503_(PaintingEvent.values().length)];
        activeEvents.put(eventIdCounter++, new PaintingEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, PaintingEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PaintingEventState> entry = iterator.next();
            PaintingEventState state = entry.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case VARIANT_CHANGE: {
                    PaintingEventsProcedure.handleVariantChange(server, state);
                    if (state.tickCount < 200) break;
                    PaintingEventsProcedure.restoreOriginalPainting(server, state);
                    iterator.remove();
                    break;
                }
                case DROP_PAINTING: {
                    PaintingEventsProcedure.handleDropPainting(server, state);
                    if (state.tickCount < 200) break;
                    iterator.remove();
                    break;
                }
                case BLEEDING: {
                    PaintingEventsProcedure.handleBleeding(server, state);
                    if (state.tickCount < 200) break;
                    iterator.remove();
                    break;
                }
                case SHAKE: {
                    PaintingEventsProcedure.handleShake(server, state);
                    if (state.tickCount < 200) break;
                    PaintingEventsProcedure.restorePaintingPosition(server, state);
                    iterator.remove();
                    break;
                }
                case DISAPPEAR_REAPPEAR: {
                    PaintingEventsProcedure.handleDisappearReappear(server, state);
                    if (state.tickCount < 200) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<Painting> findValidPaintings(ServerLevel server, Player player) {
        ArrayList<Painting> paintings = new ArrayList<Painting>();
        for (Entity entity : server.m_8583_()) {
            if (!(entity instanceof Painting)) continue;
            Painting painting = (Painting)entity;
            if (!(entity.m_20280_((Entity)player) <= 576.0)) continue;
            paintings.add(painting);
        }
        return paintings;
    }

    private static void handleVariantChange(ServerLevel server, PaintingEventState state) {
        ArrayList<Holder.Reference> allVariants;
        if (state.tickCount == 1 && state.painting.m_6084_() && !(allVariants = new ArrayList<Holder.Reference>(BuiltInRegistries.f_257051_.m_203611_().map(h -> h).toList())).isEmpty()) {
            Holder randomVariant = (Holder)allVariants.get(server.m_213780_().m_188503_(allVariants.size()));
            state.painting.m_28464_(randomVariant);
            if (state.player.m_20280_((Entity)state.painting) <= 36.0) {
                server.m_5594_(null, state.painting.m_20183_(), SoundEvents.f_12176_, SoundSource.BLOCKS, 0.5f, 0.8f);
            }
        }
    }

    private static void handleDropPainting(ServerLevel server, PaintingEventState state) {
        if (state.tickCount == 1 && state.painting.m_6084_()) {
            BlockPos pos = state.painting.m_20183_();
            if (state.player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 36.0) {
                server.m_5594_(null, pos, SoundEvents.f_12175_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            state.painting.m_6842_(true);
        } else if (state.tickCount == 200) {
            if (state.painting.m_6084_()) {
                state.painting.m_6842_(false);
                state.painting.m_20258_(state.originalNBT);
                if (state.player.m_20275_((double)state.originalPos.m_123341_(), (double)state.originalPos.m_123342_(), (double)state.originalPos.m_123343_()) <= 36.0) {
                    server.m_5594_(null, state.originalPos, SoundEvents.f_12176_, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else {
                Painting newPainting = (Painting)EntityType.f_20506_.m_20615_((Level)server);
                if (newPainting != null) {
                    newPainting.m_20258_(state.originalNBT);
                    server.m_7967_((Entity)newPainting);
                    if (state.player.m_20275_((double)state.originalPos.m_123341_(), (double)state.originalPos.m_123342_(), (double)state.originalPos.m_123343_()) <= 36.0) {
                        server.m_5594_(null, state.originalPos, SoundEvents.f_12176_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    private static void handleBleeding(ServerLevel server, PaintingEventState state) {
        if (!state.painting.m_6084_()) {
            return;
        }
        if (state.tickCount == 1 && state.player.m_20280_((Entity)state.painting) <= 36.0) {
            server.m_5594_(null, state.painting.m_20183_(), SoundEvents.f_11968_, SoundSource.BLOCKS, 0.7f, 0.5f);
        }
        if (state.tickCount <= 200 && state.tickCount % 3 == 0) {
            BlockPos pos = state.painting.m_20183_();
            Direction dir = state.painting.m_6350_();
            double offsetX = (double)pos.m_123341_() + 0.5 + (double)dir.m_122429_() * -0.1;
            double offsetY = (double)pos.m_123342_() + 0.3 + server.m_213780_().m_188500_() * 0.4;
            double offsetZ = (double)pos.m_123343_() + 0.5 + (double)dir.m_122431_() * -0.1;
            DustParticleOptions darkRedDust = new DustParticleOptions(new Vector3f(0.4f, 0.0f, 0.0f), 1.0f);
            server.m_8767_((ParticleOptions)darkRedDust, offsetX, offsetY, offsetZ, 2, 0.1, 0.0, 0.1, 0.0);
        }
    }

    private static void handleShake(ServerLevel server, PaintingEventState state) {
        if (!state.painting.m_6084_()) {
            return;
        }
        if (state.tickCount == 1 && state.player.m_20280_((Entity)state.painting) <= 36.0) {
            server.m_5594_(null, state.painting.m_20183_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.4f, 1.2f);
        }
        if (state.tickCount <= 60 && state.tickCount % 2 == 0) {
            double originalX = state.originalNBT.m_128437_("Pos", 6).m_128772_(0);
            double originalY = state.originalNBT.m_128437_("Pos", 6).m_128772_(1);
            double originalZ = state.originalNBT.m_128437_("Pos", 6).m_128772_(2);
            double offsetX = (server.m_213780_().m_188500_() - 0.5) * 0.15;
            double offsetY = (server.m_213780_().m_188500_() - 0.5) * 0.15;
            double offsetZ = (server.m_213780_().m_188500_() - 0.5) * 0.15;
            state.painting.m_7678_(originalX + offsetX, originalY + offsetY, originalZ + offsetZ, state.painting.m_146908_(), 0.0f);
        }
    }

    private static void handleDisappearReappear(ServerLevel server, PaintingEventState state) {
        if (state.tickCount == 1 && state.painting.m_6084_()) {
            BlockPos pos = state.painting.m_20183_();
            if (state.player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 36.0) {
                server.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
            for (int i = 0; i < 15; ++i) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.3, 0.3, 0.3, 0.02);
            }
            state.painting.m_6842_(true);
        } else if (state.tickCount == 60) {
            state.painting.m_6842_(false);
            BlockPos pos = state.painting.m_20183_();
            if (state.player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 36.0) {
                server.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.5f, 1.5f);
            }
            for (int i = 0; i < 15; ++i) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.3, 0.3, 0.3, 0.02);
            }
        }
    }

    private static void restoreOriginalPainting(ServerLevel server, PaintingEventState state) {
        if (state.painting.m_6084_()) {
            state.painting.m_20258_(state.originalNBT);
        }
    }

    private static void restorePaintingPosition(ServerLevel server, PaintingEventState state) {
        if (state.painting.m_6084_()) {
            state.painting.m_20258_(state.originalNBT);
        }
    }

    private static enum PaintingEvent {
        VARIANT_CHANGE,
        DROP_PAINTING,
        BLEEDING,
        SHAKE,
        DISAPPEAR_REAPPEAR;

    }

    private static class PaintingEventState {
        PaintingEvent event;
        Player player;
        Painting painting;
        int tickCount;
        CompoundTag originalNBT;
        BlockPos originalPos;

        PaintingEventState(PaintingEvent event, Player player, Painting painting) {
            this.event = event;
            this.player = player;
            this.painting = painting;
            this.tickCount = 0;
            this.originalNBT = new CompoundTag();
            painting.m_20240_(this.originalNBT);
            this.originalPos = painting.m_20183_();
        }
    }
}

