/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ParrotsEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 4.0E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 5.0E-5;
    private static final double MAX_PROB_PHASE2 = 5.5E-5;
    private static final int SCAN_RADIUS = 24;
    private static final int DURATION_TICKS = 140;
    private static final int MIN_DELAY_TICKS = 200;
    private static final int MAX_DELAY_TICKS = 600;
    private static final Map<Integer, ParrotState> active = new HashMap<Integer, ParrotState>();
    private static int counter = 0;
    private static final ResourceLocation[] PARROT_IT_SOUNDS = new ResourceLocation[]{new ResourceLocation("from_the_caves", "it_13"), new ResourceLocation("from_the_caves", "it_14"), new ResourceLocation("from_the_caves", "it_15"), new ResourceLocation("from_the_caves", "it_16"), new ResourceLocation("from_the_caves", "it_18"), new ResourceLocation("from_the_caves", "it_19"), new ResourceLocation("from_the_caves", "it_20"), new ResourceLocation("from_the_caves", "it_21"), new ResourceLocation("from_the_caves", "it_22"), new ResourceLocation("from_the_caves", "it_23"), new ResourceLocation("from_the_caves", "it_24"), new ResourceLocation("from_the_caves", "it_25"), new ResourceLocation("from_the_caves", "it_26"), new ResourceLocation("from_the_caves", "it_27"), new ResourceLocation("from_the_caves", "it_28")};

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 4.0E-5 : 5.0E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<Entity> parrots = ParrotsEventsProcedure.findParrots(server, player);
        if (parrots.isEmpty()) {
            return;
        }
        active.put(counter++, new ParrotState(ParrotEvent.MIMIC_SEQUENCE, player, parrots));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ParrotState>> it = active.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ParrotState> entry = it.next();
            ParrotState s = entry.getValue();
            if (!(s.player.m_9236_() instanceof ServerLevel)) {
                it.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)s.player.m_9236_();
            ++s.tickCount;
            long now = server.m_46467_();
            if (now >= s.nextSoundTick) {
                for (UUID id : new ArrayList<UUID>(s.parrots)) {
                    Entity en = ParrotsEventsProcedure.findEntityByUUID(server, s.player, id, 24.0);
                    if (en == null || en.m_213877_() || en.m_6095_() != EntityType.f_20508_) continue;
                    Parrot p = (Parrot)en;
                    ResourceLocation rl = PARROT_IT_SOUNDS[server.m_213780_().m_188503_(PARROT_IT_SOUNDS.length)];
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
                    if (sound == null) continue;
                    server.m_5594_(null, p.m_20183_(), sound, SoundSource.NEUTRAL, 0.3f, 1.6f);
                }
                int delay = 200 + server.m_213780_().m_188503_(401);
                s.nextSoundTick = now + (long)delay;
            }
            if (s.tickCount < 140) continue;
            it.remove();
        }
    }

    private static List<Entity> findParrots(ServerLevel server, Player player) {
        AABB box = player.m_20191_().m_82400_(24.0);
        return server.m_6443_(Entity.class, box, e -> e.m_6095_() == EntityType.f_20508_);
    }

    private static Entity findEntityByUUID(ServerLevel server, Player player, UUID id, double radius) {
        AABB box = player.m_20191_().m_82400_(radius);
        for (Entity en : server.m_6443_(Entity.class, box, e -> true)) {
            if (!en.m_20148_().equals(id)) continue;
            return en;
        }
        return null;
    }

    private static class ParrotState {
        ParrotEvent event;
        Player player;
        List<UUID> parrots;
        int tickCount;
        long nextSoundTick;

        ParrotState(ParrotEvent event, Player player, List<Entity> parrots) {
            this.event = event;
            this.player = player;
            this.parrots = new ArrayList<UUID>();
            for (Entity e : parrots) {
                this.parrots.add(e.m_20148_());
            }
            this.tickCount = 0;
            this.nextSoundTick = 0L;
        }
    }

    private static enum ParrotEvent {
        MIMIC_SEQUENCE;

    }
}

