/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class PetDeathSoundsProcedure {
    private static final double BASE_PROB = 7.0E-4;
    private static final double MAX_PROB = 0.001;
    private static final Map<UUID, PetGhostData> playerGhostData = new HashMap<UUID, PetGhostData>();
    private static final Map<UUID, Integer> finalSoundTimers = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof TamableAnimal)) {
            return;
        }
        TamableAnimal tamable = (TamableAnimal)livingEntity;
        if (!tamable.m_21824_() || tamable.m_269323_() == null) {
            return;
        }
        LivingEntity livingEntity2 = tamable.m_269323_();
        if (!(livingEntity2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity2;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 0 && phase != 1 && phase != 2) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        String petType = PetDeathSoundsProcedure.getPetType((Entity)event.getEntity());
        if (petType == null) {
            return;
        }
        PetGhostData ghostData = playerGhostData.get(playerUUID);
        if (ghostData != null && ghostData.soundCount >= 3) {
            playerGhostData.remove(playerUUID);
            finalSoundTimers.remove(playerUUID);
        }
        playerGhostData.put(playerUUID, new PetGhostData(petType));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        double dynamicProb;
        int phase;
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = ev.player;
        if (p == null || p.m_9236_().m_5776_()) {
            return;
        }
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)p;
        Level level = serverPlayer.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        UUID playerUUID = serverPlayer.m_20148_();
        if (finalSoundTimers.containsKey(playerUUID)) {
            int timer = finalSoundTimers.get(playerUUID);
            if (--timer <= 0) {
                finalSoundTimers.remove(playerUUID);
                SoundEvent finalSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves:it_21"));
                if (finalSound != null) {
                    BlockPos playerPos = serverPlayer.m_20183_();
                    double offsetX = (Math.random() - 0.5) * 10.0;
                    double offsetZ = (Math.random() - 0.5) * 10.0;
                    server.m_6263_(null, (double)playerPos.m_123341_() + offsetX, (double)playerPos.m_123342_(), (double)playerPos.m_123343_() + offsetZ, finalSound, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
            } else {
                finalSoundTimers.put(playerUUID, timer);
            }
        }
        if ((phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server)) != 0 && phase != 1 && phase != 2) {
            return;
        }
        PetGhostData ghostData = playerGhostData.get(playerUUID);
        if (ghostData == null) {
            return;
        }
        if (ghostData.soundCount >= 3) {
            playerGhostData.remove(playerUUID);
            return;
        }
        try {
            dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)serverPlayer, 7.0E-4, 0.001);
        }
        catch (Throwable t) {
            dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)serverPlayer);
        }
        if (Math.random() >= dynamicProb) {
            return;
        }
        SoundEvent sound = PetDeathSoundsProcedure.getPetSound(ghostData.petType);
        if (sound == null) {
            return;
        }
        BlockPos playerPos = serverPlayer.m_20183_();
        double offsetX = (Math.random() - 0.5) * 10.0;
        double offsetZ = (Math.random() - 0.5) * 10.0;
        server.m_6263_(null, (double)playerPos.m_123341_() + offsetX, (double)playerPos.m_123342_(), (double)playerPos.m_123343_() + offsetZ, sound, SoundSource.AMBIENT, 0.8f, 0.9f + (float)(Math.random() * 0.2));
        ++ghostData.soundCount;
        if (ghostData.soundCount >= 3) {
            finalSoundTimers.put(playerUUID, 40);
        }
    }

    private static String getPetType(Entity entity) {
        if (entity instanceof Wolf) {
            return "wolf";
        }
        if (entity instanceof Cat) {
            return "cat";
        }
        if (entity instanceof Parrot) {
            return "parrot";
        }
        if (entity instanceof Horse) {
            return "horse";
        }
        if (entity instanceof Llama) {
            return "llama";
        }
        return null;
    }

    private static SoundEvent getPetSound(String petType) {
        switch (petType) {
            case "wolf": {
                return SoundEvents.f_12625_;
            }
            case "cat": {
                return SoundEvents.f_11785_;
            }
            case "parrot": {
                return SoundEvents.f_12188_;
            }
            case "horse": {
                return SoundEvents.f_11971_;
            }
            case "llama": {
                return SoundEvents.f_12092_;
            }
        }
        return null;
    }

    private static class PetGhostData {
        String petType;
        int soundCount;

        PetGhostData(String type) {
            this.petType = type;
            this.soundCount = 0;
        }
    }
}

