/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Phase1DoorWatcherProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 7.0E-5;
    private static final double MIN_DIST = 5.0;
    private static final double MAX_DIST = 20.0;
    private static final double DETECTION_RANGE = 40.0;
    private static final double ACTIVATION_DISTANCE = 2.3;
    private static final double ESCAPE_SPEED = 0.8;
    private static final double ESCAPE_DOWNWARD_SPEED = 0.3;
    private static final int ESCAPE_DURATION_TICKS = 100;
    private static final int MAX_SPAWN_ATTEMPTS = 15;
    private static final int MAX_LIGHT_LEVEL = 13;
    private static final int DESPAWN_TIME_TICKS = 600;
    private static final String KEY_SPAWN_TIME = "doorwatcher_spawnTime";
    private static final String KEY_ACTIVATED = "doorwatcher_activated";
    private static final String KEY_ACTIVATION_TIME = "doorwatcher_activationTime";
    private static final String KEY_DOOR_POS = "doorwatcher_doorPos";
    private static final String KEY_INITIAL_POS_X = "doorwatcher_initialPosX";
    private static final String KEY_INITIAL_POS_Y = "doorwatcher_initialPosY";
    private static final String KEY_INITIAL_POS_Z = "doorwatcher_initialPosZ";
    private static final String KEY_ESCAPE_DIR_X = "doorwatcher_escapeDirX";
    private static final String KEY_ESCAPE_DIR_Y = "doorwatcher_escapeDirY";
    private static final String KEY_ESCAPE_DIR_Z = "doorwatcher_escapeDirZ";
    private static final String KEY_DOOR_FACING_X = "doorwatcher_doorFacingX";
    private static final String KEY_DOOR_FACING_Z = "doorwatcher_doorFacingZ";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 4.0E-5, 7.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        EntityType<?> chosenEntity = Phase1DoorWatcherProcedure.chooseRandomDoorEntity();
        DoorSpawnResult spawnResult = Phase1DoorWatcherProcedure.findDoorSpawnPosition(level, player);
        if (spawnResult == null) {
            return;
        }
        Mob mob = (Mob)chosenEntity.m_262496_(level, spawnResult.spawnPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        mob.f_19794_ = false;
        Phase1DoorWatcherProcedure.makeEntityLookAtPlayer(mob, player);
        CompoundTag data = mob.getPersistentData();
        data.m_128379_("phase1doorwatcher_mob", true);
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_ACTIVATED, false);
        data.m_128385_(KEY_DOOR_POS, new int[]{spawnResult.doorPos.m_123341_(), spawnResult.doorPos.m_123342_(), spawnResult.doorPos.m_123343_()});
        data.m_128347_(KEY_INITIAL_POS_X, mob.m_20185_());
        data.m_128347_(KEY_INITIAL_POS_Y, mob.m_20186_());
        data.m_128347_(KEY_INITIAL_POS_Z, mob.m_20189_());
        data.m_128405_(KEY_DOOR_FACING_X, spawnResult.doorFacing.m_122436_().m_123341_());
        data.m_128405_(KEY_DOOR_FACING_Z, spawnResult.doorFacing.m_122436_().m_123343_());
    }

    private static EntityType<?> chooseRandomDoorEntity() {
        double roll = Math.random();
        if (roll < 0.33) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESDOOR.get();
        }
        if (roll < 0.66) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESDOOR_2.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESDOOR_3.get();
    }

    private static DoorSpawnResult findDoorSpawnPosition(ServerLevel level, Player player) {
        ArrayList<DoorSpawnResult> validDoors = new ArrayList<DoorSpawnResult>();
        BlockPos playerPos = player.m_20183_();
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -10; dz <= 10; ++dz) {
                    DoorSpawnResult spawnResult;
                    BlockPos checkPos = playerPos.m_7918_(dx, dy, dz);
                    if (!level.m_46749_(checkPos)) continue;
                    BlockState state = level.m_8055_(checkPos);
                    double dist = Math.sqrt(checkPos.m_203193_((Position)player.m_20182_()));
                    if (dist < 5.0 || dist > 20.0 || !(state.m_60734_() instanceof DoorBlock) || (spawnResult = Phase1DoorWatcherProcedure.getValidDoorSpawn(level, checkPos, player)) == null) continue;
                    validDoors.add(spawnResult);
                }
            }
        }
        if (validDoors.isEmpty()) {
            return null;
        }
        return (DoorSpawnResult)validDoors.get((int)(Math.random() * (double)validDoors.size()));
    }

    private static DoorSpawnResult getValidDoorSpawn(ServerLevel level, BlockPos doorPos, Player player) {
        double distToDoor;
        BlockState doorState = level.m_8055_(doorPos);
        if (!(doorState.m_60734_() instanceof DoorBlock)) {
            return null;
        }
        if (((Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            return null;
        }
        Direction doorFacing = (Direction)doorState.m_61143_((Property)DoorBlock.f_52726_);
        Vec3 doorCenter = Vec3.m_82512_((Vec3i)doorPos);
        Vec3 playerPos = player.m_20182_();
        double dx = playerPos.f_82479_ - doorCenter.f_82479_;
        double dz = playerPos.f_82481_ - doorCenter.f_82481_;
        Direction playerSide = Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? Direction.EAST : Direction.WEST) : (dz > 0.0 ? Direction.SOUTH : Direction.NORTH);
        Direction spawnSide = playerSide.m_122424_();
        BlockPos spawnPos = doorPos.m_121945_(spawnSide);
        BlockState spawnState = level.m_8055_(spawnPos);
        BlockState spawnAbove = level.m_8055_(spawnPos.m_7494_());
        if (!spawnState.m_60795_() || !spawnAbove.m_60795_()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (dir == playerSide) continue;
                BlockPos testPos = doorPos.m_121945_(dir);
                BlockState testState = level.m_8055_(testPos);
                BlockState testAbove = level.m_8055_(testPos.m_7494_());
                if (!testState.m_60795_() || !testAbove.m_60795_()) continue;
                spawnPos = testPos;
                break;
            }
        }
        BlockState finalSpawnState = level.m_8055_(spawnPos);
        BlockState finalSpawnAbove = level.m_8055_(spawnPos.m_7494_());
        if (!finalSpawnState.m_60795_() || !finalSpawnAbove.m_60795_()) {
            return null;
        }
        BlockPos floorBelow = spawnPos.m_7495_();
        BlockState floorState = level.m_8055_(floorBelow);
        if (!floorState.m_280296_()) {
            return null;
        }
        int lightLevel = level.m_46803_(spawnPos);
        if (lightLevel > 13) {
            return null;
        }
        double distToSpawn = Math.sqrt(spawnPos.m_203193_((Position)playerPos));
        if (distToSpawn < (distToDoor = Math.sqrt(doorPos.m_203193_((Position)playerPos)))) {
            return null;
        }
        return new DoorSpawnResult(spawnPos, doorPos, doorFacing);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        long spawnTime;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.FROMTHECAVESDOOR.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESDOOR_2.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESDOOR_3.get()))) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128441_("phase1doorwatcher_mob")) {
            return;
        }
        long now = level.m_46467_();
        if (now - (spawnTime = data.m_128454_(KEY_SPAWN_TIME)) > 600L) {
            mob.m_146870_();
            return;
        }
        Player player = level.m_45930_((Entity)mob, 40.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        Phase1DoorWatcherProcedure.makeEntityLookAtPlayer(mob, player);
        boolean activated = data.m_128471_(KEY_ACTIVATED);
        if (!activated) {
            Phase1DoorWatcherProcedure.checkActivationConditions(mob, level, player, data, now);
        } else {
            Phase1DoorWatcherProcedure.handleEscapeBehavior(mob, level, player, data, now);
        }
    }

    private static void checkActivationConditions(Mob mob, ServerLevel level, Player player, CompoundTag data, long now) {
        BlockState doorState;
        int[] doorCoords;
        BlockPos doorPos;
        boolean doorOpened = false;
        if (data.m_128441_(KEY_DOOR_POS) && level.m_46749_(doorPos = new BlockPos((doorCoords = data.m_128465_(KEY_DOOR_POS))[0], doorCoords[1], doorCoords[2])) && (doorState = level.m_8055_(doorPos)).m_60734_() instanceof DoorBlock && ((Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            doorOpened = true;
        }
        double distance = mob.m_20270_((Entity)player);
        if (doorOpened || distance <= 2.3) {
            Phase1DoorWatcherProcedure.activateMob(mob, level, player, data, now);
        }
    }

    private static void activateMob(Mob mob, ServerLevel level, Player player, CompoundTag data, long now) {
        data.m_128379_(KEY_ACTIVATED, true);
        data.m_128356_(KEY_ACTIVATION_TIME, now);
        mob.f_19794_ = true;
        mob.m_20242_(true);
        mob.m_21557_(true);
        Vec3 escapeDir = Phase1DoorWatcherProcedure.calculateDoorEscapeDirection(data);
        data.m_128347_(KEY_ESCAPE_DIR_X, escapeDir.f_82479_);
        data.m_128347_(KEY_ESCAPE_DIR_Y, escapeDir.f_82480_);
        data.m_128347_(KEY_ESCAPE_DIR_Z, escapeDir.f_82481_);
        level.m_5594_(null, mob.m_20183_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 0.5f, 0.8f);
        for (int i = 0; i < 8; ++i) {
            double px = mob.m_20185_() + (Math.random() - 0.5) * 0.5;
            double py = mob.m_20186_() + Math.random() * (double)mob.m_20206_();
            double pz = mob.m_20189_() + (Math.random() - 0.5) * 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static Vec3 calculateDoorEscapeDirection(CompoundTag data) {
        int facingX = data.m_128451_(KEY_DOOR_FACING_X);
        int facingZ = data.m_128451_(KEY_DOOR_FACING_Z);
        Vec3 backwardDir = new Vec3((double)(-facingX), 0.0, (double)(-facingZ)).m_82541_();
        Vec3 escapeDir = backwardDir.m_82520_(0.0, -0.7, 0.0).m_82541_();
        escapeDir = escapeDir.m_82520_((Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2).m_82541_();
        return escapeDir;
    }

    private static void handleEscapeBehavior(Mob mob, ServerLevel level, Player player, CompoundTag data, long now) {
        long activationTime = data.m_128454_(KEY_ACTIVATION_TIME);
        if (now - activationTime > 100L) {
            mob.m_146870_();
            return;
        }
        if (!(data.m_128441_(KEY_ESCAPE_DIR_X) && data.m_128441_(KEY_ESCAPE_DIR_Y) && data.m_128441_(KEY_ESCAPE_DIR_Z))) {
            mob.m_146870_();
            return;
        }
        Vec3 escapeDir = new Vec3(data.m_128459_(KEY_ESCAPE_DIR_X), data.m_128459_(KEY_ESCAPE_DIR_Y), data.m_128459_(KEY_ESCAPE_DIR_Z));
        double currentSpeed = 0.8;
        if (escapeDir.f_82480_ < 0.0) {
            currentSpeed += Math.abs(escapeDir.f_82480_) * 0.3;
        }
        Vec3 motion = escapeDir.m_82490_(currentSpeed);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY, newZ);
        if (now % 3L == 0L) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), 2, 0.1, 0.1, 0.1, 0.005);
        }
    }

    private static void makeEntityLookAtPlayer(Mob mob, Player player) {
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        double dy = player.m_20188_() - mob.m_20188_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, horizontalDist) * 180.0 / Math.PI);
        mob.m_146926_(pitch);
    }

    private static class DoorSpawnResult {
        public final BlockPos spawnPos;
        public final BlockPos doorPos;
        public final Direction doorFacing;

        public DoorSpawnResult(BlockPos spawnPos, BlockPos doorPos, Direction doorFacing) {
            this.spawnPos = spawnPos;
            this.doorPos = doorPos;
            this.doorFacing = doorFacing;
        }
    }
}

