/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.configuration.ConfigScreenConfiguration;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Phase2PossessionProcedure {
    private static final double BASE_PROB = 3.0E-5;
    private static final double MAX_PROB = 4.0E-5;
    private static final int CHUNK_RADIUS = 6;
    private static final int MIN_DURATION = 5000;
    private static final int MAX_DURATION = 20000;
    private static final double UNWATCHED_REVERT_PROB = 0.003;
    private static final int UNWATCHED_CHECK_INTERVAL = 3;
    private static final double FOV_COS = Math.cos(Math.toRadians(65.0));
    private static final int CLEANUP_INTERVAL = 600;
    private static final int CHUNK_LOAD_GRACE_TICKS = 100;
    private static final Map<UUID, PossessionData> POSSESSED_DATA = new ConcurrentHashMap<UUID, PossessionData>();
    private static final Set<UUID> PROCESSING = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Integer> UNWATCHED_COUNTERS = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<Long, Long> recentlyLoadedChunks = new ConcurrentHashMap<Long, Long>();
    private static final Set<UUID> processedThisTick = ConcurrentHashMap.newKeySet();
    private static long lastCleanupTick = 0L;
    private static long lastScanTick = 0L;
    private static final int SCAN_INTERVAL = 4;
    private static Map<ResourceLocation, ResourceLocation> cachedPossessionPairs = null;

    private static Map<ResourceLocation, ResourceLocation> getCustomPossessionPairs() {
        if (cachedPossessionPairs == null) {
            cachedPossessionPairs = new HashMap<ResourceLocation, ResourceLocation>();
            String config = (String)ConfigScreenConfiguration.CUSTOM_POSSESSION_PAIRS.get();
            if (config != null && !config.trim().isEmpty()) {
                String[] pairs;
                for (String pair : pairs = config.split(",")) {
                    String[] parts;
                    if ((pair = pair.trim()).isEmpty() || !pair.contains("->") || (parts = pair.split("->")).length != 2) continue;
                    try {
                        ResourceLocation original = new ResourceLocation(parts[0].trim());
                        ResourceLocation possessed = new ResourceLocation(parts[1].trim());
                        cachedPossessionPairs.put(original, possessed);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return cachedPossessionPairs;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        long chunkKey = ChunkPos.m_45589_((int)event.getChunk().m_7697_().f_45578_, (int)event.getChunk().m_7697_().f_45579_);
        recentlyLoadedChunks.put(chunkKey, level.m_46467_());
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        for (ServerLevel level : event.getServer().m_129785_()) {
            for (Map.Entry<UUID, PossessionData> entry : POSSESSED_DATA.entrySet()) {
                Mob original;
                UUID possessedUUID = entry.getKey();
                PossessionData data = entry.getValue();
                Entity e = level.m_8791_(possessedUUID);
                if (!(e instanceof Mob)) continue;
                Mob possessed = (Mob)e;
                possessed.m_146870_();
                if (!possessed.m_213877_() || (original = (Mob)data.originalType.m_20615_((Level)level)) == null) continue;
                original.m_20258_(data.originalNbt);
                original.m_7678_((double)data.originalPos.m_123341_() + 0.5, (double)data.originalPos.m_123342_() + 0.1, (double)data.originalPos.m_123343_() + 0.5, data.originalYaw, data.originalPitch);
                level.m_7967_((Entity)original);
            }
        }
        POSSESSED_DATA.clear();
        PROCESSING.clear();
        UNWATCHED_COUNTERS.clear();
        recentlyLoadedChunks.clear();
        processedThisTick.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            long currentTick = level.m_46467_();
            recentlyLoadedChunks.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 100L);
            if (currentTick - lastCleanupTick >= 600L) {
                Phase2PossessionProcedure.cleanupDeadMobs(level);
                lastCleanupTick = currentTick;
            }
            for (ServerPlayer player : level.m_6907_()) {
                Phase2PossessionProcedure.updatePossessedMobs(level, player);
            }
            if (currentTick - lastScanTick < 4L || PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2 || !level.m_6042_().f_63858_()) continue;
            processedThisTick.clear();
            for (ServerPlayer player : level.m_6907_()) {
                Mob target;
                UUID targetId;
                double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, (Player)player, 3.0E-5, 4.0E-5);
                if (Math.random() >= dynamicProb) continue;
                ChunkPos playerChunk = player.m_146902_();
                ArrayList<Mob> candidateMobs = new ArrayList<Mob>();
                for (int dx = -6; dx <= 6; ++dx) {
                    for (int dz = -6; dz <= 6; ++dz) {
                        long chunkKey;
                        ChunkPos targetChunk = new ChunkPos(playerChunk.f_45578_ + dx, playerChunk.f_45579_ + dz);
                        if (!level.m_7232_(targetChunk.f_45578_, targetChunk.f_45579_) || recentlyLoadedChunks.containsKey(chunkKey = ChunkPos.m_45589_((int)targetChunk.f_45578_, (int)targetChunk.f_45579_))) continue;
                        int baseX = targetChunk.f_45578_ << 4;
                        int baseZ = targetChunk.f_45579_ << 4;
                        AABB chunkBox = new AABB((double)baseX, (double)level.m_141937_(), (double)baseZ, (double)(baseX + 16), (double)level.m_151558_(), (double)(baseZ + 16));
                        List entitiesInChunk = level.m_6443_(Entity.class, chunkBox, e -> true);
                        for (Entity entity : entitiesInChunk) {
                            Mob mob;
                            UUID mobId;
                            if (!(entity instanceof Mob) || processedThisTick.contains(mobId = (mob = (Mob)entity).m_20148_()) || POSSESSED_DATA.containsKey(mobId) || PROCESSING.contains(mobId) || Phase2PossessionProcedure.isPossessedMob(mob.m_6095_()) || !Phase2PossessionProcedure.canBePossessed(mob.m_6095_()) || !Phase2PossessionProcedure.isMobReadyForInteraction(mob) || !Phase2PossessionProcedure.hasLivedLongEnough(mob) || !Phase2PossessionProcedure.isInPlayerChunkRadius(mob, playerChunk) || Phase2PossessionProcedure.isVillagerSleeping(mob)) continue;
                            candidateMobs.add(mob);
                        }
                    }
                }
                if (candidateMobs.isEmpty() || !PROCESSING.add(targetId = (target = (Mob)candidateMobs.get(level.f_46441_.m_188503_(candidateMobs.size()))).m_20148_())) continue;
                if (!processedThisTick.add(targetId)) {
                    PROCESSING.remove(targetId);
                    continue;
                }
                try {
                    CompoundTag savedNbt = new CompoundTag();
                    target.m_20240_(savedNbt);
                    EntityType originalType = target.m_6095_();
                    BlockPos originalPos = target.m_20183_();
                    float originalYaw = target.m_146908_();
                    float originalPitch = target.m_146909_();
                    EntityType<? extends Mob> possessedType = Phase2PossessionProcedure.getPossessedType((EntityType<? extends Mob>)originalType);
                    if (possessedType == null) {
                        PROCESSING.remove(targetId);
                        continue;
                    }
                    target.m_146870_();
                    if (!target.m_213877_()) {
                        PROCESSING.remove(targetId);
                        continue;
                    }
                    Mob possessed = (Mob)possessedType.m_20615_((Level)level);
                    if (possessed == null) {
                        Mob replacement = (Mob)originalType.m_20615_((Level)level);
                        if (replacement != null) {
                            replacement.m_20258_(savedNbt);
                            replacement.m_7678_((double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.1, (double)originalPos.m_123343_() + 0.5, originalYaw, originalPitch);
                            level.m_7967_((Entity)replacement);
                        }
                        PROCESSING.remove(targetId);
                        continue;
                    }
                    possessed.m_20258_(savedNbt);
                    possessed.m_7678_((double)originalPos.m_123341_() + 0.5, (double)originalPos.m_123342_() + 0.1, (double)originalPos.m_123343_() + 0.5, originalYaw, originalPitch);
                    level.m_7967_((Entity)possessed);
                    UUID possessedUUID = possessed.m_20148_();
                    int duration = 5000 + level.f_46441_.m_188503_(15001);
                    POSSESSED_DATA.put(possessedUUID, new PossessionData(savedNbt, (EntityType<? extends Mob>)originalType, originalPos, originalYaw, originalPitch, duration));
                    UNWATCHED_COUNTERS.put(possessedUUID, 0);
                }
                finally {
                    PROCESSING.remove(targetId);
                }
            }
            lastScanTick = currentTick;
        }
    }

    private static void cleanupDeadMobs(ServerLevel level) {
        Iterator<Map.Entry<UUID, PossessionData>> iterator = POSSESSED_DATA.entrySet().iterator();
        while (iterator.hasNext()) {
            Mob mob;
            Map.Entry<UUID, PossessionData> entry = iterator.next();
            UUID possessedUUID = entry.getKey();
            Entity entity = level.m_8791_(possessedUUID);
            if (entity != null && !entity.m_213877_() && (!(entity instanceof Mob) || !(mob = (Mob)entity).m_21224_())) continue;
            iterator.remove();
            UNWATCHED_COUNTERS.remove(possessedUUID);
            PROCESSING.remove(possessedUUID);
        }
    }

    private static void updatePossessedMobs(ServerLevel level, ServerPlayer player) {
        Iterator<Map.Entry<UUID, PossessionData>> iterator = POSSESSED_DATA.entrySet().iterator();
        while (iterator.hasNext()) {
            Mob possessed;
            Map.Entry<UUID, PossessionData> entry = iterator.next();
            UUID possessedUUID = entry.getKey();
            PossessionData data = entry.getValue();
            Entity entity = level.m_8791_(possessedUUID);
            if (!(entity instanceof Mob) || (possessed = (Mob)entity).m_213877_() || possessed.m_21224_()) {
                iterator.remove();
                UNWATCHED_COUNTERS.remove(possessedUUID);
                continue;
            }
            boolean isWatched = Phase2PossessionProcedure.isPlayerLookingAt(player, possessed);
            if (!isWatched) {
                int unwatchedCount = UNWATCHED_COUNTERS.getOrDefault(possessedUUID, 0) + 1;
                UNWATCHED_COUNTERS.put(possessedUUID, unwatchedCount);
                if (unwatchedCount % 3 == 0 && Math.random() < 0.003) {
                    Phase2PossessionProcedure.revertPossessedMob(level, possessedUUID, possessed, data);
                    iterator.remove();
                    UNWATCHED_COUNTERS.remove(possessedUUID);
                    continue;
                }
            } else {
                UNWATCHED_COUNTERS.put(possessedUUID, 0);
            }
            --data.remainingTicks;
            if (data.remainingTicks > 0) continue;
            Phase2PossessionProcedure.revertPossessedMob(level, possessedUUID, possessed, data);
            iterator.remove();
            UNWATCHED_COUNTERS.remove(possessedUUID);
        }
    }

    private static boolean isPlayerLookingAt(ServerPlayer player, Mob mob) {
        Vec3 playerPos = player.m_20299_(1.0f);
        Vec3 mobPos = mob.m_20182_().m_82520_(0.0, (double)mob.m_20206_() / 2.0, 0.0);
        Vec3 toMob = mobPos.m_82546_(playerPos).m_82541_();
        Vec3 lookDir = player.m_20154_();
        double dot = lookDir.m_82526_(toMob);
        return dot >= FOV_COS;
    }

    private static void revertPossessedMob(ServerLevel level, UUID possessedUUID, Mob possessed, PossessionData data) {
        if (possessed.m_213877_() || possessed.m_21224_()) {
            return;
        }
        BlockPos currentPos = possessed.m_20183_();
        float currentYaw = possessed.m_146908_();
        float currentPitch = possessed.m_146909_();
        possessed.m_146870_();
        if (!possessed.m_213877_()) {
            return;
        }
        Mob original = (Mob)data.originalType.m_20615_((Level)level);
        if (original != null) {
            original.m_20258_(data.originalNbt);
            original.m_7678_((double)currentPos.m_123341_() + 0.5, (double)currentPos.m_123342_() + 0.1, (double)currentPos.m_123343_() + 0.5, currentYaw, currentPitch);
            level.m_7967_((Entity)original);
        }
    }

    private static EntityType<? extends Mob> getPossessedType(EntityType<? extends Mob> originalType) {
        ResourceLocation possessedKey;
        EntityType possessedEntityType;
        ResourceLocation origKey;
        Map<ResourceLocation, ResourceLocation> customPairs = Phase2PossessionProcedure.getCustomPossessionPairs();
        if (customPairs.containsKey(origKey = ForgeRegistries.ENTITY_TYPES.getKey(originalType)) && (possessedEntityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(possessedKey = customPairs.get(origKey))) != null) {
            EntityType castedType = possessedEntityType;
            return castedType;
        }
        if (originalType == EntityType.f_20492_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_V.get();
        }
        if (originalType == EntityType.f_20557_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_C.get();
        }
        if (originalType == EntityType.f_20520_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_S.get();
        }
        if (originalType == EntityType.f_20510_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_P.get();
        }
        if (originalType == EntityType.f_20499_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_W.get();
        }
        if (originalType == EntityType.f_20555_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_CKN.get();
        }
        if (originalType == EntityType.f_20460_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_IG.get();
        }
        if (originalType == EntityType.f_20501_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_Z.get();
        }
        if (originalType == EntityType.f_20479_ || originalType == EntityType.f_20554_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_SP.get();
        }
        if (originalType == EntityType.f_20524_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_SK.get();
        }
        if (originalType == EntityType.f_20566_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_END.get();
        }
        if (originalType == EntityType.f_20558_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_CRP.get();
        }
        if (originalType == EntityType.f_20513_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_PILL.get();
        }
        if (originalType == EntityType.f_20568_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_EV.get();
        }
        if (originalType == EntityType.f_20493_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_VIND.get();
        }
        if (originalType == EntityType.f_20518_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_RAVAGER.get();
        }
        if (originalType == EntityType.f_20480_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_SQ.get();
        }
        if (originalType == EntityType.f_20519_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_SAL.get();
        }
        if (originalType == EntityType.f_20491_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_VEX.get();
        }
        if (originalType == EntityType.f_147035_) {
            return (EntityType)FromTheCavesModEntities.POSSESSED_G.get();
        }
        return null;
    }

    public static CompoundTag getSavedNBT(UUID possessedUUID) {
        PossessionData data = POSSESSED_DATA.get(possessedUUID);
        return data != null ? data.originalNbt : null;
    }

    public static EntityType<? extends Mob> getSavedOriginalType(UUID possessedUUID) {
        PossessionData data = POSSESSED_DATA.get(possessedUUID);
        return data != null ? data.originalType : null;
    }

    public static BlockPos getSavedPosition(UUID possessedUUID) {
        PossessionData data = POSSESSED_DATA.get(possessedUUID);
        return data != null ? data.originalPos : null;
    }

    public static float getSavedYaw(UUID possessedUUID) {
        PossessionData data = POSSESSED_DATA.get(possessedUUID);
        return data != null ? data.originalYaw : 0.0f;
    }

    public static float getSavedPitch(UUID possessedUUID) {
        PossessionData data = POSSESSED_DATA.get(possessedUUID);
        return data != null ? data.originalPitch : 0.0f;
    }

    public static boolean hasSavedData(UUID possessedUUID) {
        return POSSESSED_DATA.containsKey(possessedUUID);
    }

    public static boolean removeSavedMobData(UUID possessedUUID) {
        PossessionData removed = POSSESSED_DATA.remove(possessedUUID);
        if (removed != null) {
            UNWATCHED_COUNTERS.remove(possessedUUID);
            return true;
        }
        return false;
    }

    private static boolean canBePossessed(EntityType<?> type) {
        ResourceLocation key;
        Map<ResourceLocation, ResourceLocation> customPairs = Phase2PossessionProcedure.getCustomPossessionPairs();
        if (customPairs.containsKey(key = ForgeRegistries.ENTITY_TYPES.getKey(type))) {
            return true;
        }
        return type == EntityType.f_20492_ || type == EntityType.f_20557_ || type == EntityType.f_20520_ || type == EntityType.f_20499_ || type == EntityType.f_20555_ || type == EntityType.f_20460_ || type == EntityType.f_20510_ || type == EntityType.f_20501_ || type == EntityType.f_20479_ || type == EntityType.f_20554_ || type == EntityType.f_20524_ || type == EntityType.f_20566_ || type == EntityType.f_20558_ || type == EntityType.f_20513_ || type == EntityType.f_20568_ || type == EntityType.f_20493_ || type == EntityType.f_20518_ || type == EntityType.f_20480_ || type == EntityType.f_20519_ || type == EntityType.f_20491_ || type == EntityType.f_147035_;
    }

    private static boolean isPossessedMob(EntityType<?> type) {
        return type == FromTheCavesModEntities.POSSESSED_V.get() || type == FromTheCavesModEntities.POSSESSED_C.get() || type == FromTheCavesModEntities.POSSESSED_CKN.get() || type == FromTheCavesModEntities.POSSESSED_P.get() || type == FromTheCavesModEntities.POSSESSED_S.get() || type == FromTheCavesModEntities.POSSESSED_SURVIVOR.get() || type == FromTheCavesModEntities.POSSESSED_W.get() || type == FromTheCavesModEntities.POSSESSED_IG.get() || type == FromTheCavesModEntities.POSSESSED_Z.get() || type == FromTheCavesModEntities.POSSESSED_SK.get() || type == FromTheCavesModEntities.POSSESSED_SP.get() || type == FromTheCavesModEntities.POSSESSED_CRP.get() || type == FromTheCavesModEntities.POSSESSED_END.get() || type == FromTheCavesModEntities.POSSESSED_RAVAGER.get() || type == FromTheCavesModEntities.POSSESSED_SQ.get() || type == FromTheCavesModEntities.POSSESSED_SAL.get() || type == FromTheCavesModEntities.POSSESSED_VEX.get() || type == FromTheCavesModEntities.POSSESSED_G.get() || type == FromTheCavesModEntities.POSSESSED_PILL.get() || type == FromTheCavesModEntities.POSSESSED_EV.get() || type == FromTheCavesModEntities.POSSESSED_VIND.get();
    }

    private static boolean isMobReadyForInteraction(Mob mob) {
        if (mob == null) {
            return false;
        }
        if (!mob.m_6084_()) {
            return false;
        }
        if (mob.m_213877_()) {
            return false;
        }
        if (!mob.isAddedToWorld()) {
            return false;
        }
        if (mob.f_19797_ < 400) {
            return false;
        }
        return mob.m_21573_() != null;
    }

    private static boolean isVillagerSleeping(Mob mob) {
        if (mob instanceof Villager) {
            Villager villager = (Villager)mob;
            return villager.m_5803_();
        }
        return false;
    }

    private static boolean hasLivedLongEnough(Mob mob) {
        return mob.f_19797_ >= 400;
    }

    private static boolean isInPlayerChunkRadius(Mob mob, ChunkPos playerChunk) {
        ChunkPos mobChunk = mob.m_146902_();
        int dx = Math.abs(mobChunk.f_45578_ - playerChunk.f_45578_);
        int dz = Math.abs(mobChunk.f_45579_ - playerChunk.f_45579_);
        return dx <= 6 && dz <= 6;
    }

    public static void clearCache() {
        cachedPossessionPairs = null;
    }

    private static class PossessionData {
        final CompoundTag originalNbt;
        final EntityType<? extends Mob> originalType;
        final BlockPos originalPos;
        final float originalYaw;
        final float originalPitch;
        final int durationTicks;
        int remainingTicks;

        PossessionData(CompoundTag nbt, EntityType<? extends Mob> type, BlockPos pos, float yaw, float pitch, int duration) {
            this.originalNbt = nbt;
            this.originalType = type;
            this.originalPos = pos;
            this.originalYaw = yaw;
            this.originalPitch = pitch;
            this.durationTicks = duration;
            this.remainingTicks = duration;
        }
    }
}

