/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class Phase2TriggerSoundProcedure {
    private static final String NBT_KEY = "fromthecaves_phase2_played";
    private static boolean hasPlayedPhase2Server = false;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        try {
            if (server.m_129921_() % 20 != 0) {
                return;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        Phase2SoundData soundData = (Phase2SoundData)overworld.m_8895_().m_164861_(Phase2SoundData::load, Phase2SoundData::new, "fromthecaves_phase2sound");
        if (soundData.hasPlayed) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)overworld);
        if (phase == 2 && !hasPlayedPhase2Server) {
            hasPlayedPhase2Server = true;
            soundData.hasPlayed = true;
            soundData.m_77762_();
            ResourceLocation rl = new ResourceLocation("from_the_caves", "phase2");
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
            if (sound == null) {
                return;
            }
            List players = server.m_6846_().m_11314_();
            for (ServerPlayer sp : players) {
                overworld.m_5594_(null, sp.m_20183_(), sound, SoundSource.AMBIENT, 0.35f, 0.9f);
            }
        } else if (phase != 2) {
            hasPlayedPhase2Server = false;
        }
    }

    public static class Phase2SoundData
    extends SavedData {
        public boolean hasPlayed = false;

        public static Phase2SoundData load(CompoundTag tag) {
            Phase2SoundData data = new Phase2SoundData();
            data.hasPlayed = tag.m_128471_(Phase2TriggerSoundProcedure.NBT_KEY);
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128379_(Phase2TriggerSoundProcedure.NBT_KEY, this.hasPlayed);
            return tag;
        }
    }
}

