/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.configuration.ConfigScreenConfiguration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PhotosensitiveSafetyProcedure {
    private static final String DATA_NAME = "fromthecaves_photosensitive_data";
    private static final String TAG_KEY = "photosensitive_mode";

    private static PhotosensitiveData getData(LevelAccessor world) {
        ServerLevel server;
        ServerLevel overworld;
        if (world instanceof ServerLevel && (overworld = (server = (ServerLevel)world).m_7654_().m_129880_(Level.f_46428_)) != null) {
            DimensionDataStorage storage = overworld.m_8895_();
            PhotosensitiveData data = (PhotosensitiveData)storage.m_164861_(PhotosensitiveData::load, PhotosensitiveData::new, DATA_NAME);
            data.initializeFromConfig();
            return data;
        }
        return null;
    }

    public static boolean isPhotosensitiveModeEnabled(LevelAccessor world) {
        PhotosensitiveData data = PhotosensitiveSafetyProcedure.getData(world);
        return data != null && data.isEnabled();
    }

    public static void setPhotosensitiveMode(LevelAccessor world, boolean enabled) {
        PhotosensitiveData data = PhotosensitiveSafetyProcedure.getData(world);
        if (data != null) {
            data.setEnabled(enabled);
        }
    }

    private static class PhotosensitiveData
    extends SavedData {
        private boolean photosensitiveMode = false;
        private boolean initialized = false;

        public static PhotosensitiveData load(CompoundTag tag) {
            PhotosensitiveData data = new PhotosensitiveData();
            data.photosensitiveMode = tag.m_128471_(PhotosensitiveSafetyProcedure.TAG_KEY);
            data.initialized = tag.m_128471_("initialized");
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128379_(PhotosensitiveSafetyProcedure.TAG_KEY, this.photosensitiveMode);
            tag.m_128379_("initialized", this.initialized);
            return tag;
        }

        public boolean isEnabled() {
            return this.photosensitiveMode;
        }

        public void setEnabled(boolean enabled) {
            this.photosensitiveMode = enabled;
            this.initialized = true;
            this.m_77762_();
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void initializeFromConfig() {
            if (!this.initialized) {
                this.photosensitiveMode = (Boolean)ConfigScreenConfiguration.PHOTOSENSITIVE_MODE_ENABLED.get();
                this.initialized = true;
                this.m_77762_();
            }
        }
    }
}

