/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedIllagerAbilitiesProcedure {
    private static final double NORMAL_SPEED = 1.0;
    private static final double ANGRY_SPEED = 1.05;
    private static final int ABILITY_COOLDOWN = 120;
    private static final int ANGRY_DURATION = 120;
    private static final double ATTACK_RANGE = 1.5;
    private static final float BASE_DAMAGE = 1.5f;
    private static final double PILLAGER_MIN_DISTANCE = 6.0;
    private static final double PILLAGER_MAX_DISTANCE = 20.0;
    private static final double PILLAGER_IDEAL_DISTANCE = 10.0;
    private static final double PILLAGER_STRAFE_PROB = 0.04;
    private static final double PILLAGER_ARROW_PROB = 0.08;
    private static final double PILLAGER_MULTISHOT_PROB = 0.05;
    private static final double PILLAGER_EXPLOSIVE_PROB = 0.03;
    private static final double PILLAGER_RAPID_FIRE_PROB = 0.04;
    private static final int PILLAGER_CROSSBOW_CHARGE_TICKS = 20;
    private static final int PILLAGER_ATTACK_COOLDOWN = 40;
    private static final double EVOKER_FANGS_PROB = 0.025;
    private static final double EVOKER_CIRCLE_PROB = 0.015;
    private static final double EVOKER_TELEPORT_PROB = 0.018;
    private static final double EVOKER_MAGIC_BLAST_PROB = 0.005;
    private static final double EVOKER_CROSS_PROB = 0.025;
    private static final double EVOKER_SPIRAL_PROB = 0.022;
    private static final double EVOKER_WALL_PROB = 0.02;
    private static final double EVOKER_STAR_PROB = 0.018;
    private static final double EVOKER_SHIELD_BURST_PROB = 1.0E-4;
    private static final double EVOKER_SOUL_DRAIN_PROB = 0.0;
    private static final double EVOKER_VEX_SUMMON_PROB = 0.005;
    private static final double EVOKER_KNOCKBACK_WAVE_PROB = 0.02;
    private static final double VINDICATOR_CHARGE_PROB = 0.03;
    private static final double VINDICATOR_WHIRLWIND_PROB = 0.025;
    private static final double VINDICATOR_LEAP_PROB = 0.028;
    private static final double VINDICATOR_RAGE_PROB = 0.022;

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        if (mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_PILL.get()) || mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_EV.get()) || mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_VIND.get())) {
            CompoundTag pd = mob.getPersistentData();
            long now = mob.m_9236_().m_46467_();
            pd.m_128356_("illager_angry_time", now);
            if (mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_EV.get())) {
                pd.m_128356_("evoker_last_hurt", now);
                if ((double)mob.m_21223_() < (double)mob.m_21233_() * 0.5) {
                    pd.m_128379_("evoker_berserk", true);
                }
                if (Math.random() < 0.3) {
                    PossessedIllagerAbilitiesProcedure.executeTacticalRetreat(mob, pd, now, (ServerLevel)mob.m_9236_());
                }
            }
            if (mob.m_6095_().equals(FromTheCavesModEntities.POSSESSED_VIND.get()) && Math.random() < 0.4 && ev.getSource().m_7639_() != null && (double)mob.m_20270_(ev.getSource().m_7639_()) <= 8.0) {
                pd.m_128356_("vindicator_enrage_until", now + 100L);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        int cooldown;
        double currentSpeed;
        long angryTime;
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.POSSESSED_PILL.get()) || type.equals(FromTheCavesModEntities.POSSESSED_EV.get()) || type.equals(FromTheCavesModEntities.POSSESSED_VIND.get()))) {
            return;
        }
        Player tgt = server.m_45930_((Entity)mob, 32.0);
        if (tgt == null) {
            return;
        }
        CompoundTag pd = mob.getPersistentData();
        long now = server.m_46467_();
        boolean isAngry = now - (angryTime = pd.m_128454_("illager_angry_time")) < 120L;
        double dx = tgt.m_20185_() - mob.m_20185_();
        double dz = tgt.m_20189_() - mob.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        int abilityState = pd.m_128451_("illager_ability_state");
        long abilityStart = pd.m_128454_("illager_ability_start");
        long lastAbilityEnd = pd.m_128454_("illager_last_ability_end");
        double dist = mob.m_20270_((Entity)tgt);
        if (abilityState != 0) {
            PossessedIllagerAbilitiesProcedure.handleActiveAbility(mob, tgt, pd, now, abilityState, abilityStart, server);
            return;
        }
        mob.m_6710_((LivingEntity)tgt);
        double d = currentSpeed = isAngry ? 1.05 : 1.0;
        if (type.equals(FromTheCavesModEntities.POSSESSED_EV.get())) {
            PossessedIllagerAbilitiesProcedure.handleEvokerMovement(mob, tgt, pd, dist, currentSpeed, now, isAngry);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_PILL.get())) {
            PossessedIllagerAbilitiesProcedure.handlePillagerMovement(mob, tgt, pd, dist, currentSpeed, now, server);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_VIND.get())) {
            PossessedIllagerAbilitiesProcedure.handleVindicatorMovement(mob, tgt, pd, dist, currentSpeed, now);
        }
        int n = cooldown = isAngry ? 60 : 120;
        if (now - lastAbilityEnd < (long)cooldown) {
            return;
        }
        if (type.equals(FromTheCavesModEntities.POSSESSED_PILL.get())) {
            PossessedIllagerAbilitiesProcedure.handlePillagerAbilities(mob, tgt, pd, now, dist, isAngry, server);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_EV.get())) {
            PossessedIllagerAbilitiesProcedure.handleEvokerAbilities(mob, tgt, pd, now, dist, isAngry);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_VIND.get())) {
            PossessedIllagerAbilitiesProcedure.handleVindicatorAbilities(mob, tgt, pd, now, dist, isAngry);
        }
    }

    private static void handleEvokerMovement(Mob mob, Player tgt, CompoundTag pd, double dist, double speed, long now, boolean isAngry) {
        boolean isRetreating;
        boolean isBerserk = pd.m_128471_("evoker_berserk");
        long lastHurt = pd.m_128454_("evoker_last_hurt");
        boolean recentlyHurt = now - lastHurt < 60L;
        long retreatUntil = pd.m_128454_("evoker_retreat_until");
        boolean bl = isRetreating = now < retreatUntil;
        if (isRetreating) {
            Vec3 awayDir = mob.m_20182_().m_82546_(tgt.m_20182_()).m_82541_();
            double tx = mob.m_20185_() + awayDir.f_82479_ * 12.0;
            double tz = mob.m_20189_() + awayDir.f_82481_ * 12.0;
            mob.m_21573_().m_26519_(tx, mob.m_20186_(), tz, speed * 1.6);
            if (now % 10L == 0L) {
                ((ServerLevel)mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 3, 0.3, 0.3, 0.3, 0.02);
            }
            return;
        }
        if (dist <= 6.0 && (isBerserk || recentlyHurt)) {
            Vec3 awayDir = mob.m_20182_().m_82546_(tgt.m_20182_()).m_82541_();
            double tx = mob.m_20185_() + awayDir.f_82479_ * 8.0;
            double tz = mob.m_20189_() + awayDir.f_82481_ * 8.0;
            mob.m_21573_().m_26519_(tx, mob.m_20186_(), tz, speed * 1.5);
        } else if (dist > 18.0) {
            mob.m_21573_().m_5624_((Entity)tgt, speed * 1.2);
        } else {
            if (!pd.m_128441_("evoker_wander_x") || Math.random() < 0.03) {
                PossessedIllagerAbilitiesProcedure.setNewEvokerWanderTarget(mob, pd, tgt, now);
            }
            double wanderX = pd.m_128459_("evoker_wander_x");
            double wanderY = pd.m_128459_("evoker_wander_y");
            double wanderZ = pd.m_128459_("evoker_wander_z");
            Vec3 wanderPos = new Vec3(wanderX, wanderY, wanderZ);
            double wanderDist = mob.m_20182_().m_82554_(wanderPos);
            if (wanderDist > 2.0) {
                mob.m_21573_().m_26519_(wanderX, wanderY, wanderZ, speed * 0.8);
            } else {
                PossessedIllagerAbilitiesProcedure.setNewEvokerWanderTarget(mob, pd, tgt, now);
            }
        }
    }

    private static void setNewEvokerWanderTarget(Mob mob, CompoundTag pd, Player tgt, long now) {
        double angle = Math.random() * 2.0 * Math.PI;
        double radius = 8.0 + Math.random() * 4.0;
        double offsetX = Math.cos(angle) * radius;
        double offsetZ = Math.sin(angle) * radius;
        double targetX = tgt.m_20185_() + offsetX;
        double targetZ = tgt.m_20189_() + offsetZ;
        double targetY = tgt.m_20186_();
        pd.m_128347_("evoker_wander_x", targetX);
        pd.m_128347_("evoker_wander_y", targetY);
        pd.m_128347_("evoker_wander_z", targetZ);
    }

    private static void executeTacticalRetreat(Mob mob, CompoundTag pd, long now, ServerLevel server) {
        pd.m_128356_("evoker_retreat_until", now + 60L);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123759_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 15, 0.5, 0.5, 0.5, 0.05);
    }

    private static void handlePillagerMovement(Mob mob, Player tgt, CompoundTag pd, double dist, double speed, long now, ServerLevel server) {
        boolean hasLoS = PossessedIllagerAbilitiesProcedure.hasLineOfSight(server, mob, tgt);
        boolean charging = pd.m_128471_("pillager_charging");
        if (charging) {
            mob.m_21563_().m_24960_((Entity)tgt, 30.0f, 30.0f);
            double reducedSpeed = Math.max(0.0, speed - 0.3);
            if (hasLoS) {
                if (!pd.m_128441_("pillager_strafe_dir")) {
                    pd.m_128405_("pillager_strafe_dir", server.f_46441_.m_188499_() ? 1 : -1);
                    pd.m_128356_("pillager_last_strafe_change", now);
                }
                int strafeDir = pd.m_128451_("pillager_strafe_dir");
                long lastStrafeChange = pd.m_128454_("pillager_last_strafe_change");
                if (server.f_46441_.m_188500_() < 0.04 || now - lastStrafeChange > 60L) {
                    strafeDir = server.f_46441_.m_188499_() ? 1 : -1;
                    pd.m_128405_("pillager_strafe_dir", strafeDir);
                    pd.m_128356_("pillager_last_strafe_change", now);
                }
                Vec3 toPlayer = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                Vec3 strafeVec = new Vec3(-toPlayer.f_82481_, 0.0, toPlayer.f_82479_).m_82541_().m_82490_((double)strafeDir * 1.2 + (server.f_46441_.m_188500_() - 0.5) * 0.4);
                double targetX = mob.m_20185_() + strafeVec.f_82479_ * 1.2;
                double targetZ = mob.m_20189_() + strafeVec.f_82481_ * 1.2;
                mob.m_21573_().m_26519_(targetX, mob.m_20186_(), targetZ, reducedSpeed * 0.8);
            } else {
                mob.m_21573_().m_5624_((Entity)tgt, reducedSpeed * 1.1);
            }
            long lastPlay = pd.m_128454_("pillager_charge_sound_last");
            if (now - lastPlay >= 6L) {
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11842_, SoundSource.HOSTILE, 0.8f, 1.0f);
                pd.m_128356_("pillager_charge_sound_last", now);
            }
            return;
        }
        if (!pd.m_128441_("pillager_strafe_dir")) {
            pd.m_128405_("pillager_strafe_dir", server.f_46441_.m_188499_() ? 1 : -1);
            pd.m_128356_("pillager_last_strafe_change", now);
        }
        int strafeDir = pd.m_128451_("pillager_strafe_dir");
        long lastStrafeChange = pd.m_128454_("pillager_last_strafe_change");
        if (server.f_46441_.m_188500_() < 0.04 || now - lastStrafeChange > 80L) {
            strafeDir = server.f_46441_.m_188499_() ? 1 : -1;
            pd.m_128405_("pillager_strafe_dir", strafeDir);
            pd.m_128356_("pillager_last_strafe_change", now);
        }
        if (dist < 6.0) {
            Vec3 awayDir = mob.m_20182_().m_82546_(tgt.m_20182_()).m_82541_();
            double targetX = mob.m_20185_() + awayDir.f_82479_ * 5.0;
            double targetZ = mob.m_20189_() + awayDir.f_82481_ * 5.0;
            mob.m_21573_().m_26519_(targetX, mob.m_20186_(), targetZ, speed * 1.4);
            return;
        }
        if (dist > 20.0) {
            mob.m_21573_().m_5624_((Entity)tgt, speed * 1.3);
            return;
        }
        if (dist >= 7.0 && dist <= 15.0) {
            if (hasLoS) {
                Vec3 toPlayer = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                Vec3 strafeVec = new Vec3(-toPlayer.f_82481_, 0.0, toPlayer.f_82479_).m_82541_().m_82490_((double)strafeDir);
                double jitter = (server.f_46441_.m_188500_() - 0.5) * 0.6;
                double targetX = mob.m_20185_() + strafeVec.f_82479_ * 3.0 + jitter;
                double targetZ = mob.m_20189_() + strafeVec.f_82481_ * 3.0 + jitter;
                mob.m_21573_().m_26519_(targetX, mob.m_20186_(), targetZ, speed * 0.9);
            } else {
                mob.m_21573_().m_5624_((Entity)tgt, speed * 1.05);
            }
            return;
        }
        if (dist < 10.0) {
            Vec3 awayDir = mob.m_20182_().m_82546_(tgt.m_20182_()).m_82541_();
            double targetX = mob.m_20185_() + awayDir.f_82479_ * 4.0;
            double targetZ = mob.m_20189_() + awayDir.f_82481_ * 4.0;
            mob.m_21573_().m_26519_(targetX, mob.m_20186_(), targetZ, speed * 1.1);
        } else {
            mob.m_21573_().m_5624_((Entity)tgt, speed);
        }
    }

    private static boolean hasLineOfSight(ServerLevel level, Mob mob, Player tgt) {
        Vec3 tgtEye;
        Vec3 mobEye = mob.m_146892_();
        ClipContext context = new ClipContext(mobEye, tgtEye = tgt.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob);
        BlockHitResult result = level.m_45547_(context);
        return result.m_6662_() == HitResult.Type.MISS;
    }

    private static void handleVindicatorMovement(Mob mob, Player tgt, CompoundTag pd, double dist, double speed, long now) {
        double effectiveSpeed;
        long enrageUntil = pd.m_128454_("vindicator_enrage_until");
        boolean isEnraged = now < enrageUntil;
        double d = effectiveSpeed = isEnraged ? speed * 1.3 : speed * 1.2;
        if (dist > 1.5) {
            mob.m_21573_().m_5624_((Entity)tgt, effectiveSpeed);
            if (isEnraged && now % 10L == 0L) {
                ((ServerLevel)mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20185_(), mob.m_20186_() + 1.2, mob.m_20189_(), 2, 0.3, 0.3, 0.3, 0.0);
            }
        } else {
            mob.m_21573_().m_26573_();
            long lastAttack = pd.m_128454_("illager_last_attack");
            if (now - lastAttack >= 10L) {
                float damage = isEnraged ? 3.3000002f : 2.6999998f;
                tgt.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), damage);
                tgt.m_147240_(0.6, mob.m_20185_() - tgt.m_20185_(), mob.m_20189_() - tgt.m_20189_());
                pd.m_128356_("illager_last_attack", now);
                ((ServerLevel)mob.m_9236_()).m_5594_(null, mob.m_20183_(), SoundEvents.f_12316_, SoundSource.HOSTILE, 1.0f, 0.9f);
            }
        }
    }

    private static void handlePillagerAbilities(Mob mob, Player tgt, CompoundTag pd, long now, double dist, boolean isAngry, ServerLevel server) {
        int attackCooldown;
        double probMod = isAngry ? 1.8 : 1.0;
        boolean hasLoS = PossessedIllagerAbilitiesProcedure.hasLineOfSight(server, mob, tgt);
        if (!hasLoS && dist > 20.0) {
            return;
        }
        int chargeTicks = pd.m_128451_("pillager_charge_ticks");
        long lastAttack = pd.m_128454_("pillager_last_attack");
        int n = attackCooldown = isAngry ? 20 : 40;
        if (chargeTicks > 0) {
            pd.m_128405_("pillager_charge_ticks", ++chargeTicks);
            pd.m_128379_("pillager_charging", true);
            if (chargeTicks >= 20) {
                if (server.f_46441_.m_188500_() < 0.05 * probMod && dist >= 8.0) {
                    PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 2);
                } else if (server.f_46441_.m_188500_() < 0.03 * probMod && dist >= 7.0 && dist <= 18.0) {
                    PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 3);
                } else if (server.f_46441_.m_188500_() < 0.04 * probMod && dist <= 15.0) {
                    PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 4);
                } else {
                    PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 1);
                }
                pd.m_128405_("pillager_charge_ticks", 0);
                pd.m_128379_("pillager_charging", false);
                pd.m_128356_("pillager_last_attack", now);
            } else if (chargeTicks == 1) {
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11843_, SoundSource.HOSTILE, 0.9f, 1.0f);
            }
            return;
        }
        if (now - lastAttack < (long)attackCooldown) {
            return;
        }
        if (dist >= 6.0 && dist <= 20.0 && hasLoS) {
            if (server.f_46441_.m_188500_() < 0.08 * probMod) {
                pd.m_128405_("pillager_charge_ticks", 1);
                pd.m_128379_("pillager_charging", true);
                pd.m_128356_("pillager_last_attack", now);
                return;
            }
            if (server.f_46441_.m_188500_() < 0.05 * probMod && dist >= 8.0) {
                pd.m_128405_("pillager_charge_ticks", 1);
                pd.m_128379_("pillager_charging", true);
                pd.m_128356_("pillager_last_attack", now);
                return;
            }
            if (server.f_46441_.m_188500_() < 0.04 * probMod && dist <= 15.0) {
                pd.m_128405_("pillager_charge_ticks", 1);
                pd.m_128379_("pillager_charging", true);
                pd.m_128356_("pillager_last_attack", now);
                return;
            }
        }
        if (!hasLoS) {
            mob.m_21573_().m_5624_((Entity)tgt, (isAngry ? 1.05 : 1.0) * 1.2);
        }
    }

    private static void handleEvokerAbilities(Mob mob, Player tgt, CompoundTag pd, long now, double dist, boolean isAngry) {
        double probMod;
        boolean isBerserk = pd.m_128471_("evoker_berserk");
        double d = probMod = isAngry ? 1.8 : 1.0;
        if (isBerserk) {
            probMod *= 2.5;
        }
        if (dist <= 6.0) {
            if (Math.random() < 1.0E-4 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 19);
                return;
            }
            if (Math.random() < 0.0 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 20);
                return;
            }
            if (Math.random() < 0.02 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 21);
                return;
            }
            if (Math.random() < 0.005 * probMod && mob.m_9236_().m_45976_(LivingEntity.class, mob.m_20191_().m_82400_(20.0)).stream().filter(e -> e.m_6095_().equals(FromTheCavesModEntities.POSSESSED_VEX.get())).count() < 3L) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 22);
                return;
            }
        }
        if (dist >= 4.0 && dist <= 16.0) {
            if (Math.random() < 0.025 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 11);
                return;
            }
            if (Math.random() < 0.005 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 14);
                return;
            }
            if (Math.random() < 0.025 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 15);
                return;
            }
            if (Math.random() < 0.02 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 17);
                return;
            }
        }
        if (dist >= 6.0 && dist <= 14.0) {
            if (Math.random() < 0.015 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 12);
                return;
            }
            if (Math.random() < 0.022 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 16);
                return;
            }
            if (Math.random() < 0.018 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 18);
                return;
            }
        }
        if ((dist < 5.0 || dist > 20.0) && Math.random() < 0.018 * probMod) {
            PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 13);
            return;
        }
    }

    private static void handleVindicatorAbilities(Mob mob, Player tgt, CompoundTag pd, long now, double dist, boolean isAngry) {
        double probMod;
        long enrageUntil = pd.m_128454_("vindicator_enrage_until");
        boolean isEnraged = now < enrageUntil;
        double d = probMod = isAngry ? 1.9 : 1.0;
        if (isEnraged) {
            probMod *= 1.5;
        }
        if (dist >= 5.0 && dist <= 16.0) {
            if (Math.random() < 0.03 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 101);
                return;
            }
            if (Math.random() < 0.028 * probMod) {
                PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 103);
                return;
            }
        }
        if (dist >= 2.0 && dist <= 10.0 && Math.random() < 0.025 * probMod) {
            PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 102);
            return;
        }
        if (dist <= 8.0 && (double)mob.m_21223_() < (double)mob.m_21233_() * 0.6 && Math.random() < 0.022 * probMod) {
            PossessedIllagerAbilitiesProcedure.startAbility(mob, pd, now, 104);
            return;
        }
    }

    private static void startAbility(Mob mob, CompoundTag pd, long now, int abilityId) {
        pd.m_128405_("illager_ability_state", abilityId);
        pd.m_128356_("illager_ability_start", now);
        mob.m_21573_().m_26573_();
    }

    private static void handleActiveAbility(Mob mob, Player tgt, CompoundTag pd, long now, int state, long start, ServerLevel server) {
        switch (state) {
            case 1: {
                PossessedIllagerAbilitiesProcedure.executePillagerArrow(mob, tgt, pd, now, server);
                break;
            }
            case 2: {
                PossessedIllagerAbilitiesProcedure.executePillagerMultishot(mob, tgt, pd, now, server);
                break;
            }
            case 3: {
                PossessedIllagerAbilitiesProcedure.executePillagerExplosive(mob, tgt, pd, now, server);
                break;
            }
            case 4: {
                PossessedIllagerAbilitiesProcedure.executePillagerRapidFire(mob, tgt, pd, now, start, server);
                break;
            }
            case 11: {
                PossessedIllagerAbilitiesProcedure.executeEvokerFangs(mob, tgt, pd, now, server);
                break;
            }
            case 12: {
                PossessedIllagerAbilitiesProcedure.executeEvokerCircle(mob, tgt, pd, now, server);
                break;
            }
            case 13: {
                PossessedIllagerAbilitiesProcedure.executeEvokerTeleport(mob, tgt, pd, now, server);
                break;
            }
            case 14: {
                PossessedIllagerAbilitiesProcedure.executeEvokerMagicBlast(mob, tgt, pd, now, server);
                break;
            }
            case 15: {
                PossessedIllagerAbilitiesProcedure.executeEvokerCross(mob, tgt, pd, now, server);
                break;
            }
            case 16: {
                PossessedIllagerAbilitiesProcedure.executeEvokerSpiral(mob, tgt, pd, now, start, server);
                break;
            }
            case 17: {
                PossessedIllagerAbilitiesProcedure.executeEvokerWall(mob, tgt, pd, now, server);
                break;
            }
            case 18: {
                PossessedIllagerAbilitiesProcedure.executeEvokerStar(mob, tgt, pd, now, server);
                break;
            }
            case 19: {
                PossessedIllagerAbilitiesProcedure.executeEvokerShieldBurst(mob, tgt, pd, now, server);
                break;
            }
            case 20: {
                PossessedIllagerAbilitiesProcedure.executeEvokerSoulDrain(mob, tgt, pd, now, server);
                break;
            }
            case 21: {
                PossessedIllagerAbilitiesProcedure.executeEvokerKnockbackWave(mob, tgt, pd, now, server);
                break;
            }
            case 22: {
                PossessedIllagerAbilitiesProcedure.executeEvokerVexSummon(mob, tgt, pd, now, server);
                break;
            }
            case 101: {
                PossessedIllagerAbilitiesProcedure.executeVindicatorCharge(mob, tgt, pd, now, start, server);
                break;
            }
            case 102: {
                PossessedIllagerAbilitiesProcedure.executeVindicatorWhirlwind(mob, tgt, pd, now, start, server);
                break;
            }
            case 103: {
                PossessedIllagerAbilitiesProcedure.executeVindicatorLeap(mob, tgt, pd, now, start, server);
                break;
            }
            case 104: {
                PossessedIllagerAbilitiesProcedure.executeVindicatorRage(mob, tgt, pd, now, server);
            }
        }
    }

    private static void executePillagerArrow(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Arrow arrow = new Arrow((Level)server, (LivingEntity)mob);
        Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
        double gravity = 0.05;
        double distance = mob.m_20270_((Entity)tgt);
        double heightDiff = tgt.m_20186_() - mob.m_20186_();
        double timeToTarget = distance / 2.5;
        double verticalVelocity = heightDiff / timeToTarget + 0.5 * gravity * timeToTarget;
        arrow.m_20334_(dir.f_82479_ * 2.5, verticalVelocity, dir.f_82481_ * 2.5);
        arrow.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
        arrow.m_5602_((Entity)mob);
        arrow.m_36762_(true);
        arrow.m_36781_(3.5);
        server.m_7967_((Entity)arrow);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11687_, SoundSource.HOSTILE, 1.0f, 0.9f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executePillagerMultishot(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
        for (int i = -1; i <= 1; ++i) {
            Arrow arrow = new Arrow((Level)server, (LivingEntity)mob);
            double angleOffset = (double)i * 0.15;
            Vec3 rotated = dir.m_82524_((float)angleOffset);
            double gravity = 0.05;
            double distance = mob.m_20270_((Entity)tgt);
            double heightDiff = tgt.m_20186_() - mob.m_20186_();
            double timeToTarget = distance / 2.3;
            double verticalVelocity = heightDiff / timeToTarget + 0.5 * gravity * timeToTarget;
            arrow.m_20334_(rotated.f_82479_ * 2.3, verticalVelocity, rotated.f_82481_ * 2.3);
            arrow.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
            arrow.m_5602_((Entity)mob);
            arrow.m_36781_(3.0);
            server.m_7967_((Entity)arrow);
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11847_, SoundSource.HOSTILE, 1.5f, 1.0f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executePillagerExplosive(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Arrow arrow = new Arrow((Level)server, (LivingEntity)mob);
        Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
        double gravity = 0.05;
        double distance = mob.m_20270_((Entity)tgt);
        double heightDiff = tgt.m_20186_() - mob.m_20186_();
        double timeToTarget = distance / 2.0;
        double verticalVelocity = heightDiff / timeToTarget + 0.5 * gravity * timeToTarget;
        arrow.m_20334_(dir.f_82479_ * 2.0, verticalVelocity, dir.f_82481_ * 2.0);
        arrow.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
        arrow.m_5602_((Entity)mob);
        arrow.getPersistentData().m_128379_("explosive_arrow", true);
        arrow.m_36781_(5.0);
        server.m_7967_((Entity)arrow);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_(), 15, 0.3, 0.3, 0.3, 0.05);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11874_, SoundSource.HOSTILE, 1.0f, 0.8f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executePillagerRapidFire(Mob mob, Player tgt, CompoundTag pd, long now, long start, ServerLevel server) {
        long elapsed = now - start;
        if (elapsed % 3L == 0L && elapsed < 30L) {
            Arrow arrow = new Arrow((Level)server, (LivingEntity)mob);
            Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
            double spread = (Math.random() - 0.5) * 0.1;
            Vec3 spreadDir = dir.m_82524_((float)spread);
            double gravity = 0.05;
            double distance = mob.m_20270_((Entity)tgt);
            double heightDiff = tgt.m_20186_() - mob.m_20186_();
            double timeToTarget = distance / 2.6;
            double verticalVelocity = heightDiff / timeToTarget + 0.5 * gravity * timeToTarget;
            arrow.m_20334_(spreadDir.f_82479_ * 2.6, verticalVelocity, spreadDir.f_82481_ * 2.6);
            arrow.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
            arrow.m_5602_((Entity)mob);
            arrow.m_36781_(2.5);
            server.m_7967_((Entity)arrow);
            server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11687_, SoundSource.HOSTILE, 0.7f, 1.4f);
        }
        if (elapsed >= 30L) {
            PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
        }
    }

    private static void executeEvokerFangs(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
        for (int i = 1; i <= 10; ++i) {
            double dist = (double)i * 1.4;
            double x = mob.m_20185_() + dir.f_82479_ * dist;
            double z = mob.m_20189_() + dir.f_82481_ * dist;
            BlockPos pos = new BlockPos((int)x, (int)mob.m_20186_(), (int)z);
            int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, i * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 30, 0.5, 0.5, 0.5, 0.12);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 1.5f, 1.0f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerCircle(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        double radius = 4.0;
        int fangsCount = 20;
        for (int i = 0; i < fangsCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)fangsCount;
            double x = tgt.m_20185_() + Math.cos(angle) * radius;
            double z = tgt.m_20189_() + Math.sin(angle) * radius;
            BlockPos pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
            int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, i * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, tgt.m_20185_(), tgt.m_20186_() + 0.5, tgt.m_20189_(), 40, radius, 0.5, radius, 0.0);
        server.m_5594_(null, tgt.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 2.0f, 0.8f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerTeleport(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 70, 0.5, 1.0, 0.5, 0.6);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
        double angle = server.f_46441_.m_188500_() * 2.0 * Math.PI;
        double distance = 10.0 + server.f_46441_.m_188500_() * 6.0;
        double x = tgt.m_20185_() + Math.cos(angle) * distance;
        double z = tgt.m_20189_() + Math.sin(angle) * distance;
        int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)x, (int)z);
        mob.m_6021_(x, (double)y, z);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 70, 0.5, 1.0, 0.5, 0.6);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerMagicBlast(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
        for (int i = 0; i < 40; ++i) {
            double offsetX = (server.f_46441_.m_188500_() - 0.5) * 2.5;
            double offsetY = (server.f_46441_.m_188500_() - 0.5) * 2.5;
            double offsetZ = (server.f_46441_.m_188500_() - 0.5) * 2.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, mob.m_20185_() + dir.f_82479_ * (double)i * 0.35 + offsetX, mob.m_20186_() + 1.0 + dir.f_82480_ * (double)i * 0.35 + offsetY, mob.m_20189_() + dir.f_82481_ * (double)i * 0.35 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        AABB hitbox = new AABB(tgt.m_20182_().m_82520_(-1.5, -1.5, -1.5), tgt.m_20182_().m_82520_(1.5, 2.5, 1.5));
        List entities = server.m_45976_(LivingEntity.class, hitbox);
        for (LivingEntity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 8.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
            player.m_147240_(0.4, mob.m_20185_() - player.m_20185_(), mob.m_20189_() - player.m_20189_());
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 1.5f, 1.5f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerCross(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        EvokerFangs fangs;
        int y;
        BlockPos pos;
        double z;
        double x;
        int i;
        Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
        Vec3 perpendicular = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_();
        for (i = -6; i <= 6; ++i) {
            x = tgt.m_20185_() + perpendicular.f_82479_ * (double)i * 1.3;
            z = tgt.m_20189_() + perpendicular.f_82481_ * (double)i * 1.3;
            pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
            y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, Math.abs(i) * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        for (i = -6; i <= 6; ++i) {
            x = tgt.m_20185_() + dir.f_82479_ * (double)i * 1.3;
            z = tgt.m_20189_() + dir.f_82481_ * (double)i * 1.3;
            pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
            y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, Math.abs(i) * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, tgt.m_20185_(), tgt.m_20186_() + 0.5, tgt.m_20189_(), 60, 5.0, 0.5, 5.0, 0.12);
        server.m_5594_(null, tgt.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 2.0f, 0.9f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerSpiral(Mob mob, Player tgt, CompoundTag pd, long now, long start, ServerLevel server) {
        long elapsed = now - start;
        if (elapsed == 0L) {
            pd.m_128347_("spiral_center_x", tgt.m_20185_());
            pd.m_128347_("spiral_center_z", tgt.m_20189_());
        }
        if (elapsed < 50L && elapsed % 2L == 0L) {
            double centerX = pd.m_128459_("spiral_center_x");
            double centerZ = pd.m_128459_("spiral_center_z");
            int spiralIndex = (int)(elapsed / 2L);
            double angle = (double)spiralIndex * 0.8975979010256552;
            double radius = (double)spiralIndex * 0.55;
            double x = centerX + Math.cos(angle) * radius;
            double z = centerZ + Math.sin(angle) * radius;
            BlockPos pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
            int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, spiralIndex * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, (double)y + 0.5, z, 4, 0.2, 0.2, 0.2, 0.05);
        }
        if (elapsed == 0L) {
            server.m_5594_(null, tgt.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 1.5f, 1.2f);
        }
        if (elapsed >= 50L) {
            PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
        }
    }

    private static void executeEvokerWall(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
        double dist = mob.m_20270_((Entity)tgt);
        double wallDist = Math.min(dist * 0.65, 8.0);
        Vec3 wallCenter = mob.m_20182_().m_82549_(dir.m_82490_(wallDist));
        Vec3 perpendicular = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_();
        for (int i = -7; i <= 7; ++i) {
            double x = wallCenter.f_82479_ + perpendicular.f_82479_ * (double)i * 1.1;
            double z = wallCenter.f_82481_ + perpendicular.f_82481_ * (double)i * 1.1;
            BlockPos pos = new BlockPos((int)x, (int)mob.m_20186_(), (int)z);
            int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, Math.abs(i) * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, wallCenter.f_82479_, wallCenter.f_82480_ + 0.5, wallCenter.f_82481_, 70, 7.0, 0.5, 0.5, 0.12);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 2.0f, 0.7f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerStar(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        int i;
        int points = 5;
        double outerRadius = 5.0;
        double innerRadius = 2.5;
        for (i = 0; i < points * 2; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)(points * 2);
            double radius = i % 2 == 0 ? outerRadius : innerRadius;
            double x = tgt.m_20185_() + Math.cos(angle) * radius;
            double z = tgt.m_20189_() + Math.sin(angle) * radius;
            BlockPos pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
            int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, i * 2, (LivingEntity)mob);
            server.m_7967_((Entity)fangs);
        }
        for (i = 0; i < points; ++i) {
            double angle1 = Math.PI * 2 * (double)(i * 2) / (double)(points * 2);
            double angle2 = Math.PI * 2 * (double)((i * 2 + 2) % (points * 2)) / (double)(points * 2);
            double x1 = tgt.m_20185_() + Math.cos(angle1) * outerRadius;
            double z1 = tgt.m_20189_() + Math.sin(angle1) * outerRadius;
            double x2 = tgt.m_20185_() + Math.cos(angle2) * outerRadius;
            double z2 = tgt.m_20189_() + Math.sin(angle2) * outerRadius;
            for (int j = 0; j <= 5; ++j) {
                double t = (double)j / 5.0;
                double x = x1 + (x2 - x1) * t;
                double z = z1 + (z2 - z1) * t;
                BlockPos pos = new BlockPos((int)x, (int)tgt.m_20186_(), (int)z);
                int y = server.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
                EvokerFangs fangs = new EvokerFangs((Level)server, x, (double)y, z, 0.0f, i * 6 + j, (LivingEntity)mob);
                server.m_7967_((Entity)fangs);
            }
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, tgt.m_20185_(), tgt.m_20186_() + 0.5, tgt.m_20189_(), 80, outerRadius, 0.5, outerRadius, 0.18);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, tgt.m_20185_(), tgt.m_20186_() + 1.0, tgt.m_20189_(), 60, outerRadius * 0.8, 0.8, outerRadius * 0.8, 0.12);
        server.m_5594_(null, tgt.m_20183_(), SoundEvents.f_11862_, SoundSource.HOSTILE, 2.5f, 0.6f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerShieldBurst(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        for (int i = 0; i < 360; i += 20) {
            double angle = Math.toRadians(i);
            double x = mob.m_20185_() + Math.cos(angle) * 3.2;
            double z = mob.m_20189_() + Math.sin(angle) * 3.2;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, mob.m_20186_() + 1.0, z, 5, 0.1, 0.1, 0.1, 0.05);
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12346_, SoundSource.HOSTILE, 1.0f, 0.7f);
        AABB hitbox = mob.m_20191_().m_82400_(4.0);
        List players = server.m_45976_(Player.class, hitbox);
        for (Player player : players) {
            if (!((double)player.m_20270_((Entity)mob) <= 4.0)) continue;
            player.m_6469_(mob.m_269291_().m_269425_(), 1.5f);
            Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            player.m_147240_(1.6, -dir.f_82479_, -dir.f_82481_);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 1));
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 10, 1.5, 0.5, 1.5, 0.1);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerSoulDrain(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        if ((double)mob.m_20270_((Entity)tgt) <= 6.0) {
            tgt.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1));
            float damage = 1.0f;
            tgt.m_6469_(mob.m_269291_().m_269425_(), damage);
            mob.m_5634_(damage * 0.2f);
            Vec3 start = tgt.m_20182_().m_82520_(0.0, (double)tgt.m_20192_() * 0.5, 0.0);
            Vec3 end = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_(), 0.0);
            Vec3 dir = end.m_82546_(start).m_82541_().m_82490_(0.35);
            for (int i = 0; i < 30; ++i) {
                double x = start.f_82479_ + dir.f_82479_ * (double)i;
                double y = start.f_82480_ + dir.f_82480_ * (double)i;
                double z = start.f_82481_ + dir.f_82481_ * (double)i;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 2, 0.1, 0.1, 0.1, 0.02);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, x, y, z, 1, 0.1, 0.1, 0.1, 0.0);
            }
        }
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerKnockbackWave(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        for (int i = 0; i < 360; i += 10) {
            double angle = Math.toRadians(i);
            double x = mob.m_20185_() + Math.cos(angle) * 6.0;
            double z = mob.m_20189_() + Math.sin(angle) * 6.0;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, mob.m_20186_() + 0.5, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        AABB hitbox = mob.m_20191_().m_82400_(6.0);
        List players = server.m_45976_(Player.class, hitbox);
        for (Player player : players) {
            double dist = player.m_20270_((Entity)mob);
            if (!(dist <= 6.0)) continue;
            Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            double strength = (7.0 - dist) * 0.5;
            player.m_20334_(dir.f_82479_ * strength, 0.5, dir.f_82481_ * strength);
            player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 1.5f);
            player.f_19864_ = true;
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.5f, 0.6f);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 15, 2.5, 0.5, 2.5, 0.1);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeEvokerVexSummon(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        int i;
        int vexCount = 2 + server.f_46441_.m_188503_(1);
        for (i = 0; i < vexCount; ++i) {
            LivingEntity possessedVex;
            if (FromTheCavesModEntities.POSSESSED_VEX.get() == null || (possessedVex = (LivingEntity)((EntityType)FromTheCavesModEntities.POSSESSED_VEX.get()).m_20615_((Level)server)) == null) continue;
            double angle = Math.PI * 2 * (double)i / (double)vexCount;
            double spawnX = mob.m_20185_() + Math.cos(angle) * 3.0;
            double spawnZ = mob.m_20189_() + Math.sin(angle) * 3.0;
            possessedVex.m_6034_(spawnX, mob.m_20186_() + 2.0, spawnZ);
            if (possessedVex instanceof Mob) {
                Mob vexMob = (Mob)possessedVex;
                vexMob.m_6710_((LivingEntity)tgt);
            }
            server.m_7967_((Entity)possessedVex);
        }
        for (i = 0; i < 70; ++i) {
            double offsetX = (server.f_46441_.m_188500_() - 0.5) * 4.0;
            double offsetY = server.f_46441_.m_188500_() * 3.0;
            double offsetZ = (server.f_46441_.m_188500_() - 0.5) * 4.0;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY, mob.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
        }
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11868_, SoundSource.HOSTILE, 0.9f, 0.7f);
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void executeVindicatorCharge(Mob mob, Player tgt, CompoundTag pd, long now, long start, ServerLevel server) {
        long elapsed = now - start;
        if (elapsed == 0L) {
            Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            pd.m_128347_("charge_dir_x", dir.f_82479_);
            pd.m_128347_("charge_dir_z", dir.f_82481_);
            server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 1.5f, 1.3f);
        }
        if (elapsed < 50L) {
            double dirX = pd.m_128459_("charge_dir_x");
            double dirZ = pd.m_128459_("charge_dir_z");
            mob.m_20334_(dirX * 1.0, mob.m_20184_().f_82480_, dirZ * 1.0);
            if (elapsed % 2L == 0L) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20185_(), mob.m_20186_() + 1.0, mob.m_20189_(), 3, 0.3, 0.3, 0.3, 0.0);
                server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, mob.m_20185_(), mob.m_20186_() + 0.1, mob.m_20189_(), 2, 0.2, 0.05, 0.2, 0.02);
            }
            AABB hitbox = mob.m_20191_().m_82400_(1.4);
            List players = server.m_45976_(Player.class, hitbox);
            for (Player player : players) {
                if (pd.m_128471_("charge_hit_" + String.valueOf(player.m_20148_()))) continue;
                player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 3.75f);
                Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                player.m_147240_(2.0, -dir.f_82479_, -dir.f_82481_);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
                pd.m_128379_("charge_hit_" + String.valueOf(player.m_20148_()), true);
                server.m_5594_(null, player.m_20183_(), SoundEvents.f_12314_, SoundSource.HOSTILE, 1.5f, 0.8f);
            }
        } else {
            AABB hitbox = mob.m_20191_().m_82400_(15.0);
            List players = server.m_45976_(Player.class, hitbox);
            for (Player player : players) {
                pd.m_128473_("charge_hit_" + String.valueOf(player.m_20148_()));
            }
            PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
        }
    }

    private static void executeVindicatorWhirlwind(Mob mob, Player tgt, CompoundTag pd, long now, long start, ServerLevel server) {
        long elapsed = now - start;
        if (elapsed < 50L) {
            double angle = (double)elapsed * 0.5 % (Math.PI * 2);
            double radius = 4.0;
            for (int i = 0; i < 12; ++i) {
                double particleAngle = angle + (double)i * Math.PI / 6.0;
                double x = mob.m_20185_() + Math.cos(particleAngle) * radius;
                double z = mob.m_20189_() + Math.sin(particleAngle) * radius;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x, mob.m_20186_() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (elapsed % 6L == 0L) {
                AABB hitbox = mob.m_20191_().m_82400_(radius);
                List players = server.m_45976_(Player.class, hitbox);
                for (Player player : players) {
                    if (!((double)player.m_20270_((Entity)mob) <= radius)) continue;
                    player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 1.5f);
                    Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                    player.m_147240_(0.7, -dir.f_82479_, -dir.f_82481_);
                }
                server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 1.3f, 0.7f);
            }
        } else {
            PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
        }
    }

    private static void executeVindicatorLeap(Mob mob, Player tgt, CompoundTag pd, long now, long start, ServerLevel server) {
        long elapsed = now - start;
        if (elapsed == 0L) {
            Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            mob.m_20334_(dir.f_82479_ * 1.3, 1.0, dir.f_82481_ * 1.3);
            server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12357_, SoundSource.HOSTILE, 1.5f, 1.1f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, mob.m_20185_(), mob.m_20186_() + 0.2, mob.m_20189_(), 15, 0.5, 0.2, 0.5, 0.05);
        }
        if (elapsed > 10L && (mob.m_20096_() || elapsed > 50L)) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 12, 1.5, 0.5, 1.5, 0.0);
            AABB hitbox = mob.m_20191_().m_82400_(3.5);
            List players = server.m_45976_(Player.class, hitbox);
            for (Player player : players) {
                if (!((double)player.m_20270_((Entity)mob) <= 3.5)) continue;
                player.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), 3.0f);
                Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                player.m_147240_(1.6, -dir.f_82479_, -dir.f_82481_);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0));
            }
            server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.5f, 0.9f);
            PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
        }
    }

    private static void executeVindicatorRage(Mob mob, Player tgt, CompoundTag pd, long now, ServerLevel server) {
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 140, 1));
        pd.m_128356_("vindicator_enrage_until", now + 140L);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20185_(), mob.m_20186_() + 1.5, mob.m_20189_(), 40, 0.6, 0.6, 0.6, 0.15);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12576_, SoundSource.HOSTILE, 2.0f, 0.5f);
        server.m_5594_(null, mob.m_20183_(), SoundEvents.f_12363_, SoundSource.HOSTILE, 1.5f, 0.8f);
        for (int i = 0; i < 30; ++i) {
            double offsetX = (server.f_46441_.m_188500_() - 0.5) * 1.5;
            double offsetY = server.f_46441_.m_188500_() * 2.5;
            double offsetZ = (server.f_46441_.m_188500_() - 0.5) * 1.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY, mob.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        AABB hitbox = mob.m_20191_().m_82400_(5.0);
        List players = server.m_45976_(Player.class, hitbox);
        for (Player player : players) {
            if (!((double)player.m_20270_((Entity)mob) <= 5.0)) continue;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 0));
        }
        PossessedIllagerAbilitiesProcedure.endAbility(mob, pd, now);
    }

    private static void endAbility(Mob mob, CompoundTag pd, long now) {
        pd.m_128405_("illager_ability_state", 0);
        pd.m_128356_("illager_last_ability_end", now);
        mob.m_21573_().m_26573_();
    }
}

