/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PressurePlateEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 4.5E-5;
    private static final double MAX_PROB_PHASE2 = 5.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int SOUND_DURATION = 300;
    private static final Map<Integer, PressurePlateEventState> activeEvents = new HashMap<Integer, PressurePlateEventState>();
    private static final Map<BlockPos, Long> plateCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.5E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validPlates = PressurePlateEventsProcedure.findValidPressurePlates(server, player);
        if (validPlates.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validPlates.removeIf(pos -> plateCooldowns.containsKey(pos) && currentTime < plateCooldowns.get(pos));
        if (validPlates.isEmpty()) {
            return;
        }
        BlockPos chosen = validPlates.get(server.m_213780_().m_188503_(validPlates.size()));
        BlockState state = server.m_8055_(chosen);
        boolean isStone = state.m_60734_() == Blocks.f_50165_ || state.m_60734_() == Blocks.f_50709_;
        plateCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new PressurePlateEventState(player, chosen, isStone));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, PressurePlateEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PressurePlateEventState> entry = iterator.next();
            PressurePlateEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            PressurePlateEventsProcedure.handleFootsteps(server, state);
            if (state.tickCount < 300 && state.stepsRemaining > 0) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidPressurePlates(ServerLevel server, Player player) {
        ArrayList<BlockPos> plates = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState blockState = server.m_8055_(pos);
                    if (!(blockState.m_60734_() instanceof PressurePlateBlock)) continue;
                    plates.add(pos.m_7949_());
                }
            }
        }
        return plates;
    }

    private static void handleFootsteps(ServerLevel server, PressurePlateEventState state) {
        if (state.tickCount >= state.nextStepTick && state.stepsRemaining > 0) {
            int currentStep = state.totalSteps - state.stepsRemaining;
            float volume = 0.4f + (float)currentStep * 0.1f;
            volume = Math.min(volume, 1.2f);
            float pitch = 0.7f + server.m_213780_().m_188501_() * 0.2f;
            int offsetX = (int)((double)(currentStep - state.totalSteps / 2) * 0.5);
            int offsetZ = (int)((double)(currentStep - state.totalSteps / 2) * 0.5);
            BlockPos stepPos = state.platePos.m_7918_(offsetX, 0, offsetZ);
            if (state.isStone) {
                server.m_5594_(null, stepPos, SoundEvents.f_12450_, SoundSource.BLOCKS, volume, pitch);
            } else {
                server.m_5594_(null, stepPos, SoundEvents.f_12638_, SoundSource.BLOCKS, volume, pitch);
            }
            --state.stepsRemaining;
            if (state.stepsRemaining == 0) {
                server.m_7654_().m_6937_((Runnable)new TickTask(server.m_7654_().m_129921_() + 12, () -> server.m_5594_(null, state.platePos, SoundEvents.f_12449_, SoundSource.BLOCKS, 1.0f, 0.8f)));
            } else {
                state.nextStepTick = state.tickCount + 12 + server.m_213780_().m_188503_(4);
            }
        }
    }

    private static class PressurePlateEventState {
        Player player;
        BlockPos platePos;
        int tickCount;
        int stepsRemaining;
        int nextStepTick;
        int totalSteps;
        boolean isStone;

        PressurePlateEventState(Player player, BlockPos platePos, boolean isStone) {
            this.player = player;
            this.platePos = platePos;
            this.tickCount = 0;
            this.stepsRemaining = this.totalSteps = 4 + player.m_9236_().m_213780_().m_188503_(6);
            this.nextStepTick = 12 + player.m_9236_().m_213780_().m_188503_(4);
            this.isStone = isStone;
        }
    }
}

