/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.SetPlayerSpawnInVillageProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConduitBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FletchingTableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PitcherCropBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.PlayerWallHeadBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.TwistingVinesPlantBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.WeepingVinesBlock;
import net.minecraft.world.level.block.WeepingVinesPlantBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProtectedBlocksProcedure {
    private static final Map<BlockPos, BlockData> blockDataCache = new ConcurrentHashMap<BlockPos, BlockData>();
    private static final Set<BlockPos> modCausedBreaks = ConcurrentHashMap.newKeySet();
    private static long tickCounter = 0L;
    private static final long CLEANUP_INTERVAL = 1200L;
    private static final long MAX_CACHE_AGE = 2400L;
    private static final int MAX_CACHE_SIZE = 1500;
    private static final Set<Class<? extends Block>> PROTECTED_CLASSES = new HashSet<Class>(Arrays.asList(BarrelBlock.class, BedBlock.class, BeaconBlock.class, BlastFurnaceBlock.class, BrewingStandBlock.class, ButtonBlock.class, ChestBlock.class, CommandBlock.class, ComparatorBlock.class, DaylightDetectorBlock.class, DispenserBlock.class, DoorBlock.class, DropperBlock.class, EnderChestBlock.class, FenceGateBlock.class, FurnaceBlock.class, HopperBlock.class, JigsawBlock.class, JukeboxBlock.class, LadderBlock.class, LecternBlock.class, LightBlock.class, NoteBlock.class, ObserverBlock.class, PistonBaseBlock.class, PressurePlateBlock.class, RedStoneOreBlock.class, RedStoneWireBlock.class, RedstoneLampBlock.class, RedstoneTorchBlock.class, RedstoneWallTorchBlock.class, RepeaterBlock.class, ShulkerBoxBlock.class, SmokerBlock.class, StructureBlock.class, TrapDoorBlock.class, TripWireBlock.class, TripWireHookBlock.class, WeightedPressurePlateBlock.class, CropBlock.class, StemBlock.class, AttachedStemBlock.class, NetherWartBlock.class, BambooStalkBlock.class, SugarCaneBlock.class, CactusBlock.class, CocoaBlock.class, SweetBerryBushBlock.class, CaveVinesBlock.class, CaveVinesPlantBlock.class, BannerBlock.class, WallBannerBlock.class, WallSignBlock.class, StandingSignBlock.class, CeilingHangingSignBlock.class, WallHangingSignBlock.class, TorchBlock.class, WallTorchBlock.class, RedstoneTorchBlock.class, RedstoneWallTorchBlock.class, LanternBlock.class, ChainBlock.class, EndRodBlock.class, LightningRodBlock.class, CandleBlock.class, CandleCakeBlock.class, BaseRailBlock.class, PoweredRailBlock.class, DetectorRailBlock.class, RailBlock.class, TargetBlock.class, BellBlock.class, LeverBlock.class, AbstractCandleBlock.class, FlowerBlock.class, TallFlowerBlock.class, DoublePlantBlock.class, SaplingBlock.class, MushroomBlock.class, DeadBushBlock.class, TallGrassBlock.class, SeagrassBlock.class, TallSeagrassBlock.class, KelpBlock.class, KelpPlantBlock.class, SeaPickleBlock.class, BambooSaplingBlock.class, TwistingVinesBlock.class, TwistingVinesPlantBlock.class, WeepingVinesBlock.class, WeepingVinesPlantBlock.class, GlowLichenBlock.class, SculkVeinBlock.class, SporeBlossomBlock.class, AzaleaBlock.class, BigDripleafBlock.class, BigDripleafStemBlock.class, SmallDripleafBlock.class, HangingRootsBlock.class, WaterlilyBlock.class, PitcherCropBlock.class, TorchflowerCropBlock.class, PinkPetalsBlock.class, VineBlock.class, SnowLayerBlock.class, CakeBlock.class, ScaffoldingBlock.class, SculkSensorBlock.class, CalibratedSculkSensorBlock.class, GrindstoneBlock.class, EnchantmentTableBlock.class, ConduitBlock.class, RespawnAnchorBlock.class, LoomBlock.class, StonecutterBlock.class, CartographyTableBlock.class, SmithingTableBlock.class, FletchingTableBlock.class, CraftingTableBlock.class, ComposterBlock.class, CarvedPumpkinBlock.class, SkullBlock.class, PlayerHeadBlock.class, PlayerWallHeadBlock.class, DecoratedPotBlock.class, FlowerPotBlock.class));
    private static final String[] PROTECTED_KEYWORDS = new String[]{"bed", "chest", "barrel", "furnace", "blast_furnace", "smoker", "brewing_stand", "dispenser", "dropper", "hopper", "shulker_box", "ender_chest", "beacon", "jukebox", "note_block", "lectern", "command_block", "jigsaw", "structure_block", "comparator", "repeater", "observer", "daylight_detector", "redstone_lamp", "redstone_torch", "redstone_wire", "redstone_block", "redstone_ore", "redstone", "deepslate_redstone_ore", "lever", "button", "pressure_plate", "weighted_pressure_plate", "target", "tripwire", "tripwire_hook", "trapped_chest", "piston", "sticky_piston", "slime_block", "honey_block", "door", "trapdoor", "fence_gate", "ladder", "scaffolding", "rail", "powered_rail", "detector_rail", "activator_rail", "sensor", "calibrated_sculk_sensor", "sculk_sensor", "lightning_rod", "crafter", "minecart", "boat", "armor_stand", "item_frame", "glow_item_frame", "painting", "sign", "hanging_sign", "wheat", "carrots", "potatoes", "beetroots", "melon_stem", "pumpkin_stem", "attached_melon_stem", "attached_pumpkin_stem", "cocoa", "nether_wart", "sweet_berry_bush", "cave_vines", "glow_berries", "torchflower_crop", "pitcher_crop", "torchflower", "pitcher_plant", "bamboo", "bamboo_sapling", "sugar_cane", "cactus", "chorus_flower", "chorus_plant", "kelp", "seagrass", "sea_pickle", "vine", "twisting_vines", "weeping_vines", "glow_lichen", "sculk_vein", "spore_blossom", "azalea", "flowering_azalea", "big_dripleaf", "small_dripleaf", "hanging_roots", "lily_pad", "pink_petals", "torch", "soul_torch", "lantern", "soul_lantern", "chain", "end_rod", "candle", "bell", "flower", "rose", "tulip", "orchid", "allium", "bluet", "daisy", "cornflower", "lily", "wither_rose", "sunflower", "lilac", "peony", "fern", "dead_bush", "mushroom", "sapling", "banner", "carpet", "snow", "cake", "storage", "grindstone", "enchanting_table", "enchantment_table", "conduit", "respawn_anchor", "loom", "stonecutter", "cartography_table", "smithing_table", "fletching_table", "crafting_table", "composter", "carved_pumpkin", "jack_o_lantern", "skull", "head", "skeleton_skull", "wither_skeleton_skull", "zombie_head", "creeper_head", "dragon_head", "piglin_head", "player_head", "decorated_pot", "flower_pot", "mechanical", "kinetic", "cogwheel", "gearbox", "clutch", "gearshift", "sequenced_gearshift", "rotation_speed_controller", "belt", "motor", "encased", "shaft", "deployer", "harvester", "plough", "saw", "drill", "millstone", "crushing_wheel", "mechanical_press", "mechanical_mixer", "basin", "blaze_burner", "flywheel", "speedometer", "stressometer", "gauge", "fluid_tank", "item_vault", "andesite_funnel", "brass_funnel", "andesite_tunnel", "brass_tunnel", "chute", "smart_chute", "depot", "weighted_ejector", "contraption", "piston_extension_pole", "mechanical_piston", "sticky_mechanical_piston", "windmill_bearing", "mechanical_bearing", "clockwork_bearing", "rope_pulley", "hose_pulley", "cart_assembler", "linear_chassis", "radial_chassis", "super_glue", "sticker", "redstone_link", "analog_lever", "powered_toggle_latch", "powered_latch", "pulse_repeater", "flex_crate", "adjustable_crate", "stockpile_switch", "content_observer", "mechanical_arm", "spout", "item_drain", "smart_observer", "threshold_switch", "nixie_tube", "display_link", "display_board", "schematicannon", "schematic_table", "creative_motor", "creative_fluid_tank", "creative_crate", "candle", "painting", "armor", "armorstand", "itemframe"};

    public static boolean isProtected(BlockState state) {
        if (state == null) {
            return false;
        }
        Block block = state.m_60734_();
        for (Class<? extends Block> clazz : PROTECTED_CLASSES) {
            if (!clazz.isInstance(block)) continue;
            return true;
        }
        try {
            Holder holder = state.m_222976_();
            TagKey redstoneTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "redstone"));
            if (holder.m_203656_(redstoneTag)) {
                return true;
            }
            TagKey createTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("create", "all"));
            if (holder.m_203656_(createTag)) {
                return true;
            }
            TagKey railsTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "rails"));
            if (holder.m_203656_(railsTag)) {
                return true;
            }
            TagKey flowersTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "flowers"));
            if (holder.m_203656_(flowersTag)) {
                return true;
            }
            TagKey cropsTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "crops"));
            if (holder.m_203656_(cropsTag)) {
                return true;
            }
            TagKey signsTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "signs"));
            if (holder.m_203656_(signsTag)) {
                return true;
            }
            TagKey bannersTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "banners"));
            if (holder.m_203656_(bannersTag)) {
                return true;
            }
            TagKey candlesTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "candles"));
            if (holder.m_203656_(candlesTag)) {
                return true;
            }
        }
        catch (Exception holder) {
            // empty catch block
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id != null) {
            String idString = id.toString().toLowerCase();
            String namespace = id.m_135827_().toLowerCase();
            if (SetPlayerSpawnInVillageProcedure.isModIdProtected(namespace)) {
                return true;
            }
            if (idString.startsWith("create:")) {
                return true;
            }
            for (String keyword : PROTECTED_KEYWORDS) {
                if (!idString.contains(keyword)) continue;
                return true;
            }
        }
        return false;
    }

    public static void markModCausedBreak(BlockPos pos) {
        modCausedBreaks.add(pos.m_7949_());
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        if (modCausedBreaks.contains(pos)) {
            modCausedBreaks.remove(pos);
            if (!ProtectedBlocksProcedure.isProtected(event.getState())) {
                return;
            }
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)levelAccessor;
                ProtectedBlocksProcedure.cacheBlockData(server, pos);
            }
            event.setCanceled(true);
            if (event.hasResult()) {
                event.setResult(Event.Result.DENY);
            }
            return;
        }
        if (event.getPlayer() != null) {
            return;
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List blocks = event.getAffectedBlocks();
        blocks.removeIf(pos -> {
            BlockState state;
            if (modCausedBreaks.contains(pos) && ProtectedBlocksProcedure.isProtected(state = server.m_8055_(pos))) {
                ProtectedBlocksProcedure.cacheBlockData(server, pos);
                modCausedBreaks.remove(pos);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        BlockData data = blockDataCache.get(pos);
        if (data != null && level.m_8055_(pos).m_60795_()) {
            ProtectedBlocksProcedure.restoreProtectedBlock(level, pos, data.state, data.data);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        blockDataCache.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            return pos.m_123341_() >> 4 == chunkX && pos.m_123343_() >> 4 == chunkZ;
        });
        modCausedBreaks.removeIf(pos -> pos.m_123341_() >> 4 == chunkX && pos.m_123343_() >> 4 == chunkZ);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 1200L) {
            return;
        }
        tickCounter = 0L;
        long currentTime = event.getServer().m_129783_().m_46467_();
        blockDataCache.entrySet().removeIf(entry -> currentTime - ((BlockData)entry.getValue()).timestamp > 2400L);
        if (blockDataCache.size() > 1500) {
            blockDataCache.entrySet().stream().sorted(Comparator.comparingLong(e -> ((BlockData)e.getValue()).timestamp)).limit(blockDataCache.size() - 1500).map(Map.Entry::getKey).forEach(blockDataCache::remove);
        }
        modCausedBreaks.clear();
    }

    public static void cacheBlockData(ServerLevel level, BlockPos pos) {
        if (level == null || pos == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!ProtectedBlocksProcedure.isProtected(state)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
        blockDataCache.put(pos.m_7949_(), new BlockData(state, data, level.m_46467_()));
    }

    private static CompoundTag saveContainerContents(BlockEntity blockEntity) {
        if (!(blockEntity instanceof Container)) {
            return null;
        }
        Container container = (Container)blockEntity;
        CompoundTag tag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            items.m_128365_("Slot" + i, (Tag)itemTag);
        }
        tag.m_128365_("Items", (Tag)items);
        tag.m_128405_("Size", container.m_6643_());
        return tag;
    }

    private static void restoreContainerContents(BlockEntity blockEntity, CompoundTag tag) {
        Container container;
        block4: {
            block3: {
                if (!(blockEntity instanceof Container)) break block3;
                container = (Container)blockEntity;
                if (tag != null && tag.m_128441_("Items")) break block4;
            }
            return;
        }
        CompoundTag items = tag.m_128469_("Items");
        for (int i = 0; i < container.m_6643_(); ++i) {
            String key = "Slot" + i;
            if (!items.m_128441_(key)) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)items.m_128469_(key));
            container.m_6836_(i, stack);
        }
        blockEntity.m_6596_();
    }

    public static void restoreProtectedBlock(ServerLevel level, BlockPos pos, BlockState state, CompoundTag data) {
        BlockEntity blockEntity;
        if (level == null || pos == null || state == null) {
            return;
        }
        level.m_7731_(pos, state, 3);
        if (data != null && (blockEntity = level.m_7702_(pos)) != null) {
            ProtectedBlocksProcedure.restoreContainerContents(blockEntity, data);
        }
        blockDataCache.remove(pos);
    }

    private static class BlockData {
        final BlockState state;
        final CompoundTag data;
        final long timestamp;

        BlockData(BlockState state, CompoundTag data, long timestamp) {
            this.state = state;
            this.data = data;
            this.timestamp = timestamp;
        }
    }
}

