/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RBBSlowerProcedure {
    private static final long RESTORE_DELAY_TICKS = 500L;
    private static final int GRAVITY_SCAN_RADIUS = 8;
    private static final int GRAVITY_SCAN_HEIGHT = 16;
    private static final long GRAVITY_SNAPSHOT_MAX_AGE = 200L;
    private static final int MAX_RESTORE_ATTEMPTS = 5;
    private static final long BLOCK_STATE_CACHE_SIZE = 2000L;
    private static final Map<ResourceKey<Level>, List<BrokenBlockInfo>> pendingRestores = new ConcurrentHashMap<ResourceKey<Level>, List<BrokenBlockInfo>>();
    private static final Map<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>> gravitySnapshots = new ConcurrentHashMap<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>>();
    private static final Map<BlockPos, Long> recentRestores = new ConcurrentHashMap<BlockPos, Long>();
    private static final Set<Block> GRAVITY_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.f_49992_, Blocks.f_49993_, Blocks.f_49994_, Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_, Blocks.f_50506_, Blocks.f_50507_, Blocks.f_50508_, Blocks.f_50509_, Blocks.f_50510_, Blocks.f_50511_, Blocks.f_50512_, Blocks.f_50513_, Blocks.f_50514_, Blocks.f_50515_, Blocks.f_50516_, Blocks.f_50517_, Blocks.f_50518_, Blocks.f_50519_, Blocks.f_50573_, Blocks.f_50574_, Blocks.f_50260_, Blocks.f_50616_));
    private static final Set<Block> DEPENDENT_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50123_, Blocks.f_50146_, Blocks.f_50328_, Blocks.f_50164_, Blocks.f_50124_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50308_, Blocks.f_50309_, Blocks.f_50669_, Blocks.f_50670_, Blocks.f_50710_, Blocks.f_220846_, Blocks.f_271396_, Blocks.f_244625_, Blocks.f_50081_, Blocks.f_50082_, Blocks.f_50139_, Blocks.f_50140_, Blocks.f_50683_, Blocks.f_50684_, Blocks.f_50156_, Blocks.f_50030_, Blocks.f_50031_, Blocks.f_50285_, Blocks.f_50336_, Blocks.f_50337_, Blocks.f_50338_, Blocks.f_50339_, Blocks.f_50340_, Blocks.f_50341_, Blocks.f_50342_, Blocks.f_50343_, Blocks.f_50344_, Blocks.f_50345_, Blocks.f_50346_, Blocks.f_50347_, Blocks.f_50348_, Blocks.f_50349_, Blocks.f_50350_, Blocks.f_50351_, Blocks.f_152543_, Blocks.f_50165_, Blocks.f_50167_, Blocks.f_50168_, Blocks.f_50169_, Blocks.f_50170_, Blocks.f_50171_, Blocks.f_50172_, Blocks.f_50659_, Blocks.f_50660_, Blocks.f_50709_, Blocks.f_220840_, Blocks.f_271227_, Blocks.f_244183_, Blocks.f_50326_, Blocks.f_50327_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50716_, Blocks.f_50261_, Blocks.f_50112_, Blocks.f_50111_, Blocks.f_50113_, Blocks.f_50114_, Blocks.f_50115_, Blocks.f_50116_, Blocks.f_50117_, Blocks.f_50118_, Blocks.f_50119_, Blocks.f_50120_, Blocks.f_50121_, Blocks.f_50071_, Blocks.f_50070_, Blocks.f_50355_, Blocks.f_50356_, Blocks.f_50357_, Blocks.f_50358_, Blocks.f_50359_, Blocks.f_50360_, Blocks.f_50072_, Blocks.f_50073_, Blocks.f_50700_, Blocks.f_50691_, Blocks.f_50654_, Blocks.f_50693_, Blocks.f_50694_, Blocks.f_50036_, Blocks.f_50034_, Blocks.f_50035_, Blocks.f_50130_, Blocks.f_50092_, Blocks.f_50249_, Blocks.f_50250_, Blocks.f_50444_, Blocks.f_50685_, Blocks.f_50190_, Blocks.f_50189_, Blocks.f_50188_, Blocks.f_50187_, Blocks.f_50262_, Blocks.f_50200_, Blocks.f_50491_, Blocks.f_50490_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50567_, Blocks.f_50571_, Blocks.f_50570_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50702_, Blocks.f_50703_, Blocks.f_152475_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_152540_, Blocks.f_152541_, Blocks.f_152542_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_152548_, Blocks.f_50196_, Blocks.f_271329_, Blocks.f_276668_, Blocks.f_276665_, Blocks.f_271410_, Blocks.f_271445_, Blocks.f_50095_, Blocks.f_50149_, Blocks.f_50150_, Blocks.f_50152_, Blocks.f_50151_, Blocks.f_50153_, Blocks.f_50673_, Blocks.f_50674_, Blocks.f_220841_, Blocks.f_271516_, Blocks.f_244433_, Blocks.f_50158_, Blocks.f_50159_, Blocks.f_50160_, Blocks.f_50162_, Blocks.f_50161_, Blocks.f_50163_, Blocks.f_50675_, Blocks.f_50676_, Blocks.f_220839_, Blocks.f_271107_, Blocks.f_244608_, Blocks.f_244319_, Blocks.f_244633_, Blocks.f_243890_, Blocks.f_244263_, Blocks.f_243716_, Blocks.f_243960_, Blocks.f_244147_, Blocks.f_244396_, Blocks.f_244485_, Blocks.f_271116_, Blocks.f_244091_, Blocks.f_244093_, Blocks.f_243895_, Blocks.f_244296_, Blocks.f_243897_, Blocks.f_243773_, Blocks.f_243998_, Blocks.f_244281_, Blocks.f_244241_, Blocks.f_244385_, Blocks.f_271427_, Blocks.f_244462_, Blocks.f_50155_, Blocks.f_50616_, Blocks.f_50681_, Blocks.f_50682_, Blocks.f_50184_, Blocks.f_50145_, Blocks.f_50125_, Blocks.f_50191_, Blocks.f_152539_, Blocks.f_220856_, Blocks.f_50414_, Blocks.f_50415_, Blocks.f_50416_, Blocks.f_50417_, Blocks.f_50418_, Blocks.f_50419_, Blocks.f_50420_, Blocks.f_50421_, Blocks.f_50422_, Blocks.f_50423_, Blocks.f_50424_, Blocks.f_50425_, Blocks.f_50426_, Blocks.f_50427_, Blocks.f_50428_, Blocks.f_50429_, Blocks.f_50430_, Blocks.f_50431_, Blocks.f_50432_, Blocks.f_50433_, Blocks.f_50434_, Blocks.f_50435_, Blocks.f_50436_, Blocks.f_50437_, Blocks.f_50438_, Blocks.f_50439_, Blocks.f_50388_, Blocks.f_50389_, Blocks.f_50390_, Blocks.f_50391_, Blocks.f_50392_, Blocks.f_50393_, Blocks.f_50680_, Blocks.f_152482_, Blocks.f_152483_, Blocks.f_152484_, Blocks.f_152511_, Blocks.f_152512_, Blocks.f_152513_, Blocks.f_152514_, Blocks.f_152515_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152518_, Blocks.f_152519_, Blocks.f_152520_, Blocks.f_152521_, Blocks.f_152522_, Blocks.f_152523_, Blocks.f_152524_, Blocks.f_152525_, Blocks.f_152526_, Blocks.f_152527_, Blocks.f_152528_, Blocks.f_152529_, Blocks.f_152530_, Blocks.f_152531_, Blocks.f_152532_, Blocks.f_152533_, Blocks.f_152534_, Blocks.f_152535_, Blocks.f_152536_, Blocks.f_152485_, Blocks.f_152486_, Blocks.f_152487_, Blocks.f_152488_, Blocks.f_152489_, Blocks.f_50489_, Blocks.f_152587_, Blocks.f_50128_));
    private static final Set<Block> CONNECTABLE_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.f_50132_, Blocks.f_50479_, Blocks.f_50480_, Blocks.f_50481_, Blocks.f_50482_, Blocks.f_50483_, Blocks.f_50661_, Blocks.f_50662_, Blocks.f_220852_, Blocks.f_271219_, Blocks.f_244641_, Blocks.f_50198_, Blocks.f_50274_, Blocks.f_50275_, Blocks.f_50609_, Blocks.f_50607_, Blocks.f_50611_, Blocks.f_50615_, Blocks.f_50608_, Blocks.f_50613_, Blocks.f_50606_, Blocks.f_50604_, Blocks.f_50605_, Blocks.f_50612_, Blocks.f_50614_, Blocks.f_50732_, Blocks.f_50711_, Blocks.f_50740_, Blocks.f_152558_, Blocks.f_152592_, Blocks.f_152562_, Blocks.f_152554_, Blocks.f_220854_, Blocks.f_50185_, Blocks.f_50303_, Blocks.f_50304_, Blocks.f_50305_, Blocks.f_50306_, Blocks.f_50307_, Blocks.f_50361_, Blocks.f_50362_, Blocks.f_50363_, Blocks.f_50364_, Blocks.f_50365_, Blocks.f_50366_, Blocks.f_50367_, Blocks.f_50368_, Blocks.f_50369_, Blocks.f_50370_, Blocks.f_50371_, Blocks.f_50183_, Blocks.f_50184_, Blocks.f_50267_));

    private static void captureGravityBlocksInArea(ServerLevel server, BlockPos centerPos) {
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        ResourceKey dimension = server.m_46472_();
        Map gravityMap = gravitySnapshots.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ConcurrentHashMap());
        long currentTick = server.m_46467_();
        for (int x = -8; x <= 8; ++x) {
            for (int y = -2; y <= 16; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(checkPos);
                    if (!GRAVITY_BLOCKS.contains(state.m_60734_()) || gravityMap.containsKey(checkPos)) continue;
                    CompoundTag nbt = RBBSlowerProcedure.captureCompleteBlockEntityData(server.m_7702_(checkPos));
                    gravityMap.put(checkPos.m_7949_(), new GravityBlockSnapshot(checkPos.m_7949_(), state, nbt, currentTick));
                }
            }
        }
    }

    private static List<DependentBlockInfo> collectFallenGravityBlocks(ServerLevel server, BlockPos centerPos) {
        ArrayList<DependentBlockInfo> fallen = new ArrayList<DependentBlockInfo>();
        ResourceKey dimension = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravitySnapshots.get(dimension);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return fallen;
        }
        gravityMap.entrySet().removeIf(entry -> {
            BlockPos originalPos = (BlockPos)entry.getKey();
            GravityBlockSnapshot snapshot = (GravityBlockSnapshot)entry.getValue();
            BlockState currentState = server.m_8055_(originalPos);
            if (currentState.m_60795_() || !currentState.m_60713_(snapshot.state.m_60734_())) {
                CompoundTag fullData = RBBSlowerProcedure.captureFullBlockStateProperties(snapshot.state);
                fallen.add(new DependentBlockInfo(snapshot.originalPos, snapshot.state, snapshot.blockEntityNbt, fullData));
                return true;
            }
            return false;
        });
        if (gravityMap.isEmpty()) {
            gravitySnapshots.remove(dimension);
        }
        return fallen;
    }

    private static List<DependentBlockInfo> findDependentBlocks(ServerLevel server, BlockPos pos) {
        BlockPos[] positions;
        ArrayList<DependentBlockInfo> dependents = new ArrayList<DependentBlockInfo>();
        for (BlockPos checkPos : positions = new BlockPos[]{pos.m_7494_(), pos.m_6630_(2), pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7495_()}) {
            BlockState state = server.m_8055_(checkPos);
            Block block = state.m_60734_();
            if (!DEPENDENT_BLOCKS.contains(block) && !ProtectedBlocksProcedure.isProtected(state)) continue;
            if (ProtectedBlocksProcedure.isProtected(state)) {
                ProtectedBlocksProcedure.markModCausedBreak(checkPos);
                ProtectedBlocksProcedure.cacheBlockData(server, checkPos);
                continue;
            }
            CompoundTag nbt = RBBSlowerProcedure.captureCompleteBlockEntityData(server.m_7702_(checkPos));
            CompoundTag fullData = RBBSlowerProcedure.captureFullBlockStateProperties(state);
            dependents.add(new DependentBlockInfo(checkPos.m_7949_(), state, nbt, fullData));
        }
        return dependents;
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos) {
        RBBSlowerProcedure.destroyAndRecord(server, pos, false);
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos, boolean dropItems) {
        if (server == null || pos == null) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllowGriefEnabled()) {
            return;
        }
        BlockState state = server.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        if (ProtectedBlocksProcedure.isProtected(state)) {
            ProtectedBlocksProcedure.markModCausedBreak(pos);
            ProtectedBlocksProcedure.cacheBlockData(server, pos);
            return;
        }
        boolean isGravityBlock = GRAVITY_BLOCKS.contains(state.m_60734_());
        if (isGravityBlock) {
            RBBSlowerProcedure.captureGravityBlocksInArea(server, pos);
        }
        List<DependentBlockInfo> dependents = RBBSlowerProcedure.findDependentBlocks(server, pos);
        CompoundTag blockEntityNbt = RBBSlowerProcedure.captureCompleteBlockEntityData(server.m_7702_(pos));
        CompoundTag fullStateData = RBBSlowerProcedure.captureFullBlockStateProperties(state);
        boolean hasCustomData = blockEntityNbt != null && RBBSlowerProcedure.hasImportantCustomData(server.m_7702_(pos));
        for (DependentBlockInfo dep : dependents) {
            RBBSlowerProcedure.safeDestroyBlock(server, dep.pos, false);
        }
        RBBSlowerProcedure.safeDestroyBlock(server, pos, dropItems);
        if (isGravityBlock) {
            server.m_7654_().execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<DependentBlockInfo> fallen = RBBSlowerProcedure.collectFallenGravityBlocks(server, pos);
                dependents.addAll(fallen);
            });
        }
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        long restoreTick = server.m_46467_() + 500L;
        ResourceKey dimension = server.m_46472_();
        pendingRestores.computeIfAbsent((ResourceKey<Level>)dimension, k -> Collections.synchronizedList(new ArrayList())).add(new BrokenBlockInfo(pos.m_7949_(), state, blockEntityNbt, fullStateData, restoreTick, dependents, hasCustomData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        RBBSlowerProcedure.cleanupOldGravitySnapshots(server);
        RBBSlowerProcedure.cleanupRecentRestores(server);
        ResourceKey dimension = server.m_46472_();
        List<BrokenBlockInfo> pendingList = pendingRestores.get(dimension);
        if (pendingList == null || pendingList.isEmpty()) {
            return;
        }
        long currentTick = server.m_46467_();
        List<BrokenBlockInfo> list = pendingList;
        synchronized (list) {
            pendingList.removeIf(info -> {
                if (currentTick >= info.restoreAtTick) {
                    RBBSlowerProcedure.restoreBlock(server, info);
                    return true;
                }
                return false;
            });
            if (pendingList.isEmpty()) {
                pendingRestores.remove(dimension);
            }
        }
    }

    private static void restoreBlock(ServerLevel server, BrokenBlockInfo info) {
        if (recentRestores.containsKey(info.pos)) {
            long lastRestore = recentRestores.get(info.pos);
            if (server.m_46467_() - lastRestore < 20L) {
                return;
            }
        }
        for (int attempt = 0; attempt < 5; ++attempt) {
            try {
                BlockEntity blockEntity;
                if (!server.m_8055_(info.pos).m_60795_()) break;
                server.m_7731_(info.pos, info.state, 3);
                if (info.fullBlockStateData != null) {
                    RBBSlowerProcedure.restoreBlockStateProperties(server, info.pos, info.state, info.fullBlockStateData);
                }
                if (info.blockEntityNbt != null && (blockEntity = server.m_7702_(info.pos)) != null) {
                    if (info.hasCustomData) {
                        RBBSlowerProcedure.restoreCompleteBlockEntity(blockEntity, info.blockEntityNbt);
                    } else {
                        RBBSlowerProcedure.restoreBlockEntityFromNbt(blockEntity, info.blockEntityNbt);
                    }
                    blockEntity.m_6596_();
                    server.m_7260_(info.pos, info.state, info.state, 3);
                }
                if (CONNECTABLE_BLOCKS.contains(info.state.m_60734_())) {
                    RBBSlowerProcedure.updateConnections(server, info.pos);
                }
                recentRestores.put(info.pos.m_7949_(), server.m_46467_());
                break;
            }
            catch (Throwable t) {
                if (attempt != 4) continue;
                try {
                    server.m_7731_(info.pos, info.state, 2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                continue;
            }
        }
        for (DependentBlockInfo dep : info.dependents) {
            try {
                BlockEntity depEntity;
                if (!server.m_8055_(dep.pos).m_60795_()) continue;
                server.m_7731_(dep.pos, dep.state, 3);
                if (dep.fullBlockStateData != null) {
                    RBBSlowerProcedure.restoreBlockStateProperties(server, dep.pos, dep.state, dep.fullBlockStateData);
                }
                if (dep.blockEntityNbt != null && (depEntity = server.m_7702_(dep.pos)) != null) {
                    RBBSlowerProcedure.restoreCompleteBlockEntity(depEntity, dep.blockEntityNbt);
                    depEntity.m_6596_();
                }
                if (!CONNECTABLE_BLOCKS.contains(dep.state.m_60734_())) continue;
                RBBSlowerProcedure.updateConnections(server, dep.pos);
            }
            catch (Throwable throwable) {}
        }
    }

    private static void updateConnections(ServerLevel server, BlockPos pos) {
        BlockState neighborState;
        BlockPos neighborPos;
        BlockState currentState;
        BlockState updatedState = currentState = server.m_8055_(pos);
        for (Direction dir : Direction.values()) {
            neighborPos = pos.m_121945_(dir);
            neighborState = server.m_8055_(neighborPos);
            updatedState = updatedState.m_60728_(dir, neighborState, (LevelAccessor)server, pos, neighborPos);
        }
        if (!updatedState.equals(currentState)) {
            server.m_7731_(pos, updatedState, 3);
        }
        for (Direction dir : Direction.values()) {
            BlockState updatedNeighbor;
            neighborPos = pos.m_121945_(dir);
            neighborState = server.m_8055_(neighborPos);
            if (!CONNECTABLE_BLOCKS.contains(neighborState.m_60734_()) || (updatedNeighbor = neighborState.m_60728_(dir.m_122424_(), updatedState, (LevelAccessor)server, neighborPos, pos)).equals(neighborState)) continue;
            server.m_7731_(neighborPos, updatedNeighbor, 3);
        }
    }

    private static void cleanupOldGravitySnapshots(ServerLevel server) {
        ResourceKey dimension = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravitySnapshots.get(dimension);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return;
        }
        long currentTick = server.m_46467_();
        gravityMap.entrySet().removeIf(entry -> currentTick - ((GravityBlockSnapshot)entry.getValue()).capturedTick > 200L);
        if (gravityMap.isEmpty()) {
            gravitySnapshots.remove(dimension);
        }
    }

    private static void cleanupRecentRestores(ServerLevel server) {
        if ((long)recentRestores.size() < 2000L) {
            return;
        }
        long currentTick = server.m_46467_();
        recentRestores.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 100L);
    }

    private static void safeDestroyBlock(ServerLevel server, BlockPos pos, boolean dropItems) {
        try {
            server.m_46961_(pos, dropItems);
        }
        catch (Throwable t) {
            try {
                server.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static CompoundTag captureCompleteBlockEntityData(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        CompoundTag completeTag = new CompoundTag();
        CompoundTag basicNbt = RBBSlowerProcedure.captureBlockEntityNbt(blockEntity);
        if (basicNbt != null) {
            completeTag.m_128365_("BasicData", (Tag)basicNbt);
        }
        if (blockEntity instanceof BannerBlockEntity) {
            BannerBlockEntity banner = (BannerBlockEntity)blockEntity;
            CompoundTag bannerData = new CompoundTag();
            try {
                ItemStack itemStack = new ItemStack((ItemLike)banner.m_58900_().m_60734_());
                banner.m_187476_(itemStack);
                CompoundTag itemTag = itemStack.m_41783_();
                if (itemTag != null && itemTag.m_128441_("BlockEntityTag")) {
                    bannerData.m_128365_("Patterns", (Tag)itemTag.m_128469_("BlockEntityTag"));
                }
            }
            catch (Exception itemStack) {
                // empty catch block
            }
            completeTag.m_128365_("BannerData", (Tag)bannerData);
        }
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            CompoundTag signData = new CompoundTag();
            try {
                Method getFrontText = sign.getClass().getMethod("getFrontText", new Class[0]);
                Object frontText = getFrontText.invoke((Object)sign, new Object[0]);
                Method getMessage = frontText.getClass().getMethod("getMessage", Integer.TYPE, Boolean.TYPE);
                for (int i = 0; i < 4; ++i) {
                    Object component = getMessage.invoke(frontText, i, false);
                    signData.m_128359_("Text" + i, component.toString());
                }
            }
            catch (Exception e) {
                try {
                    Method saveWithoutMetadata = sign.getClass().getMethod("saveWithoutMetadata", new Class[0]);
                    Object result = saveWithoutMetadata.invoke((Object)sign, new Object[0]);
                    if (result instanceof CompoundTag) {
                        signData = (CompoundTag)result;
                    }
                }
                catch (Exception saveWithoutMetadata) {
                    // empty catch block
                }
            }
            completeTag.m_128365_("SignData", (Tag)signData);
        }
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            CompoundTag skullData = new CompoundTag();
            try {
                Method getOwnerProfile = skull.getClass().getMethod("getOwnerProfile", new Class[0]);
                Object profile = getOwnerProfile.invoke((Object)skull, new Object[0]);
                if (profile != null) {
                    skullData.m_128359_("SkullOwner", profile.toString());
                }
            }
            catch (Exception getOwnerProfile) {
                // empty catch block
            }
            completeTag.m_128365_("SkullData", (Tag)skullData);
        }
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity pot = (DecoratedPotBlockEntity)blockEntity;
            CompoundTag potData = new CompoundTag();
            try {
                potData = RBBSlowerProcedure.captureBlockEntityNbt((BlockEntity)pot);
            }
            catch (Exception getOwnerProfile) {
                // empty catch block
            }
            completeTag.m_128365_("PotData", (Tag)potData);
        }
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            CompoundTag inventoryData = new CompoundTag();
            ListTag itemsList = new ListTag();
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                stack.m_41739_(itemTag);
                itemsList.add((Object)itemTag);
            }
            inventoryData.m_128365_("Items", (Tag)itemsList);
            inventoryData.m_128405_("Size", container.m_6643_());
            completeTag.m_128365_("Inventory", (Tag)inventoryData);
        }
        return completeTag.m_128456_() ? null : completeTag;
    }

    private static void restoreCompleteBlockEntity(BlockEntity blockEntity, CompoundTag completeTag) {
        if (blockEntity == null || completeTag == null) {
            return;
        }
        if (completeTag.m_128441_("BasicData")) {
            RBBSlowerProcedure.restoreBlockEntityFromNbt(blockEntity, completeTag.m_128469_("BasicData"));
        }
        if (blockEntity instanceof BannerBlockEntity) {
            BannerBlockEntity banner = (BannerBlockEntity)blockEntity;
            if (completeTag.m_128441_("BannerData")) {
                try {
                    CompoundTag bannerData = completeTag.m_128469_("BannerData");
                    if (bannerData.m_128441_("Patterns")) {
                        banner.m_142466_(bannerData.m_128469_("Patterns"));
                    }
                }
                catch (Exception bannerData) {
                    // empty catch block
                }
            }
        }
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            if (completeTag.m_128441_("SignData")) {
                try {
                    CompoundTag signData = completeTag.m_128469_("SignData");
                    if (signData.m_128441_("Text0")) {
                        Method getFrontText = sign.getClass().getMethod("getFrontText", new Class[0]);
                        Object frontText = getFrontText.invoke((Object)sign, new Object[0]);
                        Method setMessage = frontText.getClass().getMethod("setMessage", Integer.TYPE, Component.class);
                        for (int i = 0; i < 4; ++i) {
                            if (!signData.m_128441_("Text" + i)) continue;
                            String text = signData.m_128461_("Text" + i);
                            setMessage.invoke(frontText, i, Component.m_237113_((String)text));
                        }
                    } else {
                        sign.m_142466_(signData);
                    }
                }
                catch (Exception signData) {
                    // empty catch block
                }
            }
        }
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            if (completeTag.m_128441_("SkullData")) {
                try {
                    CompoundTag skullData = completeTag.m_128469_("SkullData");
                    if (skullData.m_128441_("SkullOwner")) {
                        skull.m_142466_(skullData);
                    }
                }
                catch (Exception skullData) {
                    // empty catch block
                }
            }
        }
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity pot = (DecoratedPotBlockEntity)blockEntity;
            if (completeTag.m_128441_("PotData")) {
                try {
                    pot.m_142466_(completeTag.m_128469_("PotData"));
                }
                catch (Exception skullData) {
                    // empty catch block
                }
            }
        }
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            if (completeTag.m_128441_("Inventory")) {
                try {
                    CompoundTag inventoryData = completeTag.m_128469_("Inventory");
                    ListTag itemsList = inventoryData.m_128437_("Items", 10);
                    for (int i = 0; i < itemsList.size(); ++i) {
                        CompoundTag itemTag = itemsList.m_128728_(i);
                        int slot = itemTag.m_128451_("Slot");
                        ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                        if (slot < 0 || slot >= container.m_6643_()) continue;
                        container.m_6836_(slot, stack);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        blockEntity.m_6596_();
    }

    private static CompoundTag captureFullBlockStateProperties(BlockState state) {
        if (state == null) {
            return null;
        }
        CompoundTag stateTag = new CompoundTag();
        CompoundTag propertiesTag = new CompoundTag();
        try {
            for (Property property : state.m_61147_()) {
                String propName = property.m_61708_();
                String propValue = state.m_61143_(property).toString();
                propertiesTag.m_128359_(propName, propValue);
            }
            stateTag.m_128365_("Properties", (Tag)propertiesTag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stateTag.m_128456_() ? null : stateTag;
    }

    private static void restoreBlockStateProperties(ServerLevel server, BlockPos pos, BlockState baseState, CompoundTag stateTag) {
        if (stateTag == null || !stateTag.m_128441_("Properties")) {
            return;
        }
        try {
            CompoundTag propertiesTag = stateTag.m_128469_("Properties");
            BlockState restoredState = baseState;
            for (Property property : baseState.m_61147_()) {
                String propName = property.m_61708_();
                if (!propertiesTag.m_128441_(propName)) continue;
                String propValue = propertiesTag.m_128461_(propName);
                restoredState = RBBSlowerProcedure.setPropertyValue(restoredState, property, propValue);
            }
            if (!restoredState.equals(baseState)) {
                server.m_7731_(pos, restoredState, 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T extends Comparable<T>> BlockState setPropertyValue(BlockState state, Property<T> property, String value) {
        try {
            Optional optional = property.m_6215_(value);
            if (optional.isPresent()) {
                return (BlockState)state.m_61124_(property, (Comparable)optional.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private static boolean hasImportantCustomData(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        return blockEntity instanceof BannerBlockEntity || blockEntity instanceof SignBlockEntity || blockEntity instanceof SkullBlockEntity || blockEntity instanceof DecoratedPotBlockEntity || blockEntity instanceof Container;
    }

    private static CompoundTag captureBlockEntityNbt(BlockEntity blockEntity) {
        String[] methods;
        if (blockEntity == null) {
            return null;
        }
        for (String methodName : methods = new String[]{"saveWithFullMetadata", "saveWithId", "saveWithoutMetadata", "createNbtWithIdentifyingData", "createNbt", "serializeNBT", "save"}) {
            try {
                Method method = blockEntity.getClass().getMethod(methodName, new Class[0]);
                Object result = method.invoke((Object)blockEntity, new Object[0]);
                if (!(result instanceof CompoundTag)) continue;
                return (CompoundTag)result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            CompoundTag tag = new CompoundTag();
            Method method = blockEntity.getClass().getMethod("save", CompoundTag.class);
            method.invoke((Object)blockEntity, tag);
            return tag;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void restoreBlockEntityFromNbt(BlockEntity blockEntity, CompoundTag tag) {
        String[] methods;
        if (blockEntity == null || tag == null) {
            return;
        }
        for (String methodName : methods = new String[]{"load", "readNbt", "deserializeNBT", "fromTag", "read"}) {
            try {
                Method method = blockEntity.getClass().getMethod(methodName, CompoundTag.class);
                method.invoke((Object)blockEntity, tag);
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    private static class GravityBlockSnapshot {
        final BlockPos originalPos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final long capturedTick;

        GravityBlockSnapshot(BlockPos pos, BlockState state, CompoundTag nbt, long tick) {
            this.originalPos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
            this.capturedTick = tick;
        }
    }

    private static class DependentBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final CompoundTag fullBlockStateData;

        DependentBlockInfo(BlockPos pos, BlockState state, CompoundTag nbt, CompoundTag fullData) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
            this.fullBlockStateData = fullData;
        }
    }

    private static class BrokenBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final CompoundTag fullBlockStateData;
        final long restoreAtTick;
        final List<DependentBlockInfo> dependents;
        final boolean hasCustomData;

        BrokenBlockInfo(BlockPos pos, BlockState state, CompoundTag nbt, CompoundTag fullData, long restoreTick, List<DependentBlockInfo> deps, boolean custom) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = nbt;
            this.fullBlockStateData = fullData;
            this.restoreAtTick = restoreTick;
            this.dependents = deps != null ? deps : new ArrayList();
            this.hasCustomData = custom;
        }
    }
}

