/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashSet;
import java.util.Set;
import net.mcreator.fromthecaves.configuration.ConfigScreenConfiguration;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SetPlayerSpawnInVillageProcedure {
    private static final TagKey<Structure> DEFAULT_VILLAGE_TAG = StructureTags.f_215889_;
    private static final String PERSISTED_TAG = "PlayerPersisted";
    private static final String FLAG_KEY = "FromTheCavesFirstSpawn";
    private static Set<String> protectedModIds = new HashSet<String>();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CompoundTag root = player.getPersistentData();
        CompoundTag persisted = root.m_128425_(PERSISTED_TAG, 10) ? root.m_128469_(PERSISTED_TAG) : new CompoundTag();
        if (persisted.m_128471_(FLAG_KEY)) {
            return;
        }
        boolean spawnInVillageEnabled = (Boolean)ConfigScreenConfiguration.SPAWN_IN_VILLAGE_ENABLED.get();
        String locateVillageTag = (String)ConfigScreenConfiguration.LOCATE_VILLAGE_TAG.get();
        boolean keepDefaultVillageTagBackup = (Boolean)ConfigScreenConfiguration.KEEP_DEFAULT_VILLAGE_TAG_BACKUP.get();
        boolean startInPhase1 = (Boolean)ConfigScreenConfiguration.START_IN_PHASE_1.get();
        double defaultSingleplayerMultiplier = (Double)ConfigScreenConfiguration.DEFAULT_SINGLEPLAYER_MULTIPLIER.get();
        double defaultMultiplayerScale = (Double)ConfigScreenConfiguration.DEFAULT_MULTIPLAYER_SCALE.get();
        String protectedModIdsConfig = (String)ConfigScreenConfiguration.PROTECTED_MOD_IDS.get();
        ChunkTensionProcedure.setSingleplayerMultiplier(defaultSingleplayerMultiplier);
        ChunkTensionProcedure.setMultiplayerScaleFactor(defaultMultiplayerScale);
        SetPlayerSpawnInVillageProcedure.loadProtectedModIds(protectedModIdsConfig);
        if (startInPhase1) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)serverLevel, 1);
        }
        if (!spawnInVillageEnabled) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        BlockPos structPos = null;
        if (locateVillageTag != null && !locateVillageTag.isEmpty()) {
            try {
                String tagName = locateVillageTag.startsWith("#") ? locateVillageTag.substring(1) : locateVillageTag;
                TagKey structureTag = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(tagName));
                structPos = serverLevel.m_215011_(structureTag, player.m_20183_(), 100, false);
            }
            catch (Exception tagName) {
                // empty catch block
            }
        }
        if (structPos == null && keepDefaultVillageTagBackup) {
            try {
                structPos = serverLevel.m_215011_(DEFAULT_VILLAGE_TAG, player.m_20183_(), 100, false);
            }
            catch (Exception tagName) {
                // empty catch block
            }
        }
        if (structPos == null) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        int x = structPos.m_123341_();
        int z = structPos.m_123343_();
        int maxHeight = serverLevel.m_151558_();
        int highestNonAirY = -1;
        for (int y = maxHeight - 1; y >= 0; --y) {
            BlockPos checkPos = new BlockPos(x, y, z);
            BlockState state = serverLevel.m_8055_(checkPos);
            if (state.m_60795_()) continue;
            highestNonAirY = y;
            break;
        }
        if (highestNonAirY < 0 && (highestNonAirY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z)) > 0) {
            --highestNonAirY;
        }
        if (highestNonAirY < 0) {
            persisted.m_128379_(FLAG_KEY, true);
            root.m_128365_(PERSISTED_TAG, (Tag)persisted);
            return;
        }
        BlockPos spawnPos = new BlockPos(x, highestNonAirY + 1, z);
        player.m_9158_(serverLevel.m_46472_(), spawnPos, 0.0f, true, false);
        try {
            player.m_6021_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        }
        catch (NoSuchMethodError nsme) {
            try {
                player.m_8999_(serverLevel, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        persisted.m_128379_(FLAG_KEY, true);
        root.m_128365_(PERSISTED_TAG, (Tag)persisted);
    }

    private static void loadProtectedModIds(String config) {
        protectedModIds.clear();
        if (config != null && !config.isEmpty()) {
            String[] ids;
            for (String id : ids = config.split(",")) {
                String trimmed = id.trim().toLowerCase();
                if (trimmed.isEmpty()) continue;
                protectedModIds.add(trimmed);
            }
        }
    }

    public static boolean isModIdProtected(String modId) {
        return protectedModIds.contains(modId.toLowerCase());
    }

    public static Set<String> getProtectedModIds() {
        return new HashSet<String>(protectedModIds);
    }
}

