/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkyCrouchBehaviorProcedure {
    private static final int CROUCH_DELAY_TICKS = 20;
    private static final double DETECTION_EXPANSION = 0.5;
    private static final Map<UUID, Long> crouchSchedule = new ConcurrentHashMap<UUID, Long>();
    private static final String NBT_SKY_CROUCH = "FTC_skyCrouch";
    private static final String NBT_TOUCHED_TIME = "FTC_touchedTime";

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        Player player;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!SkyCrouchBehaviorProcedure.isSkyEntity((Entity)mob)) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        long now = server.m_46467_();
        UUID mobId = mob.m_20148_();
        CompoundTag data = mob.getPersistentData();
        Long scheduledTime = crouchSchedule.get(mobId);
        if (scheduledTime != null) {
            if (now >= scheduledTime) {
                data.m_128379_(NBT_SKY_CROUCH, true);
                crouchSchedule.remove(mobId);
            }
            return;
        }
        if (data.m_128471_(NBT_SKY_CROUCH)) {
            return;
        }
        AABB mobBB = mob.m_20191_().m_82400_(0.5);
        List nearbyPlayers = server.m_45976_(Player.class, mobBB);
        if (!nearbyPlayers.isEmpty() && (player = (Player)nearbyPlayers.get(0)).m_20191_().m_82381_(mobBB) && !data.m_128441_(NBT_TOUCHED_TIME)) {
            data.m_128356_(NBT_TOUCHED_TIME, now);
            crouchSchedule.put(mobId, now + 20L);
        }
    }

    private static boolean isSkyEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        try {
            return entity.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESSKY.get());
        }
        catch (Throwable t) {
            return false;
        }
    }
}

