/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashSet;
import java.util.Set;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnChestWithCrossInVillageProcedureProcedure {
    private static final int MAX_ATTEMPTS = 5;
    private static final int SEARCH_RADIUS = 3;
    private static final int CHECK_INTERVAL = 100;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int attempt;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.f_19797_ % 100 != 0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 0) {
            return;
        }
        BlockPos villagePos = serverLevel.m_215011_(StructureTags.f_215889_, player.m_20183_(), 100, false);
        if (villagePos == null) {
            return;
        }
        VillageChestData data = (VillageChestData)serverLevel.m_8895_().m_164861_(VillageChestData::load, VillageChestData::new, "village_chest_data");
        if (data.hasChest(villagePos)) {
            return;
        }
        boolean chestPlaced = false;
        boolean signPlaced = false;
        BlockPos successfulChestPos = null;
        for (attempt = 0; attempt < 5 && !chestPlaced; ++attempt) {
            BlockPos chestBasePos = SpawnChestWithCrossInVillageProcedureProcedure.getAttemptPosition(villagePos, attempt);
            int y = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, chestBasePos.m_123341_(), chestBasePos.m_123343_()) - 1;
            BlockPos placePos = new BlockPos(chestBasePos.m_123341_(), y + 1, chestBasePos.m_123343_());
            BlockState stateAbove = serverLevel.m_8055_(placePos);
            if (!stateAbove.m_60795_()) continue;
            serverLevel.m_7731_(placePos, Blocks.f_50087_.m_49966_(), 3);
            BlockEntity be = serverLevel.m_7702_(placePos);
            if (!(be instanceof ChestBlockEntity)) continue;
            ChestBlockEntity chestBE = (ChestBlockEntity)be;
            ItemStack compass = new ItemStack((ItemLike)FromTheCavesModItems.CROSS_COMPASS.get());
            CompoundTag compassTag = compass.m_41784_();
            compassTag.m_128379_("hasAdvanced", false);
            chestBE.m_6836_(5, compass);
            ItemStack loreBook = new ItemStack((ItemLike)FromTheCavesModItems.VILLAGER_LORE_BOOK.get());
            chestBE.m_6836_(13, loreBook);
            chestBE.m_6596_();
            chestPlaced = true;
            successfulChestPos = placePos;
        }
        if (chestPlaced && successfulChestPos != null) {
            for (attempt = 0; attempt < 5 && !signPlaced; ++attempt) {
                BlockPos signPos = SpawnChestWithCrossInVillageProcedureProcedure.getSignAttemptPosition(successfulChestPos, attempt);
                BlockState signAbove = serverLevel.m_8055_(signPos);
                if (!signAbove.m_60795_()) continue;
                serverLevel.m_7731_(signPos, Blocks.f_50095_.m_49966_(), 3);
                BlockEntity signBE = serverLevel.m_7702_(signPos);
                if (!(signBE instanceof SignBlockEntity)) continue;
                SignBlockEntity sign = (SignBlockEntity)signBE;
                CompoundTag tag = new CompoundTag();
                CompoundTag front = new CompoundTag();
                ListTag messages = new ListTag();
                messages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u00a74Do not access"))));
                messages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u00a7cThis container"))));
                messages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)"\u00a74is sealed"))));
                messages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)""))));
                front.m_128365_("messages", (Tag)messages);
                tag.m_128365_("front_text", (Tag)front);
                tag.m_128359_("id", "minecraft:sign");
                sign.m_142466_(tag);
                sign.m_6596_();
                serverLevel.m_7260_(signPos, signAbove, serverLevel.m_8055_(signPos), 3);
                signPlaced = true;
            }
        }
        if (chestPlaced) {
            data.addChest(villagePos);
            data.m_77762_();
        }
    }

    private static BlockPos getAttemptPosition(BlockPos villagePos, int attempt) {
        if (attempt == 0) {
            return villagePos.m_7918_(2, 0, 0);
        }
        int xOffset = attempt % 3 - 1;
        int zOffset = attempt / 3 - 1;
        return villagePos.m_7918_(xOffset, 0, zOffset);
    }

    private static BlockPos getSignAttemptPosition(BlockPos chestPos, int attempt) {
        if (attempt == 0) {
            return chestPos.m_7494_();
        }
        int xOffset = attempt % 3 - 1;
        int zOffset = attempt / 3 - 1;
        return chestPos.m_7918_(xOffset, 1, zOffset);
    }

    public static class VillageChestData
    extends SavedData {
        private Set<BlockPos> villagesWithChest = new HashSet<BlockPos>();

        public static VillageChestData load(CompoundTag tag) {
            VillageChestData data = new VillageChestData();
            if (tag.m_128441_("villages")) {
                CompoundTag villagesTag = tag.m_128469_("villages");
                for (String key : villagesTag.m_128431_()) {
                    CompoundTag posTag = villagesTag.m_128469_(key);
                    int x = posTag.m_128451_("x");
                    int y = posTag.m_128451_("y");
                    int z = posTag.m_128451_("z");
                    data.villagesWithChest.add(new BlockPos(x, y, z));
                }
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            CompoundTag villagesTag = new CompoundTag();
            int index = 0;
            for (BlockPos pos : this.villagesWithChest) {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128405_("x", pos.m_123341_());
                posTag.m_128405_("y", pos.m_123342_());
                posTag.m_128405_("z", pos.m_123343_());
                villagesTag.m_128365_("pos" + index, (Tag)posTag);
                ++index;
            }
            tag.m_128365_("villages", (Tag)villagesTag);
            return tag;
        }

        public boolean hasChest(BlockPos pos) {
            return this.villagesWithChest.contains(pos);
        }

        public void addChest(BlockPos pos) {
            this.villagesWithChest.add(pos);
        }
    }
}

