/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnUpsideDownCrossInVillageProcedure {
    private static final int MAX_ATTEMPTS = 5;
    private static final int SEARCH_RADIUS = 3;
    private static final int CHECK_INTERVAL = 100;
    private static final int VILLAGE_SEARCH_COOLDOWN = 600;
    private static final Map<String, Integer> playerTickCounters = new HashMap<String, Integer>();
    private static final Map<String, Long> playerVillageSearchCooldown = new HashMap<String, Long>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String playerUUID = player.m_20149_();
        int tickCounter = playerTickCounters.getOrDefault(playerUUID, 0) + 1;
        playerTickCounters.put(playerUUID, tickCounter);
        if (tickCounter % 100 != 0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase < 0 || phase > 3) {
            return;
        }
        long currentTime = serverLevel.m_46467_();
        Long lastSearch = playerVillageSearchCooldown.get(playerUUID);
        if (lastSearch != null && currentTime - lastSearch < 600L) {
            return;
        }
        BlockPos villagePos = serverLevel.m_215011_(StructureTags.f_215889_, player.m_20183_(), 100, false);
        if (villagePos == null) {
            playerVillageSearchCooldown.put(playerUUID, currentTime);
            return;
        }
        VillageCrossData data = (VillageCrossData)serverLevel.m_8895_().m_164861_(VillageCrossData::load, VillageCrossData::new, "village_cross_data");
        if (data.hasCross(villagePos)) {
            playerVillageSearchCooldown.put(playerUUID, currentTime + 1200L);
            return;
        }
        playerVillageSearchCooldown.put(playerUUID, currentTime);
        boolean crossPlaced = false;
        for (int attempt = 0; attempt < 5 && !crossPlaced; ++attempt) {
            BlockPos crossBasePos = SpawnUpsideDownCrossInVillageProcedure.getCrossAttemptPosition(villagePos, attempt);
            int maxSearchHeight = crossBasePos.m_123342_() + 10;
            BlockPos highestSolidPos = null;
            for (int y = crossBasePos.m_123342_(); y <= maxSearchHeight; ++y) {
                BlockPos checkPos = new BlockPos(crossBasePos.m_123341_(), y, crossBasePos.m_123343_());
                BlockState stateBelow = serverLevel.m_8055_(checkPos);
                BlockState stateAt = serverLevel.m_8055_(checkPos.m_7494_());
                if (stateBelow.m_60795_() || !stateBelow.m_280296_() || !stateAt.m_60795_()) continue;
                highestSolidPos = checkPos.m_7494_();
            }
            if (highestSolidPos == null) {
                int surfaceY = serverLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, crossBasePos.m_123341_(), crossBasePos.m_123343_()) - 1;
                highestSolidPos = new BlockPos(crossBasePos.m_123341_(), surfaceY + 1, crossBasePos.m_123343_());
            }
            BlockState stateAbove = serverLevel.m_8055_(highestSolidPos);
            BlockState stateBelow = serverLevel.m_8055_(highestSolidPos.m_7495_());
            if (!stateAbove.m_60795_() || stateBelow.m_60795_()) continue;
            serverLevel.m_7731_(highestSolidPos, ((Block)FromTheCavesModBlocks.CROSS_FLOOR.get()).m_49966_(), 3);
            crossPlaced = true;
        }
        if (crossPlaced) {
            data.addCross(villagePos);
            data.m_77762_();
        }
    }

    private static BlockPos getCrossAttemptPosition(BlockPos villagePos, int attempt) {
        if (attempt == 0) {
            return villagePos.m_7918_(3, 0, 0);
        }
        int xOffset = attempt % 3 - 1 + 3;
        int zOffset = attempt / 3 - 1;
        return villagePos.m_7918_(xOffset, 0, zOffset);
    }

    public static class VillageCrossData
    extends SavedData {
        private Set<BlockPos> villagesWithCross = new HashSet<BlockPos>();

        public static VillageCrossData load(CompoundTag tag) {
            VillageCrossData data = new VillageCrossData();
            if (tag.m_128441_("villages")) {
                CompoundTag villagesTag = tag.m_128469_("villages");
                for (String key : villagesTag.m_128431_()) {
                    CompoundTag posTag = villagesTag.m_128469_(key);
                    int x = posTag.m_128451_("x");
                    int y = posTag.m_128451_("y");
                    int z = posTag.m_128451_("z");
                    data.villagesWithCross.add(new BlockPos(x, y, z));
                }
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            CompoundTag villagesTag = new CompoundTag();
            int index = 0;
            for (BlockPos pos : this.villagesWithCross) {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128405_("x", pos.m_123341_());
                posTag.m_128405_("y", pos.m_123342_());
                posTag.m_128405_("z", pos.m_123343_());
                villagesTag.m_128365_("pos" + index, (Tag)posTag);
                ++index;
            }
            tag.m_128365_("villages", (Tag)villagesTag);
            return tag;
        }

        public boolean hasCross(BlockPos pos) {
            return this.villagesWithCross.contains(pos);
        }

        public void addCross(BlockPos pos) {
            this.villagesWithCross.add(pos);
        }
    }
}

