/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.mcreator.fromthecaves.configuration.ConfigScreenConfiguration;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnUpsideDownCrossProcedure {
    private static final double BASE_PROB = 1.0E-4;
    private static final double MAX_PROB = 2.0E-4;
    private static final double MIN_DIST = 8.0;
    private static final double MAX_DIST = 64.0;
    private static final int MAX_TRIES = 10;
    private static final Set<Block> FORBIDDEN_GROUND_BLOCKS = ImmutableSet.of((Object)Blocks.f_50069_, (Object)Blocks.f_152550_, (Object)Blocks.f_50334_, (Object)Blocks.f_50228_, (Object)Blocks.f_50122_, (Object)Blocks.f_152496_, (Object[])new Block[]{Blocks.f_49997_, Blocks.f_49996_, Blocks.f_152505_, Blocks.f_49995_, Blocks.f_50173_, Blocks.f_50264_, Blocks.f_50059_, Blocks.f_50089_, Blocks.f_152469_, Blocks.f_152468_, Blocks.f_152506_, Blocks.f_152467_, Blocks.f_152473_, Blocks.f_152479_, Blocks.f_152472_, Blocks.f_152474_});

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        if (!((Boolean)ConfigScreenConfiguration.UPSIDE_DOWN_CROSS_SPAWN_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player2 = event.player;
        if (!(player2 instanceof ServerPlayer) || !((player2 = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)player2;
        if (player.m_20186_() >= 55.0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 0 || phase > 3) {
            return;
        }
        double prob = ChunkTensionProcedure.getDynamicProbability(server, (Player)player, 1.0E-4, 2.0E-4);
        if (server.m_213780_().m_188500_() >= prob) {
            return;
        }
        RandomSource rnd = server.m_213780_();
        for (int attempt = 0; attempt < 10; ++attempt) {
            double angle = rnd.m_188500_() * Math.PI * 2.0;
            double dist = 8.0 + rnd.m_188500_() * 56.0;
            int x = (int)(player.m_20185_() + Math.cos(angle) * dist);
            int z = (int)(player.m_20189_() + Math.sin(angle) * dist);
            for (int yOffset = 10; yOffset >= -20; --yOffset) {
                int searchY = (int)player.m_20186_() + yOffset;
                BlockPos potentialPos = new BlockPos(x, searchY, z);
                if (server.m_151570_(potentialPos)) continue;
                BlockState stateAtPos = server.m_8055_(potentialPos);
                BlockState stateBelow = server.m_8055_(potentialPos.m_7495_());
                if (!stateAtPos.m_60795_() || !stateBelow.m_60804_((BlockGetter)server, potentialPos.m_7495_()) || server.m_45527_(potentialPos) || FORBIDDEN_GROUND_BLOCKS.contains(stateBelow.m_60734_())) continue;
                boolean spaceOk = true;
                for (int dx = 0; dx <= 1 && spaceOk; ++dx) {
                    for (int dz = 0; dz <= 1 && spaceOk; ++dz) {
                        for (int dy = 0; dy <= 1 && spaceOk; ++dy) {
                            BlockPos p = potentialPos.m_7918_(dx, dy, dz);
                            if (server.m_46859_(p)) continue;
                            spaceOk = false;
                        }
                    }
                }
                if (!spaceOk) continue;
                server.m_46597_(potentialPos, ((Block)FromTheCavesModBlocks.UPSIDE_DOWN_CROSS.get()).m_49966_());
                return;
            }
        }
    }
}

