/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Random;
import net.mcreator.fromthecaves.entity.FROMTHECAVESTORCHEntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TorchBreakProcedure {
    private static final int BREAK_DELAY = 20;
    private static final int MAX_BREAKS = 6;
    private static final int RADIUS = 3;
    private static final double SOUND_CHANCE_BREAK = 0.1;
    private static final int BLINDNESS_DURATION = 200;
    private static final int MIN_RESTORE_TIME = 100;
    private static final int MAX_RESTORE_TIME = 200;
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onTorchMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVESTORCHEntity)) {
            return;
        }
        FROMTHECAVESTORCHEntity mob = (FROMTHECAVESTORCHEntity)ent;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)lvl);
        if (phase < 1 || phase > 3) {
            return;
        }
        ServerLevel server = (ServerLevel)lvl;
        CompoundTag data = mob.getPersistentData();
        long tick = server.m_46467_();
        if (!data.m_128441_("torchStartTick")) {
            data.m_128356_("torchStartTick", tick);
            data.m_128405_("torchBreakCount", 0);
            data.m_128356_("nextTorchBreakTick", tick);
        }
        int broken = data.m_128451_("torchBreakCount");
        long start = data.m_128454_("torchStartTick");
        if (broken >= 6 || tick - start >= 120L) {
            mob.m_146870_();
            return;
        }
        long nextBreak = data.m_128454_("nextTorchBreakTick");
        if (tick < nextBreak) {
            return;
        }
        BlockPos origin = mob.m_20183_();
        BlockPos toBreak = null;
        BlockState blockState = null;
        boolean isTorch = false;
        boolean isCandle = false;
        block0: for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    BlockPos pos = origin.m_7918_(dx, dy, dz);
                    BlockState st = lvl.m_8055_(pos);
                    Block block = st.m_60734_();
                    if (block != Blocks.f_50081_ && block != Blocks.f_50082_ && block != Blocks.f_50681_ && block != Blocks.f_50139_ && block != Blocks.f_50140_ && block != Blocks.f_50682_ && !(block instanceof CandleBlock) && !(block instanceof CandleCakeBlock)) continue;
                    toBreak = pos;
                    blockState = st;
                    isTorch = true;
                    isCandle = block instanceof CandleBlock || block instanceof CandleCakeBlock;
                    break block0;
                }
            }
        }
        if (toBreak != null && blockState != null) {
            if (isTorch) {
                if (isCandle) {
                    BlockState newState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                    server.m_7731_(toBreak, newState, 3);
                    TorchBreakProcedure.scheduleRestore(server, toBreak, blockState, tick);
                } else {
                    BlockState newState = null;
                    BlockState originalState = blockState;
                    boolean shouldRestore = false;
                    if (blockState.m_60734_() == Blocks.f_50081_) {
                        Block unlitFloor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
                        if (unlitFloor != null) {
                            newState = unlitFloor.m_49966_();
                            shouldRestore = true;
                        }
                    } else if (blockState.m_60734_() == Blocks.f_50082_) {
                        Block unlitWall = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
                        if (unlitWall != null) {
                            Direction facing = (Direction)blockState.m_61143_((Property)WallTorchBlock.f_58119_);
                            newState = (BlockState)unlitWall.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)facing);
                            shouldRestore = true;
                        }
                    } else if (blockState.m_60734_() == Blocks.f_50681_) {
                        server.m_46961_(toBreak, true);
                        newState = Blocks.f_50016_.m_49966_();
                    } else if (blockState.m_60734_() == Blocks.f_50139_) {
                        server.m_46961_(toBreak, true);
                        newState = Blocks.f_50016_.m_49966_();
                    } else if (blockState.m_60734_() == Blocks.f_50140_) {
                        server.m_46961_(toBreak, true);
                        newState = Blocks.f_50016_.m_49966_();
                    } else if (blockState.m_60734_() == Blocks.f_50682_) {
                        server.m_46961_(toBreak, true);
                        newState = Blocks.f_50016_.m_49966_();
                    }
                    if (newState != null && newState.m_60734_() != Blocks.f_50016_) {
                        server.m_7731_(toBreak, newState, 3);
                        if (shouldRestore) {
                            TorchBreakProcedure.scheduleRestore(server, toBreak, originalState, tick);
                        }
                    }
                }
            } else {
                server.m_46961_(toBreak, true);
            }
            if (Math.random() < 0.1) {
                Player p;
                SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "it_10"));
                if (se != null) {
                    server.m_5594_(null, toBreak, se, SoundSource.AMBIENT, 0.8f, 0.5f);
                }
                if ((p = server.m_45930_((Entity)mob, 16.0)) != null) {
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 255, false, false));
                    p.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 255, false, false));
                    server.m_5594_(null, p.m_20183_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "heartbeat")), SoundSource.PLAYERS, 0.6f, 1.0f);
                }
            }
        }
        data.m_128405_("torchBreakCount", broken + 1);
        data.m_128356_("nextTorchBreakTick", tick + 20L);
    }

    private static void scheduleRestore(ServerLevel level, BlockPos pos, BlockState originalState, long currentTick) {
        TorchRestoreData data = TorchRestoreData.get(level.m_7654_());
        CompoundTag entry = new CompoundTag();
        entry.m_128356_("x", (long)pos.m_123341_());
        entry.m_128356_("y", (long)pos.m_123342_());
        entry.m_128356_("z", (long)pos.m_123343_());
        entry.m_128359_("dimension", level.m_46472_().m_135782_().toString());
        String blockName = ForgeRegistries.BLOCKS.getKey((Object)originalState.m_60734_()).toString();
        entry.m_128359_("block", blockName);
        if (originalState.m_60734_() instanceof WallTorchBlock) {
            entry.m_128359_("facing", ((Direction)originalState.m_61143_((Property)WallTorchBlock.f_58119_)).m_122433_());
        }
        if (originalState.m_60734_() instanceof CandleBlock) {
            entry.m_128405_("candles", ((Integer)originalState.m_61143_((Property)CandleBlock.f_152790_)).intValue());
            entry.m_128379_("lit", ((Boolean)originalState.m_61143_((Property)CandleBlock.f_152791_)).booleanValue());
            entry.m_128379_("waterlogged", ((Boolean)originalState.m_61143_((Property)CandleBlock.f_152792_)).booleanValue());
        }
        int restoreDelay = 100 + RANDOM.nextInt(101);
        entry.m_128356_("restoreTick", currentTick + (long)restoreDelay);
        data.addTorch(entry);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.m_129783_();
        TorchRestoreData data = TorchRestoreData.get(server);
        ListTag restoreList = data.getRestoreList();
        if (restoreList.isEmpty()) {
            return;
        }
        long currentTick = overworld.m_46467_();
        ListTag newList = new ListTag();
        for (int i = 0; i < restoreList.size(); ++i) {
            String blockName;
            Block originalBlock;
            boolean isUnlitCandle;
            CompoundTag entry = restoreList.m_128728_(i);
            long restoreTick = entry.m_128454_("restoreTick");
            if (currentTick < restoreTick) {
                newList.add((Object)entry);
                continue;
            }
            String dimensionStr = entry.m_128461_("dimension");
            ServerLevel level = null;
            for (ServerLevel serverLevel : server.m_129785_()) {
                if (!serverLevel.m_46472_().m_135782_().toString().equals(dimensionStr)) continue;
                level = serverLevel;
                break;
            }
            if (level == null) continue;
            BlockPos pos = new BlockPos((int)entry.m_128454_("x"), (int)entry.m_128454_("y"), (int)entry.m_128454_("z"));
            BlockState currentState = level.m_8055_(pos);
            Block unlitFloor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
            Block unlitWall = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
            boolean isUnlitTorch = unlitFloor != null && currentState.m_60734_() == unlitFloor || unlitWall != null && currentState.m_60734_() == unlitWall;
            boolean bl = isUnlitCandle = currentState.m_60734_() instanceof CandleBlock && (Boolean)currentState.m_61143_((Property)CandleBlock.f_152791_) == false || currentState.m_60734_() instanceof CandleCakeBlock && (Boolean)currentState.m_61143_((Property)CandleBlock.f_152791_) == false;
            if (!isUnlitTorch && !isUnlitCandle || (originalBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName = entry.m_128461_("block")))) == null) continue;
            BlockState newState = originalBlock.m_49966_();
            if (originalBlock instanceof WallTorchBlock && entry.m_128441_("facing")) {
                Direction facing = Direction.m_122402_((String)entry.m_128461_("facing"));
                if (facing != null) {
                    newState = (BlockState)newState.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)facing);
                }
            } else if (originalBlock instanceof CandleBlock) {
                if (entry.m_128441_("candles")) {
                    newState = (BlockState)newState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(entry.m_128451_("candles")));
                }
                if (entry.m_128441_("waterlogged")) {
                    newState = (BlockState)newState.m_61124_((Property)CandleBlock.f_152792_, (Comparable)Boolean.valueOf(entry.m_128471_("waterlogged")));
                }
                newState = (BlockState)newState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
            }
            level.m_7731_(pos, newState, 3);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 1.5f);
        }
        data.setRestoreList(newList);
    }

    public static class TorchRestoreData
    extends SavedData {
        private static final String DATA_NAME = "ftc_torch_restore";
        private ListTag restoreList = new ListTag();

        public TorchRestoreData() {
        }

        public TorchRestoreData(CompoundTag tag) {
            if (tag.m_128425_("torches", 9)) {
                this.restoreList = tag.m_128437_("torches", 10);
            }
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128365_("torches", (Tag)this.restoreList);
            return tag;
        }

        public static TorchRestoreData get(MinecraftServer server) {
            return (TorchRestoreData)server.m_129783_().m_8895_().m_164861_(TorchRestoreData::new, TorchRestoreData::new, DATA_NAME);
        }

        public void addTorch(CompoundTag entry) {
            this.restoreList.add((Object)entry);
            this.m_77762_();
        }

        public ListTag getRestoreList() {
            return this.restoreList;
        }

        public void setRestoreList(ListTag list) {
            this.restoreList = list;
            this.m_77762_();
        }
    }
}

