/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class TreeWatcherProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 7.0E-5;
    private static final int SCAN_RADIUS = 32;
    private static final int MIN_SPAWN_DISTANCE = 12;
    private static final int MAX_SPAWN_DISTANCE = 32;
    private static final double LOG_PROXIMITY_RANGE = 8.0;
    private static final double PLAYER_FOV = 50.0;
    private static final double RUN_SPEED = 0.8;
    private static final Set<Block> LOG_BLOCKS = TreeWatcherProcedure.initLogBlocks();

    private static Set<Block> initLogBlocks() {
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.add(Blocks.f_49999_);
        blocks.add(Blocks.f_50000_);
        blocks.add(Blocks.f_50001_);
        blocks.add(Blocks.f_50002_);
        blocks.add(Blocks.f_50003_);
        blocks.add(Blocks.f_50004_);
        blocks.add(Blocks.f_220832_);
        blocks.add(Blocks.f_271170_);
        blocks.add(Blocks.f_50695_);
        blocks.add(Blocks.f_50686_);
        blocks.add(Blocks.f_50010_);
        blocks.add(Blocks.f_50005_);
        blocks.add(Blocks.f_50006_);
        blocks.add(Blocks.f_50007_);
        blocks.add(Blocks.f_50008_);
        blocks.add(Blocks.f_50009_);
        blocks.add(Blocks.f_220835_);
        blocks.add(Blocks.f_271326_);
        blocks.add(Blocks.f_50696_);
        blocks.add(Blocks.f_50687_);
        blocks.add(Blocks.f_50011_);
        blocks.add(Blocks.f_50012_);
        blocks.add(Blocks.f_50013_);
        blocks.add(Blocks.f_50014_);
        blocks.add(Blocks.f_50015_);
        blocks.add(Blocks.f_50043_);
        blocks.add(Blocks.f_220836_);
        blocks.add(Blocks.f_271348_);
        blocks.add(Blocks.f_50697_);
        blocks.add(Blocks.f_50688_);
        blocks.add(Blocks.f_50044_);
        blocks.add(Blocks.f_50045_);
        blocks.add(Blocks.f_50046_);
        blocks.add(Blocks.f_50047_);
        blocks.add(Blocks.f_50048_);
        blocks.add(Blocks.f_50049_);
        blocks.add(Blocks.f_220837_);
        blocks.add(Blocks.f_271145_);
        blocks.add(Blocks.f_50698_);
        blocks.add(Blocks.f_50689_);
        return Collections.unmodifiableSet(blocks);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 7.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos logPos = TreeWatcherProcedure.findValidLogForSpawn(server, player);
        if (logPos == null) {
            return;
        }
        BlockPos spawnPos = TreeWatcherProcedure.findAdjacentSpawnPosition(server, logPos);
        if (spawnPos == null) {
            return;
        }
        Mob watcher = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)server);
        if (watcher == null) {
            return;
        }
        watcher.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_() + 180.0f, 0.0f);
        watcher.m_21530_();
        watcher.m_20225_(true);
        watcher.m_21557_(false);
        CompoundTag nbt = watcher.getPersistentData();
        nbt.m_128379_("treeWatcher", true);
        nbt.m_128379_("runningToLog", false);
        nbt.m_128379_("hiding", false);
        nbt.m_128405_("logX", logPos.m_123341_());
        nbt.m_128405_("logY", logPos.m_123342_());
        nbt.m_128405_("logZ", logPos.m_123343_());
        nbt.m_128356_("spawnTick", server.m_46467_());
        nbt.m_128356_("hideStartTick", 0L);
        watcher.m_20049_("treeWatcher");
        server.m_7967_((Entity)watcher);
    }

    private static BlockPos findValidLogForSpawn(ServerLevel world, Player player) {
        BlockPos playerPos = player.m_20183_();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        int minDistSq = 144;
        int maxDistSq = 1024;
        for (int x = -32; x <= 32; x += 2) {
            for (int z = -32; z <= 32; z += 2) {
                for (int y = -5; y <= 5; ++y) {
                    BlockState state;
                    BlockPos pos = playerPos.m_7918_(x, y, z);
                    double distSq = pos.m_123331_((Vec3i)playerPos);
                    if (distSq < (double)minDistSq || distSq > (double)maxDistSq || !LOG_BLOCKS.contains((state = world.m_8055_(pos)).m_60734_()) || !TreeWatcherProcedure.hasValidSpawnSpace(world, pos)) continue;
                    candidates.add(pos);
                }
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (BlockPos)candidates.get(world.f_46441_.m_188503_(candidates.size()));
    }

    private static boolean hasValidSpawnSpace(ServerLevel world, BlockPos logPos) {
        Direction[] dirs;
        for (Direction dir : dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos belowPos;
            BlockState belowState;
            BlockPos checkPos = logPos.m_121945_(dir);
            BlockPos abovePos = checkPos.m_7494_();
            if (!world.m_46859_(checkPos) || !world.m_46859_(abovePos) || !TreeWatcherProcedure.isSolidGround(belowState = world.m_8055_(belowPos = checkPos.m_7495_()))) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findAdjacentSpawnPosition(ServerLevel world, BlockPos logPos) {
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        ArrayList<Direction> dirList = new ArrayList<Direction>(Arrays.asList(dirs));
        Collections.shuffle(dirList);
        for (Direction dir : dirList) {
            BlockPos belowPos;
            BlockState belowState;
            BlockPos spawnPos = logPos.m_121945_(dir);
            BlockPos abovePos = spawnPos.m_7494_();
            if (!world.m_46859_(spawnPos) || !world.m_46859_(abovePos) || !TreeWatcherProcedure.isSolidGround(belowState = world.m_8055_(belowPos = spawnPos.m_7495_()))) continue;
            return spawnPos;
        }
        return null;
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (!mob.m_19880_().contains("treeWatcher")) {
            return;
        }
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("treeWatcher")) {
            return;
        }
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        TreeWatcherProcedure.handleTreeWatcherBehavior(mob, server);
    }

    private static void handleTreeWatcherBehavior(Mob watcher, ServerLevel server) {
        CompoundTag nbt;
        Player nearestPlayer = server.m_45930_((Entity)watcher, 100.0);
        if (nearestPlayer == null) {
            watcher.m_146870_();
            return;
        }
        long now = server.m_46467_();
        if (now - (nbt = watcher.getPersistentData()).m_128454_("spawnTick") > 12000L) {
            watcher.m_146870_();
            return;
        }
        BlockPos logPos = new BlockPos(nbt.m_128451_("logX"), nbt.m_128451_("logY"), nbt.m_128451_("logZ"));
        BlockState logState = server.m_8055_(logPos);
        if (!LOG_BLOCKS.contains(logState.m_60734_())) {
            watcher.m_146870_();
            return;
        }
        double distToPlayer = watcher.m_20270_((Entity)nearestPlayer);
        if (distToPlayer > 80.0) {
            watcher.m_146870_();
            return;
        }
        if (!TreeWatcherProcedure.isPlayerLookingAt(nearestPlayer, watcher, 50.0)) {
            nbt.m_128379_("runningToLog", false);
            nbt.m_128379_("hiding", false);
            nbt.m_128356_("hideStartTick", 0L);
            watcher.f_19794_ = false;
            double distToLog = watcher.m_20275_((double)logPos.m_123341_(), (double)logPos.m_123342_(), (double)logPos.m_123343_());
            if (distToLog > 64.0) {
                watcher.m_21573_().m_26519_((double)logPos.m_123341_() + 0.5, (double)logPos.m_123342_(), (double)logPos.m_123343_() + 0.5, 0.3);
            } else if (now % 40L == 0L && watcher.m_21573_().m_26571_()) {
                double angle = Math.random() * Math.PI * 2.0;
                double distance = 2.0 + Math.random() * 4.0;
                double targetX = (double)logPos.m_123341_() + 0.5 + Math.cos(angle) * distance;
                double targetZ = (double)logPos.m_123343_() + 0.5 + Math.sin(angle) * distance;
                double targetY = logPos.m_123342_();
                watcher.m_21573_().m_26519_(targetX, targetY, targetZ, 0.2);
            }
            TreeWatcherProcedure.lookAtPlayer(watcher, nearestPlayer);
            return;
        }
        if (!nbt.m_128471_("runningToLog")) {
            nbt.m_128379_("runningToLog", true);
            nbt.m_128356_("runStartTick", now);
            watcher.m_21573_().m_26573_();
            watcher.f_19794_ = true;
            BlockPos hidePos = TreeWatcherProcedure.findBestHidingSpot(server, watcher.m_20183_(), nearestPlayer);
            if (hidePos != null) {
                nbt.m_128405_("hideX", hidePos.m_123341_());
                nbt.m_128405_("hideY", hidePos.m_123342_());
                nbt.m_128405_("hideZ", hidePos.m_123343_());
            } else {
                nbt.m_128405_("hideX", logPos.m_123341_());
                nbt.m_128405_("hideY", logPos.m_123342_());
                nbt.m_128405_("hideZ", logPos.m_123343_());
            }
        }
        if (nbt.m_128471_("runningToLog")) {
            TreeWatcherProcedure.lookAtPlayer(watcher, nearestPlayer);
            BlockPos hideTarget = new BlockPos(nbt.m_128451_("hideX"), nbt.m_128451_("hideY"), nbt.m_128451_("hideZ"));
            Vec3 targetPos = Vec3.m_82512_((Vec3i)hideTarget);
            Vec3 currentPos = watcher.m_20182_();
            Vec3 direction = targetPos.m_82546_(currentPos);
            double distance = direction.m_82553_();
            if (distance > 0.5) {
                Vec3 normalizedDir = direction.m_82541_();
                double speed = Math.min(0.5, distance * 0.3);
                watcher.m_6034_(currentPos.f_82479_ + normalizedDir.f_82479_ * speed, currentPos.f_82480_, currentPos.f_82481_ + normalizedDir.f_82481_ * speed);
            } else if (!TreeWatcherProcedure.isVisibleToPlayer(nearestPlayer, watcher, server, hideTarget)) {
                ResourceLocation soundRL = new ResourceLocation("minecraft", "ambient.cave");
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundRL);
                if (sound != null) {
                    server.m_5594_(null, watcher.m_20183_(), sound, SoundSource.HOSTILE, 0.5f, 0.8f);
                }
                watcher.m_146870_();
            }
        }
    }

    private static BlockPos findBestHidingSpot(ServerLevel server, BlockPos mobPos, Player player) {
        Vec3 playerEye = player.m_146892_();
        Vec3 playerLook = player.m_20154_().m_82541_();
        ArrayList<BlockPos> pillars = new ArrayList<BlockPos>();
        for (int x = -16; x <= 16; ++x) {
            for (int z = -16; z <= 16; ++z) {
                for (int y = -3; y <= 3; ++y) {
                    BlockPos checkPos = mobPos.m_7918_(x, y, z);
                    if (!TreeWatcherProcedure.isPillar(server, checkPos)) continue;
                    pillars.add(checkPos);
                }
            }
        }
        if (pillars.isEmpty()) {
            return null;
        }
        BlockPos bestSpot = null;
        double bestScore = -1000000.0;
        for (BlockPos pillar : pillars) {
            Direction[] dirs;
            Vec3 pillarCenter = Vec3.m_82512_((Vec3i)pillar);
            Vec3 playerToPillar = pillarCenter.m_82546_(playerEye).m_82541_();
            for (Direction dir : dirs = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new)) {
                double distToMob;
                double score;
                Vec3 hideCenter;
                Vec3 pillarToHide;
                double alignment;
                BlockPos hidePos = pillar.m_121945_(dir);
                if (!server.m_46859_(hidePos) || !server.m_46859_(hidePos.m_7494_()) || !((alignment = (pillarToHide = (hideCenter = Vec3.m_82512_((Vec3i)hidePos)).m_82546_(pillarCenter).m_82541_()).m_82526_(playerToPillar)) > 0.5) || !((score = alignment * 100.0 - Math.sqrt(distToMob = hidePos.m_123331_((Vec3i)mobPos))) > bestScore)) continue;
                bestScore = score;
                bestSpot = hidePos;
            }
        }
        return bestSpot;
    }

    private static boolean isPillar(ServerLevel server, BlockPos pos) {
        BlockState state = server.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (LOG_BLOCKS.contains(state.m_60734_())) {
            return true;
        }
        if (state.m_60815_()) {
            BlockState above = server.m_8055_(pos.m_7494_());
            BlockState below = server.m_8055_(pos.m_7495_());
            if (above.m_60815_() || below.m_60815_()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isVisibleToPlayer(Player player, Mob mob, ServerLevel level, BlockPos hidePos) {
        if (!TreeWatcherProcedure.isPlayerLookingAt(player, mob, 50.0)) {
            return false;
        }
        Vec3 playerEye = player.m_146892_();
        Vec3 mobCenter = mob.m_20182_().m_82520_(0.0, (double)(mob.m_20192_() / 2.0f), 0.0);
        Vec3 direction = mobCenter.m_82546_(playerEye);
        double distance = direction.m_82553_();
        if (distance < 0.1) {
            return true;
        }
        Vec3 step = direction.m_82541_().m_82490_(0.3);
        int steps = (int)(distance / 0.3);
        for (int i = 0; i < steps; ++i) {
            double distToHide;
            Vec3 checkPos = playerEye.m_82549_(step.m_82490_((double)i));
            BlockPos pos = BlockPos.m_274446_((Position)checkPos);
            BlockState state = level.m_8055_(pos);
            if (TreeWatcherProcedure.isPillar(level, pos) && (distToHide = pos.m_123331_((Vec3i)hidePos)) <= 4.0) {
                return false;
            }
            if (!state.m_60815_() || state.m_60795_()) continue;
            return false;
        }
        return true;
    }

    private static boolean isPlayerLookingAt(Player player, Mob mob, double fov) {
        Vec3 toMob;
        Vec3 playerLook = player.m_20154_().m_82541_();
        double dotProduct = playerLook.m_82526_(toMob = mob.m_20182_().m_82546_(player.m_146892_()).m_82541_());
        double angleInDegrees = Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dotProduct))));
        return angleInDegrees <= fov;
    }

    private static void lookAtPlayer(Mob mob, Player target) {
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        if (toPlayer.m_82556_() > 1.0E-6) {
            Vec3 toPlayerNorm = toPlayer.m_82541_();
            float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
    }

    private static boolean isSolidGround(BlockState state) {
        return !state.m_60795_() && state.m_60815_();
    }
}

