/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2WINDOWEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class WindowMobSpawnProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final double MIN_DIST = 2.0;
    private static final double MAX_DIST = 20.0;
    private static final int SEARCH_ATTEMPTS = 100;
    private static final long DESPAWN_DELAY = 20L;
    private static final double LOOK_THRESHOLD = Math.cos(Math.toRadians(65.0));
    private static final double PROXIMITY_THRESHOLD = 4.0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Vec3 dirFromPlayerToGlass;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level world = player.m_9236_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 2 && phase != 3) {
            return;
        }
        RandomSource rand = server.f_46441_;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 5.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        Vec3 playerPos = player.m_20182_();
        BlockPos glassPos = null;
        for (int attempt = 0; attempt < 100; ++attempt) {
            double dist = 2.0 + rand.m_188500_() * 18.0;
            double theta = rand.m_188500_() * 2.0 * Math.PI;
            double dx = Math.sin(theta) * dist;
            double dz = Math.cos(theta) * dist;
            double dy = (rand.m_188500_() - 0.5) * 5.0;
            BlockPos candidate = new BlockPos((int)(playerPos.f_82479_ + dx), (int)(playerPos.f_82480_ + dy), (int)(playerPos.f_82481_ + dz));
            if (!world.m_8055_(candidate).m_204336_(Tags.Blocks.GLASS) && !world.m_8055_(candidate).m_204336_(Tags.Blocks.GLASS_PANES)) continue;
            glassPos = candidate;
            break;
        }
        if (glassPos == null) {
            return;
        }
        Vec3 glassVec = new Vec3((double)glassPos.m_123341_() + 0.5, (double)glassPos.m_123342_() + 0.5, (double)glassPos.m_123343_() + 0.5);
        Vec3 spawnVec = glassVec.m_82549_((dirFromPlayerToGlass = glassVec.m_82546_(playerPos).m_82541_()).m_82490_(1.0));
        BlockPos spawnPos = BlockPos.m_274446_((Position)spawnVec);
        if (!world.m_8055_(spawnPos).m_60795_()) {
            return;
        }
        FROMTHECAVES2WINDOWEntity mob = new FROMTHECAVES2WINDOWEntity((EntityType<FROMTHECAVES2WINDOWEntity>)((EntityType)FromTheCavesModEntities.FROMTHECAVES_2_WINDOW.get()), (Level)server);
        mob.m_6034_(spawnVec.f_82479_, spawnVec.f_82480_, spawnVec.f_82481_);
        mob.m_21530_();
        Vec3 diff = playerPos.m_82546_(spawnVec);
        float yaw = (float)(Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0);
        mob.m_146922_(yaw);
        mob.f_20885_ = yaw;
        mob.f_20883_ = yaw;
        mob.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)mob, Player.class, 20.0f, 1.0f));
        CompoundTag nbt = mob.getPersistentData();
        long now = server.m_46467_();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128356_("despawnTick", 0L);
        server.m_7967_((Entity)mob);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        Mob mob;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (mob = (Mob)livingEntity) instanceof FROMTHECAVES2WINDOWEntity) {
            FROMTHECAVES2WINDOWEntity windowMob = (FROMTHECAVES2WINDOWEntity)mob;
            Level world = mob.m_9236_();
            if (world.m_5776_() || !(world instanceof ServerLevel)) {
                return;
            }
            ServerLevel server = (ServerLevel)world;
            int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
            if (phase != 2 && phase != 3) {
                windowMob.m_146870_();
                return;
            }
            CompoundTag nbt = windowMob.getPersistentData();
            if (!nbt.m_128441_("targetUUID")) {
                return;
            }
            UUID targetId = nbt.m_128342_("targetUUID");
            Player player = server.m_46003_(targetId);
            if (player == null) {
                windowMob.m_146870_();
                return;
            }
            long now = server.m_46467_();
            long despawnTick = nbt.m_128454_("despawnTick");
            Vec3 diff = player.m_20182_().m_82546_(windowMob.m_20182_());
            float yaw = (float)(Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0);
            windowMob.m_146922_(yaw);
            windowMob.f_20885_ = yaw;
            windowMob.f_20883_ = yaw;
            if (despawnTick == 0L) {
                boolean isClose;
                double dist = player.m_20270_((Entity)windowMob);
                boolean bl = isClose = dist <= 4.0;
                if (isClose) {
                    nbt.m_128356_("despawnTick", now + 20L);
                } else {
                    Vec3 playerEye = player.m_20299_(1.0f);
                    Vec3 mobEye = windowMob.m_20182_().m_82520_(0.0, (double)windowMob.m_20192_(), 0.0);
                    Vec3 toMob = mobEye.m_82546_(playerEye).m_82541_();
                    Vec3 look = player.m_20154_().m_82541_();
                    double dot = look.m_82526_(toMob);
                    if (dot > LOOK_THRESHOLD) {
                        nbt.m_128356_("despawnTick", now + 20L);
                    }
                }
            }
            if (now >= despawnTick && despawnTick > 0L) {
                SoundEvent knockSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "knock"));
                if (knockSound != null) {
                    server.m_6263_(null, windowMob.m_20185_(), windowMob.m_20186_(), windowMob.m_20189_(), knockSound, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                windowMob.m_146870_();
            }
        }
    }
}

