/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class CemeteryMarkerManager {
    private static final Set<BlockPos> MARKER_LOCATIONS = ConcurrentHashMap.newKeySet();

    public static void addMarker(BlockPos pos) {
        if (pos == null) {
            return;
        }
        MARKER_LOCATIONS.add(pos.m_7949_());
    }

    public static void removeMarker(BlockPos pos) {
        if (pos == null) {
            return;
        }
        MARKER_LOCATIONS.remove(pos);
    }

    @Nullable
    public static BlockPos findNearestMarker(BlockPos searchOrigin, double maxRadius) {
        if (searchOrigin == null || MARKER_LOCATIONS.isEmpty() || maxRadius <= 0.0) {
            return null;
        }
        double minDistanceSq = maxRadius * maxRadius;
        BlockPos nearestMarker = null;
        for (BlockPos markerPos : MARKER_LOCATIONS) {
            double distanceSq = markerPos.m_123331_((Vec3i)searchOrigin);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            nearestMarker = markerPos;
        }
        return nearestMarker;
    }

    @Nullable
    public static BlockPos findNearestMarker(BlockPos searchOrigin) {
        if (searchOrigin == null || MARKER_LOCATIONS.isEmpty()) {
            return null;
        }
        double minDistanceSq = Double.MAX_VALUE;
        BlockPos nearestMarker = null;
        for (BlockPos markerPos : MARKER_LOCATIONS) {
            double distanceSq = markerPos.m_123331_((Vec3i)searchOrigin);
            if (!(distanceSq < minDistanceSq)) continue;
            minDistanceSq = distanceSq;
            nearestMarker = markerPos;
        }
        return nearestMarker;
    }

    public static Set<BlockPos> getMarkers() {
        return Collections.unmodifiableSet(MARKER_LOCATIONS);
    }

    public static int getMarkerCount() {
        return MARKER_LOCATIONS.size();
    }

    public static void clearMarkers() {
        MARKER_LOCATIONS.clear();
    }
}

