/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork;

import commonnetwork.networking.DelayedPacketRegistrationHandler;
import commonnetwork.networking.PacketRegistrar;
import commonnetwork.networking.PacketRegistrationHandler;
import commonnetwork.networking.data.PacketContext;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class CommonNetworkMod {
    private final PacketRegistrationHandler packetRegistration;
    private static DelayedPacketRegistrationHandler delayedHandler;
    public static CommonNetworkMod INSTANCE;

    public CommonNetworkMod(PacketRegistrationHandler packetRegistration) {
        INSTANCE = this;
        this.packetRegistration = packetRegistration;
        CommonNetworkMod.getDelayedHandler().registerQueuedPackets(packetRegistration);
    }

    private static DelayedPacketRegistrationHandler getDelayedHandler() {
        if (delayedHandler == null) {
            delayedHandler = new DelayedPacketRegistrationHandler();
        }
        return delayedHandler;
    }

    @Deprecated(forRemoval=true)
    public static <T> PacketRegistrar registerPacket(Identifier packetIdentifier, Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, Consumer<PacketContext<T>> handler) {
        if (INSTANCE != null) {
            return CommonNetworkMod.INSTANCE.packetRegistration.registerPacket(packetIdentifier, packetClass, encoder, decoder, handler);
        }
        return CommonNetworkMod.getDelayedHandler().registerPacket(packetIdentifier, packetClass, encoder, decoder, handler);
    }

    public static <T> PacketRegistrar registerPacket(CustomPacketPayload.Type<? extends CustomPacketPayload> type, Class<T> packetClass, StreamCodec<? extends FriendlyByteBuf, T> codec, Consumer<PacketContext<T>> handler) {
        if (INSTANCE != null) {
            return CommonNetworkMod.INSTANCE.packetRegistration.registerPacket(type, packetClass, codec, handler);
        }
        return CommonNetworkMod.getDelayedHandler().registerPacket(type, packetClass, codec, handler);
    }

    public static <T> PacketRegistrar registerConfigurationPacket(CustomPacketPayload.Type<? extends CustomPacketPayload> type, Class<T> packetClass, StreamCodec<? extends FriendlyByteBuf, T> codec, Consumer<PacketContext<T>> handler) {
        if (INSTANCE != null) {
            return CommonNetworkMod.INSTANCE.packetRegistration.registerConfigurationPacket(type, packetClass, codec, handler);
        }
        return CommonNetworkMod.getDelayedHandler().registerConfigurationPacket(type, packetClass, codec, handler);
    }

    public PacketRegistrationHandler getPacketRegistration() {
        return this.packetRegistration;
    }
}

