/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.beam;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.function.Function;
import me.clefal.lootbeams.CommonClass;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;

public abstract class BeamRenderType {
    public static final Identifier LOOT_BEAM_TEXTURE = CommonClass.id("textures/entity/loot_beam.png");
    public static final Identifier WHITE_TEXTURE = CommonClass.id("textures/entity/white.png");
    public static final Identifier GLOW_TEXTURE = CommonClass.id("textures/entity/glow.png");
    private static final Function<Identifier, RenderType> beamOnShader = Util.memoize(location -> {
        RenderSetup rendersetup = RenderSetup.builder((RenderPipeline)RenderPipelines.TRANSLUCENT_PARTICLE).withTexture("Sampler0", location).useLightmap().useOverlay().affectsCrumbling().sortOnUpload().setLayeringTransform(LayeringTransform.VIEW_OFFSET_Z_LAYERING).createRenderSetup();
        return RenderType.create((String)"lb_beam", (RenderSetup)rendersetup);
    });

    public static RenderType getBeamRendertype(Identifier location, boolean isShaderOn) {
        if (isShaderOn) {
            return beamOnShader.apply(location);
        }
        return RenderTypes.beaconBeam((Identifier)location, (boolean)true);
    }
}

