/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.modules.tooltip.overlay;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.clefal.lootbeams.LootBeamsConstants;
import me.clefal.lootbeams.config.configs.LootInfomationConfig;
import me.clefal.lootbeams.data.lbitementity.LBItemEntity;
import me.clefal.lootbeams.data.lbitementity.LBItemEntityCache;
import me.clefal.lootbeams.events.TooltipsGatherNameAndRarityEvent;
import me.clefal.lootbeams.modules.tooltip.LootInformationEnableStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class AdvanceTooltipOverlay {
    public static final AdvanceTooltipOverlay INSTANCE = new AdvanceTooltipOverlay();

    public static EntityHitResult getEntityItem(Player playerm, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        double distance = 6.0;
        Vec3 position = player.getEyePosition(partialTick);
        Vec3 view = player.getViewVector(partialTick);
        if (mc.hitResult != null && mc.hitResult.getType() != HitResult.Type.MISS) {
            distance = mc.hitResult.getLocation().distanceTo(position);
        }
        return AdvanceTooltipOverlay.getEntityItem((Player)player, position, position.add(view.x * distance, view.y * distance, view.z * distance));
    }

    public static EntityHitResult getEntityItem(Player player, Vec3 position, Vec3 look) {
        Vec3 include = look.subtract(position);
        List list = player.level().getEntities((Entity)player, player.getBoundingBox().expandTowards(include.x, include.y, include.z));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            AABB axisalignedbb = item.getBoundingBox().inflate(0.5).inflate(0.0, 0.5, 0.0);
            Optional vec = axisalignedbb.clip(position, look);
            if (vec.isPresent()) {
                return new EntityHitResult((Entity)item, (Vec3)vec.get());
            }
            if (!axisalignedbb.contains(position)) continue;
            return new EntityHitResult((Entity)item);
        }
        return null;
    }

    public static boolean checkCrouch() {
        return !LootInfomationConfig.lootInfomationConfig.tooltips.render_tooltips_on_crouch || Minecraft.getInstance().player.isCrouching();
    }

    public Vector2f transformToScreenCoordinate(Vector3f worldCoordinate, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        int guiScaledWidth = window.getGuiScaledWidth();
        int guiScaledHeight = window.getGuiScaledHeight();
        LootInfomationConfig.TooltipsSection tooltips = LootInfomationConfig.lootInfomationConfig.tooltips;
        if (((Style)((Object)tooltips.TooltipsAtCenter.get())).equals((Object)Style.Center)) {
            return new Vector2f((float)guiScaledWidth / 2.0f, (float)guiScaledHeight / 2.0f);
        }
        return new Vector2f((float)(guiScaledWidth - (Integer)tooltips.offsetXFromLeft.get()), (float)(guiScaledHeight - (Integer)tooltips.offsetYFromBottom.get()));
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker tracker) {
        if (LootInfomationConfig.lootInfomationConfig.lootInformationControl.loot_information_status != LootInformationEnableStatus.LootInformationStatus.NAME_AND_RARITY_IN_TOOLTIPS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        EntityHitResult entityItem = AdvanceTooltipOverlay.getEntityItem((Player)mc.player, tracker.getGameTimeDeltaPartialTick(true));
        if (entityItem == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityItem.getEntity();
        LBItemEntity ask = LBItemEntityCache.ask(itemEntity);
        Vector2f vector2f = this.transformToScreenCoordinate(itemEntity.position().toVector3f(), tracker.getGameTimeDeltaTicks());
        if (AdvanceTooltipOverlay.checkCrouch()) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, itemEntity.getItem(), (int)vector2f.x, (int)vector2f.y);
        } else {
            TooltipsGatherNameAndRarityEvent tooltipsGatherNameAndRarityEvent = new TooltipsGatherNameAndRarityEvent(ask);
            LootBeamsConstants.EVENT_BUS.post((Event)tooltipsGatherNameAndRarityEvent);
            ArrayList<Component> nameAndRarity = new ArrayList<Component>(tooltipsGatherNameAndRarityEvent.gather.values());
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, nameAndRarity, itemEntity.getItem().getTooltipImage(), (int)vector2f.x, (int)vector2f.y);
        }
    }

    public static enum Style {
        Center,
        Custom;

    }
}

