/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.lang;

import com.clefal.nirvana_lib.client.lang.ILangEntry;
import com.clefal.nirvana_lib.client.lang.LangCreator;
import com.clefal.nirvana_lib.client.lang.LangPair;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;

public class SingleLangEntry
implements ILangEntry {
    private final LangPair main;

    private SingleLangEntry(LangPair main) {
        this.main = main;
    }

    public MutableComponent get() {
        return MutableComponent.create((ComponentContents)new TranslatableContents(this.main.getKey(), null, TranslatableContents.NO_ARGS));
    }

    public MutableComponent get(Object ... args) {
        return MutableComponent.create((ComponentContents)new TranslatableContents(this.main.getKey(), null, args));
    }

    @Override
    public Supplier<List<LangPair>> provide() {
        return () -> List.of(this.main);
    }

    public static final class SingleLangEntryBuilder {
        private String modId;
        private List<String> categories;
        private String keySuffix;
        private String value;

        public SingleLangEntryBuilder(String modId, List<String> categories) {
            this.modId = modId;
            this.categories = categories;
        }

        public SingleLangEntryBuilder lang(String keySuffix, String value) {
            this.keySuffix = keySuffix;
            this.value = value;
            return this;
        }

        public SingleLangEntry build() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.modId);
            for (String category : this.categories) {
                stringBuilder.append(".").append(category);
            }
            stringBuilder.append(".").append(this.keySuffix);
            SingleLangEntry singleLangEntry = new SingleLangEntry(LangPair.of(stringBuilder.toString(), this.value));
            LangCreator.entries.add(singleLangEntry);
            return singleLangEntry;
        }
    }
}

