/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.client.render.batch;

import com.clefal.nirvana_lib.client.render.batch.IBufferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public record DrawStringBufferInfo(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, Font.DisplayMode displayMode, int backgroundColor, int packedLightCoords) implements IBufferInfo
{
    public static DrawStringBufferInfo of(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, Font.DisplayMode displayMode) {
        return new DrawStringBufferInfo(text, x, y, color, dropShadow, matrix, displayMode, 0, 0xF000F0);
    }

    public static DrawStringBufferInfo of(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix) {
        return DrawStringBufferInfo.of(text, x, y, color, dropShadow, matrix, Font.DisplayMode.NORMAL);
    }

    public static DrawStringBufferInfo of(String text, float x, float y, int color, Matrix4f matrix) {
        return DrawStringBufferInfo.of(text, x, y, color, false, matrix);
    }

    @Override
    public void upload(MultiBufferSource bufferSource) {
        Minecraft.getInstance().font.drawInBatch(this.text, this.x, this.y, this.color, this.dropShadow, this.matrix, bufferSource, this.displayMode, this.backgroundColor, this.packedLightCoords);
    }

    public GuiTextRenderState toRenderState(GuiGraphics guiGraphics) {
        return new GuiTextRenderState(Minecraft.getInstance().font, Language.getInstance().getVisualOrder(FormattedText.of((String)this.text)), (Matrix3x2fc)guiGraphics.pose(), (int)this.x, (int)this.y, this.color, this.backgroundColor, this.dropShadow, false, guiGraphics.peekScissorStack());
    }
}

